//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/10/24.
//

#ifndef UOS_RECOVERY_INITIALIZE_RESTORE_DIM_H
#define UOS_RECOVERY_INITIALIZE_RESTORE_DIM_H

#include <QWidget>
#include <QLabel>
#include <DPushButton>
#include <DTipLabel>
#include <QVBoxLayout>
#include "utils/global.h"

DWIDGET_USE_NAMESPACE

class RadioItem;

class InitializeRestoreDim : public QWidget {
    Q_OBJECT
public:
    explicit InitializeRestoreDim(QWidget* parent = nullptr);
    void initUI();
    void doSuccess();
    void doCancelRestoreSuccess();
    void doError(int errCode);
    void setEnableInSelinuxMode(bool enable);
    void setTipsVisible(const bool &visible);
    void setTipsLabelText(const QString &msg);

Q_SIGNALS:
    void initializeRestoreV20Clicked(bool formatData);
    void cancelInitRestore();

private Q_SLOTS:
    void startRestore();

private:
    bool isExistInitBackup();

private:
    QLabel *m_titleLabel = nullptr;
    QLabel *m_restoreLabel = nullptr;
    RadioItem *m_savaUserDataItem = nullptr;
    DTipLabel *m_descriptionLabel = nullptr;
    QWidget* m_loadingWidget;
    Dtk::Widget::DTipLabel* m_tipsLabel = nullptr;
    DPushButton *m_startRestoreBtn = nullptr;
    QVBoxLayout *m_mainLayout = nullptr;
    ActionType m_actionType;
    bool m_existInitBackup = false;
};

#endif //UOS_RECOVERY_INITIALIZE_RESTORE_DIM_H
