//
// Created by uos on 2022/3/21.
//


#include "ResultWidget.h"
#include "utils/Utils.h"
#include <QVBoxLayout>
#include <DPushButton>
#include <DFontSizeManager>
#include <QDebug>
#include <QGraphicsOpacityEffect>

ResultWidget::ResultWidget(bool success, const QString &resultText,
                           const QString &errorMsg, const QString &btnText, bool hideIcon, DWidget *parent)
{
    m_isSuccess = success;
    this->setAccessibleName("ResultWidget");
    setAccessibleDescription("ResultWidget");

    //垂直布局
    QVBoxLayout *verticalLayout = new QVBoxLayout(this);
    verticalLayout->addStretch();

    m_resultIcon = new DLabel(this);
    m_resultIcon->setAccessibleName("ResultWidget_resultIcon");
    verticalLayout->addWidget(m_resultIcon);
    verticalLayout->setAlignment(m_resultIcon, Qt::AlignHCenter);
    // verticalLayout->addSpacing(10);

    m_resultText = new DLabel(this);
    m_resultText->setAlignment(Qt::AlignHCenter);
    m_resultText->setAccessibleName("ResultWidget_resultText");
    DFontSizeManager::instance()->bind(m_resultText, DFontSizeManager::T5);
    QFont font = m_resultText->font();
    font.setWeight(QFont::Medium);
    m_resultText->setFont(font);
    m_resultText->setFixedSize(620, 100);
    m_resultText->setWordWrap(true);
    verticalLayout->addWidget(m_resultText);
    verticalLayout->setAlignment(m_resultText, Qt::AlignHCenter);
    verticalLayout->addSpacing(20);

    m_errorMsg = new DLabel;
    m_errorMsg->setAccessibleName("ResultWidget_errorMsg");
    m_errorMsg->setAlignment(Qt::AlignHCenter);
    m_errorMsg->setStyleSheet("QLabel {"
                             "font-family: SourceHanSansSC, SourceHanSansSC-Medium;"
                             "font-size: 14px;"
                             "font-weight: 500;"
                             "color: #ff5736;"
                             "}");
    verticalLayout->addWidget(m_errorMsg);

    m_introduction = new DLabel;
    m_introduction->setAccessibleName("ResultWidget_introLabel");
    m_introduction->setWordWrap(true);
    m_introduction->setAlignment(Qt::AlignHCenter);
    m_introduction->hide();
    verticalLayout->addWidget(m_introduction);

    verticalLayout->addStretch();

    m_viewButton = new DPushButton(this);
    m_viewButton->setAccessibleName("ResultWidget_viewButton");
    m_viewButton->hide();
    DFontSizeManager::instance()->bind(m_viewButton, DFontSizeManager::T6);
    m_viewButton->setStyleSheet("QPushButton {"
                                "color: #0081FF;"
                                "border: none;"
                                "background-color: transparent;"
                                "}");
    verticalLayout->addWidget(m_viewButton);
    verticalLayout->setAlignment(m_viewButton, Qt::AlignHCenter);

    m_button = new DPushButton(this);
    m_button->setAccessibleName("ResultWidget_Button");
    m_button->setFixedWidth(200);
    DFontSizeManager::instance()->bind(m_button, DFontSizeManager::T6);
    verticalLayout->addWidget(m_button);
    verticalLayout->setAlignment(m_button, Qt::AlignHCenter);
    verticalLayout->setContentsMargins(0, 123, 0, 30);
    set(success, resultText, errorMsg, btnText, hideIcon);

    connect(m_button, &QPushButton::clicked, this, &ResultWidget::done);
    connect(m_viewButton, &QPushButton::clicked, this, &ResultWidget::viewBtnClicked);
}

void ResultWidget::set(bool success, const QString &resultText,
                       const QString &errorMsg, const QString &btnText, bool hideIcon)
{
    m_isSuccess = success;
    if (success) {
        m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/success.svg", QSize(128, 128)));
    } else {
        m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/fail.svg", QSize(128, 128)));
    }
    m_resultIcon->setVisible(!hideIcon);
    m_resultText->setText(resultText);
//    m_errorMsg->setText(errorMsg);
    if (!errorMsg.isEmpty()) {
        qCritical()<<"ResultWidget errorMsg = "<<errorMsg;
    }

    m_button->setText(btnText);

}

void ResultWidget::showViewButton(bool show, const QString &btnText, const QString &style)
{
    m_viewButton->setVisible(show);

    if (!btnText.isEmpty()) {
        m_viewButton->setText(btnText);
    }

    if (!style.isEmpty()) {
        m_viewButton->setStyleSheet(style);
    }

}

void ResultWidget::showIntroductionMsg(bool show, const QString &msg, const QString &style)
{
    m_introduction->setVisible(show);

    if (!msg.isEmpty()) {
        m_introduction->setText(msg);
    }

    if (!style.isEmpty()) {
        m_introduction->setStyleSheet(style);
    }
}


ResultWidgetV2::ResultWidgetV2(int opType, bool success, const QString &resultText,
                           const QString &errorMsg, const QString &btnText, bool hideIcon, DWidget *parent)
{
    m_opType = opType;
    m_isSuccess = success;
    this->setAccessibleName("ResultWidgetV2");
    setAccessibleDescription("ResultWidgetV2");
    this->setFixedHeight(600);

    //垂直布局
    QVBoxLayout *verticalLayout = new QVBoxLayout(this);
    verticalLayout->setContentsMargins(0, 64, 0, 0);
    verticalLayout->setSpacing(0);
    //verticalLayout->addStretch();

    m_resultIcon = new DLabel(this);
    m_resultIcon->setAccessibleName("ResultWidgetV2_resultIcon");
    verticalLayout->addWidget(m_resultIcon, 0, Qt::AlignHCenter);
    // verticalLayout->addSpacing(10);

    m_resultText = new DLabel(this);
    m_resultText->setAlignment(Qt::AlignHCenter);
    m_resultText->setAccessibleName("ResultWidgetV2_resultText");
    QFont font = m_resultText->font();
    font.setPixelSize(20);
    font.setWeight(QFont::Bold);
    m_resultText->setFont(font);
    DFontSizeManager::instance()->bind(m_resultText, DFontSizeManager::T4);
    m_resultText->setWordWrap(true);

    verticalLayout->addWidget(m_resultText, 0, Qt::AlignHCenter);
    //verticalLayout->addSpacing(20);

    m_errorMsg = new DLabel;
    m_errorMsg->setAccessibleName("ResultWidgetV2_errorMsg");
    m_errorMsg->setAlignment(Qt::AlignHCenter);
    m_errorMsg->setStyleSheet("QLabel {"
                              "font-family: SourceHanSansSC, SourceHanSansSC-Medium;"
                              "font-size: 14px;"
                              "font-weight: 500;"
                              "color: #ff5736;"
                              "}");
    verticalLayout->addWidget(m_errorMsg);

    m_introduction = new DLabel;
    m_introduction->setContentsMargins(0, 0, 0, 0);
    m_introduction->setAccessibleName("ResultWidgetV2_introLabel");
    QFont introductionFont = m_resultText->font();
    introductionFont.setPixelSize(12);
    introductionFont.setWeight(QFont::Normal);
    m_introduction->setFont(introductionFont);
    m_introduction->setWordWrap(true);
    m_introduction->setAlignment(Qt::AlignCenter);
    QGraphicsOpacityEffect *opacityEffect = new QGraphicsOpacityEffect(m_introduction);
    opacityEffect->setOpacity(0.6);
    m_introduction->setGraphicsEffect(opacityEffect);
    m_introduction->hide();
    verticalLayout->addWidget(m_introduction, 0, Qt::AlignHCenter);
    verticalLayout->addSpacing(52);

    m_viewButton = new DPushButton(this);
    m_viewButton->setAccessibleName("ResultWidgetV2_viewButton");
    m_viewButton->hide();
    DFontSizeManager::instance()->bind(m_viewButton, DFontSizeManager::T6);
    m_viewButton->setStyleSheet("QPushButton {"
                                "color: #0081FF;"
                                "border: none;"
                                "background-color: transparent;"
                                "}");
    verticalLayout->addWidget(m_viewButton, 0, Qt::AlignHCenter);
    verticalLayout->addSpacing(10);

    m_button = new DPushButton(this);
    m_button->setAccessibleName("ResultWidgetV2_Button");
    m_button->setFixedWidth(200);
    DFontSizeManager::instance()->bind(m_button, DFontSizeManager::T6);
    verticalLayout->addWidget(m_button, 0, Qt::AlignHCenter);
    verticalLayout->addStretch();
    set(opType, success, resultText, errorMsg, btnText, hideIcon);

    connect(m_button, &QPushButton::clicked, this, &ResultWidgetV2::done);
    connect(m_viewButton, &QPushButton::clicked, this, &ResultWidgetV2::viewBtnClicked);

    m_guiHelper = Dtk::Gui::DGuiApplicationHelper::instance();
    connect(m_guiHelper, &Dtk::Gui::DGuiApplicationHelper::themeTypeChanged, this, &ResultWidgetV2::onThemeChange);
}

void ResultWidgetV2::set(int opType, bool success, const QString &resultText,
                       const QString &errorMsg, const QString &btnText, bool hideIcon)
{
    m_opType = opType;
    m_isSuccess = success;
    m_viewButton->setVisible(false);
    m_introduction->setVisible(false);

    if (success) {
        if (DGuiApplicationHelper::instance()->themeType() == DGuiApplicationHelper::LightType) {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_success.png", QSize(160, 160)));
        } else {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_success_dark.png", QSize(160, 160)));
        }
    } else {
        if (DGuiApplicationHelper::instance()->themeType() == DGuiApplicationHelper::LightType) {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_failed.png", QSize(160, 160)));
        } else {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_failed_dark.png", QSize(160, 160)));
        }
    }
    m_resultIcon->setVisible(!hideIcon);
    m_resultText->setText(resultText);
    m_resultText->setFixedWidth(this->width() * 0.8);
    m_resultText->adjustSize();
//    m_errorMsg->setText(errorMsg);
    if (!errorMsg.isEmpty()) {
        qCritical()<<"ResultWidgetV2 errorMsg = "<<errorMsg;
    }

    m_button->setText(btnText);

}

void ResultWidgetV2::showViewButton(bool show, const QString &btnText, const QString &style)
{
    m_viewButton->setVisible(show);

    if (!btnText.isEmpty()) {
        m_viewButton->setText(btnText);
    }

    if (!style.isEmpty()) {
        m_viewButton->setStyleSheet(style);
    }

}

void ResultWidgetV2::showIntroductionMsg(bool show, const QString &msg, const QString &style)
{
    m_introduction->setVisible(show);

    if (!msg.isEmpty()) {
        m_introduction->setText(msg);
        m_introduction->setFixedWidth(this->width() * 0.8);
        m_introduction->adjustSize();
    }

    if (!style.isEmpty()) {
        m_introduction->setStyleSheet(style);
    }
}

void ResultWidgetV2::onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType)
{
    if (themeType == Dtk::Gui::DGuiApplicationHelper::LightType) {
        if (m_isSuccess) {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_success.png", QSize(160, 160)));
        } else {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_failed.png", QSize(160, 160)));
        }
    } else {
        if (m_isSuccess) {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_success_dark.png", QSize(160, 160)));
        } else {
            m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/v25/operate_failed_dark.png", QSize(160, 160)));
        }
    }
}