---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              numérotation des équations, numérotation, numéroter, référence,
              répétition, \label, \ref
---

# Comment conserver une numérotation fixe à une équation répétée dans un document ?

Lorsqu'une équation est répétée, il est souvent souhaitable que sa numérotation
soit la même que lors de sa première apparition. Sous LaTeX, 
l'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) fournit 
la commande `\tag` permettant de gérer ce point :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
Nous posons :
\begin{equation}
  a=b  \label{eq1}
\end{equation}
(...) Et comme nous l'avons vu :
\begin{equation}
  a=b  \tag{\ref{eq1}}
\end{equation}
Ces deux équations sont numérotées
par \eqref{eq1}.
\end{document}
```

La commande `\tag` permet initialement de personnaliser la numérotation 
des équations en mettant son argument comme numérotation. 
Ici, elle remplace donc la numérotation de la deuxième équation 
par celle de la première équation récupérée avec la commande `\label` 
et restituée avec la commande `\ref`.

La commande `eqref` remplace `ref` pour les équations : la police utilisée
est toujours la même et le résultat est plus esthétique.

:::{sources}
- [FAQ-reuseq](https://texfaq.org/FAQ-reuseq)
:::