---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, espace inter-colonnes
---

# Comment modifier l'espace inter-colonnes ?

Il suffit de modifier la variable `\columnsep`, 
par exemple en ajoutant 1cm à cette marge avec la commande `\addtolength` :

```{noedit}
\addtolength{\columnsep}{1cm}
```

Voici un exemple montrant une page obtenue avec et sans cette commande.

::::{tab-set}

:::{tab-item} Sans modification de `\columnsep`
```
\documentclass[twocolumn,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux-texte      

\begin{document}
\lipsum[1-6]
\end{document}
```
:::

:::{tab-item} Avec modification de `\columnsep`

```
\documentclass[twocolumn,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux-texte      

  \addtolength{\columnsep}{1cm}

\begin{document}
\lipsum[1-6]
\end{document}
```
:::

::::
