//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 6>, 140> igamma_int_data = { {
      {{ SC_(0.5), SC_(0.004999999888241291046142578125), SC_(1.631267845368323485191815380032984903074365412587098308286220239190324188420710121791871591309590004), SC_(0.9203443263332001265162236927545643793578786527087679769237787431564844748135321134774112708209554194), SC_(0.1411860055371925421063521033081602797231840435352888199275875506625870961703220596656577919527041757), SC_(0.07965567366679987348377630724543562064212134729123202307622125684351552518646788652258872917904458057) }}, 
      {{ SC_(0.5), SC_(0.25), SC_(0.8498918380799311297867616098602389766300312781938048348528626579829435160004444680322048858624092311), SC_(0.479500122186953462317253346108035471263548424242036299941194274352806478283146429109461900411394659), SC_(0.9225620128255848975114058734809062061675181779285822933609451318699677685905877134253244973998849491), SC_(0.520499877813046537682746653891964528736451575757963700058805725647193521716853570890538099588605341) }}, 
      {{ SC_(0.5), SC_(0.449999988079071044921875), SC_(0.6075647752751784703583581789426278456752564880945645704809989500539948786183333019925969429005007538), SC_(0.3427817175407890768272360273834711985342418909050114189064883223090985450970247707985828865357086527), SC_(1.164889075630337556939809304398517337122292968027822557732808839798916405972698879464932440361793426), SC_(0.6572182824592109231727639726165288014657581090949885810935116776909014549029752292014171134642913473) }}, 
      {{ SC_(0.5), SC_(0.5), SC_(0.5624182315944071242794949573020430690267675647965080152711827351225288269777202721053138351861008813), SC_(0.3173105078629141028295349087359241550441740665467912180252110995140171160255903409776584970430004241), SC_(1.210035619311108903018672526039102113770781891325879112942625054730382457613311909352215548076193299), SC_(0.6826894921370858971704650912640758449558259334532087819747889004859828839744096590223415029569995759) }}, 
      {{ SC_(0.5), SC_(0.550000011920928955078125), SC_(0.5215730804923022694296157870452972118167645274078781347659207691038036243173236920652888890778334457), SC_(0.2942660990726723860419838415374453483460616872211918064199672606812661428450855377898215276021760526), SC_(1.250880770413213757868551696295847970980784928714508993447887020749107660273708489392240494184460734), SC_(0.7057339009273276139580161584625546516539383127788081935800327393187338571549144622101784723978239474) }}, 
      {{ SC_(0.5), SC_(1.0), SC_(0.2788055852806619764992326110774391720885500824971744701584987919357006294674865183689945658651387992), SC_(0.1572992070502851306587793649173907407039330020336970915400621021652827459039891587248999441840165472), SC_(1.493648265624854050798934872263706010708999373625212658055308997917210655123545663088534817397155381), SC_(0.8427007929497148693412206350826092592960669979663029084599378978347172540960108412751000558159834528) }}, 
      {{ SC_(0.5), SC_(100.0), SC_(0.3701747860408278920253566448133907572136210252033768764800615129976497004743801458060294976199881689e-44), SC_(0.2088487583762544757000786294957788611560818119321163727012213713938174695833440290513463628030792355e-44), SC_(1.772453850905516027298167483341145182797549452420639267805528869599344836457124609321319131228525415), SC_(0.999999999999999999999999999999999999999999997911512416237455242999213705042211388439181880678836273) }}, 
      {{ SC_(1.0), SC_(0.00999999977648258209228515625), SC_(0.9900498339704614360382138392834551161113407838357779440886813669674202814166581683103367609018741592), SC_(0.9900498339704614360382138392834551161113407838357779440886813669674202814166581683014245491001600443), SC_(0.009950166029538563961786160716544883888659216164222055911318633032579718583341831698248133897676852056), SC_(0.009950166029538563961786160716544883888659216164222055911318633032579718583341831698575450899839955738) }}, 
      {{ SC_(1.0), SC_(0.5), SC_(0.6065306597126334236037995349911804534419181354871869556828921587350565194137484240072325063075404673), SC_(0.606530659712633423603799534991180453441918135487186955682892158735056519413748423985704188802918523), SC_(0.393469340287366576396200465008819546558081864512813044317107841264943480586251576001352388492010544), SC_(0.393469340287366576396200465008819546558081864512813044317107841264943480586251576014295811197081477) }}, 
      {{ SC_(1.0), SC_(0.89999997615814208984375), SC_(0.4065696694339752855534404747740105862953642332665029835031979841616081291898465027056760538362422369), SC_(0.4065696694339752855534404747740105862953642332665029835031979841616081291898465026775698931385242319), SC_(0.5934303305660247144465595252259894137046357667334970164968020158383918708101534973029088409633087743), SC_(0.5934303305660247144465595252259894137046357667334970164968020158383918708101534973224301068614757681) }}, 
      {{ SC_(1.0), SC_(1.0), SC_(0.3678794411714423215955237701614608674458111310317678345078368016974614957448998033087215393207514013), SC_(0.3678794411714423215955237701614608674458111310317678345078368016974614957448998033055633330193769539), SC_(0.63212055882855767840447622983853913255418886896823216549216319830253850425510019669986335547879961), SC_(0.6321205588285576784044762298385391325541888689682321654921631983025385042551001966944366669806230461) }}, 
      {{ SC_(1.0), SC_(1.10000002384185791015625), SC_(0.3328710757618145679671571848455601132593649668322841328963855852147267744456382506080158515376624924), SC_(0.332871075761814567967157184845560113259364966832284132896385585214726774445638250618965856020172342), SC_(0.6671289242381854320328428151544398867406350331677158671036144147852732255543617494005690432618885189), SC_(0.667128924238185432032842815154439886740635033167715867103614414785273225554361749381034143979827658) }}, 
      {{ SC_(1.0), SC_(2.0), SC_(0.1353352832366126918939994949724844034076315459095758814681588726540733741014876899370981224906570488), SC_(0.1353352832366126918939994949724844034076315459095758814681588726540733741014876899415500621934116259), SC_(0.8646647167633873081060005050275155965923684540904241185318411273459266258985123100714867723088939625), SC_(0.8646647167633873081060005050275155965923684540904241185318411273459266258985123100584499378065883741) }}, 
      {{ SC_(1.0), SC_(100.0), SC_(0.3720075976020835962959695803863118337358892292376781967120613876663290475895815718157118778642281497e-43), SC_(0.37200759760208359629596958038631183373588922923767819671206138766632904758958157182794930297528019e-43), SC_(0.9999999999999999999999999999999999999999999627992402397916403704030419613688166264196619710317313401), SC_(0.9999999999999999999999999999999999999999999627992402397916403704030419613688166264110770762321803288) }}, 
      {{ SC_(4.5), SC_(0.04500000178813934326171875), SC_(11.63172821024549441698223162601989743958836118115278238773312379208547617681782066799483071466068875), SC_(0.9999999839815762404539939126624023829295483903490073208372721857918957147514500440457971141443476684), SC_(0.1863219545121619924834063678225205571246503831411699898288242541283108286160415992612505831218724607e-6), SC_(0.1601842375954600608733759761707045160965099267916272781420810428524854995595420288585565233163730242e-7) }}, 
      {{ SC_(4.5), SC_(2.25), SC_(10.18403214286566234526019345802929635910911247967051220522868706375276166311515909530042932735839335), SC_(0.8755390252983378432498497196860962665082171215981371572250371700817082375787028909649723325825612257), SC_(1.447696253701786583884030651396968902999805826132653323674426557156968642013490188736000648552878518), SC_(0.1244609747016621567501502803139037334917828784018628427749628299182917624212971090350276674174387743) }}, 
      {{ SC_(4.5), SC_(4.05000019073486328125), SC_(6.09619930418143348416524470101117228128122328067345332825921779733679304342948890732050183956106854), SC_(0.5241008985371801309146383358952143428740875054170474426280841553357280361181152065130979676546783232), SC_(5.535529092386015444978979408415092980827695025129712200643895823572937261699160376715928136350203327), SC_(0.4758991014628198690853616641047856571259124945829525573719158446642719638818847934869020323453216768) }}, 
      {{ SC_(4.5), SC_(4.5), SC_(5.086254600275426697913639521658010730996650663525051864372270593095170813752910875972462124348963572), SC_(0.4372741889138670641009400424805416858000898092452887404106985701939067450505769204643336461025544414), SC_(6.545473796292022231230584587768254531112267642278113664530843027814559491375738408063967851562308295), SC_(0.5627258110861329358990599575194583141999101907547112595893014298060932549494230795356663538974455586) }}, 
      {{ SC_(4.5), SC_(4.94999980926513671875), SC_(4.171619037527984520106404613863040137459486720891266230650903452565397410131822886149880468009497741), SC_(0.358641372571856074939053294589508679033634983899266698915641630338280455365687643506844120103652795), SC_(7.460109359039464409037819495563225124649431584911899298252210168344332894996826397886549507901774126), SC_(0.641358627428143925060946705410491320966365016100733301084358369661719544634312356493155879896347205) }}, 
      {{ SC_(4.5), SC_(9.0), SC_(0.4091290578259129167084715853082353502626692647486120256202132894658723311868270942796421924196065643), SC_(0.03517353946698479370199687053093014862983302800603394447087367382013309253731519097199460653264692538), SC_(11.2225993387415360124357525241180299118462490410545535032829003314438579739418221897567877834916653), SC_(0.9648264605330152062980031294690698513701669719939660555291263261798669074626848090280053934673530746) }}, 
      {{ SC_(4.5), SC_(450.0), SC_(0.7196318925241676790109647122732225514004728234306601365503952006972497663734022332093732557969025565e-186), SC_(0.6186801032394573312940670423335380296959282495326244342840235902543792488308251923279019916234142554e-187), SC_(11.63172839656744892914422410942626526210891830580316552890311362090973030512864928403642997591127187), SC_(1.0) }}, 
      {{ SC_(5.0), SC_(0.0500000007450580596923828125), SC_(23.99999994004916350633644961260122656653664491185268165244451756481952788144669061826601838078812299), SC_(0.9999999975020484794306854005250511069390268713271950688518548985341469950602786506533530129487017602), SC_(0.5995083649366355038739877343346335508814731834755548243518047211855331238431950262301489615187855928e-7), SC_(0.2497951520569314599474948893060973128672804931148145101465853004939721349346646987051298239750878608e-8) }}, 
      {{ SC_(5.0), SC_(2.5), SC_(21.38827245393962981636031524084932742973783628208471181487292583987325071465208671448266485830519579), SC_(0.8911780189141512423483464683687219762390765117535296589530385766613854464438367758291769089731179492), SC_(2.611727546060370183639684759150672570262163717915288185127074160126749285347916288102856145497823352), SC_(0.1088219810858487576516535316312780237609234882464703410469614233386145535561632241708230910268820508) }}, 
      {{ SC_(5.0), SC_(4.5), SC_(12.7704858329931714614725418087195748313701092021032548034028349273176889749341215454498260899815839), SC_(0.5321035763747154775613559086966489513070878834209689501417847886382370406222547436524965080056891442), SC_(11.22951416700682853852745819128042516862989079789674519659716507268231102506588145713569491382143525), SC_(0.4678964236252845224386440913033510486929121165790310498582152113617629593777452563475034919943108558) }}, 
      {{ SC_(5.0), SC_(5.0), SC_(10.57183884156509787462195997591987764644499890792012904014937903754044682698277371959369884656291927), SC_(0.4404932850652124114425816656633282352685416211633387100062241265641852844576157558256487654577723022), SC_(13.42816115843490212537804002408012235355500109207987095985062096245955317301722928299182215724009988), SC_(0.5595067149347875885574183343366717647314583788366612899937758734358147155423842441743512345422276978) }}, 
      {{ SC_(5.0), SC_(5.5), SC_(8.580432058270212656966234830489048321441708054685433321182252592334448446721753741667920409614551336), SC_(0.3575180024279255273735931179370436800600711689452263883825938580139353519467398887190411618148282154), SC_(15.41956794172978734303376516951095167855829194531456667881774740766555155327824926091760059418846781), SC_(0.6424819975720744726264068820629563199399288310547736116174061419860646480532601112809588381851717846) }}, 
      {{ SC_(5.0), SC_(10.0), SC_(0.7020645138470657441463871966283546367191653262325606846222786705870550558435704834746466702985365058), SC_(0.0292526880769610726727661331928481098632985552596900285259282779411272939934821157090356236963392941), SC_(23.29793548615293425585361280337164536328083467376743931537772132941294494415643251911087433350448264), SC_(0.9707473119230389273272338668071518901367014447403099714740717220588727060065178842909643763036607059) }}, 
      {{ SC_(5.0), SC_(500.0), SC_(0.4488697730198279270014087935779332513461985555302178400984791023118393639647158471228961467234795536e-206), SC_(0.1870290720915949695839203306574721880609160648042574333743662926299330683186316811671353639020700731e-207), SC_(24.00000000000000000000000000000000000000000000000000000000000000000000000000000300258552100380301914), SC_(1.0) }}, 
      {{ SC_(8.5), SC_(0.085000000894069671630859375), SC_(14034.40729348332597683709082089397938947082951078273372283890406365346315997830789903731495780802164), SC_(0.9999999999999938279022636529759259686788151196749348834678540104000240548960293173305107805271248809), SC_(0.8662173348708113564879084246223256289818562825896457543331130378647651698396085258692890196362671152e-10), SC_(0.6172097736347024074031321184880325065116532145989599975945103970682669489219472875119077752586483254e-14) }}, 
      {{ SC_(8.5), SC_(4.25), SC_(13398.02611556486261656519607014407040013307010409888898043369516324190546471704361222760825179948947), SC_(0.9546556427634788361102495083939179307956584074020191267048394174113457749206968247380407667019708046), SC_(636.3811779185499820053818318855577801802216392467429280334678649869910065650507633266906668611190987), SC_(0.04534435723652116388975049160608206920434159259798087329516058258865422507930317526195923329802919545) }}, 
      {{ SC_(8.5), SC_(7.650000095367431640625), SC_(8054.103015923469209837900656383346293994763127034685647011666389839598808773004782279936119536547422), SC_(0.5738826619107189324870222439209789471072353870626357940206528413726551137628061821428968526905863248), SC_(5980.304277559943388732677245646281886318528616310946261455496638389297662509089593274362799124061145), SC_(0.4261173380892810675129777560790210528927646129373642059793471586273448862371938178571031473094136752) }}, 
      {{ SC_(8.5), SC_(8.5), SC_(6376.759101295021456337303820746054585087015067521626463802044215041631715663748360323703460292800449), SC_(0.4543661137906363847016048969089946512162386170012576111346724358984223716784534102921782488634614219), SC_(7657.648192188391142233274081283573595226276675824005444665118813187264755618346015230595458367808118), SC_(0.5456338862093636152983951030910053487837613829987423888653275641015776283215465897078217511365385781) }}, 
      {{ SC_(8.5), SC_(9.3500003814697265625), SC_(4856.201041985890295975071614780753073865978989810261110175975652721427895587489346332702495579966446), SC_(0.3460210994618039219480697300093915749627105596536157299373014903896477221607016661374469354919695395), SC_(9178.206251497522302595506287248875106447312753535370798291187375507468575694605029221596423080642121), SC_(0.6539789005381960780519302699906084250372894403463842700626985096103522778392983338625530645080304605) }}, 
      {{ SC_(8.5), SC_(17.0), SC_(117.8346090840893084178053642198781750440584425703207167706619826572853421777546878511803698206227762), SC_(0.008396122944130556722290584924449112662756825312131019511304467435544622182743135302677732395312034933), SC_(13916.57268439932329015277253780975000526923330077531119169650104557161112910433968770311854883998579), SC_(0.9916038770558694432777094150755508873372431746878689804886955325644553778172568646973222676046879651) }}, 
      {{ SC_(8.5), SC_(850.0), SC_(0.6670782232751103251596111986495271866428233031128299793717854900160169024185809119064510164504617311e-347), SC_(0.4753162775779311547951717390014647469330765650819847441097078096533260879760478891033055186258358972e-351), SC_(14034.40729348341259857057790202962818031329174334563190846716302822889647128209437555429891866060857), SC_(1.0) }}, 
      {{ SC_(9.0), SC_(0.0900000035762786865234375), SC_(40319.99999999996030125065652373437331304590106001929156292487320950118655183517229729467586450286251), SC_(0.9999999999999990154080023939418247349465749270838117947153986411086603807498392677784232391922103959), SC_(0.3969874934347626562668695409893998070843707512679049881344816648072317397499073296196845258814027859e-10), SC_(0.9845919976060581752650534250729161882052846013588913396192501607322215767608077896041018200906107908e-15) }}, 
      {{ SC_(9.0), SC_(4.5), SC_(38696.82516072423952355706046040199814503747029763913999664139325564202231313424946996196835932831684), SC_(0.9597426875179622897707604280853670174860483704771612102341615390784231724487200023672016425087257103), SC_(1623.174839275760476442939539598001854962529702360860003358606744357977686867403550506682495907507633), SC_(0.04025731248203771022923957191463298251395162952283878976583846092157682755127999763279835749127428969) }}, 
      {{ SC_(9.0), SC_(8.1000003814697265625), SC_(23328.81026793695624997910761458825241844584711605221405377315554020087409799879732429012445630769103), SC_(0.5785915245024046688982913594887959429178037479179616580796913576438708853669391964979037887321261409), SC_(16991.18973206304375002089238541174758155415288394778594622684445979912590200285569617852639892813345), SC_(0.4214084754975953311017086405112040570821962520820383419203086423561291146330608035020962112678738591) }}, 
      {{ SC_(9.0), SC_(9.0), SC_(18371.91300627992311613474965070308734871070902940540801943084535447015551739359979803948312987599234), SC_(0.4556526043224187280787388306225964124184203628324753973073126327993590158084308256453020319784733739), SC_(21948.08699372007688386525034929691265128929097059459198056915464552984448260805322242916772535983214), SC_(0.5443473956775812719212611693774035875815796371675246026926873672006409841915691743546979680215266261) }}, 
      {{ SC_(9.0), SC_(9.8999996185302734375), SC_(13877.799172052158434501174306328657751917969824275897916292773962598300200139305593969624214338983), SC_(0.3441914477195475802207632516450559958312988547687474681620231637549181597257208942761352456216558902), SC_(26442.20082794784156549882569367134224808203017572410208370722603740169979986234742649902664089684147), SC_(0.6558085522804524197792367483549440041687011452312525318379768362450818402742791057238647543783441098) }}, 
      {{ SC_(9.0), SC_(18.0), SC_(284.4982888269366160877517511252798455244028043822653104845308033312273987827926604521949427819652366), SC_(0.007056009147493467660906541446559519978283799711861738851302847304841949374574125956866063564974443447), SC_(40035.50171117306338391224824887472015447559719561773468951546919666877260121886036001645591245385924), SC_(0.9929439908525065323390934585534404800217162002881382611486971526951580506254258740431339364350255566) }}, 
      {{ SC_(9.0), SC_(900.0), SC_(0.5926245805028194096046641666744185620899605952111155892295120431029813271130855411472723676020689805e-367), SC_(0.1469803027040722742075059937188538100421529253995822393922400900553029085102085157260496058195358159e-371), SC_(40320.00000000000000000000000000000000000000000000000000000000000000000000000165302046865085523582448), SC_(1.0) }}, 
      {{ SC_(12.5), SC_(0.125), SC_(136843365.4655658572552832108710781298837797782743070196644786942067000763272295928128074707860359726), SC_(0.9999999999999999999973208812679129139294956056134857683730770608400891033370414969480772869888334185), SC_(0.3666196237806365401262424499185233610246580977350430222810467436716103864309508576100159651900479157e-12), SC_(0.2679118732087086070504394386514231626922939159910896662958503051922713011166581494211385930044649959e-20) }}, 
      {{ SC_(12.5), SC_(6.25), SC_(134388480.8348861198942052583624979739301466738655918286054043179133685225593287078568623470331726701), SC_(0.9820606236749017663807192707405338778700064351721085883766267815658460169631346032239469936514779267), SC_(2454884.630679737361444572132360792493759346858633714420099034391066596790181931699616734139294253291), SC_(0.01793937632509823361928072925946612212999356482789141162337321843415398303686539677605300634852207334) }}, 
      {{ SC_(12.5), SC_(11.25), SC_(83027628.16981147712375563451033436655437271770891097986620758512457999554746790704981173672571558316), SC_(0.6067347721779311900721361379468091439464114517216831148497311096636630527642744678296329544090654199), SC_(53815737.29575438013189419598452439986953330301531456315929576717985512380204273250666734444675134028), SC_(0.3932652278220688099278638620531908560535885482783168851502688903363369472357255321703670455909345801) }}, 
      {{ SC_(12.5), SC_(12.5), SC_(63272768.13751895464258795290545161333864191418938437646234170610660866375871319512717114875416932903), SC_(0.4623736629266136790024432589792019686354588142002833695517147973817691441435368874792553281999201132), SC_(73570597.32804690261306187758940715308526410653484116656316164619782645559079744442930793241829759441), SC_(0.5376263370733863209975567410207980313645411857997166304482852026182308558564631125207446718000798868) }}, 
      {{ SC_(12.5), SC_(13.75), SC_(45346885.09422811486658694309600617993749255628538664364547804938729523276990649428521561499639323683), SC_(0.3313780316637917920196119406319880633992936874126714113490597824450097093678546877611635257158571186), SC_(91496480.37133774238906288739885258648641346443883889938002530291713988657960414527126346617607368661), SC_(0.6686219683362082079803880593680119366007063125873285886509402175549902906321453122388364742841428814) }}, 
      {{ SC_(12.5), SC_(25.0), SC_(291634.0009284780453292067517573397586842917452779710909635632059087586245211603178769195818161764942), SC_(0.002131151919103176651421229050736255386147703297527935085263815602097869498819238660830130173071480489), SC_(136551731.4646373792103206237431014266652217289789475719345397890985263607249894792386021615906507469), SC_(0.9978688480808968233485787709492637446138522967024720649147361843979021305011807613391698698269285195) }}, 
      {{ SC_(12.5), SC_(1250.0), SC_(0.5628251838370822093670984549813087655823566109419034942886891209494234710050575637479118869427495642e-507), SC_(0.411291538995879873328878609309656920676985362275527041419982584635789356289490443028297038424111637e-515), SC_(136843365.4655658572556498304948587664239060207242255430255033523044351193495106395564790811724669234), SC_(1.0) }}, 
      {{ SC_(13.0), SC_(0.12999999523162841796875), SC_(479001599.9999999999997935044119758872017543686979717359487267304675573748752553442191357808632655649), SC_(0.9999999999999999999995689041789753671005574275701203001174249323333311932023985019238725430971056006), SC_(0.2064955880241127982456313020282640512732695324426251261419937408619736604156877680428486714937330842e-12), SC_(0.4310958210246328994425724298796998825750676666688067976014980761274569028943994324163838490197552124e-21) }}, 
      {{ SC_(13.0), SC_(6.5), SC_(471324812.7573446522734391013173479981711440350239466084047496559556554645949851471568565525252985193), SC_(0.9839733578287518293747643041638023717898730088249112495756791959685634966428543264700094539465652269), SC_(7676787.242655347726560898682652001828855964976053391595250344044344535406412190803141201998382733319), SC_(0.01602664217124817062523569583619762821012699117508875042432080403143650335714567352999054605343477306) }}, 
      {{ SC_(13.0), SC_(11.69999980926513671875), SC_(292302230.0070816725963746814544762636696872449572392926743002189206720871146379793884644857870608234), SC_(0.6102322622869770635345992194065244535084793974743284629410428251610685373736466383236007293439402457), SC_(186699369.9929183274036253185455237363303127550427607073256997810793279128867593585715332687366204292), SC_(0.3897677377130229364654007805934755464915206025256715370589571748389314626263533616763992706560597543) }}, 
      {{ SC_(13.0), SC_(13.0), SC_(221827914.8283426812449459618039906537723573924659330648043327121351752797310404569796170445996717871), SC_(0.4631047470996812562733526606257487527648287447597942570637190191748321503162961920101893109881448021), SC_(257173685.1716573187550540381960093462276426075340669351956672878648247202703568809803807099240094655), SC_(0.5368952529003187437266473393742512472351712552402057429362809808251678496837038079898106890118551979) }}, 
      {{ SC_(13.0), SC_(14.30000019073486328125), SC_(157870572.9946750210561331758305711988362338633785606617656456973172395769927459457056301224641362476), SC_(0.329582558794532254289198983532771495619709544558015384010503717142572335862974894377941612540757116), SC_(321131027.005324978943866824169428801163766136621439338234354302682760423008651392254367632059545005), SC_(0.670417441205467745710801016467228504380290455441984615989496282857427664137025105622058387459242884) }}, 
      {{ SC_(13.0), SC_(26.0), SC_(862321.9649085756573800795187107689377787187372682479262292804996623980360097518564772688401806784177), SC_(0.001800248610669725648891526706196323640210635491130401080558562851694854539143837614711873175552347863), SC_(478139278.0350914243426199204812892310622212812627317520737707195003376019653875861035204856835005742), SC_(0.9981997513893302743511084732938036763597893645088695989194414371483051454608561623852881268244476521) }}, 
      {{ SC_(13.0), SC_(1300.0), SC_(0.6144946500866966819756400515650559966475045454738436270212962186900798179035639824155522896612464956e-527), SC_(0.128286554802050072896549834398268397568505939327518661111214705481167457041655740607512514973641764e-535), SC_(479001600.0000000000000000000000000000000000000000000000000000000000000000013973379599977545236812526), SC_(1.0) }}, 
      {{ SC_(16.5), SC_(0.16500000655651092529296875), SC_(5189998453040.125083072481768017699264732447502030220543657187756599284467539650371809581521974169451), SC_(0.9999999999999999999999999987745723382650967236488722150412128312324639515303454146319825385083954406), SC_(0.6359967668716725687093414777996004228534393113952843900038379123266266578879036227239604343598224411e-14), SC_(0.1225427661734903276351127784958787168767536048469654585368017461491604559374266453131429478017582777e-26) }}, 
      {{ SC_(16.5), SC_(8.25), SC_(5151715261216.043779837218979035256352959647395813624635667529855145298731587875407962709872303583674), SC_(0.992623660263009075122253184587048540801846945918618221589970313303750650979766762075115667286754522), SC_(38283191824.08130323526279534241058048952579331001068598566212998837884990461886388525077293685235596), SC_(0.007376339736990924877746815412951459198153054081381778410029686696249349020233237924884332713245478029) }}, 
      {{ SC_(16.5), SC_(14.8500003814697265625), SC_(3281170062324.489562662671371498689785819541458453535252942745406987512366194288716459533042446669149), SC_(0.6322102197164416139523032718656298410408290904170998573677743388398243158258125272315355187754506265), SC_(1908828390715.63552040981040287897714762963173067010006871044657814616521529820555538842760279376688), SC_(0.3677897802835583860476967281343701589591709095829001426322256611601756841741874727684644812245493735) }}, 
      {{ SC_(16.5), SC_(16.5), SC_(2425041731503.939538171649250125627303277592420419824296183298715413344683420634781457884706240902129), SC_(0.4672528813729091447747883941065008886716783719424019151711359825453585798767668818478603996596143678), SC_(2764956721536.1855449008325242520396301715807687038110254698932697203328980718594903900759389995339), SC_(0.5327471186270908552252116058934991113283216280575980848288640174546414201232331181521396003403856322) }}, 
      {{ SC_(16.5), SC_(18.1499996185302734375), SC_(1647422133289.360209741648510375741060393355812928732413438306313733302833145045026521944676353539372), SC_(0.3174224709690146812698759704116603688189327167560198106058627367921125935495318348074863075386583803), SC_(3542576319750.764873330833264001925873055817376194902908214885671400374748347449245326015968886896658), SC_(0.6825775290309853187301240295883396311810672832439801893941372632078874064504681651925136924613416197) }}, 
      {{ SC_(16.5), SC_(33.0), SC_(2901186058.305020571211999232924516665685282077969962057923379163927126135950413482820943636880932982), SC_(0.0005589955535739329878732234056712927392864902633844918831542774874781904321157456359281689093477538193), SC_(5187097266981.820062501269775144742416783487907045665359595268605969750455356543858365139701603555097), SC_(0.9994410044464260670121267765943287072607135097366155081168457225125218095678842543640718310906522462) }}, 
      {{ SC_(16.5), SC_(1650.0), SC_(0.1946267352533885182968524738572152665958498958163999880266472538302199673522698959999334614825229749e-666), SC_(0.3750034552310565280576801157233877619635177889025441075563944573941372570215399044083676072009131442e-679), SC_(5189998453040.12508307248177437766693344917318912363532165319198513367758149249427184796064524043603), SC_(1.0) }}, 
      {{ SC_(17.0), SC_(0.17000000178813934326171875), SC_(20922789887999.99999999999999585550285263989865320908990534962201305988055560727127752501054067134438), SC_(0.9999999999999999999999999998019146983004821471162827893590335907052378154555171021536348839906953415), SC_(0.4144497147360101346790910094650377986940119446152096661248865026795426422808553938948145597829161787e-14), SC_(0.1980853016995178528837172106409664092947621845444828978463651160093046585489828581527528828869466675e-27) }}, 
      {{ SC_(17.0), SC_(8.5), SC_(20784433600502.67097540303723378137542756521119723064689816850936499894851390923610404778992152582084), SC_(0.9933872926011324372480854707028531159699428319963180857694473333229961130562576444429883043720757676), SC_(138356287497.3290245969627662186245724347888027693531018314906350010514878501318347260856459409499552), SC_(0.00661270739886756275191452929714688403005716800368191423055266667700388694374235555701169562792423245) }}, 
      {{ SC_(17.0), SC_(15.30000019073486328125), SC_(13287099753146.81563908726762911180304218042070867906651510632558234141904270956355097166492372652512), SC_(0.6350539208333522810496460131116431656908306810923448926959049708132985978549285020416193402477180332), SC_(7635690134853.184360912732370888196957819579291320933484893674417658580959049804387802210643740245682), SC_(0.3649460791666477189503539868883568343091693189076551073040950291867014021450714979583806597522819668) }}, 
      {{ SC_(17.0), SC_(17.0), SC_(9786389836065.484662933923931178566154761312673926353042493107631067618977440495765314161347875510856), SC_(0.4677382838738128355157682846764037701720724116238065355700382030748240423080178307084005801282570024), SC_(11136400051934.51533706607606882143384523868732607364695750689236893238102431887217345971421959125994), SC_(0.5322617161261871644842317153235962298279275883761934644299617969251759576919821692915994198717429976) }}, 
      {{ SC_(17.0), SC_(18.700000762939453125), SC_(6606316846932.248047783850738006295546650522014877213547484123836773443331813812630509278068947506478), SC_(0.3157474162048158330090405741786272220223388411095826011615743008876810899891639366537189641631440663), SC_(14316473041067.75195221614926199370445334947798512278645251587616322655666994555530826459749851926432), SC_(0.6842525837951841669909594258213727779776611588904173988384256991123189100108360633462810358368559337) }}, 
      {{ SC_(17.0), SC_(34.0), SC_(9910056056.804399413187707484361240049353376906731624036494056243934933698596212859019749196574567885), SC_(0.0004736488828618494136639923172162211434311650105469731913265417122911239599294674476619883710998844076), SC_(20912879831943.19560058681229251563875995064662309326837596350594375606506806077172591485581827019623), SC_(0.9995263511171381505863360076827837788565688349894530268086734582877088760400705325523380116289001156) }}, 
      {{ SC_(17.0), SC_(1700.0), SC_(0.2458486870964415317217718788554326586945418246595856381802945647755080667210486890463968024635167932e-686), SC_(0.1175028227174641365503215432640837781444444741248006352776382499107702489871018536223821644052375213e-699), SC_(20922789888000.0000000000000000000000000000000000000000000000000000000000017593679387738755674667708), SC_(1.0) }}, 
      {{ SC_(20.5), SC_(0.20499999821186065673828125), SC_(540624298233507504.473687364780821829102087234025696758243578603379333048033861452074846033633078383), SC_(0.999999999999999999999999999999999422657785775772262737062201125061400042154183032910755146252341537), SC_(0.3121252294055524747207166162228645932491013737698168406518342062954509290310466641126750345014703397e-15), SC_(0.5773422142242277372629377988749385999578458169670892448537476584629559849301971871019075211556113262e-33) }}, 
      {{ SC_(20.5), SC_(10.25), SC_(538946805335988652.0709965042629878388797336290391983067462526312939781227450734454841507688955033896), SC_(0.9968971189363850856943032162663079377677473800330018691355952317262889335515107133697970076615234958), SC_(1677492897518852.402690860517834302347583010538973172213942194949948174390161776407535916571781288832), SC_(0.003102881063614914305696783733692062232252619966998130864404768273711066448489286630202992338476504222) }}, 
      {{ SC_(20.5), SC_(18.5), SC_(350870600436163198.7364975318180419252982809735188997582318059369662979807981699981363242839334102096), SC_(0.6490100455762616918406256396197338343553551005208322891662299606718936269597316444769779046824470834), SC_(189753697797344305.7371898329627802159290356660592717207283888892776283163370652237553624015338744688), SC_(0.3509899544237383081593743603802661656446448994791677108337700393281063730402683555230220953175529166) }}, 
      {{ SC_(20.5), SC_(20.5), SC_(254429892200746877.619547267113914421792554743293110951578043017441766619415833128863308491477095986), SC_(0.4706223768189808976345190174958215496863188395818484023720734533436530753835271399969728679308838697), SC_(286194406032760626.8541400976669077194347618962850605273821518088021596777194020930283781939901886924), SC_(0.5293776231810191023654809825041784503136811604181515976279265466563469246164728600030271320691161303) }}, 
      {{ SC_(20.5), SC_(22.5), SC_(166564230981595225.1232057180177844971941373641092607315100831817200402016941276034724830431086627961), SC_(0.3080960872936060240510470665024940294803493434512654502154415432746618007430058687457265447073002346), SC_(374060067251912279.3504816467630376440331792754689107474501116445238860954411076184192036423586218823), SC_(0.6919039127063939759489529334975059705196506565487345497845584567253381992569941312542734552926997654) }}, 
      {{ SC_(20.5), SC_(41.0), SC_(80908170732637.92511208009816068271109417702109468117761455902142043347907731125572368454312466128223), SC_(0.0001496569262554527464745335325685386464583793728562383901263243260613982847006246072548944091071889976), SC_(540543390062774866.5485752846826614585162224625570767977825802672225058636561579106359630009241600171), SC_(0.999850343073744547253525466467431461353541620627143761609873675673938601715299375392745105590892811) }}, 
      {{ SC_(20.5), SC_(2050.0), SC_(0.1903974835689651617706004158608178882122332263643773645562260375004357181223818669293650115572363009e-825), SC_(0.3521807735817458730053494830686081463253394537138516157394953530571968070553995753734356429302753096e-843), SC_(540624298233507504.4736873647808221412273166395781714789601948262439262971352352218916866854672846784), SC_(1.0) }}, 
      {{ SC_(21.0), SC_(0.20999999344348907470703125), SC_(2432902008176639999.999999999999999772308157712399209862411173233862762286153636670126899636089253877), SC_(0.9999999999999999999999999999999999064114207960860446184442190293349354799025878974408527618001186727), SC_(0.2276918422876007901375888267661372377170528272567496581283801933546699751824687019116072780799381851e-15), SC_(0.9358857920391395538155578097066506452009741210255914723819988132728539758629841178518386142714303973e-34) }}, 
      {{ SC_(21.0), SC_(10.5), SC_(2426119495007797370.40376524336035175028046790074405731296091680086344729734192262453341420636270341), SC_(0.9972121716591759302793458038182555963815913921508066795312531588781716095021759440337735350673534736), SC_(6782513168842629.59623475663964824971953209925594268703908319913655270586454130234314355810674382143), SC_(0.002787828340824069720654196181744403618408607849193320468746841121828390497824055966226464932646526408) }}, 
      {{ SC_(21.0), SC_(19.0), SC_(1574511812824323347.940041254339858588371158799540091638983719756794324353518472514974332612071125281), SC_(0.6471743652365000917310541667062840372172362427537768011343976097544263909327586354003721706607604771), SC_(858390195352316652.0599587456601414116288412004599083610162802432056756496879914119022251523983219507), SC_(0.3528256347634999082689458332937159627827637572462231988656023902455736090672413645996278293392395229) }}, 
      {{ SC_(21.0), SC_(21.0), SC_(1145834475653466482.061252354627279360127134084576577302508463538933399896676314167403702844750897965), SC_(0.4709743638677096979187745869898213414114836156728811564349721279282722447347523831952859753731266863), SC_(1287067532523173517.938747645372720639872865915423422697491536461066600106530149759472854919718549267), SC_(0.5290256361322903020812254130101786585885163843271188435650278720717277552652476168047140246268733137) }}, 
      {{ SC_(21.0), SC_(23.0), SC_(754444010774681179.1782906259030682866725169347550464981575900964019870763849280489300061368765366202), SC_(0.3101004513289484840835994598244177527470443778390800601682494869205054681232211068119294191807642768), SC_(1678457997401958820.821709374096931713327483065244953501842409903598012926821535877946551627592910611), SC_(0.6898995486710515159164005401755822472529556221609199398317505130794945318767788931880705808192357232) }}, 
      {{ SC_(21.0), SC_(42.0), SC_(309138187487010.162720227677303694050835397549248621949449793686714776813069243490510764208520969702), SC_(0.0001270656140066638033956074498302991046310047335891718633118915033504153772916738580086368580494085496), SC_(2432592869989152989.837279772322696305949164602450751378050550206313285226393394683386047000260926262), SC_(0.9998729343859933361966043925501697008953689952664108281366881084966495846227083261419913631419505915) }}, 
      {{ SC_(21.0), SC_(2100.0), SC_(0.269232728131886828359357484553907523109988255735406905387089068170333762311982842516226640368397699e-845), SC_(0.1106632027212907295321977020988755421386634327493363623489788714601653349619878624154520901787534427e-863), SC_(2432902008176640000.000000000000000000000000000000000000000000000000000003206463926876557764469447232), SC_(1.0) }}, 
      {{ SC_(24.5), SC_(0.24500000476837158203125), SC_(125990634307293746235546.2120618541659368807444577235295166230949255268732373652108637623329938479225), SC_(0.9999999999999999999999999999999999999997227611781397184300222785264653695545658388153856097297425985), SC_(0.3492949502078369059138366090493797207621490149796207508388319605878367180147682626114416143072027397e-16), SC_(0.2772388218602815699777214735346304454341611846143902702574015423419761143217374412527475730060597296e-39) }}, 
      {{ SC_(24.5), SC_(12.25), SC_(125823677034648511889061.3572394022933144208926313405896801819149937631935451893327901924439542097587), SC_(0.9986748437805462418145972988119198275209493269836409931338017356688128141602611602377636443528815348), SC_(166957272645234346484.854822451872622494781321403723527032563592668617664252092975067851114722047059), SC_(0.001325156219453758185402701188080172479050673016359006866198264331187185839738839762236355647118465171) }}, 
      {{ SC_(24.5), SC_(22.5), SC_(80127563162173678805638.4970827497912620494334933283216359134701980355856839098748854660331866976061), SC_(0.6359803139552492893898058540149147647405033187209937102704148384920623287552354155265294006673620328), SC_(45863071145120067429907.71497910437467486624045941599157130100838839622552553155087979426188223419962), SC_(0.3640196860447507106101941459850852352594966812790062897295851615079376712447645844734705993326379672) }}, 
      {{ SC_(24.5), SC_(24.5), SC_(59609734078272681283130.65191195770102228216411883482727180600153695436445385451381437373924724460492), SC_(0.4731282956547652173997215352208794210103454607852125399426567531974233945440640175005045276462118007), SC_(66380900229021064952415.56014989646491463350983390948593540847704947744675558691195088655582168720079), SC_(0.5268717043452347826002784647791205789896545392147874600573432468025766054559359824994954723537881993) }}, 
      {{ SC_(24.5), SC_(26.5), SC_(40640753938080337896226.24784239868443178185802774240148815785844665586470001481354635904215035959368), SC_(0.322569643065346459458351118206279802619959503357154901174282534384133594129380080161822100237270034), SC_(85349880369213408339319.96421945548150513381592500191171905662013977594650942661221890125291857221204), SC_(0.677430356934653540541648881793720197380040496642845098825717465615866405870619919838177899762729966) }}, 
      {{ SC_(24.5), SC_(49.0), SC_(5119371947749950369.360329185306941605229857346797596446200986494865710182516154021979872797215122826), SC_(0.4063295637724703396262423754457665635181954799841258697689252008320003697674069166126366226246611348e-4), SC_(125985514935345996285176.8517326688589953104440953975156107682775999369454992589096112383151961345906), SC_(0.9999593670436227529660373757624554233436481804520015874130231074799167999630232593083387363377375339) }}, 
      {{ SC_(24.5), SC_(2450.0), SC_(0.4247235832898155088040188524650788769670099653858944485985120151767792440690541620633018317571613247e-984), SC_(0.3371072664448263359905527459359500845898141806821150832587857954598321585796405105835652436721220935e-1007), SC_(125990634307293746235546.2120618541659369156739527443132072144785864318112094414257652602950689318057), SC_(1.0) }}, 
      {{ SC_(25.0), SC_(0.25), SC_(620448401733239439359999.9999999999999999720629086296192064573656184799764082902831108548614175919024), SC_(0.9999999999999999999999999999999999999999549727402112121313707979195640051759926386511151612192034694), SC_(0.2793709137038079354263438152003183658267823026382085865724949244620001425981390784977186842179479799e-16), SC_(0.4502725978878786862920208043599482400736134888483878079653064270040072612275539760669481124560941441e-40) }}, 
      {{ SC_(25.0), SC_(12.5), SC_(619708548751205438154180.288847809651254660315390966301020278449415356119729789629696595664987296899), SC_(0.9988075511517682988099491921420578379705307819799838443610602594400026335328279205785417246744370559), SC_(739852982034001205819.7111521903487453396846090336989797215505846438885150833316445230172889522528912), SC_(0.001192448848231701190050807857942162029469218020016155638939740559997366467172079421458275325562944144) }}, 
      {{ SC_(25.0), SC_(23.0), SC_(393724645607384737076425.2982613186871819894810046263128270697847090072077220492330717222680143784832), SC_(0.6345808039919262587136029033874392715156908989961508509135117393705667712146254420732533914020784457), SC_(226723756125854702283574.7017386813128180105189953736871729302152909928005228237282693964142618706687), SC_(0.3654191960080737412863970966125607284843091010038491490864882606294332287853745579267466085979215543) }}, 
      {{ SC_(25.0), SC_(25.0), SC_(293719323198750164455426.9103167580915569762577632520173320353301458358294584503831662869002913569104), SC_(0.4733984685563493567248096097898752542226436634054655335626455002445213651680516573325489729171204834), SC_(326729078534489274904573.0896832419084430237422367479826679646698541641787864225781748317819848922414), SC_(0.5266015314436506432751903902101247457773563365945344664373544997554786348319483426674510270828795166) }}, 
      {{ SC_(25.0), SC_(27.0), SC_(201123340746644881844220.8766347887740077661869208057270231263993264704535307521596567681820867410827), SC_(0.3241580447057343917309158720274329468745713576502590752898666717688528508234278623287842755377330191), SC_(419325060986594557515779.1233652112259922338130791942729768736006735295547141208016843505001895080692), SC_(0.6758419552942656082690841279725670531254286423497409247101333282311471491765721376712157244622669809) }}, 
      {{ SC_(25.0), SC_(50.0), SC_(21436066546709693903.93782557631631091258857629862868097328697281172967238027768701290777149493027156), SC_(0.3454931382984863942145434713316366603841537912110553761218525385413889480554247251480899217714546107e-4), SC_(620426965666692729666096.0621744236836890874114237013713190267130271882785724926836541057745047542216), SC_(0.9999654506861701513605785456528668363339615846208788944623878147461458611051944575274851910078228545) }}, 
      {{ SC_(25.0), SC_(2500.0), SC_(0.6584808048840185477562925343128472681602285612814620235060693586441766630455361239730732391922799346e-1004), SC_(0.1061298253077185078725394204668571235682904586641213114611433592873760496552482744000852142731313932e-1027), SC_(620448401733239439360000.0000000000000000000000000000000000000000000000082448729613411186822762491519), SC_(1.0) }}, 
      {{ SC_(28.5), SC_(0.2849999964237213134765625), SC_(57361842800962338401329150199.53762058572292903857693300666646513812664420063937337854946606911979551), SC_(0.9999999999999999999999999999999999999999999998650877932614163884503521966751540210985757416423689422), SC_(0.773881279486956501771975804719669109144808525603519258451641516404494312769694124793526358376902158e-17), SC_(0.1349122067385836115496478033248459789014242583576310578082789420105686804839321529882474826011261937e-45) }}, 
      {{ SC_(28.5), SC_(14.25), SC_(57329025675645999380007424269.04064586340779307886426110851578087473411487441327382336789506042295454), SC_(0.9994278927643553937468831308065942000301145480407243376019932583695816802749987696506391122273593834), SC_(32817125316339021321725930.49697472231513596745148469302024928111228737342279064662965626473203355664), SC_(0.0005721072356446062531168691934057999698854519592756623980067416304183197250012303493608877726406166465) }}, 
      {{ SC_(28.5), SC_(26.5), SC_(35900570085871452757017625073.99150603062055829813329369820580014734075607878374962697352000668696698), SC_(0.6258615193106934525309695815894821675982186893256384744865035810569936289601844746660081346337305862), SC_(21461272715090885644311525125.54611455510237074818245210333023000850564616905231484302403131846802112), SC_(0.3741384806893065474690304184105178324017813106743615255134964189430063710398155253339918653662694138) }}, 
      {{ SC_(28.5), SC_(28.5), SC_(27251805466015208513274388051.73652891177668287898939088182153854916869634549769806111713198302867877), SC_(0.4750859479981353573526392824740128561807258770438950341897088086926527360947287856209388429944526139), SC_(30110037334947129888054762147.80109167394624616732635491971449160667770590233836640888041934212630933), SC_(0.5249140520018646426473607175259871438192741229561049658102911913073472639052712143790611570055473861) }}, 
      {{ SC_(28.5), SC_(30.5), SC_(19170265674526286520153832711.74345643559517044329286019886266031241054742932788446962284446043294663), SC_(0.3341989158375622142627673369464799595201121767850709186387023981469534828783915690297939739791899987), SC_(38191577126436051881175317487.79416415012775860302288560267336984343585481850818000037470686472204147), SC_(0.6658010841624377857372326630535200404798878232149290813612976018530465171216084309702060260208100013) }}, 
      {{ SC_(28.5), SC_(57.0), SC_(639329848034974228423164.6769791395427949161694033112723560390640960090171034897451044917959104939978), SC_(0.1114555978010260905081072913758752125683667623823399293671927836431826219358538594148130563541170252e-4), SC_(57361203471114303427100727034.8606414461801341301463424902636741167823062388189609802524468333590776), SC_(0.9999888544402198973909491892708624124787431633237617660070632807216356817378064146140585186943645883) }}, 
      {{ SC_(28.5), SC_(2850.0), SC_(0.1875727032021411982480690374486891806913355006814066726466649598131563144124266462854328230307976818e-1142), SC_(0.3269990886676924550370677343728083793689049803281483380025931735824580936767960581845054313877892179e-1171), SC_(57361842800962338401329150199.5376205857229290463157458015360301558464022478360644699975513251549881), SC_(1.0) }}, 
      {{ SC_(29.0), SC_(0.2899999916553497314453125), SC_(304888344611713860501503999999.9999999999999999933101642923344849147721790748589030351108422499829174), SC_(0.9999999999999999999999999999999999999999999999780580798646623945308161718263006180927167389812479563), SC_(0.6689835707665515085227850163723649978463120941468404076192514605282469263295003764492776748505276162e-17), SC_(0.2194192013533760546918382817369938190728326101875204366944898705411657891135681016899378264254524897e-46) }}, 
      {{ SC_(29.0), SC_(14.5), SC_(304731204308214173404715900123.779306684005152489587864590044536816454370420630653532998543059317866), SC_(0.9994845972098414885079798582306346252147472873798195624648386116966405572046848552450752025928549427), SC_(157140303499687096788099876.2206933159948475104121354099554631835456588179518994805754201321334555052), SC_(0.0005154027901585114920201417693653747852527126201804375351613883033594427953151447549247974071450573192) }}, 
      {{ SC_(29.0), SC_(27.0), SC_(190478756652745756527055462749.1062733701646395525538196356867639581367814280618613549309949857289277), SC_(0.6247492238357855916234987901478134054280690819197591729256016201075976808091531275087303563717011732), SC_(114409587958968103974448537250.8937266298353604474461803643132360418632478105206916586429682057223937), SC_(0.3752507761642144083765012098521865945719309180802408270743983798924023191908468724912696436282988268) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(144913957084466230660547260160.7178382854814124107141846396590098933632626358828780113583703346060302), SC_(0.4753017281425411777481301424926433731869994151512845251734232068420156660058770258953501884904752115), SC_(159974387527247629840956739839.2821617145185875892858153603409901066367666026996750022155928568452912), SC_(0.5246982718574588222518698575073566268130005848487154748265767931579843339941229741046498115095247885) }}, 
      {{ SC_(29.0), SC_(31.0), SC_(102289287494407775982367094392.8031479859409851583807385513331066341315796955931008571539647874864497), SC_(0.3354975331204504322032237504004497778805206868587854082637595456617490065929415360431775135687466019), SC_(202599057117306084519136905607.1968520140590148416192614486668933658684495429894521564199984039648718), SC_(0.6645024668795495677967762495995502221194793131412145917362404543382509934070584639568224864312533981) }}, 
      {{ SC_(29.0), SC_(58.0), SC_(2892517074287968989912469.888918702879367020618358913421677538548776524150308136922924925839572096239), SC_(0.9487135619997846276151041345405856302838389761000159801100790909631178603269050851607213365638567364e-5), SC_(304885452094639572532514087530.1110812971206329793816410865783224614512527144322448766510382656117494), SC_(0.9999905128643800021537238489586545941436971616102389998401988992090903688213967309491483927866343614) }}, 
      {{ SC_(29.0), SC_(2900.0), SC_(0.3143102259608077661740577752916068744868021451921564246761123455026351071030263789592698013016859553e-1162), SC_(0.1030902727229842145420823591763412232948519431888416610764325060829822574393741681193444602752178939e-1191), SC_(304888344611713860501504000000.0000000000000000000000000000000000000000292385825530135739631914513215), SC_(1.0) }}, 
      {{ SC_(32.5), SC_(0.324999988079071044921875), SC_(46334060788513904384988971821323500.26802927540630912915186063279843684009289524602475103569566120769), SC_(0.9999999999999999999999999999999999999999999999999999337002400254654465134437777742026615770780541156), SC_(0.3071937108923965070627162971161280609031648943051554034889576558366642743362284829170009040890767968e-17), SC_(0.6629975997453455348655622222579733842292194588440659557355121773647380912409957308044925536720187399e-52) }}, 
      {{ SC_(32.5), SC_(16.25), SC_(46322522730222611292608497533548302.43943777548545116639369338978347802543343303135760668007261667008), SC_(0.9997509810688953611501047192176947134897284736418296905462081746004660191828341581576205721672751686), SC_(11538058291293092380474287775197.82859149992085796583010435193892388528662518582842496465469348066164), SC_(0.0002490189311046388498952807823052865102715263581703094537918253995339808171658418423794278327248313602) }}, 
      {{ SC_(32.5), SC_(30.5), SC_(28621007643720182006077134838146782.95883906379256793188822237091897230621059367776008945872023656119), SC_(0.6177098910962549796098763032964066958628227303028015095518499614723898239110229739106407453151542127), SC_(17713053144793722378911836983176717.30919021161374120033557537080342960450946453942594218600707358956), SC_(0.3822901089037450203901236967035933041371772696971984904481500385276101760889770260893592546848457873) }}, 
      {{ SC_(32.5), SC_(32.5), SC_(22086053016848511566963307387930013.16260281540273487265707840984355296181178149718030229778163622351), SC_(0.4766699192988409044611385448927340913390216019830607900339534117343979333601086446612686588650620676), SC_(24248007771665392818025664433393487.10542646000357425956671933187884894890827672000572934694567392723), SC_(0.5233300807011590955388614551072659086609783980169392099660465882656020666398913553387313411349379324) }}, 
      {{ SC_(32.5), SC_(34.5), SC_(15929984929735402664933756144665957.49287311113186407619356762099919819017469613256737240979297707395), SC_(0.3438072264472101987883211998866135121555991482820664842271765773700151264261197086071726004781636204), SC_(30404075858778501720055215676657542.77515616427444505603023012072320372054536208461865923493433307679), SC_(0.6561927735527898012116788001133864878444008517179335157728234226299848735738802913928273995218363796) }}, 
      {{ SC_(32.5), SC_(65.0), SC_(142761347286773564929810657719.9602609908854108736907492246016219341962310483549118706465501178102169), SC_(0.3081131782046691214702430585972536329343580504205419131996313773478525625472231412293455075097903735e-5), SC_(46333918027166617611424042010665780.30776828452089825853304851712077997652382716883111977408076003294), SC_(0.9999969188682179533087852975694140274636706564194957945808680036862265214743745277685877065449249021) }}, 
      {{ SC_(32.5), SC_(3250.0), SC_(0.1484185597736004907504358778932123824630239848300836183590157424893530365583445173075870585504689164e-1300), SC_(0.3203227976305350589149255291837955379623896649388683491749264167255028925437095164617203676065096547e-1335), SC_(46334060788513904384988971821323500.26802927540630913222379774172240191072005821718603164472731015075), SC_(1.0) }}, 
      {{ SC_(33.0), SC_(0.3300000131130218505859375), SC_(263130836933693530167218012159999999.9999999999999999971597009336809473588262277616785778368781691701), SC_(0.9999999999999999999999999999999999999999999999999999892057536873385115678521964144069695214796957037), SC_(0.2840299066319052781318762073475803811776132238243053482256197592739651068520683692770637579337711626e-17), SC_(0.1079424631266148843214780358559303047852030429631156728354872666198273180917792118476042704403843341e-52) }}, 
      {{ SC_(33.0), SC_(16.5), SC_(263071754810938555593905150285830039.9013149090036838977830493205901675724636474415759841358850045707), SC_(0.9997754648469048015582150573448994889541539147463865500821162324772215895513769125072676674716742899), SC_(59082122754974573312861874169960.09868509099631610221695067940983256768134239357839751276929683761343), SC_(0.0002245351530951984417849426551005110458460852536134499178837675227784104486230874927323325283257100747) }}, 
      {{ SC_(33.0), SC_(31.0), SC_(162298695681589120992228451249431749.1182640646309791272297056919375804404812200726519322580585642423), SC_(0.6167984625932947936660006970927840753925768251839107574617248176524285825042695426028932570342212548), SC_(100832141252104409174989560910568250.881735935369020872770294308062419699663769762502449390595737166), SC_(0.3832015374067052063339993029072159246074231748160892425382751823475714174957304573971067429657787452) }}, 
      {{ SC_(33.0), SC_(33.0), SC_(125473252468549551731963143517407658.8833751453695524982663979524542201016894851346678414375457457378), SC_(0.4768473886630308507823781455837688570632946883204313471614756839792705550160238355942104302601025457), SC_(137657584465143978435254868642592341.1166248546304475017336020475457800384555047004865402111085556706), SC_(0.5231526113369691492176218544162311429367053116795686528385243160207294449839761644057895697398974543) }}, 
      {{ SC_(33.0), SC_(35.0), SC_(90752382644240602265695985840268093.80155020103808767855232207731872018001496004374357967883306848595), SC_(0.3448945159822120737797161944821761022350313753814505254141386911335679511045428020170838067055914315), SC_(172378454289452927901522026319731906.1984497989619123214476779226812799601300297914108019698212329224), SC_(0.6551054840177879262202838055178238977649686246185494745858613088664320488954571979829161932944085685) }}, 
      {{ SC_(33.0), SC_(66.0), SC_(690689197981234573971964538903.9217983821756186614812519665732869336692719821881476009486685956504548), SC_(0.2624888842485921506876304750022556823451127207465239231677013156569163155317600802678203776018185223e-5), SC_(263130146244495548932644040195461096.0782016178243813385187480334267132064757178529662340477056328127), SC_(0.9999973751111575140784931236952499774431765488727925347607683229868434308368446823991973217962239818) }}, 
      {{ SC_(33.0), SC_(3300.0), SC_(0.2660029095005274146733635911570338124648146558855644546617488369820519446790559159046816506915223932e-1320), SC_(0.1010914998030267427355024834993305293670497251700514115155290007590672282491624577981977807588016461e-1355), SC_(263130836933693530167218012160000000.0000000000000000000000000000000001401449898351543816486543014083), SC_(1.0) }}, 
      {{ SC_(36.5), SC_(0.3650000095367431640625), SC_(61783994085109905285617221075553185632871.46593990870317617905112221558346802474495293361093686477298), SC_(0.9999999999999999999999999999999999999999999999999999999999671715496188758407628085162996316950792355), SC_(0.2028272784170699070176744961750260016534774310992690385363535341051709960919433646055822700438618255e-17), SC_(0.3282845038112415923719148370036830492076450037779705575700234148891870089197147052054094034784675396e-58) }}, 
      {{ SC_(36.5), SC_(18.25), SC_(61777254520646317770028385636707658594498.76692706361131964752360928908845136386547082001572396520059), SC_(0.9998909173069273653963982410400592541189386034850415758139503734982352352344255678028981107922458406), SC_(6739564463587515588835438845527038372.699012845091856533555785710665715731056227075345472916107167543), SC_(0.0001090826930726346036017589599407458810613965149584241860496265017647647655744321971018892077541594021) }}, 
      {{ SC_(36.5), SC_(34.5), SC_(37747609725485141381203912943265322693554.60633588885976291637124692013534422509674151917211311041349), SC_(0.6109609824429011506164679172242535904254179657867172438923963043601755299082871880515734973007440131), SC_(24036384359624763904413308132287862939316.85960401984341326470814807961882286982495637618908377089426), SC_(0.3890390175570988493835320827757464095745820342132827561076036956398244700917128119484265026992559869) }}, 
      {{ SC_(36.5), SC_(36.5), SC_(29531867110567733996206172826469404227498.9311927638816270130276092332480177066415858688849469128158), SC_(0.477985723452686052398471307401499970104499214598903118308733135180099804927481749049570771313257641), SC_(32252126974542171289411048249083781405372.53474714482154916805178576650614938828011202647624996849196), SC_(0.522014276547313947601528692598500029895500785401096881691266864819900195072518250950429228686742359) }}, 
      {{ SC_(36.5), SC_(38.5), SC_(21742960397427655971999858476245787542154.15150586635725616093880001666211564993165974656956851031785), SC_(0.3519189835392620395302152269324892873693310528827889471335875731231959108019664428015002605063426072), SC_(40041033687682249313617362599307398090717.31443404234592002014059498309205144499003814879162837098991), SC_(0.6480810164607379604697847730675107126306689471172110528664124268768040891980335571984997394936573928) }}, 
      {{ SC_(36.5), SC_(73.0), SC_(52949442154506109118983369217871874.38246594734925702394423038249326654537455487682886341892236797151), SC_(0.8570090512692680556802347857159858050844535163506777789989580690865292168793799100092698899450718342e-6), SC_(61783941135667750779508102092183967760997.08347396135391915713516461726090054954714301853233346238539), SC_(0.9999991429909487307319443197652142840141949155464836493222210010419309134707831206200899907301100549) }}, 
      {{ SC_(36.5), SC_(3650.0), SC_(0.1953355084312233771020954281999372828097757306846922312364706684936133958688600435101169722435920175e-1458), SC_(0.3161587581439635603576946151249429130551615750835979291506861400626078334974808393076908597655919673e-1499), SC_(61783994085109905285617221075553185632871.46593990870317618107939499975416709492169789536119688130775), SC_(1.0) }}, 
      {{ SC_(37.0), SC_(0.37000000476837158203125), SC_(371993326789901217467999448150835199999999.999999999999999998010144152088536780620259902094609630282), SC_(0.9999999999999999999999999999999999999999999999999999999999946508291802582432073734328927504122445964), SC_(0.1989855848803199113330559282105407777739456877542387398548067882388920416527083270608322077134689013e-17), SC_(0.5349170819741756792626567107249587755403553332314009452247515306615350728798447484985751790393880222e-59) }}, 
      {{ SC_(37.0), SC_(18.5), SC_(371956712793231153197597830186294584210422.2758111030818172279500018253795285911205314038120175905779), SC_(0.9999015735121217818090760205581543280418411120156879903724853447672046973321848456420679481585530018), SC_(36613996670064270401617964540615789577.72418889691818277204999817551220730283028778038799981744356341), SC_(0.9842648787821819092397944184567195815888798431200962751465523279530266781515435793205184144699823239e-4) }}, 
      {{ SC_(37.0), SC_(35.0), SC_(226989024014514715184435975122876165449017.4354380189351676839148067141921226508640903916939172052318), SC_(0.6101964945804424491761955895760276454618789066404902936457902256016569955365846250467251759013351627), SC_(145004302775386502283563473027959034550982.5645619810648323160851932866996132430867287925061002027896), SC_(0.3898035054195575508238044104239723545381210933595097063542097743983430044634153749532748240986648373) }}, 
      {{ SC_(37.0), SC_(37.0), SC_(177863034503958843994685514205494501614349.5019963234044377047596609195056110031786919237288259549572), SC_(0.4781350139767814391926669215604954535637725270056258313717131858978224542335868299177336178494837268), SC_(194130292285942373473313933945340698385650.4980036765955622952403390813861248907721272604711914530642), SC_(0.5218649860232185608073330784395045464362274729943741686282868141021775457664131700822663821505162732) }}, 
      {{ SC_(37.0), SC_(39.0), SC_(131256580134582475503504585688775961443809.3151145960527074790695530203993802515906461401417853004337), SC_(0.3528465988012605299562448021483701523550172331761938728513557987821171322564921159639473486646029879), SC_(240736746655318741964494862462059238556190.6848854039472925209304469804923556423601730440582321075878), SC_(0.6471534011987394700437551978516298476449827668238061271486442012178828677435078840360526513353970121) }}, 
      {{ SC_(37.0), SC_(74.0), SC_(271778651018441097347065883466473848.2746511977815237362658432276453536467157425861343116997640371484), SC_(0.730600877611816548123508890538883154677474348252631497380790705322862094368509049491763524535733931e-6), SC_(371993055011250199026902101084951733526151.7253488022184762637341567732463822472350765980657057082574), SC_(0.9999992693991223881834518764911094611168453225256517473685026192092946771379056314909505082364754643) }}, 
      {{ SC_(37.0), SC_(3700.0), SC_(0.3714703196437381532843643639864485147019841838742418471961281810239780186658714011436027292802695334e-1478), SC_(0.9985940415902717138423033467831033580547327587141446387368733042084326864839438382850644573580819965e-1520), SC_(371993326789901217467999448150835200000000.0000000000000000000000000008917358939508191842000174080214), SC_(1.0) }}
   } };


