# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/logging/v2/logging_config_pb"

module Google
  module Cloud
    module Logging
      module V2
        module ConfigService
          ##
          # Client for the ConfigService service.
          #
          # Service for configuring sinks used to route log entries.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "logging.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :config_service_stub

            ##
            # Configure the ConfigService Client class.
            #
            # See {::Google::Cloud::Logging::V2::ConfigService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ConfigService clients
            #   ::Google::Cloud::Logging::V2::ConfigService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Logging", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_sinks.timeout = 60.0
                default_config.rpcs.list_sinks.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.get_sink.timeout = 60.0
                default_config.rpcs.get_sink.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.create_sink.timeout = 120.0

                default_config.rpcs.update_sink.timeout = 60.0
                default_config.rpcs.update_sink.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.delete_sink.timeout = 60.0
                default_config.rpcs.delete_sink.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.list_exclusions.timeout = 60.0
                default_config.rpcs.list_exclusions.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.get_exclusion.timeout = 60.0
                default_config.rpcs.get_exclusion.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config.rpcs.create_exclusion.timeout = 120.0

                default_config.rpcs.update_exclusion.timeout = 120.0

                default_config.rpcs.delete_exclusion.timeout = 60.0
                default_config.rpcs.delete_exclusion.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ConfigService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Logging::V2::ConfigService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @config_service_stub.universe_domain
            end

            ##
            # Create a new ConfigService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ConfigService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/logging/v2/logging_config_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @config_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Logging::V2::ConfigServiceV2::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @config_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Logging::V2::ConfigService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @config_service_stub.logger
            end

            # Service calls

            ##
            # Lists log buckets.
            #
            # @overload list_buckets(request, options = nil)
            #   Pass arguments to `list_buckets` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListBucketsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListBucketsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_buckets(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_buckets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource whose buckets are to be listed:
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
            #         "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
            #         "folders/[FOLDER_ID]/locations/[LOCATION_ID]"
            #
            #     Note: The locations portion of the resource must be specified, but
            #     supplying the character `-` in place of [LOCATION_ID] will return all
            #     buckets.
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method. `pageToken` must be the value of
            #     `nextPageToken` from the previous response. The values of other method
            #     parameters should be identical to those in the previous call.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #     Non-positive values are ignored. The presence of `nextPageToken` in the
            #     response indicates that more results might be available.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogBucket>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogBucket>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListBucketsRequest.new
            #
            #   # Call the list_buckets method.
            #   result = client.list_buckets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Logging::V2::LogBucket.
            #     p item
            #   end
            #
            def list_buckets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListBucketsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_buckets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_buckets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_buckets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :list_buckets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_service_stub, :list_buckets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a log bucket.
            #
            # @overload get_bucket(request, options = nil)
            #   Pass arguments to `get_bucket` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::GetBucketRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::GetBucketRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_bucket(name: nil)
            #   Pass arguments to `get_bucket` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the bucket:
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogBucket]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogBucket]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::GetBucketRequest.new
            #
            #   # Call the get_bucket method.
            #   result = client.get_bucket request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogBucket.
            #   p result
            #
            def get_bucket request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::GetBucketRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_bucket.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_bucket.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_bucket.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :get_bucket, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a log bucket asynchronously that can be used to store log entries.
            #
            # After a bucket has been created, the bucket's location cannot be changed.
            #
            # @overload create_bucket_async(request, options = nil)
            #   Pass arguments to `create_bucket_async` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::CreateBucketRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::CreateBucketRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_bucket_async(parent: nil, bucket_id: nil, bucket: nil)
            #   Pass arguments to `create_bucket_async` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource in which to create the log bucket:
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global"`
            #   @param bucket_id [::String]
            #     Required. A client-assigned identifier such as `"my-bucket"`. Identifiers
            #     are limited to 100 characters and can include only letters, digits,
            #     underscores, hyphens, and periods.
            #   @param bucket [::Google::Cloud::Logging::V2::LogBucket, ::Hash]
            #     Required. The new bucket. The region specified in the new bucket must be
            #     compliant with any Location Restriction Org Policy. The name field in the
            #     bucket is ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::CreateBucketRequest.new
            #
            #   # Call the create_bucket_async method.
            #   result = client.create_bucket_async request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_bucket_async request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::CreateBucketRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_bucket_async.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_bucket_async.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_bucket_async.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :create_bucket_async, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a log bucket asynchronously.
            #
            # If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
            # `FAILED_PRECONDITION` will be returned.
            #
            # After a bucket has been created, the bucket's location cannot be changed.
            #
            # @overload update_bucket_async(request, options = nil)
            #   Pass arguments to `update_bucket_async` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UpdateBucketRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UpdateBucketRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_bucket_async(name: nil, bucket: nil, update_mask: nil)
            #   Pass arguments to `update_bucket_async` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the bucket to update.
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket"`
            #   @param bucket [::Google::Cloud::Logging::V2::LogBucket, ::Hash]
            #     Required. The updated bucket.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask that specifies the fields in `bucket` that need an
            #     update. A bucket field will be overwritten if, and only if, it is in the
            #     update mask. `name` and output only fields cannot be updated.
            #
            #     For a detailed `FieldMask` definition, see:
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
            #
            #     For example: `updateMask=retention_days`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UpdateBucketRequest.new
            #
            #   # Call the update_bucket_async method.
            #   result = client.update_bucket_async request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_bucket_async request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UpdateBucketRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_bucket_async.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_bucket_async.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_bucket_async.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :update_bucket_async, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a log bucket that can be used to store log entries. After a bucket
            # has been created, the bucket's location cannot be changed.
            #
            # @overload create_bucket(request, options = nil)
            #   Pass arguments to `create_bucket` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::CreateBucketRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::CreateBucketRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_bucket(parent: nil, bucket_id: nil, bucket: nil)
            #   Pass arguments to `create_bucket` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource in which to create the log bucket:
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global"`
            #   @param bucket_id [::String]
            #     Required. A client-assigned identifier such as `"my-bucket"`. Identifiers
            #     are limited to 100 characters and can include only letters, digits,
            #     underscores, hyphens, and periods.
            #   @param bucket [::Google::Cloud::Logging::V2::LogBucket, ::Hash]
            #     Required. The new bucket. The region specified in the new bucket must be
            #     compliant with any Location Restriction Org Policy. The name field in the
            #     bucket is ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogBucket]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogBucket]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::CreateBucketRequest.new
            #
            #   # Call the create_bucket method.
            #   result = client.create_bucket request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogBucket.
            #   p result
            #
            def create_bucket request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::CreateBucketRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_bucket.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_bucket.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_bucket.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :create_bucket, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a log bucket.
            #
            # If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
            # `FAILED_PRECONDITION` will be returned.
            #
            # After a bucket has been created, the bucket's location cannot be changed.
            #
            # @overload update_bucket(request, options = nil)
            #   Pass arguments to `update_bucket` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UpdateBucketRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UpdateBucketRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_bucket(name: nil, bucket: nil, update_mask: nil)
            #   Pass arguments to `update_bucket` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the bucket to update.
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket"`
            #   @param bucket [::Google::Cloud::Logging::V2::LogBucket, ::Hash]
            #     Required. The updated bucket.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask that specifies the fields in `bucket` that need an
            #     update. A bucket field will be overwritten if, and only if, it is in the
            #     update mask. `name` and output only fields cannot be updated.
            #
            #     For a detailed `FieldMask` definition, see:
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
            #
            #     For example: `updateMask=retention_days`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogBucket]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogBucket]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UpdateBucketRequest.new
            #
            #   # Call the update_bucket method.
            #   result = client.update_bucket request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogBucket.
            #   p result
            #
            def update_bucket request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UpdateBucketRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_bucket.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_bucket.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_bucket.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :update_bucket, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a log bucket.
            #
            # Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
            # After 7 days, the bucket will be purged and all log entries in the bucket
            # will be permanently deleted.
            #
            # @overload delete_bucket(request, options = nil)
            #   Pass arguments to `delete_bucket` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::DeleteBucketRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::DeleteBucketRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_bucket(name: nil)
            #   Pass arguments to `delete_bucket` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the bucket to delete.
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::DeleteBucketRequest.new
            #
            #   # Call the delete_bucket method.
            #   result = client.delete_bucket request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_bucket request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::DeleteBucketRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_bucket.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_bucket.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_bucket.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :delete_bucket, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Undeletes a log bucket. A bucket that has been deleted can be undeleted
            # within the grace period of 7 days.
            #
            # @overload undelete_bucket(request, options = nil)
            #   Pass arguments to `undelete_bucket` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UndeleteBucketRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UndeleteBucketRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undelete_bucket(name: nil)
            #   Pass arguments to `undelete_bucket` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the bucket to undelete.
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UndeleteBucketRequest.new
            #
            #   # Call the undelete_bucket method.
            #   result = client.undelete_bucket request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def undelete_bucket request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UndeleteBucketRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undelete_bucket.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undelete_bucket.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undelete_bucket.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :undelete_bucket, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists views on a log bucket.
            #
            # @overload list_views(request, options = nil)
            #   Pass arguments to `list_views` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListViewsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListViewsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_views(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_views` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The bucket whose views are to be listed:
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method. `pageToken` must be the value of
            #     `nextPageToken` from the previous response. The values of other method
            #     parameters should be identical to those in the previous call.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #
            #     Non-positive values are ignored. The presence of `nextPageToken` in the
            #     response indicates that more results might be available.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogView>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogView>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListViewsRequest.new
            #
            #   # Call the list_views method.
            #   result = client.list_views request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Logging::V2::LogView.
            #     p item
            #   end
            #
            def list_views request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListViewsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_views.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_views.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_views.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :list_views, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_service_stub, :list_views, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a view on a log bucket..
            #
            # @overload get_view(request, options = nil)
            #   Pass arguments to `get_view` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::GetViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::GetViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_view(name: nil)
            #   Pass arguments to `get_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the policy:
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogView]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogView]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::GetViewRequest.new
            #
            #   # Call the get_view method.
            #   result = client.get_view request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogView.
            #   p result
            #
            def get_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::GetViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :get_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a view over log entries in a log bucket. A bucket may contain a
            # maximum of 30 views.
            #
            # @overload create_view(request, options = nil)
            #   Pass arguments to `create_view` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::CreateViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::CreateViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_view(parent: nil, view_id: nil, view: nil)
            #   Pass arguments to `create_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The bucket in which to create the view
            #
            #         `"projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"`
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket"`
            #   @param view_id [::String]
            #     Required. A client-assigned identifier such as `"my-view"`. Identifiers are
            #     limited to 100 characters and can include only letters, digits,
            #     underscores, hyphens, and periods.
            #   @param view [::Google::Cloud::Logging::V2::LogView, ::Hash]
            #     Required. The new view.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogView]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogView]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::CreateViewRequest.new
            #
            #   # Call the create_view method.
            #   result = client.create_view request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogView.
            #   p result
            #
            def create_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::CreateViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :create_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a view on a log bucket. This method replaces the following fields
            # in the existing view with values from the new view: `filter`.
            # If an `UNAVAILABLE` error is returned, this indicates that system is not in
            # a state where it can update the view. If this occurs, please try again in a
            # few minutes.
            #
            # @overload update_view(request, options = nil)
            #   Pass arguments to `update_view` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UpdateViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UpdateViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_view(name: nil, view: nil, update_mask: nil)
            #   Pass arguments to `update_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the view to update
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
            #   @param view [::Google::Cloud::Logging::V2::LogView, ::Hash]
            #     Required. The updated view.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask that specifies the fields in `view` that need
            #     an update. A field will be overwritten if, and only if, it is
            #     in the update mask. `name` and output only fields cannot be updated.
            #
            #     For a detailed `FieldMask` definition, see
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
            #
            #     For example: `updateMask=filter`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogView]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogView]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UpdateViewRequest.new
            #
            #   # Call the update_view method.
            #   result = client.update_view request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogView.
            #   p result
            #
            def update_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UpdateViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :update_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a view on a log bucket.
            # If an `UNAVAILABLE` error is returned, this indicates that system is not in
            # a state where it can delete the view. If this occurs, please try again in a
            # few minutes.
            #
            # @overload delete_view(request, options = nil)
            #   Pass arguments to `delete_view` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::DeleteViewRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::DeleteViewRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_view(name: nil)
            #   Pass arguments to `delete_view` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the view to delete:
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
            #
            #     For example:
            #
            #        `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::DeleteViewRequest.new
            #
            #   # Call the delete_view method.
            #   result = client.delete_view request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_view request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::DeleteViewRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_view.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_view.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_view.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :delete_view, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists sinks.
            #
            # @overload list_sinks(request, options = nil)
            #   Pass arguments to `list_sinks` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListSinksRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListSinksRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_sinks(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_sinks` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource whose sinks are to be listed:
            #
            #         "projects/[PROJECT_ID]"
            #         "organizations/[ORGANIZATION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]"
            #         "folders/[FOLDER_ID]"
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method. `pageToken` must be the value of
            #     `nextPageToken` from the previous response. The values of other method
            #     parameters should be identical to those in the previous call.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #     Non-positive values are ignored. The presence of `nextPageToken` in the
            #     response indicates that more results might be available.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogSink>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogSink>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListSinksRequest.new
            #
            #   # Call the list_sinks method.
            #   result = client.list_sinks request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Logging::V2::LogSink.
            #     p item
            #   end
            #
            def list_sinks request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListSinksRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_sinks.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_sinks.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_sinks.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :list_sinks, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_service_stub, :list_sinks, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a sink.
            #
            # @overload get_sink(request, options = nil)
            #   Pass arguments to `get_sink` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::GetSinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::GetSinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_sink(sink_name: nil)
            #   Pass arguments to `get_sink` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param sink_name [::String]
            #     Required. The resource name of the sink:
            #
            #         "projects/[PROJECT_ID]/sinks/[SINK_ID]"
            #         "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
            #         "folders/[FOLDER_ID]/sinks/[SINK_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/sinks/my-sink"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogSink]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogSink]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::GetSinkRequest.new
            #
            #   # Call the get_sink method.
            #   result = client.get_sink request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogSink.
            #   p result
            #
            def get_sink request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::GetSinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_sink.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.sink_name
                header_params["sink_name"] = request.sink_name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_sink.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_sink.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :get_sink, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a sink that exports specified log entries to a destination. The
            # export of newly-ingested log entries begins immediately, unless the sink's
            # `writer_identity` is not permitted to write to the destination. A sink can
            # export log entries only from the resource owning the sink.
            #
            # @overload create_sink(request, options = nil)
            #   Pass arguments to `create_sink` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::CreateSinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::CreateSinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_sink(parent: nil, sink: nil, unique_writer_identity: nil)
            #   Pass arguments to `create_sink` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource in which to create the sink:
            #
            #         "projects/[PROJECT_ID]"
            #         "organizations/[ORGANIZATION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]"
            #         "folders/[FOLDER_ID]"
            #
            #     For examples:
            #
            #       `"projects/my-project"`
            #       `"organizations/123456789"`
            #   @param sink [::Google::Cloud::Logging::V2::LogSink, ::Hash]
            #     Required. The new sink, whose `name` parameter is a sink identifier that
            #     is not already in use.
            #   @param unique_writer_identity [::Boolean]
            #     Optional. Determines the kind of IAM identity returned as `writer_identity`
            #     in the new sink. If this value is omitted or set to false, and if the
            #     sink's parent is a project, then the value returned as `writer_identity` is
            #     the same group or service account used by Cloud Logging before the addition
            #     of writer identities to this API. The sink's destination must be in the
            #     same project as the sink itself.
            #
            #     If this field is set to true, or if the sink is owned by a non-project
            #     resource such as an organization, then the value of `writer_identity` will
            #     be a unique service account used only for exports from the new sink. For
            #     more information, see `writer_identity` in
            #     {::Google::Cloud::Logging::V2::LogSink LogSink}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogSink]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogSink]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::CreateSinkRequest.new
            #
            #   # Call the create_sink method.
            #   result = client.create_sink request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogSink.
            #   p result
            #
            def create_sink request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::CreateSinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_sink.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_sink.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_sink.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :create_sink, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a sink. This method replaces the following fields in the existing
            # sink with values from the new sink: `destination`, and `filter`.
            #
            # The updated sink might also have a new `writer_identity`; see the
            # `unique_writer_identity` field.
            #
            # @overload update_sink(request, options = nil)
            #   Pass arguments to `update_sink` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UpdateSinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UpdateSinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_sink(sink_name: nil, sink: nil, unique_writer_identity: nil, update_mask: nil)
            #   Pass arguments to `update_sink` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param sink_name [::String]
            #     Required. The full resource name of the sink to update, including the
            #     parent resource and the sink identifier:
            #
            #         "projects/[PROJECT_ID]/sinks/[SINK_ID]"
            #         "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
            #         "folders/[FOLDER_ID]/sinks/[SINK_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/sinks/my-sink"`
            #   @param sink [::Google::Cloud::Logging::V2::LogSink, ::Hash]
            #     Required. The updated sink, whose name is the same identifier that appears
            #     as part of `sink_name`.
            #   @param unique_writer_identity [::Boolean]
            #     Optional. See {::Google::Cloud::Logging::V2::ConfigService::Client#create_sink sinks.create}
            #     for a description of this field. When updating a sink, the effect of this
            #     field on the value of `writer_identity` in the updated sink depends on both
            #     the old and new values of this field:
            #
            #     +   If the old and new values of this field are both false or both true,
            #         then there is no change to the sink's `writer_identity`.
            #     +   If the old value is false and the new value is true, then
            #         `writer_identity` is changed to a unique service account.
            #     +   It is an error if the old value is true and the new value is
            #         set to false or defaulted to false.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask that specifies the fields in `sink` that need
            #     an update. A sink field will be overwritten if, and only if, it is
            #     in the update mask. `name` and output only fields cannot be updated.
            #
            #     An empty `updateMask` is temporarily treated as using the following mask
            #     for backwards compatibility purposes:
            #
            #       `destination,filter,includeChildren`
            #
            #     At some point in the future, behavior will be removed and specifying an
            #     empty `updateMask` will be an error.
            #
            #     For a detailed `FieldMask` definition, see
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
            #
            #     For example: `updateMask=filter`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogSink]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogSink]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UpdateSinkRequest.new
            #
            #   # Call the update_sink method.
            #   result = client.update_sink request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogSink.
            #   p result
            #
            def update_sink request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UpdateSinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_sink.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.sink_name
                header_params["sink_name"] = request.sink_name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_sink.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_sink.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :update_sink, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a sink. If the sink has a unique `writer_identity`, then that
            # service account is also deleted.
            #
            # @overload delete_sink(request, options = nil)
            #   Pass arguments to `delete_sink` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::DeleteSinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::DeleteSinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_sink(sink_name: nil)
            #   Pass arguments to `delete_sink` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param sink_name [::String]
            #     Required. The full resource name of the sink to delete, including the
            #     parent resource and the sink identifier:
            #
            #         "projects/[PROJECT_ID]/sinks/[SINK_ID]"
            #         "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
            #         "folders/[FOLDER_ID]/sinks/[SINK_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/sinks/my-sink"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::DeleteSinkRequest.new
            #
            #   # Call the delete_sink method.
            #   result = client.delete_sink request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_sink request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::DeleteSinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_sink.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.sink_name
                header_params["sink_name"] = request.sink_name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_sink.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_sink.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :delete_sink, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Asynchronously creates a linked dataset in BigQuery which makes it possible
            # to use BigQuery to read the logs stored in the log bucket. A log bucket may
            # currently only contain one link.
            #
            # @overload create_link(request, options = nil)
            #   Pass arguments to `create_link` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::CreateLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::CreateLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_link(parent: nil, link: nil, link_id: nil)
            #   Pass arguments to `create_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The full resource name of the bucket to create a link for.
            #
            #         "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #         "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
            #   @param link [::Google::Cloud::Logging::V2::Link, ::Hash]
            #     Required. The new link.
            #   @param link_id [::String]
            #     Required. The ID to use for the link. The link_id can have up to 100
            #     characters. A valid link_id must only have alphanumeric characters and
            #     underscores within it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::CreateLinkRequest.new
            #
            #   # Call the create_link method.
            #   result = client.create_link request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::CreateLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :create_link, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a link. This will also delete the corresponding BigQuery linked
            # dataset.
            #
            # @overload delete_link(request, options = nil)
            #   Pass arguments to `delete_link` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::DeleteLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::DeleteLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_link(name: nil)
            #   Pass arguments to `delete_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The full resource name of the link to delete.
            #
            #      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
            #       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
            #       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
            #       "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::DeleteLinkRequest.new
            #
            #   # Call the delete_link method.
            #   result = client.delete_link request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::DeleteLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :delete_link, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists links.
            #
            # @overload list_links(request, options = nil)
            #   Pass arguments to `list_links` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListLinksRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListLinksRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_links(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_links` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource whose links are to be listed:
            #
            #       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/"
            #       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/"
            #       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/"
            #       "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method. `pageToken` must be the value of
            #     `nextPageToken` from the previous response.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::Link>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::Link>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListLinksRequest.new
            #
            #   # Call the list_links method.
            #   result = client.list_links request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Logging::V2::Link.
            #     p item
            #   end
            #
            def list_links request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListLinksRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_links.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_links.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_links.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :list_links, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_service_stub, :list_links, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a link.
            #
            # @overload get_link(request, options = nil)
            #   Pass arguments to `get_link` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::GetLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::GetLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_link(name: nil)
            #   Pass arguments to `get_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the link:
            #
            #       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
            #       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
            #       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
            #       "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::Link]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::Link]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::GetLinkRequest.new
            #
            #   # Call the get_link method.
            #   result = client.get_link request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::Link.
            #   p result
            #
            def get_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::GetLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :get_link, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all the exclusions on the _Default sink in a parent resource.
            #
            # @overload list_exclusions(request, options = nil)
            #   Pass arguments to `list_exclusions` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::ListExclusionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::ListExclusionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_exclusions(parent: nil, page_token: nil, page_size: nil)
            #   Pass arguments to `list_exclusions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource whose exclusions are to be listed.
            #
            #         "projects/[PROJECT_ID]"
            #         "organizations/[ORGANIZATION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]"
            #         "folders/[FOLDER_ID]"
            #   @param page_token [::String]
            #     Optional. If present, then retrieve the next batch of results from the
            #     preceding call to this method. `pageToken` must be the value of
            #     `nextPageToken` from the previous response. The values of other method
            #     parameters should be identical to those in the previous call.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return from this request.
            #     Non-positive values are ignored. The presence of `nextPageToken` in the
            #     response indicates that more results might be available.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogExclusion>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Logging::V2::LogExclusion>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::ListExclusionsRequest.new
            #
            #   # Call the list_exclusions method.
            #   result = client.list_exclusions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Logging::V2::LogExclusion.
            #     p item
            #   end
            #
            def list_exclusions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::ListExclusionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_exclusions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_exclusions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_exclusions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :list_exclusions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @config_service_stub, :list_exclusions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the description of an exclusion in the _Default sink.
            #
            # @overload get_exclusion(request, options = nil)
            #   Pass arguments to `get_exclusion` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::GetExclusionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::GetExclusionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_exclusion(name: nil)
            #   Pass arguments to `get_exclusion` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of an existing exclusion:
            #
            #         "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
            #         "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
            #         "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/exclusions/my-exclusion"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogExclusion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogExclusion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::GetExclusionRequest.new
            #
            #   # Call the get_exclusion method.
            #   result = client.get_exclusion request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogExclusion.
            #   p result
            #
            def get_exclusion request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::GetExclusionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_exclusion.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_exclusion.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_exclusion.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :get_exclusion, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new exclusion in the _Default sink in a specified parent
            # resource. Only log entries belonging to that resource can be excluded. You
            # can have up to 10 exclusions in a resource.
            #
            # @overload create_exclusion(request, options = nil)
            #   Pass arguments to `create_exclusion` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::CreateExclusionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::CreateExclusionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_exclusion(parent: nil, exclusion: nil)
            #   Pass arguments to `create_exclusion` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource in which to create the exclusion:
            #
            #         "projects/[PROJECT_ID]"
            #         "organizations/[ORGANIZATION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]"
            #         "folders/[FOLDER_ID]"
            #
            #     For examples:
            #
            #       `"projects/my-logging-project"`
            #       `"organizations/123456789"`
            #   @param exclusion [::Google::Cloud::Logging::V2::LogExclusion, ::Hash]
            #     Required. The new exclusion, whose `name` parameter is an exclusion name
            #     that is not already used in the parent resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogExclusion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogExclusion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::CreateExclusionRequest.new
            #
            #   # Call the create_exclusion method.
            #   result = client.create_exclusion request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogExclusion.
            #   p result
            #
            def create_exclusion request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::CreateExclusionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_exclusion.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_exclusion.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_exclusion.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :create_exclusion, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Changes one or more properties of an existing exclusion in the _Default
            # sink.
            #
            # @overload update_exclusion(request, options = nil)
            #   Pass arguments to `update_exclusion` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UpdateExclusionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UpdateExclusionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_exclusion(name: nil, exclusion: nil, update_mask: nil)
            #   Pass arguments to `update_exclusion` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the exclusion to update:
            #
            #         "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
            #         "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
            #         "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/exclusions/my-exclusion"`
            #   @param exclusion [::Google::Cloud::Logging::V2::LogExclusion, ::Hash]
            #     Required. New values for the existing exclusion. Only the fields specified
            #     in `update_mask` are relevant.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. A non-empty list of fields to change in the existing exclusion.
            #     New values for the fields are taken from the corresponding fields in the
            #     {::Google::Cloud::Logging::V2::LogExclusion LogExclusion} included in this request.
            #     Fields not mentioned in `update_mask` are not changed and are ignored in
            #     the request.
            #
            #     For example, to change the filter and description of an exclusion,
            #     specify an `update_mask` of `"filter,description"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::LogExclusion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::LogExclusion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UpdateExclusionRequest.new
            #
            #   # Call the update_exclusion method.
            #   result = client.update_exclusion request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::LogExclusion.
            #   p result
            #
            def update_exclusion request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UpdateExclusionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_exclusion.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_exclusion.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_exclusion.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :update_exclusion, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an exclusion in the _Default sink.
            #
            # @overload delete_exclusion(request, options = nil)
            #   Pass arguments to `delete_exclusion` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::DeleteExclusionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::DeleteExclusionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_exclusion(name: nil)
            #   Pass arguments to `delete_exclusion` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of an existing exclusion to delete:
            #
            #         "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
            #         "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
            #         "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
            #
            #     For example:
            #
            #       `"projects/my-project/exclusions/my-exclusion"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::DeleteExclusionRequest.new
            #
            #   # Call the delete_exclusion method.
            #   result = client.delete_exclusion request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_exclusion request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::DeleteExclusionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_exclusion.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_exclusion.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_exclusion.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :delete_exclusion, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the Logging CMEK settings for the given resource.
            #
            # Note: CMEK for the Log Router can be configured for Google Cloud projects,
            # folders, organizations and billing accounts. Once configured for an
            # organization, it applies to all projects and folders in the Google Cloud
            # organization.
            #
            # See [Enabling CMEK for Log
            # Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
            # for more information.
            #
            # @overload get_cmek_settings(request, options = nil)
            #   Pass arguments to `get_cmek_settings` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::GetCmekSettingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::GetCmekSettingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_cmek_settings(name: nil)
            #   Pass arguments to `get_cmek_settings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource for which to retrieve CMEK settings.
            #
            #         "projects/[PROJECT_ID]/cmekSettings"
            #         "organizations/[ORGANIZATION_ID]/cmekSettings"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
            #         "folders/[FOLDER_ID]/cmekSettings"
            #
            #     For example:
            #
            #       `"organizations/12345/cmekSettings"`
            #
            #     Note: CMEK for the Log Router can be configured for Google Cloud projects,
            #     folders, organizations and billing accounts. Once configured for an
            #     organization, it applies to all projects and folders in the Google Cloud
            #     organization.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::CmekSettings]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::CmekSettings]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::GetCmekSettingsRequest.new
            #
            #   # Call the get_cmek_settings method.
            #   result = client.get_cmek_settings request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::CmekSettings.
            #   p result
            #
            def get_cmek_settings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::GetCmekSettingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_cmek_settings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_cmek_settings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_cmek_settings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :get_cmek_settings, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the Log Router CMEK settings for the given resource.
            #
            # Note: CMEK for the Log Router can currently only be configured for Google
            # Cloud organizations. Once configured, it applies to all projects and
            # folders in the Google Cloud organization.
            #
            # {::Google::Cloud::Logging::V2::ConfigService::Client#update_cmek_settings UpdateCmekSettings}
            # will fail if 1) `kms_key_name` is invalid, or 2) the associated service
            # account does not have the required
            # `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
            # 3) access to the key is disabled.
            #
            # See [Enabling CMEK for Log
            # Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
            # for more information.
            #
            # @overload update_cmek_settings(request, options = nil)
            #   Pass arguments to `update_cmek_settings` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UpdateCmekSettingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UpdateCmekSettingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_cmek_settings(name: nil, cmek_settings: nil, update_mask: nil)
            #   Pass arguments to `update_cmek_settings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name for the CMEK settings to update.
            #
            #         "projects/[PROJECT_ID]/cmekSettings"
            #         "organizations/[ORGANIZATION_ID]/cmekSettings"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
            #         "folders/[FOLDER_ID]/cmekSettings"
            #
            #     For example:
            #
            #       `"organizations/12345/cmekSettings"`
            #
            #     Note: CMEK for the Log Router can currently only be configured for Google
            #     Cloud organizations. Once configured, it applies to all projects and
            #     folders in the Google Cloud organization.
            #   @param cmek_settings [::Google::Cloud::Logging::V2::CmekSettings, ::Hash]
            #     Required. The CMEK settings to update.
            #
            #     See [Enabling CMEK for Log
            #     Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
            #     for more information.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask identifying which fields from `cmek_settings` should
            #     be updated. A field will be overwritten if and only if it is in the update
            #     mask. Output only fields cannot be updated.
            #
            #     See {::Google::Protobuf::FieldMask FieldMask} for more information.
            #
            #     For example: `"updateMask=kmsKeyName"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::CmekSettings]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::CmekSettings]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UpdateCmekSettingsRequest.new
            #
            #   # Call the update_cmek_settings method.
            #   result = client.update_cmek_settings request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::CmekSettings.
            #   p result
            #
            def update_cmek_settings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UpdateCmekSettingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_cmek_settings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_cmek_settings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_cmek_settings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :update_cmek_settings, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the Log Router settings for the given resource.
            #
            # Note: Settings for the Log Router can be get for Google Cloud projects,
            # folders, organizations and billing accounts. Currently it can only be
            # configured for organizations. Once configured for an organization, it
            # applies to all projects and folders in the Google Cloud organization.
            #
            # See [Enabling CMEK for Log
            # Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
            # for more information.
            #
            # @overload get_settings(request, options = nil)
            #   Pass arguments to `get_settings` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::GetSettingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::GetSettingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_settings(name: nil)
            #   Pass arguments to `get_settings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource for which to retrieve settings.
            #
            #         "projects/[PROJECT_ID]/settings"
            #         "organizations/[ORGANIZATION_ID]/settings"
            #         "billingAccounts/[BILLING_ACCOUNT_ID]/settings"
            #         "folders/[FOLDER_ID]/settings"
            #
            #     For example:
            #
            #       `"organizations/12345/settings"`
            #
            #     Note: Settings for the Log Router can be get for Google Cloud projects,
            #     folders, organizations and billing accounts. Currently it can only be
            #     configured for organizations. Once configured for an organization, it
            #     applies to all projects and folders in the Google Cloud organization.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::Settings]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::Settings]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::GetSettingsRequest.new
            #
            #   # Call the get_settings method.
            #   result = client.get_settings request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::Settings.
            #   p result
            #
            def get_settings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::GetSettingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_settings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_settings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_settings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :get_settings, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the Log Router settings for the given resource.
            #
            # Note: Settings for the Log Router can currently only be configured for
            # Google Cloud organizations. Once configured, it applies to all projects and
            # folders in the Google Cloud organization.
            #
            # {::Google::Cloud::Logging::V2::ConfigService::Client#update_settings UpdateSettings}
            # will fail if 1) `kms_key_name` is invalid, or 2) the associated service
            # account does not have the required
            # `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
            # 3) access to the key is disabled. 4) `location_id` is not supported by
            # Logging. 5) `location_id` violate OrgPolicy.
            #
            # See [Enabling CMEK for Log
            # Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
            # for more information.
            #
            # @overload update_settings(request, options = nil)
            #   Pass arguments to `update_settings` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::UpdateSettingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::UpdateSettingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_settings(name: nil, settings: nil, update_mask: nil)
            #   Pass arguments to `update_settings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name for the settings to update.
            #
            #         "organizations/[ORGANIZATION_ID]/settings"
            #
            #     For example:
            #
            #       `"organizations/12345/settings"`
            #
            #     Note: Settings for the Log Router can currently only be configured for
            #     Google Cloud organizations. Once configured, it applies to all projects and
            #     folders in the Google Cloud organization.
            #   @param settings [::Google::Cloud::Logging::V2::Settings, ::Hash]
            #     Required. The settings to update.
            #
            #     See [Enabling CMEK for Log
            #     Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
            #     for more information.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask identifying which fields from `settings` should
            #     be updated. A field will be overwritten if and only if it is in the update
            #     mask. Output only fields cannot be updated.
            #
            #     See {::Google::Protobuf::FieldMask FieldMask} for more information.
            #
            #     For example: `"updateMask=kmsKeyName"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Logging::V2::Settings]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Logging::V2::Settings]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::UpdateSettingsRequest.new
            #
            #   # Call the update_settings method.
            #   result = client.update_settings request
            #
            #   # The returned object is of type Google::Cloud::Logging::V2::Settings.
            #   p result
            #
            def update_settings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::UpdateSettingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_settings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_settings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_settings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :update_settings, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Copies a set of log entries from a log bucket to a Cloud Storage bucket.
            #
            # @overload copy_log_entries(request, options = nil)
            #   Pass arguments to `copy_log_entries` via a request object, either of type
            #   {::Google::Cloud::Logging::V2::CopyLogEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Logging::V2::CopyLogEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload copy_log_entries(name: nil, filter: nil, destination: nil)
            #   Pass arguments to `copy_log_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Log bucket from which to copy log entries.
            #
            #     For example:
            #
            #       `"projects/my-project/locations/global/buckets/my-source-bucket"`
            #   @param filter [::String]
            #     Optional. A filter specifying which log entries to copy. The filter must be
            #     no more than 20k characters. An empty filter matches all log entries.
            #   @param destination [::String]
            #     Required. Destination to which to copy log entries.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/logging/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Logging::V2::ConfigService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Logging::V2::CopyLogEntriesRequest.new
            #
            #   # Call the copy_log_entries method.
            #   result = client.copy_log_entries request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def copy_log_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Logging::V2::CopyLogEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.copy_log_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Logging::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.copy_log_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.copy_log_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @config_service_stub.call_rpc :copy_log_entries, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ConfigService API.
            #
            # This class represents the configuration for ConfigService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Logging::V2::ConfigService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_buckets to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Logging::V2::ConfigService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_buckets.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_buckets.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Logging::V2::ConfigService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "logging.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ConfigService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_buckets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_buckets
                ##
                # RPC-specific configuration for `get_bucket`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_bucket
                ##
                # RPC-specific configuration for `create_bucket_async`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_bucket_async
                ##
                # RPC-specific configuration for `update_bucket_async`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_bucket_async
                ##
                # RPC-specific configuration for `create_bucket`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_bucket
                ##
                # RPC-specific configuration for `update_bucket`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_bucket
                ##
                # RPC-specific configuration for `delete_bucket`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_bucket
                ##
                # RPC-specific configuration for `undelete_bucket`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undelete_bucket
                ##
                # RPC-specific configuration for `list_views`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_views
                ##
                # RPC-specific configuration for `get_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_view
                ##
                # RPC-specific configuration for `create_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_view
                ##
                # RPC-specific configuration for `update_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_view
                ##
                # RPC-specific configuration for `delete_view`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_view
                ##
                # RPC-specific configuration for `list_sinks`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_sinks
                ##
                # RPC-specific configuration for `get_sink`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_sink
                ##
                # RPC-specific configuration for `create_sink`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_sink
                ##
                # RPC-specific configuration for `update_sink`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_sink
                ##
                # RPC-specific configuration for `delete_sink`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_sink
                ##
                # RPC-specific configuration for `create_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_link
                ##
                # RPC-specific configuration for `delete_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_link
                ##
                # RPC-specific configuration for `list_links`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_links
                ##
                # RPC-specific configuration for `get_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_link
                ##
                # RPC-specific configuration for `list_exclusions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_exclusions
                ##
                # RPC-specific configuration for `get_exclusion`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_exclusion
                ##
                # RPC-specific configuration for `create_exclusion`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_exclusion
                ##
                # RPC-specific configuration for `update_exclusion`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_exclusion
                ##
                # RPC-specific configuration for `delete_exclusion`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_exclusion
                ##
                # RPC-specific configuration for `get_cmek_settings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_cmek_settings
                ##
                # RPC-specific configuration for `update_cmek_settings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_cmek_settings
                ##
                # RPC-specific configuration for `get_settings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_settings
                ##
                # RPC-specific configuration for `update_settings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_settings
                ##
                # RPC-specific configuration for `copy_log_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :copy_log_entries

                # @private
                def initialize parent_rpcs = nil
                  list_buckets_config = parent_rpcs.list_buckets if parent_rpcs.respond_to? :list_buckets
                  @list_buckets = ::Gapic::Config::Method.new list_buckets_config
                  get_bucket_config = parent_rpcs.get_bucket if parent_rpcs.respond_to? :get_bucket
                  @get_bucket = ::Gapic::Config::Method.new get_bucket_config
                  create_bucket_async_config = parent_rpcs.create_bucket_async if parent_rpcs.respond_to? :create_bucket_async
                  @create_bucket_async = ::Gapic::Config::Method.new create_bucket_async_config
                  update_bucket_async_config = parent_rpcs.update_bucket_async if parent_rpcs.respond_to? :update_bucket_async
                  @update_bucket_async = ::Gapic::Config::Method.new update_bucket_async_config
                  create_bucket_config = parent_rpcs.create_bucket if parent_rpcs.respond_to? :create_bucket
                  @create_bucket = ::Gapic::Config::Method.new create_bucket_config
                  update_bucket_config = parent_rpcs.update_bucket if parent_rpcs.respond_to? :update_bucket
                  @update_bucket = ::Gapic::Config::Method.new update_bucket_config
                  delete_bucket_config = parent_rpcs.delete_bucket if parent_rpcs.respond_to? :delete_bucket
                  @delete_bucket = ::Gapic::Config::Method.new delete_bucket_config
                  undelete_bucket_config = parent_rpcs.undelete_bucket if parent_rpcs.respond_to? :undelete_bucket
                  @undelete_bucket = ::Gapic::Config::Method.new undelete_bucket_config
                  list_views_config = parent_rpcs.list_views if parent_rpcs.respond_to? :list_views
                  @list_views = ::Gapic::Config::Method.new list_views_config
                  get_view_config = parent_rpcs.get_view if parent_rpcs.respond_to? :get_view
                  @get_view = ::Gapic::Config::Method.new get_view_config
                  create_view_config = parent_rpcs.create_view if parent_rpcs.respond_to? :create_view
                  @create_view = ::Gapic::Config::Method.new create_view_config
                  update_view_config = parent_rpcs.update_view if parent_rpcs.respond_to? :update_view
                  @update_view = ::Gapic::Config::Method.new update_view_config
                  delete_view_config = parent_rpcs.delete_view if parent_rpcs.respond_to? :delete_view
                  @delete_view = ::Gapic::Config::Method.new delete_view_config
                  list_sinks_config = parent_rpcs.list_sinks if parent_rpcs.respond_to? :list_sinks
                  @list_sinks = ::Gapic::Config::Method.new list_sinks_config
                  get_sink_config = parent_rpcs.get_sink if parent_rpcs.respond_to? :get_sink
                  @get_sink = ::Gapic::Config::Method.new get_sink_config
                  create_sink_config = parent_rpcs.create_sink if parent_rpcs.respond_to? :create_sink
                  @create_sink = ::Gapic::Config::Method.new create_sink_config
                  update_sink_config = parent_rpcs.update_sink if parent_rpcs.respond_to? :update_sink
                  @update_sink = ::Gapic::Config::Method.new update_sink_config
                  delete_sink_config = parent_rpcs.delete_sink if parent_rpcs.respond_to? :delete_sink
                  @delete_sink = ::Gapic::Config::Method.new delete_sink_config
                  create_link_config = parent_rpcs.create_link if parent_rpcs.respond_to? :create_link
                  @create_link = ::Gapic::Config::Method.new create_link_config
                  delete_link_config = parent_rpcs.delete_link if parent_rpcs.respond_to? :delete_link
                  @delete_link = ::Gapic::Config::Method.new delete_link_config
                  list_links_config = parent_rpcs.list_links if parent_rpcs.respond_to? :list_links
                  @list_links = ::Gapic::Config::Method.new list_links_config
                  get_link_config = parent_rpcs.get_link if parent_rpcs.respond_to? :get_link
                  @get_link = ::Gapic::Config::Method.new get_link_config
                  list_exclusions_config = parent_rpcs.list_exclusions if parent_rpcs.respond_to? :list_exclusions
                  @list_exclusions = ::Gapic::Config::Method.new list_exclusions_config
                  get_exclusion_config = parent_rpcs.get_exclusion if parent_rpcs.respond_to? :get_exclusion
                  @get_exclusion = ::Gapic::Config::Method.new get_exclusion_config
                  create_exclusion_config = parent_rpcs.create_exclusion if parent_rpcs.respond_to? :create_exclusion
                  @create_exclusion = ::Gapic::Config::Method.new create_exclusion_config
                  update_exclusion_config = parent_rpcs.update_exclusion if parent_rpcs.respond_to? :update_exclusion
                  @update_exclusion = ::Gapic::Config::Method.new update_exclusion_config
                  delete_exclusion_config = parent_rpcs.delete_exclusion if parent_rpcs.respond_to? :delete_exclusion
                  @delete_exclusion = ::Gapic::Config::Method.new delete_exclusion_config
                  get_cmek_settings_config = parent_rpcs.get_cmek_settings if parent_rpcs.respond_to? :get_cmek_settings
                  @get_cmek_settings = ::Gapic::Config::Method.new get_cmek_settings_config
                  update_cmek_settings_config = parent_rpcs.update_cmek_settings if parent_rpcs.respond_to? :update_cmek_settings
                  @update_cmek_settings = ::Gapic::Config::Method.new update_cmek_settings_config
                  get_settings_config = parent_rpcs.get_settings if parent_rpcs.respond_to? :get_settings
                  @get_settings = ::Gapic::Config::Method.new get_settings_config
                  update_settings_config = parent_rpcs.update_settings if parent_rpcs.respond_to? :update_settings
                  @update_settings = ::Gapic::Config::Method.new update_settings_config
                  copy_log_entries_config = parent_rpcs.copy_log_entries if parent_rpcs.respond_to? :copy_log_entries
                  @copy_log_entries = ::Gapic::Config::Method.new copy_log_entries_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
