% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelAR.R
\name{modelAR}
\alias{modelAR}
\alias{print.modelAR}
\title{Time Series Forecasts with a user-defined model}
\usage{
modelAR(
  y,
  p,
  P = 1,
  FUN,
  predict.FUN,
  xreg = NULL,
  lambda = NULL,
  model = NULL,
  subset = NULL,
  scale.inputs = FALSE,
  x = y,
  ...
)
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{p}{Embedding dimension for non-seasonal time series. Number of
non-seasonal lags used as inputs. For non-seasonal time series, the default
is the optimal number of lags (according to the AIC) for a linear AR(p)
model. For seasonal time series, the same method is used but applied to
seasonally adjusted data (from an stl decomposition).}

\item{P}{Number of seasonal lags used as inputs.}

\item{FUN}{Function used for model fitting. Must accept argument \code{x} and \code{y}
for the predictors and response, respectively (\code{formula} object not
currently supported).}

\item{predict.FUN}{Prediction function used to apply \code{FUN} to new data.
Must accept an object of class \code{FUN} as its first argument, and a
data frame or matrix of new data for its second argument. Additionally,
it should return fitted values when new data is omitted.}

\item{xreg}{Optionally, a numerical vector or matrix of external regressors,
which must have the same number of rows as \code{y}. It should not be a data frame.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{model}{Output from a previous call to \code{nnetar}. If model is
passed, this same model is fitted to \code{y} without re-estimating any
parameters.}

\item{subset}{Optional vector specifying a subset of observations to be used
in the fit. Can be an integer index vector or a logical vector the same
length as \code{y}. All observations are used by default.}

\item{scale.inputs}{If \code{TRUE}, inputs are scaled by subtracting the column
means and dividing by their respective standard deviations. If \code{lambda}
is not \code{NULL}, scaling is applied after Box-Cox transformation.}

\item{x}{Deprecated. Included for backwards compatibility.}

\item{...}{Other arguments passed to \code{FUN} for \code{modelAR}.}
}
\value{
Returns an object of class \code{modelAR}.

The function \code{summary} is used to obtain and print a summary of the
results.

The generic accessor functions \code{fitted.values} and \code{residuals}
extract useful features of the value returned by \code{modelAR}.

\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{x}{The original time series.}
\item{xreg}{The external regressors used in fitting (if given).}
\item{residuals}{Residuals from the fitted model. That is x minus fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
\item{...}{Other arguments}
}
\description{
Experimental function to forecast univariate time series with a
user-defined model
}
\details{
This is an experimental function and only recommended for advanced users.
The selected model is fitted with lagged values of \verb{y as inputs. The inputs are for lags 1 to }p\verb{, and lags }m\code{to}mP\code{where}m = frequency(y)\verb{. If }xreg\verb{is provided, its columns are also used as inputs. If there are missing values in}y\code{or}xreg`, the corresponding rows (and any others
which depend on them as lags) are omitted from the fit. The model is trained
for one-step forecasting. Multi-step forecasts are computed recursively.
}
\examples{
## Set up functions
my_lm <- function(x, y) {
 structure(lsfit(x,y), class = "lsfit")
}
predict.lsfit <- function(object, newdata = NULL) {
  n <- length(object$qr$qt)
  if(is.null(newdata)) {
    z <- numeric(n)
    z[seq_len(object$qr$rank)] <- object$qr$qt[seq_len(object$qr$rank)]
    as.numeric(qr.qy(object$qr, z))
  } else {
    sum(object$coefficients * c(1, newdata))
  }
}
# Fit an AR(2) model
fit <- modelAR(
  y = lynx,
  p = 2,
  FUN = my_lm,
  predict.FUN = predict.lsfit,
  lambda = 0.5,
  scale.inputs = TRUE
)
forecast(fit, h = 20) |> autoplot()
}
\author{
Rob J Hyndman and Gabriel Caceres
}
\keyword{ts}
