% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_tabulate.R
\name{.process_denominator}
\alias{.process_denominator}
\title{Process \code{denominator} Argument}
\usage{
.process_denominator(data, variables, denominator, by, strata)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries. Default is \code{everything()}.}

\item{denominator}{(\code{string}, \code{data.frame}, \code{integer})\cr
Specify this argument to change the denominator,
e.g. the \code{"N"} statistic. Default is \code{'column'}. See below for details.}

\item{by, strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to use for grouping or stratifying the table output.
Arguments are similar, but with an important distinction:

\code{by}: results are tabulated by \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: results are tabulated by \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}
}
\value{
a data frame
}
\description{
Function takes the \code{ard_tabulate(denominator)} argument and returns a
structured data frame that is merged with the count data and used as the
denominator in percentage calculations.
}
\examples{
cards:::.process_denominator(mtcars, denominator = 1000, variables = "cyl", by = "gear")
}
\keyword{internal}
