/* Generated table of ln(x) - (t - 1) table values.

   See declntables.c to understand how, or fix these
   values if such is neeeded.

   Copyright (C) 2019 Free Software Foundation, Inc.

   This file is part of the Decimal Floating Point C Library.

   This is adapted, derived, and in some spiritual form based on
   the version found in glibc's float128/ibm128 variant.

   The Decimal Floating Point C Library is free software; you can
   redistribute it and/or modify it under the terms of the GNU Lesser
   General Public License version 2.1.

   The Decimal Floating Point C Library is distributed in the hope that
   it will be useful, but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
   the GNU Lesser General Public License version 2.1 for more details.

   You should have received a copy of the GNU Lesser General Public
   License version 2.1 along with the Decimal Floating Point C Library;
   if not, write to the Free Software Foundation, Inc., 51 Franklin
   Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Please see libdfp/COPYING.txt for more information.  */

static const struct { _Decimal128 t; _Decimal128 lnt; } lntvals[] = {
  {  1.0DL,                                  0.0DL},
  { 1.01DL, -0.00004966914683191715178464245573925831DL},
  { 1.02DL, -0.0001973727038202869739709331148996069DL},
  { 1.03DL, -0.0004411977584555972673805943152875946DL},
  { 1.04DL, -0.0007792868467187037307991034288801062DL},
  { 1.05DL, -0.001209835830567996934625595776835341DL},
  { 1.06DL, -0.001731091876024224474281648881494077DL},
  { 1.07DL, -0.002341351526185194731584092345451414DL},
  { 1.08DL, -0.003038958863871675015782955684798165DL},
  { 1.09DL, -0.003822303758947667658666457159526764DL},
  {  1.1DL, -0.004689820195675139956047876719234908DL},
  { 1.11DL, -0.005639984675757232272642001414755547DL},
  { 1.12DL, -0.006671314692996825261701680092842413DL},
  { 1.13DL, -0.007782367275750799453851415752706743DL},
  { 1.14DL, -0.008971737593595907214478119100172605DL},
  { 1.15DL, -0.01023805762484130262847074433234466DL},
  { 1.16DL, -0.01157999488172672201824663409046367DL},
  { 1.17DL, -0.01299625119033524919200499395835840DL},
  { 1.18DL, -0.01448556152242660800270041419085422DL},
  { 1.19DL, -0.01604669287656198268109554805242215DL},
  {  1.2DL, -0.01767844320604537378828197484548537DL},
  { 1.21DL, -0.01937964039135027991209575343846982DL},
  { 1.22DL, -0.02114914125483480986736168448493710DL},
  { 1.23DL, -0.02298583061567387277397429940879512DL},
  { 1.24DL, -0.02488862038305450327235434191001807DL},
  { 1.25DL, -0.02685644868579024423370490969016550DL},
  { 1.26DL, -0.02888827903661337072290757062232071DL},
  { 1.27DL, -0.03098309952950009498854210165243602DL},
  { 1.28DL, -0.03313992206847420211535805916149244DL},
  { 1.29DL, -0.03535778162641925316789515910035567DL},
  {  1.3DL, -0.03763573553250894796450401311904560DL},
  { 1.31DL, -0.03997286278693982388655889819920252DL},
  { 1.32DL, -0.04236826340172051374432985156472027DL},
  { 1.33DL, -0.04482105776633760292160273403769515DL},
  { 1.34DL, -0.04733038603717999894867879154682910DL},
  { 1.35DL, -0.04989540754966191924948786537496366DL},
  { 1.36DL, -0.05251530025203935953475192712107218DL},
  { 1.37DL, -0.05518926015996645272079278138886302DL},
  { 1.38DL, -0.05791650083088667641675271917783002DL},
  { 1.39DL, -0.06069625285739961084719799049318463DL},
  {  1.4DL, -0.06352776337878706949540658978300791DL},
  { 1.41DL, -0.06641029560992308981978700267402900DL},
  { 1.42DL, -0.06934312838683063728929625539751775DL},
  { 1.43DL, -0.07232555572818408792055188983828051DL},
  { 1.44DL, -0.07535688641209074757656394969097073DL},
  { 1.45DL, -0.07843644356751696625195154378062917DL},
  { 1.46DL, -0.08156356427975492952664193047200928DL},
  { 1.47DL, -0.08473759920935506643003218555984325DL},
  { 1.48DL, -0.08795791222397630483342299542092812DL},
  { 1.49DL, -0.09122388004263222704355463426460793DL},
  {  1.5DL, -0.09453489189183561802198688453565086DL},
  { 1.51DL, -0.09789034917316703923974660988425212DL},
  { 1.52DL, -0.1012896651418149797752591131063452DL},
  { 1.53DL, -0.1047322645956559049959578176505505DL},
  { 1.54DL, -0.1082175835744622094514544665022428DL},
  { 1.55DL, -0.1117450690688447475060592516001836DL},
  { 1.56DL, -0.1153141787385543217527859879645310DL},
  { 1.57DL, -0.1189243806397833106115376729652532DL},
  { 1.58DL, -0.1225751529611245644458052464291409DL},
  { 1.59DL, -0.1262659837678598424962685334171449DL},
  {  1.6DL, -0.1299963707542644463490629688516579DL},
  { 1.61DL, -0.1337658210036283721238773341153526DL},
  { 1.62DL, -0.1375738507557072930377698402204490DL},
  { 1.63DL, -0.1414199851813290339710505432479785DL},
  { 1.64DL, -0.1453037581638929453347552934149677DL},
  { 1.65DL, -0.1492247120875107579780347612548858DL},
  { 1.66DL, -0.1531823976315481351432785646191814DL},
  { 1.67DL, -0.1571763735713362607762321326239490DL},
  { 1.68DL, -0.1612062065848324432836885646284933DL},
  { 1.69DL, -0.1652714710650178959290080262380912DL},
  {  1.7DL, -0.1693717489378296037684568368112377DL},
  { 1.71DL, -0.1735066294854315252364650036358235DL},
  { 1.72DL, -0.1776757091746383257286761531065282DL},
  { 1.73DL, -0.1818785914903124211024825209277369DL},
  { 1.74DL, -0.1861148867735623400402335186261145DL},
  { 1.75DL, -0.1903842120645773137291114994731734DL},
  { 1.76DL, -0.1946861909499395863051108455708928DL},
  { 1.77DL, -0.1990204534142622260246872987265051DL},
  { 1.78DL, -0.2033866356960062203009352472407026DL},
  { 1.79DL, -0.2077843801473363718581784793473262DL},
  {  1.8DL, -0.2122133350978809918102688593811362DL},
  { 1.81DL, -0.2166731547222656211968958707357195DL},
  { 1.82DL, -0.2211634989112960174599106029020535DL},
  { 1.83DL, -0.2256840331466704278893485690205880DL},
  { 1.84DL, -0.2302344283791057489775337131840026DL},
  { 1.85DL, -0.2348143609097665490671279051110936DL},
  { 1.86DL, -0.2394235122748901212943412264456689DL},
  { 1.87DL, -0.2440615691335047437245047135304726DL},
  { 1.88DL, -0.2487282231581421623805679966802016DL},
  { 1.89DL, -0.2534231709284489887448944551579716DL},
  {  1.9DL, -0.2581461138276052240089640227965107DL},
  { 1.91DL, -0.2628967579414614951860329571663613DL},
  { 1.92DL, -0.2676748139603098201373449436971433DL},
  { 1.93DL, -0.2724799970832058161810518559856697DL},
  { 1.94DL, -0.2773120269247632365020291662065901DL},
  { 1.95DL, -0.2821706274243445659864908976546965DL},
  { 1.96DL, -0.2870555267575741389908131795660158DL},
  { 1.97DL, -0.2919664572501028612561855802058974DL},
  { 1.98DL, -0.2969031552935561317663167361003711DL},
  { 1.99DL, -0.3018653612635989726258616175001912DL},
  {  0.2DL, -0.8094379124341003746007593332261876DL},
  {0.201DL, -0.8054503709230613009886571307668442DL},
  {0.202DL, -0.8014875815809322917525439756819269DL},
  {0.203DL, -0.7975492999403497197653495882480013DL},
  {0.204DL, -0.7936352851379206615747302663410872DL},
  {0.205DL, -0.7897452998437288735864516577894974DL},
  {0.206DL, -0.7858791101925559718681399275414752DL},
  {0.207DL, -0.7820364857167679784567310583978451DL},
  {0.208DL, -0.7782171992808190783315584366550677DL},
  {0.209DL, -0.7744210270173260479830033542001098DL},
  { 0.21DL, -0.7706477482646683715353849290030230DL},
  {0.211DL, -0.7668971455060705563120180985988125DL},
  {0.212DL, -0.7631690043101245990750409821076817DL},
  {0.213DL, -0.7594631132727119393292745946175328DL},
  {0.214DL, -0.7557792639602855693323434255716391DL},
  {0.215DL, -0.7521172508544742539803725174810579DL},
  {0.216DL, -0.7484768712979720496165422889109858DL},
  {0.217DL, -0.7448579254416775010194572960675557DL},
  {0.218DL, -0.7412602161930480422594257903857144DL},
  {0.219DL, -0.7376835491656362315666202696920243DL},
  { 0.22DL, -0.7341277326297755145568072099454225DL},
  {0.221DL, -0.7305925774643842357509523046146475DL},
  {0.222DL, -0.7270778971098576068734013346409432DL},
  {0.223DL, -0.7235835075220182934178691543299526DL},
  {0.224DL, -0.7201092271270971998624610133190301DL},
  {0.225DL, -0.7166548767777169200619652237556659DL},
  {0.226DL, -0.7132202797098511740546107489788944DL},
  {0.227DL, -0.7098052615007343770405927872195956DL},
  {0.228DL, -0.7064096500276962818152374523263602DL},
  {0.229DL, -0.7030332754278974036127387601204843DL},
  { 0.23DL, -0.6996759700589416772292300775585323DL},
  {0.231DL, -0.6963375684603435114914328057222579DL},
  {0.232DL, -0.6930179073158270966190059673166513DL},
  {0.233DL, -0.6897168254164364867517494893842051DL},
  {0.234DL, -0.6864341636244356237927643271845460DL},
  {0.235DL, -0.6831697648379780906322643610547313DL},
  {0.236DL, -0.6799234739565269826034597474170419DL},
  {0.237DL, -0.6766951378470058664857835856491560DL},
  {0.238DL, -0.6734846053106623572818548812786098DL},
  {0.239DL, -0.6702917270506263850908107697911835DL},
  { 0.24DL, -0.6671163556401457483890413080716730DL},
  {0.241DL, -0.6639583454914820565875630453422769DL},
  {0.242DL, -0.6608175528254506545128550866646575DL},
  {0.243DL, -0.6576938356415885950777481794404641DL},
  {0.244DL, -0.6545870536889351844681210177111247DL},
  {0.245DL, -0.6514970684374100672425095439405455DL},
  {0.246DL, -0.6484237430497742473747336326349828DL},
  {0.247DL, -0.6453669423541598559914594905999205DL},
  {0.248DL, -0.6423265328171548778731136751362057DL},
  {0.249DL, -0.6393023825174294371832569038391965DL},
  { 0.25DL, -0.6362943611198906188344642429163531DL},
  {0.251DL, -0.6333023398503531658353891250448394DL},
  {0.252DL, -0.6303261914707137453236669038485083DL},
  {0.253DL, -0.6273657902546168171852779542777672DL},
  {0.254DL, -0.6244210119636004695893014348786237DL},
  {0.255DL, -0.6214917338237109058084351760312527DL},
  {0.256DL, -0.6185778345025745767161173923876801DL},
  {0.257DL, -0.6156791940869172537021800492918372DL},
  {0.258DL, -0.6127956940605196277686544923265433DL},
  {0.259DL, -0.6099272172825993025805259495784657DL},
  { 0.26DL, -0.6070736479666093225652633463452332DL},
  {0.261DL, -0.6042348716594436420802118578461296DL},
  {0.262DL, -0.6014107752210401984873182314253902DL},
  {0.263DL, -0.5986012468043725009680480998480205DL},
  {0.264DL, -0.5958061758358208883450891847909079DL},
  {0.265DL, -0.5930254529959148433087458917978472DL},
  {0.266DL, -0.5902589702004379775223620672638828DL},
  {0.267DL, -0.5875066205818875223409135864607177DL},
  {0.268DL, -0.5847682984712803735494381247730167DL},
  {0.269DL, -0.5820438993802979458340211835578555DL},
  { 0.27DL, -0.5793333199837622938502471986011513DL},
  {0.271DL, -0.5766364581024361519571042908472306DL},
  {0.272DL, -0.5739532126861397341355112603472598DL},
  {0.273DL, -0.5712834837971773194998889421220686DL},
  {0.274DL, -0.5686271725940668273215521146150507DL},
  {0.275DL, -0.5659841813155657587905121196355880DL},
  {0.276DL, -0.5633544132649870510175120524040177DL},
  {0.277DL, -0.5607377727947985521845768145284818DL},
  {0.278DL, -0.5581341652914999854479573237193723DL},
  {0.279DL, -0.5555434971607714233343195656656840DL},
  { 0.28DL, -0.5529656758128874440961659230091955DL},
  {0.281DL, -0.5504006096483912869473360393599207DL},
  {0.282DL, -0.5478482080440234644205463359002166DL},
  {0.283DL, -0.5453083813388994274079872172579524DL},
  {0.284DL, -0.5427810408209310118900555886237054DL},
  {0.285DL, -0.5402660987134865260489423620165257DL},
  {0.286DL, -0.5377634681622844625213112230644682DL},
  {0.287DL, -0.5352730632225159430818582475725053DL},
  {0.288DL, -0.5327947988461911221773232829171584DL},
  {0.289DL, -0.5303285908697048915549051283068396DL},
  { 0.29DL, -0.5278743560016173408527108770068168DL},
  {0.291DL, -0.5254320118106445385420075054266052DL},
  {0.292DL, -0.5230014767138553041274012636981969DL},
  {0.293DL, -0.5205826699650697461141341012405944DL},
  {0.294DL, -0.5181755116434554410307915187860309DL},
  {0.295DL, -0.5157799226423172268371646571072074DL},
  {0.296DL, -0.5133958246580766794341823286471158DL},
  {0.297DL, -0.5110231401794374338062950753203862DL},
  {0.298DL, -0.5086617924767326016443139674907956DL},
  {0.299DL, -0.5063117055914506251937340906775779DL},
  {  0.3DL, -0.5039728043259359926227462177618385DL},
  {0.301DL, -0.5016450142332613234757791072640659DL},
  {0.302DL, -0.4993282616072674138405059431104398DL},
  {0.303DL, -0.4970224734727679097745308602175778DL},
  {0.304DL, -0.4947275775759153543760184463325328DL},
  {0.305DL, -0.4924435023747254287018259274012902DL},
  {0.306DL, -0.4901701770297562795967171508767381DL},
  {0.307DL, -0.4879075313949398984555117967706003DL},
  {0.308DL, -0.4856554960085625840522137997284305DL},
  {0.309DL, -0.4834140020843915898901268120771261DL},
  { 0.31DL, -0.4811829815029451221068185848263712DL},
  {0.311DL, -0.4789623668029029178579787986204103DL},
  {0.312DL, -0.4767520911726546963535453211907186DL},
  {0.313DL, -0.4745520884419838353752090547958823DL},
  {0.314DL, -0.4723622930738836852122970061914408DL},
  {0.315DL, -0.4701826401565039895573718135386738DL},
  {0.316DL, -0.4680130653952249390465645796553286DL},
  {0.317DL, -0.4658535051048564378542121947544813DL},
  {0.318DL, -0.4637038962019602170970278666433326DL},
  {0.319DL, -0.4615641761972924808087587537260517DL},
  { 0.32DL, -0.4594342831883648209498223020778456DL},
  {0.321DL, -0.4573141558521211873543303101072899DL},
  {0.322DL, -0.4552037334377287467246366673415402DL},
  {0.323DL, -0.4531029557594805117954123142921125DL},
  {0.324DL, -0.4510117631898076676385291734466367DL},
  {0.325DL, -0.4489300966523995667989682560353987DL},
  {0.326DL, -0.4468578976154294085718098764741662DL},
  {0.327DL, -0.4447951080848836602814126749213653DL},
  {0.328DL, -0.4427416705979933199355146266411553DL},
  {0.329DL, -0.4406975282167651601276709508377392DL},
  { 0.33DL, -0.4386626245216111325787940944810734DL},
  {0.331DL, -0.4366369036050741512693575244764558DL},
  {0.332DL, -0.4346203100656485097440378978453690DL},
  {0.333DL, -0.4326127890016932248953882191765940DL},
  {0.334DL, -0.4306142860054366353769914658501367DL},
  {0.335DL, -0.4286247471570706177831430344631822DL},
  {0.336DL, -0.4266441190189328178844478978546809DL},
  {0.337DL, -0.4246723486297753275491078094046614DL},
  {0.338DL, -0.4227093834991182705297673594642788DL},
  {0.339DL, -0.4207551716016867920765976335145452DL},
  { 0.34DL, -0.4188096613719299783692161700374253DL},
  {0.341DL, -0.4168728016986202620628664615456061DL},
  {0.342DL, -0.4149445419195318998372243368620111DL},
  {0.343DL, -0.4130248318161971367379161337235534DL},
  {0.344DL, -0.4111136216087387003294354863327159DL},
  {0.345DL, -0.4092108619507772952512169620941832DL},
  {0.346DL, -0.4073165039244127957032418541539246DL},
  {0.347DL, -0.4054304990352778597002975176672331DL},
  {0.348DL, -0.4035527992076627146409928518523022DL},
  {0.349DL, -0.4016833567797098888544928415544529DL},
  { 0.35DL, -0.3998221244986776883298708326993610DL},
  {0.351DL, -0.3979690555162712418147512117201969DL},
  {0.352DL, -0.3961241033840399609058701787970805DL},
  {0.353DL, -0.3942872220488402846582542468651226DL},
  {0.354DL, -0.3924583658483626006254466319526927DL},
  {0.355DL, -0.3906374895067212561237604983138709DL},
  {0.356DL, -0.3888245481301065949016945804668903DL},
  {0.357DL, -0.3870194972024979753038417658142607DL},
  {0.358DL, -0.3852222925814367464589378125735139DL},
  {0.359DL, -0.3834328904938581790058814784484126DL},
  { 0.36DL, -0.3816512475319813664110281926073239DL},
  {0.361DL, -0.3798773206492561320359195002773855DL},
  {0.362DL, -0.3781110671563659957976552039619071DL},
  {0.363DL, -0.3763524447172862725348419712003083DL},
  {0.364DL, -0.3746014113453963920606699361282412DL},
  {0.365DL, -0.3728579253996455483611061733883624DL},
  {0.366DL, -0.3711219455807708024901079022467756DL},
  {0.367DL, -0.3693934309275667804345424248946635DL},
  {0.368DL, -0.3676723408132061235782930464101902DL},
  {0.369DL, -0.3659586349416098653967205171706336DL},
  { 0.37DL, -0.3642522733438669236678872383372813DL},
  {0.371DL, -0.3625532163747019128041524815808551DL},
  {0.372DL, -0.3608614247089904958951005596718566DL},
  {0.373DL, -0.3591768593383215107182397589514285DL},
  {0.374DL, -0.3574994815676051183252640467566602DL},
  {0.375DL, -0.3558292530117262368564511274520040DL},
  {0.376DL, -0.3541661355922425369813273299063892DL},
  {0.377DL, -0.3525100915341262888172148901258624DL},
  {0.378DL, -0.3508610833625493633456537883841592DL},
  {0.379DL, -0.3492190738997107042367377803994647DL},
  { 0.38DL, -0.3475840262617055986097233560226983DL},
  {0.381DL, -0.3459559038554360876112883194142745DL},
  {0.382DL, -0.3443346703755618697867922903925489DL},
  {0.383DL, -0.3427202898014910620609198269006224DL},
  {0.384DL, -0.3411127263944101947381042769233309DL},
  {0.385DL, -0.3395119446943528282859187094185960DL},
  {0.386DL, -0.3379179095173061907818111892118573DL},
  {0.387DL, -0.3363305859523552457906413768621942DL},
  {0.388DL, -0.3347499393588636111027884994327778DL},
  {0.389DL, -0.3331759353636907592053541304209200DL},
  { 0.39DL, -0.3316085398584449405872502308808841DL},
  {0.391DL, -0.3300477189967712809976869143697700DL},
  {0.392DL, -0.3284934391916745135915725127922035DL},
  {0.393DL, -0.3269456671128758165093051159610410DL},
  {0.394DL, -0.3254043696842032358569449134320851DL},
  {0.395DL, -0.3238695140810151832802694893454941DL},
  {0.396DL, -0.3223410677276565063670760693265588DL},
  {0.397DL, -0.3208189982949466389705423338762333DL},
  {0.398DL, -0.3193032736976993472266209507263789DL},
  {0.399DL, -0.3177938620922735955443489517995337DL},
  {  0.4DL, -0.3162907318741550651835272117680111DL},
  {0.401DL, -0.3147938516755678662032952767037429DL},
  {0.402DL, -0.3133031903631159915714250093086676DL},
  {0.403DL, -0.3118187170354540700713225979454168DL},
  {0.404DL, -0.3103404010209869823353118542237503DL},
  {0.405DL, -0.3088682118755979118722340831368022DL},
  {0.406DL, -0.3074021193804044103481174667898247DL},
  {0.407DL, -0.3059420935395420636239351150565162DL},
  {0.408DL, -0.3044881045779753521574981448829107DL},
  {0.409DL, -0.3030401229393353063404521549247065DL},
  { 0.41DL, -0.3015981192837835641692195363313208DL},
  {0.411DL, -0.3001620644859024453435389991507015DL},
  {0.412DL, -0.2987319296326106624509078060832987DL},
  {0.413DL, -0.2973076860211042963325712468902153DL},
  {0.414DL, -0.2958893051568226690394989369396685DL},
  {0.415DL, -0.2944767587514387539777428075355345DL},
  {0.416DL, -0.2930700187208737689143263151968912DL},
  {0.417DL, -0.2916690571833356034699442082550231DL},
  {0.418DL, -0.2902738464573807385657712327419332DL},
  {0.419DL, -0.2888843590599993210210404423676022DL},
  { 0.42DL, -0.2875005677047230621181528075448464DL},
  {0.421DL, -0.2861224452997556344652581356559951DL},
  {0.422DL, -0.2847499649461252468947859771406359DL},
  {0.423DL, -0.2833830999358590824425332204358675DL},
  {0.424DL, -0.2820218237501792896578088606495051DL},
  {0.425DL, -0.2806661100577202226029210797275908DL},
  {0.426DL, -0.2793159327127666299120424731593563DL},
  {0.427DL, -0.2779712657535124981972325171842981DL},
  {0.428DL, -0.2766320834003402599151113041134625DL},
  {0.429DL, -0.2752983600541200805432981076001190DL},
  { 0.43DL, -0.2739700702945289445631403960228814DL},
  {0.431DL, -0.2726471888783892643063075577280424DL},
  {0.432DL, -0.2713296907380267401993101674528092DL},
  {0.433DL, -0.2700175509796472053336897900805487DL},
  {0.434DL, -0.2687107448817321916022251746093791DL},
  {0.435DL, -0.2674092478934529588746977615424677DL},
  {0.436DL, -0.2661130356331027328421936689275378DL},
  {0.437DL, -0.2648220838865469012381941003550430DL},
  {0.438DL, -0.2635363686056909221493881482338478DL},
  {0.439DL, -0.2622558659069657020607622343103389DL},
  { 0.44DL, -0.2609805520698302051395750884872460DL},
  {0.441DL, -0.2597104035352910590527784033216818DL},
  {0.442DL, -0.2584453969044389263337201831564709DL},
  {0.443DL, -0.2571855089370014139679671062078169DL},
  {0.444DL, -0.2559307165499122974561692131827666DL},
  {0.445DL, -0.2546809968158968391353994901570558DL},
  {0.446DL, -0.2534363269620729840006370328717760DL},
  {0.447DL, -0.2521966843685682196663008520264464DL},
  {0.448DL, -0.2509620465671518904452288918608535DL},
  {0.449DL, -0.2497323912398827588004525732269826DL},
  { 0.45DL, -0.2485076962177716106447331022974894DL},
  {0.451DL, -0.2472879394794587041252674130505557DL},
  {0.452DL, -0.2460730991499058646373786275207178DL},
  {0.453DL, -0.2448631534991030318624928276460906DL},
  {0.454DL, -0.2436580809407890676233606657614190DL},
  {0.455DL, -0.2424578600311866362943748458184066DL},
  {0.456DL, -0.2412624694677509723980053308681837DL},
  {0.457DL, -0.2400718880879323528608429828996091DL},
  {0.458DL, -0.2388860948679520941955066386623077DL},
  {0.459DL, -0.2377050689215918976187040354123890DL},
  { 0.46DL, -0.2365287894989963678119979561003557DL},
  {0.461DL, -0.2353572359854885336812491707785661DL},
  {0.462DL, -0.2341903879003982020742006842640813DL},
  {0.463DL, -0.2330282248959029779741271827943827DL},
  {0.464DL, -0.2318707267558817872017738458584747DL},
  {0.465DL, -0.2307178733947807401288054693620221DL},
  {0.466DL, -0.2295696448564911773345173679260286DL},
  {0.467DL, -0.2284260213132397405244430753188236DL},
  {0.468DL, -0.2272869830644903143755322057263695DL},
  {0.469DL, -0.2261525105358576872785496242461901DL},
  { 0.47DL, -0.2250225842780327812150322395965547DL},
  {0.471DL, -0.2238971849657193032342838907270917DL},
  {0.472DL, -0.2227762933965816731862276259588653DL},
  {0.473DL, -0.2216598904902040845191882727421163DL},
  {0.474DL, -0.2205479572870605570685514641909794DL},
  {0.475DL, -0.2194404749474958428434282657128638DL},
  {0.476DL, -0.2183374247507170478646227598204332DL},
  {0.477DL, -0.2172387880937958351190147511789834DL},
  {0.478DL, -0.2161445464906810756735786483330070DL},
  {0.479DL, -0.2150546815712218169372965326534760DL},
  { 0.48DL, -0.2139691750802004389718091866134964DL},
  {0.481DL, -0.2128880088763758716323912514563269DL},
  {0.482DL, -0.2118111649315367471703309238841003DL},
  {0.483DL, -0.2107386253295643647466235518771911DL},
  {0.484DL, -0.2096703722655053450956229652064809DL},
  {0.485DL, -0.2086063880446538553364934091229433DL},
  {0.486DL, -0.2075466550816432856605160579822875DL},
  {0.487DL, -0.2064911558995472613240635328025471DL},
  {0.488DL, -0.2054398731289898750508888962529482DL},
  {0.489DL, -0.2043927895072650265937967610098170DL},
  { 0.49DL, -0.2033498878774647578252774224823690DL},
  {0.491DL, -0.2023111511876164733197840390380080DL},
  {0.492DL, -0.2012765624898289379575015111768062DL},
  {0.493DL, -0.2002461049394469446211677138180545DL},
  {0.494DL, -0.1992197617942145465742273691417439DL},
  {0.495DL, -0.1981975164134467506007809790167243DL},
  {0.496DL, -0.1971793522572095684558815536780291DL},
  {0.497DL, -0.1961652528855083256191670880968788DL},
  {0.498DL, -0.1951552019574841277660247823810199DL},
  {0.499DL, -0.1941491832306183867688832260686996DL},
  {  0.5DL, -0.1931471805599453094172321214581766DL},
  {0.501DL, -0.1921491778972722533989783503857876DL},
  {0.502DL, -0.1911551592904078564181570035866628DL},
  {0.503DL, -0.1901651088823978456352132484174826DL},
  {0.504DL, -0.1891790109107684359064347823903318DL},
  {0.505DL, -0.1881968497067772265690167639139158DL},
  {0.506DL, -0.1872186096946715077680458328195906DL},
  {0.507DL, -0.1862442753909538885517542439999297DL},
  {0.508DL, -0.1852738314036551601720693134204471DL},
  {0.509DL, -0.1843072624316143092191105079933340DL},
  { 0.51DL, -0.1833445532637655963912030545730762DL},
  {0.511DL, -0.1823856887784326178565127631713703DL},
  {0.512DL, -0.1814306539426292672988852709295035DL},
  {0.513DL, -0.1804794338113675178592112213976620DL},
  {0.514DL, -0.1795320135269719442849479278336606DL},
  {0.515DL, -0.1785883783184009066846127157734642DL},
  {0.516DL, -0.1776485135005743183514223708683667DL},
  {0.517DL, -0.1767124044737079211710801163157896DL},
  {0.518DL, -0.1757800367226539931632938281202892DL},
  {0.519DL, -0.1748513958162484137252287386895754DL},
  { 0.52DL, -0.1739264674066640131480312248870567DL},
  {0.521DL, -0.1730052372287701339650786575352562DL},
  {0.522DL, -0.1720876910994983326629797363879530DL},
  {0.523DL, -0.1711738149172141512438311871399973DL},
  {0.524DL, -0.1702635946610948890700861099672136DL},
  {0.525DL, -0.1693570163905133063518577172350119DL},
  {0.526DL, -0.1684540662444271915508159783898440DL},
  {0.527DL, -0.1675547304407747258752754216376089DL},
  {0.528DL, -0.1666589952758755789278570633327313DL},
  {0.529DL, -0.1657668471238376704404687004327004DL},
  { 0.53DL, -0.1648782724359695338915137703396706DL},
  {0.531DL, -0.1639932577401982186474335164883436DL},
  {0.532DL, -0.1631117896404926681051299458057062DL},
  {0.533DL, -0.1622338548162925121337235494503664DL},
  {0.534DL, -0.1613594400219422129236814650025411DL},
  {0.535DL, -0.1604885320861305041488162138036280DL},
  {0.536DL, -0.1596211179113350641322060033148402DL},
  {0.537DL, -0.1587571844732723644809246971091647DL},
  {0.538DL, -0.1578967188203526364167890620996789DL},
  {0.539DL, -0.1570397080731398977813252992016039DL},
  { 0.54DL, -0.1561861394238169844330150771429747DL},
  {0.541DL, -0.1553360001356555304837887514684425DL},
  {0.542DL, -0.1544892775424908425398721693890540DL},
  {0.543DL, -0.1536459590482016138196420884975580DL},
  {0.544DL, -0.1528060321261944247182791388890832DL},
  {0.545DL, -0.1519694843188929770758985786177033DL},
  {0.546DL, -0.1511363032372320100826568206638920DL},
  {0.547DL, -0.1503064765601558464212417424554319DL},
  {0.548DL, -0.1494799920341215179043199931568741DL},
  {0.549DL, -0.1486568374726064205120947867824265DL},
  { 0.55DL, -0.1478370007556204493732799981774115DL},
  {0.551DL, -0.1470204698292225648616748998033275DL},
  {0.552DL, -0.1462072327050417416002799309458411DL},
  {0.553DL, -0.1453972774598022527756760791285020DL},
  {0.554DL, -0.1445905922348532427673446930703052DL},
  {0.555DL, -0.1437871652357025416898741228729321DL},
  {0.556DL, -0.1429869847315546760307252022611957DL},
  {0.557DL, -0.1421900390548530301425474272083109DL},
  {0.558DL, -0.1413963166008261139170874442075074DL},
  {0.559DL, -0.1406058058270378925276444091419270DL},
  { 0.56DL, -0.1398184952529421346789338015510190DL},
  {0.561DL, -0.1390343734594407363472509312923111DL},
  {0.562DL, -0.1382534290884459775301039179017441DL},
  {0.563DL, -0.1374756508424466700531373754353516DL},
  {0.564DL, -0.1367010274840781550033142144420401DL},
  {0.565DL, -0.1359295478356961088710835372108833DL},
  {0.566DL, -0.1351612007789541179907550957997758DL},
  {0.567DL, -0.1343959752543849813676406729198101DL},
  {0.568DL, -0.1336338602609857024728234671655288DL},
  {0.569DL, -0.1328748448558061310717895546689541DL},
  { 0.57DL, -0.1321189181535412166317102405583492DL},
  {0.571DL, -0.1313660693261268353240081681134635DL},
  {0.572DL, -0.1306162876023391531040791016062916DL},
  {0.573DL, -0.1298695622673974878087791749281998DL},
  {0.574DL, -0.1291258826625706336646261261143287DL},
  {0.575DL, -0.1283852381847866120457028657905212DL},
  {0.576DL, -0.1276476182862458127600911614589818DL},
  {0.577DL, -0.1269130124740374905773990567824042DL},
  {0.578DL, -0.1261814103097595821376730068486630DL},
  {0.579DL, -0.1254528014091418088037980737475082DL},
  { 0.58DL, -0.1247271754416720314354787555486402DL},
  {0.581DL, -0.1240045221302258234731493973185424DL},
  {0.582DL, -0.1232848312506992291247753839684286DL},
  {0.583DL, -0.1225680926316446738475616470589056DL},
  {0.584DL, -0.1218542961539099947101691422400203DL},
  {0.585DL, -0.1211434317502805586092371154165350DL},
  {0.586DL, -0.1204354894051244366969019797824179DL},
  {0.587DL, -0.1197304591540406037536738664834199DL},
  {0.588DL, -0.1190283310835101316135593973278543DL},
  {0.589DL, -0.1183290953305503461157826076228819DL},
  { 0.59DL, -0.1176327420823719174199325356490308DL},
  {0.591DL, -0.1169392615760388538789317979677359DL},
  {0.592DL, -0.1162486440981313700169502071889392DL},
  {0.593DL, -0.1155608799844115995073546204029440DL},
  {0.594DL, -0.1148759596194921243890629538622096DL},
  {0.595DL, -0.1141938734365072920983276695105987DL},
  {0.596DL, -0.1135146119167872922270818460326190DL},
  {0.597DL, -0.1128381655895349652486078352620297DL},
  {0.598DL, -0.1121645250315053157765019692194013DL},
  {0.599DL, -0.1114936808666877032437751911716359DL},
  {  0.6DL, -0.1108256237659906832055140963036619DL},
  {0.601DL, -0.1101603444469294727808938574739465DL},
  {0.602DL, -0.1094978336733160140585469858058893DL},
  {0.603DL, -0.1088380822549516095934118938443185DL},
  {0.604DL, -0.1081810810473221044232738216522632DL},
  {0.605DL, -0.1075268209512955893293278748966464DL},
  {0.606DL, -0.1068752929128226003572987387594012DL},
  {0.607DL, -0.1062264879226387899040021292064009DL},
  {0.608DL, -0.1055803970159700449587863248743562DL},
  {0.609DL, -0.1049370112722400283701043513254756DL},
  { 0.61DL, -0.1042963218147801192845938059431137DL},
  {0.611DL, -0.1036583198105417291795362527156003DL},
  {0.612DL, -0.1030229964698109701794850294185615DL},
  {0.613DL, -0.1023903430459256526142417704770417DL},
  {0.614DL, -0.1017603508349945890382796753124238DL},
  {0.615DL, -0.1011330111756191821912064208669717DL},
  {0.616DL, -0.1005083154486172746349816782702539DL},
  {0.617DL, -0.09988625507674923805640268544290180DL},
  {0.618DL, -0.09926682152444628047289469061894953DL},
  {0.619DL, -0.09865000629754094982593897390336889DL},
  { 0.62DL, -0.09803580094299981268958646336819464DL},
  {0.621DL, -0.09742419704865828706148582147531939DL},
  {0.622DL, -0.09681518624295760844074667716223378DL},
  {0.623DL, -0.09620876019468390863080607994006367DL},
  {0.624DL, -0.09560491061270938693631319973254204DL},
  {0.625DL, -0.09500362924573555365093703114834206DL},
  {0.626DL, -0.09440490788203852595797693333770570DL},
  {0.627DL, -0.09380873834921635658775811727758408DL},
  {0.628DL, -0.09321511251393837579506488473326424DL},
  {0.629DL, -0.09262402228169652743634407514851892DL},
  { 0.63DL, -0.09203545959655868014013969208049728DL},
  {0.631DL, -0.09144941644092389477523633038749854DL},
  {0.632DL, -0.09086588483527962962933245819715200DL},
  {0.633DL, -0.09028485683796086491677286167628680DL},
  {0.634DL, -0.08970632454491112843698007329630475DL},
  {0.635DL, -0.08913028008944540440577422311061259DL},
  {0.636DL, -0.08855671564201490767979574518515601DL},
  {0.637DL, -0.08798562340997370578978143560141456DL},
  {0.638DL, -0.08741699563734717139152663226787515DL},
  {0.639DL, -0.08685082460460224793402935769500712DL},
  { 0.64DL, -0.08628710262841951153259018061966901DL},
  {0.641DL, -0.08572582206146701222056782605149244DL},
  {0.642DL, -0.08516697529217587793709818864911335DL},
  {0.643DL, -0.08461055474451766478940586050505954DL},
  {0.644DL, -0.08405655287778343730740454588336364DL},
  {0.645DL, -0.08350496218636456258512728055853224DL},
  {0.646DL, -0.08295577519953520237818019283393598DL},
  {0.647DL, -0.08240898448123648739890514839555221DL},
  {0.648DL, -0.08186458262986235822129705198846010DL},
  {0.649DL, -0.08132256227804705737598041236826570DL},
  { 0.65DL, -0.08078291609245425738173613457722217DL},
  {0.651DL, -0.08024563677356780962421205914502998DL},
  {0.652DL, -0.07971071705548409915457775501598961DL},
  {0.653DL, -0.07917814970570599064102329285486754DL},
  {0.654DL, -0.07864792752493835086418055346318870DL},
  {0.655DL, -0.07812004334688513330379101965737909DL},
  {0.656DL, -0.07759449003804801051828250518297876DL},
  {0.657DL, -0.07707126049752654017137503276949864DL},
  {0.658DL, -0.07655034765681985071043882937956262DL},
  {0.659DL, -0.07603174447962983285010051323326852DL},
  { 0.66DL, -0.07551544396166582316156197302289684DL},
  {0.661DL, -0.07500143913045076621328477557438535DL},
  {0.662DL, -0.07448972304512884185212540301827925DL},
  {0.663DL, -0.07398028879627454435570706769212178DL},
  {0.664DL, -0.07347312950570320032680577638719247DL},
  {0.665DL, -0.07296823832628291233883485549587172DL},
  {0.666DL, -0.07246560844174791547815609771841748DL},
  {0.667DL, -0.07196523306651333406394949988098490DL},
  {0.668DL, -0.07146710544549132595975934439196012DL},
  {0.669DL, -0.07097121885390860202262391740742689DL},
  { 0.67DL, -0.07047756659712530836591091300500566DL},
  {0.671DL, -0.06998614201045525924064168266234858DL},
  {0.672DL, -0.06949693845898750846721577639650435DL},
  {0.673DL, -0.06900994933740924747506319969675442DL},
  {0.674DL, -0.06852516806983001813187568794648484DL},
  {0.675DL, -0.06804258810960722866671998683314023DL},
  {0.676DL, -0.06756220293917296111253523800610228DL},
  {0.677DL, -0.06708400606986205881328242873258060DL},
  {0.678DL, -0.06660799104174148265936551205636868DL},
  {0.679DL, -0.06613415142344092483189999890595118DL},
  { 0.68DL, -0.06566248081198466895198404857924874DL},
  {0.681DL, -0.06519297283262468564534755029706987DL},
  {0.682DL, -0.06472562113867495264563434008742954DL},
  {0.683DL, -0.06426041941134698867112921524303067DL},
  {0.684DL, -0.06379736135958659041999221540383454DL},
  {0.685DL, -0.06333644071991176213802490284703959DL},
  {0.686DL, -0.06287765125625182732068401226537687DL},
  {0.687DL, -0.06242098675978771221749352319795860DL},
  {0.688DL, -0.06196644104879339091220336487453931DL},
  {0.689DL, -0.06151400796847848185601778345871625DL},
  { 0.69DL, -0.06106368139083198583398484063600659DL},
  {0.691DL, -0.06061545521446715544621629423013745DL},
  {0.692DL, -0.06016932336446748628600973269574802DL},
  {0.693DL, -0.05972527979223382009618756879973218DL},
  {0.694DL, -0.05928331847533255028306539620905652DL},
  {0.695DL, -0.05884343341734492026443011195136120DL},
  {0.696DL, -0.05840561864771740522376073039412561DL},
  {0.697DL, -0.05796986822161316793767637314255850DL},
  {0.698DL, -0.05753617621976457943726072009627635DL},
  {0.699DL, -0.05710453674832679535650425246167944DL},
  {  0.7DL, -0.05667494393873237891263871124118448DL},
  {0.701DL, -0.05624739194754696155362594002509205DL},
  {0.702DL, -0.05582187495632593239751909026202034DL},
  {0.703DL, -0.05539838717147214767685126113379192DL},
  {0.704DL, -0.05497692282409465148863805733890391DL},
  {0.705DL, -0.05455747616986839923701912413220557DL},
  {0.706DL, -0.05414004148889497524102212540694605DL},
  {0.707DL, -0.05372461308556429606442335369692374DL},
  {0.708DL, -0.05331118528841729120821451049451616DL},
  {0.709DL, -0.05289975245000955288877730725386952DL},
  { 0.71DL, -0.05249030894677594670652837685569432DL},
  {0.711DL, -0.05208284917889617509053834872663029DL},
  {0.712DL, -0.05167736757016128548446245900871370DL},
  {0.713DL, -0.05127385856784111531805720770053929DL},
  {0.714DL, -0.05087231664255266588660964435608408DL},
  {0.715DL, -0.05047273628812939733778401129645708DL},
  {0.716DL, -0.05007511202149143704170569111533731DL},
  {0.717DL, -0.04967943838251669369556553286865782DL},
  {0.718DL, -0.04928570993391286958864935699023608DL},
  {0.719DL, -0.04889392126109036352748830216639912DL},
  { 0.72DL, -0.04850406697203605699379607114914730DL},
  {0.721DL, -0.04811614169718797618001930555647207DL},
  {0.722DL, -0.04773014008931082261868737881920898DL},
  {0.723DL, -0.04734605682337236519231780841975118DL},
  {0.724DL, -0.04696388659642068638042308250373056DL},
  {0.725DL, -0.04658362412746227566918366523880574DL},
  {0.726DL, -0.04620526415734096311760984974213175DL},
  {0.727DL, -0.04582880144861768614152139520982473DL},
  {0.728DL, -0.04545423078545108264343781467006458DL},
  {0.729DL, -0.04508154697347890368250294251793839DL},
  { 0.73DL, -0.04471074483970023894387405193018584DL},
  {0.731DL, -0.04434181923235854833159723283411905DL},
  {0.732DL, -0.04397476502082549307287578078859904DL},
  {0.733DL, -0.04360957709548555978482566526799432DL},
  {0.734DL, -0.04324625036762147101731030343648689DL},
  {0.735DL, -0.04288477976930037584726430701801982DL},
  {0.736DL, -0.04252516025326081416106092495201366DL},
  {0.737DL, -0.04216738679280044832195878972424057DL},
  {0.738DL, -0.04181145438166455597948839571245706DL},
  {0.739DL, -0.04145735803393527783681548897255429DL},
  { 0.74DL, -0.04110509278392161425065511687910468DL},
  {0.741DL, -0.04075465368605016459621425367739478DL},
  {0.742DL, -0.04040603581475660338692036012267855DL},
  {0.743DL, -0.04005923426437788719535552441857974DL},
  {0.744DL, -0.03971424414904518647786843821368000DL},
  {0.745DL, -0.03937106060257753646078675572278450DL},
  {0.746DL, -0.03902967877837620130100763749325192DL},
  {0.747DL, -0.03869009384931974578801166691667076DL},
  {0.748DL, -0.03835230100765980890803192529848365DL},
  {0.749DL, -0.03801629546491757364422280358663589DL},
  { 0.75DL, -0.03768207245178092743921900599382743DL},
  {0.751DL, -0.03734962721800230779846096118615869DL},
  {0.752DL, -0.03701895503229722756409520844821264DL},
  {0.753DL, -0.03669005118224347444014388812231368DL},
  {0.754DL, -0.03636291097418097939998276866768584DL},
  {0.755DL, -0.03603752973311234865697873134242869DL},
  {0.756DL, -0.03571390280260405392842166692598264DL},
  {0.757DL, -0.03539202554468827577164859216015107DL},
  {0.758DL, -0.03507189333976539481950565894128815DL},
  {0.759DL, -0.03475350158650712579003271735524150DL},
  { 0.76DL, -0.03443684570176028919249123456452174DL},
  {0.761DL, -0.03412192112045121569859561619632300DL},
  {0.762DL, -0.03380872329549077819405619795609796DL},
  {0.763DL, -0.03349724769768004657130516840071124DL},
  {0.764DL, -0.03318748981561656036956016893437234DL},
  {0.765DL, -0.03287944515560121441318993910872704DL},
  {0.766DL, -0.03257310924154575264368770544244580DL},
  {0.767DL, -0.03226847761488086538443654876807639DL},
  {0.768DL, -0.03196554583446488532087215546515437DL},
  {0.769DL, -0.03166430947649307752161751813201498DL},
  { 0.77DL, -0.03136476413440751886868658796041939DL},
  {0.771DL, -0.03106690541880756230693481236931147DL},
  {0.772DL, -0.03077072895736088136457906775368072DL},
  {0.773DL, -0.03047623039471509043782280226625013DL},
  {0.774DL, -0.03018340539240993637340925540401761DL},
  {0.775DL, -0.02989224962879005692329137305836013DL},
  {0.776DL, -0.02960275879891830168555637797460120DL},
  {0.777DL, -0.02931492861448961118528071265594002DL},
  {0.778DL, -0.02902875480374544978812200896274340DL},
  {0.779DL, -0.02874423311138878817818355912783150DL},
  { 0.78DL, -0.02846135929849963117001810942270754DL},
  {0.781DL, -0.02818012914245108666257625357492923DL},
  {0.782DL, -0.02790053843682597158045479291159340DL},
  {0.783DL, -0.02762258299133395068496662092360390DL},
  {0.784DL, -0.02734625863172920417434039133402689DL},
  {0.785DL, -0.02707156119972862002876979442342973DL},
  {0.786DL, -0.02679848655293050709207299450286446DL},
  {0.787DL, -0.02652703056473382491739691556867683DL},
  {0.788DL, -0.02625718912425792643971279197390851DL},
  {0.789DL, -0.02598895813626280957280286292549483DL},
  { 0.79DL, -0.02572233352106987386303736788731749DL},
  {0.791DL, -0.02545731121448317836649012699389122DL},
  {0.792DL, -0.02519388716771119694984394786838221DL},
  {0.793DL, -0.02493205734728906724909781906215927DL},
  {0.794DL, -0.02467181773500132955331021241805677DL},
  {0.795DL, -0.02441316432780515191350065487532151DL},
  {0.796DL, -0.02415609313775403780938882926820228DL},
  {0.797DL, -0.02390060019192201273888056069315405DL},
  {0.798DL, -0.02364668153232828612711683034135708DL},
  {0.799DL, -0.02339433321586238498348907640779238DL},
  {  0.8DL, -0.02314355131420975576629509030983450DL},
  {0.801DL, -0.02289433191377783094566834953819199DL},
  {0.802DL, -0.02264667111562255678606315524556632DL},
  {0.803DL, -0.02240056503537537889992192864942075DL},
  {0.804DL, -0.02215600980317068215419288785049103DL},
  {0.805DL, -0.02191300156357368154110945557352914DL},
  {0.806DL, -0.02167153647550876065409047648724024DL},
  {0.807DL, -0.02143161071218825443877594663532980DL},
  {0.808DL, -0.02119322046104167291807973276557376DL},
  {0.809DL, -0.02095636192364536261872190136650744DL},
  { 0.81DL, -0.02072103131565260245500196167862560DL},
  {0.811DL, -0.02048722486672413085359369032419214DL},
  {0.812DL, -0.02025493882045910093088534533164815DL},
  {0.813DL, -0.02002416943432646056185905392470488DL},
  {0.814DL, -0.01979491297959675420670299359833959DL},
  {0.815DL, -0.01956716574127434338828266470615511DL},
  {0.816DL, -0.01934092401803004274026602342473411DL},
  {0.817DL, -0.01911618412213416857210441881939205DL},
  {0.818DL, -0.01889294237938999692322003346652997DL},
  {0.819DL, -0.01867119512906762810464370519954288DL},
  { 0.82DL, -0.01845093872383825475198741487314426DL},
  {0.821DL, -0.01823216952970883043902613421133133DL},
  {0.822DL, -0.01801488392595713592630687769252496DL},
  {0.823DL, -0.01779907830506724014410139860771448DL},
  {0.824DL, -0.01758474907266535303367568462512210DL},
  {0.825DL, -0.01737189264745606739526688271306234DL},
  {0.826DL, -0.01716050546115898691533912543203870DL},
  {0.827DL, -0.01695058395844573756963651716975218DL},
  {0.828DL, -0.01674212459687735962226681548149196DL},
  {0.829DL, -0.01653512384684207746453562421051064DL},
  { 0.83DL, -0.01632957819149344456051068607735796DL},
  {0.831DL, -0.01612548412668886078933157760595608DL},
  {0.832DL, -0.01592283816092845949709419373871461DL},
  {0.833DL, -0.01572163681529436159373425929360663DL},
  {0.834DL, -0.01552187662339029405271208679684657DL},
  {0.835DL, -0.01532355413128157019346425408212562DL},
  {0.836DL, -0.01512666589743542914853911128375665DL},
  {0.837DL, -0.01493120849266173193907432874315830DL},
  {0.838DL, -0.01473717850005401160380832090942566DL},
  {0.839DL, -0.01454457251493087484814555565346759DL},
  { 0.84DL, -0.01435338714477775270092068608666984DL},
  {0.841DL, -0.01416361900918899768743029932926941DL},
  {0.842DL, -0.01397526473981032504802601419781858DL},
  {0.843DL, -0.01378832098028159555209080243739498DL},
  {0.844DL, -0.01360278438617993747755385568245937DL},
  {0.845DL, -0.01341865162496320534624014769626777DL},
  {0.846DL, -0.01323591937591377302530109897769094DL},
  {0.847DL, -0.01305458433008265882473446467965429DL},
  {0.848DL, -0.01287464319023398024057673919132858DL},
  {0.849DL, -0.01269609267078973601274198033542671DL},
  { 0.85DL, -0.01251892949777491318568895826941424DL},
  {0.851DL, -0.01234315040876291687912586121144934DL},
  {0.852DL, -0.01216875215282132049481035170117969DL},
  {0.853DL, -0.01199573149045793410417445051411850DL},
  {0.854DL, -0.01182408519356718878000039572612158DL},
  {0.855DL, -0.01165381004537683465369712509400004DL},
  {0.856DL, -0.01148490284039495049787918265528592DL},
  {0.857DL, -0.01131736038435726265193245576034404DL},
  {0.858DL, -0.01115117949417477112606598614194245DL},
  {0.859DL, -0.01098635699788168073699792688146305DL},
  { 0.86DL, -0.01082288973458363514590827456470481DL},
  {0.861DL, -0.01066077455440625168661301064997960DL},
  {0.862DL, -0.01050000831844395488907543626986580DL},
  {0.863DL, -0.01034058789870910662037245883951959DL},
  {0.864DL, -0.01018251017808143078207804599463267DL},
  {0.865DL, -0.01002577205025773051971464238591351DL},
  {0.866DL, -0.009870370419701895916457668622372085DL},
  {0.867DL, -0.009716302201595200159659891384313847DL},
  {0.868DL, -0.009563564321786882184993053151202547DL},
  {0.869DL, -0.009412153716745013819085244606552401DL},
  { 0.87DL, -0.009262067333507649457465640084291105DL},
  {0.871DL, -0.009113302129634256330414926124051267DL},
  {0.872DL, -0.008965855073157423424961547469361268DL},
  {0.873DL, -0.008819723142534847146762268504079500DL},
  {0.874DL, -0.008674903326601591820961978896866399DL},
  {0.875DL, -0.008531392624522623146343620931349975DL},
  {0.876DL, -0.008389188045745612732156026775671211DL},
  {0.877DL, -0.008248286609954011861946754447881889DL},
  {0.878DL, -0.008108685347020392643530112852162354DL},
  {0.879DL, -0.007970381296960054718888864318068728DL},
  { 0.88DL, -0.007833371509884895722342967029069411DL},
  {0.881DL, -0.007697653045957543689721533368774191DL},
  {0.882DL, -0.007563222975345749635546281863505186DL},
  {0.883DL, -0.007430078378177038529377483099785068DL},
  {0.884DL, -0.007298216344493616916488061698294346DL},
  {0.885DL, -0.007167633974207535441919420184681655DL},
  {0.886DL, -0.007038328377056104550734984749640352DL},
  {0.887DL, -0.006910296672557561650925711240363866DL},
  {0.888DL, -0.006783535989966988038937091724590050DL},
  {0.889DL, -0.006658043468232473901180812893620498DL},
  { 0.89DL, -0.006533816255951529718167368698879196DL},
  {0.891DL, -0.006410851511327742411049838397860504DL},
  {0.892DL, -0.006289146402127674583404911413599460DL},
  {0.893DL, -0.006168698105638005223996262393065377DL},
  {0.894DL, -0.006049503808622910249068730568269862DL},
  {0.895DL, -0.005931560707281681275410600805502808DL},
  {0.896DL, -0.005814866007206581027996770402676917DL},
  {0.897DL, -0.005699416923340933798488853755052195DL},
  {0.898DL, -0.005585210679937449383220451768806053DL},
  {0.899DL, -0.005472244510516778941538007148823807DL},
  {  0.9DL, -0.005360515657826301227500980839312798DL},
  {0.901DL, -0.005250021373799137659970607150908317DL},
  {0.902DL, -0.005140758919513394708035291592379167DL},
  {0.903DL, -0.005032725565151632080533870341540153DL},
  {0.904DL, -0.004925918589960555220146506062541247DL},
  {0.905DL, -0.004820335282210930614127992193896056DL},
  {0.906DL, -0.004715972939157722445260706187914060DL},
  {0.907DL, -0.004612828867000449118005409417477733DL},
  {0.908DL, -0.004510900380843758206128544303242441DL},
  {0.909DL, -0.004410184804658218379285623295052057DL},
  { 0.91DL, -0.004310679471241326877142724360230081DL},
  {0.911DL, -0.004212381722178731110622977468108821DL},
  {0.912DL, -0.004115288907805662980773209410007109DL},
  {0.913DL, -0.004019398387168584516558562796592870DL},
  {0.914DL, -0.003924707527987043443610861441432520DL},
  {0.915DL, -0.003831213706615737306580690478764532DL},
  {0.916DL, -0.003738914308006784778274517204131169DL},
  {0.917DL, -0.003647806725672202799197609440387000DL},
  {0.918DL, -0.003557888361646588201471913954212405DL},
  {0.919DL, -0.003469156626450002481356329997542269DL},
  { 0.92DL, -0.003381608939051058394765834642179161DL},
  {0.921DL, -0.003295242726830207060266559848074634DL},
  {0.922DL, -0.003210055425543224264017049320389515DL},
  {0.923DL, -0.003126044479284894671032389974739921DL},
  {0.924DL, -0.003043207340452892656968562805904753DL},
  {0.925DL, -0.002961541469711858484360026569270180DL},
  {0.926DL, -0.002881044335957668556895061336206113DL},
  {0.927DL, -0.002801713416281898494881575154600393DL},
  {0.928DL, -0.002723546195936477784541724400298177DL},
  {0.929DL, -0.002646540168298534763177616901192197DL},
  { 0.93DL, -0.002570692834835430711573347903845500DL},
  {0.931DL, -0.002496001705069981834241445278879626DL},
  {0.932DL, -0.002422464296545867917285246467852008DL},
  {0.933DL, -0.002350078134793226462733561697884642DL},
  {0.934DL, -0.002278840753294431107210953860647069DL},
  {0.935DL, -0.002208749693450053141736834988649148DL},
  {0.936DL, -0.002139802504545004958300084268192904DL},
  {0.937DL, -0.002071996743714864257633766887763881DL},
  {0.938DL, -0.002005329975912377861317502788013575DL},
  {0.939DL, -0.001939799773874143979963817873356565DL},
  { 0.94DL, -0.001875403718087471797800118138378138DL},
  {0.941DL, -0.001812139396757417242440462571182331DL},
  {0.942DL, -0.001750004405773993817051769268915101DL},
  {0.943DL, -0.001688996348679557380458159205488916DL},
  {0.944DL, -0.001629112836636363768995504500688726DL},
  {0.945DL, -0.001570351488394298162126576616148140DL},
  {0.946DL, -0.001512709930258775101956151283939719DL},
  {0.947DL, -0.001456185796058808084845680751330618DL},
  {0.948DL, -0.001400776727115247651319342732802860DL},
  {0.949DL, -0.001346480372209186908378065049231447DL},
  { 0.95DL, -0.001293294387550533426196144254687238DL},
  {0.951DL, -0.001241216436746746458966957831955609DL},
  {0.952DL, -0.001190244190771738447390638362256653DL},
  {0.953DL, -0.001140375327934939767958053458723949DL},
  {0.954DL, -0.001091607533850525701782629720806875DL},
  {0.955DL, -0.001043938501406804603265078624537837DL},
  {0.956DL, -0.0009973659307357662563465268748303902DL},
  {0.957DL, -0.0009518875291827894135135168035260128DL},
  {0.958DL, -0.0009075010112765075200644111952994408DL},
  {0.959DL, -0.0008642040986988316334314926300475026DL},
  { 0.96DL, -0.0008219945202551295545770651553198702DL},
  {0.961DL, -0.0007808700118445601956457149683782019DL},
  {0.962DL, -0.0007408283164305622151591299981502860DL},
  {0.963DL, -0.0007018671840114959590850731847642119DL},
  {0.964DL, -0.0006639843715914377530988024259237516DL},
  {0.965DL, -0.0006271776431511255982839774438462191DL},
  {0.966DL, -0.0005914447696190553293914304190145020DL},
  {0.967DL, -0.0005567835288427263015886377435869042DL},
  {0.968DL, -0.0005231917055600356783908437483043189DL},
  {0.969DL, -0.0004906670913708204001670773695868453DL},
  { 0.97DL, -0.0004592074847085459192612876647667014DL},
  {0.971DL, -0.0004288106908121407943610167299151956DL},
  {0.972DL, -0.0003994745216979762432839365241109634DL},
  {0.973DL, -0.0003711967961319897598367017343691107DL},
  {0.974DL, -0.0003439753396019519068314113443705496DL},
  {0.975DL, -0.0003178079842898754037230191128730343DL},
  {0.976DL, -0.0002926925690445656336567747947716042DL},
  {0.977DL, -0.0002686269393543117009886957318015146DL},
  {0.978DL, -0.0002456089473197171765646395516404734DL},
  {0.979DL, -0.0002236364516266696742152454181141036DL},
  { 0.98DL, -0.0002027073175194484080453010241923879DL},
  {0.981DL, -0.0001828194167739688861674379988395624DL},
  {0.982DL, -0.0001639706276711639025519175798314017DL},
  {0.983DL, -0.0001461588349704999946370945973781867DL},
  {0.984DL, -0.0001293819298836285402693897186296256DL},
  {0.985DL, -0.0001136378100481706734177016640740083DL},
  {0.986DL, -0.00009892437950163520393559235987791365DL},
  {0.987DL, -0.00008523954865546873242571391521347962DL},
  {0.988DL, -0.00007258123426923715699524768356734461DL},
  {0.989DL, -0.00006094735942493777437901889704946880DL},
  { 0.99DL, -0.00005033585350144118354885755854770609DL},
  {0.991DL, -0.00004074465214906220552411528238585077DL},
  {0.992DL, -0.00003217169726425903864943221985257198DL},
  {0.993DL, -0.00002461493696445987411228755393011146DL},
  {0.994DL, -0.00001807232556301620193496663870222833DL},
  {0.995DL, -0.00001254182354428204309373895836778139DL},
  {0.996DL, -0.000008021397538818348792660922843328976DL},
  {0.997DL, -0.000004509020298721813250889349620111032DL},
  {0.998DL, -0.000002002670673077351651104610523031719DL},
  {0.999DL, -5.003335835335001429822540683449608E-7DL},
  {  1.0DL,                                  0.0DL},
};
#define LNTVALS_START 100
