#pragma once
/*
 *  $Id: ruler.h 28517 2025-09-05 07:38:23Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_RULER_H__
#define __GWYUI_RULER_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <libgwyddion/unit.h>

G_BEGIN_DECLS

typedef enum {
    GWY_UNITS_PLACEMENT_NONE,
    GWY_UNITS_PLACEMENT_AT_ZERO
} GwyUnitsPlacement;

#define GWY_TYPE_RULER            (gwy_ruler_get_type())
#define GWY_RULER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_RULER, GwyRuler))
#define GWY_RULER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_RULER, GwyRulerClass))
#define GWY_IS_RULER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_RULER))
#define GWY_IS_RULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_RULER))
#define GWY_RULER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_RULER, GwyRulerClass))

typedef struct _GwyRuler             GwyRuler;
typedef struct _GwyRulerClass        GwyRulerClass;
typedef struct _GwyRulerPrivate      GwyRulerPrivate;

struct _GwyRuler {
    GtkWidget widget;
    GwyRulerPrivate *priv;
};

struct _GwyRulerClass {
    GtkWidgetClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};


GType             gwy_ruler_get_type            (void)                         G_GNUC_CONST;
GtkWidget*        gwy_ruler_new                 (GtkOrientation orientation);
void              gwy_ruler_set_orientation     (GwyRuler *ruler,
                                                 GtkOrientation orientation);
GtkOrientation    gwy_ruler_get_orientation     (GwyRuler *ruler);
void              gwy_ruler_set_range           (GwyRuler *ruler,
                                                 gdouble lower,
                                                 gdouble upper,
                                                 gdouble position,
                                                 gdouble max_size);
void              gwy_ruler_get_range           (GwyRuler *ruler,
                                                 gdouble *lower,
                                                 gdouble *upper,
                                                 gdouble *position,
                                                 gdouble *max_size);
GwyUnit*          gwy_ruler_get_unit            (GwyRuler *ruler);
GwyUnitsPlacement gwy_ruler_get_units_placement (GwyRuler *ruler);
void              gwy_ruler_set_units_placement (GwyRuler *ruler,
                                                 GwyUnitsPlacement placement);
void              gwy_ruler_move_marker         (GwyRuler *ruler,
                                                 gdouble value);
gdouble           gwy_ruler_coord_real_to_widget(GwyRuler *ruler,
                                                 gdouble value);
gdouble           gwy_ruler_coord_widget_to_real(GwyRuler *ruler,
                                                 gdouble pos);


G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
