// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package fleetengine

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"regexp"
	"strings"
	"time"

	fleetenginepb "cloud.google.com/go/maps/fleetengine/apiv1/fleetenginepb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newTripClientHook clientHook

// TripCallOptions contains the retry settings for each method of TripClient.
type TripCallOptions struct {
	CreateTrip         []gax.CallOption
	GetTrip            []gax.CallOption
	ReportBillableTrip []gax.CallOption
	SearchTrips        []gax.CallOption
	UpdateTrip         []gax.CallOption
}

func defaultTripGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("fleetengine.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("fleetengine.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("fleetengine.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://fleetengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultTripCallOptions() *TripCallOptions {
	return &TripCallOptions{
		CreateTrip: []gax.CallOption{
			gax.WithTimeout(15000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetTrip: []gax.CallOption{
			gax.WithTimeout(15000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ReportBillableTrip: []gax.CallOption{},
		SearchTrips: []gax.CallOption{
			gax.WithTimeout(15000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateTrip: []gax.CallOption{
			gax.WithTimeout(15000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

// internalTripClient is an interface that defines the methods available from Local Rides and Deliveries API.
type internalTripClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateTrip(context.Context, *fleetenginepb.CreateTripRequest, ...gax.CallOption) (*fleetenginepb.Trip, error)
	GetTrip(context.Context, *fleetenginepb.GetTripRequest, ...gax.CallOption) (*fleetenginepb.Trip, error)
	ReportBillableTrip(context.Context, *fleetenginepb.ReportBillableTripRequest, ...gax.CallOption) error
	SearchTrips(context.Context, *fleetenginepb.SearchTripsRequest, ...gax.CallOption) *TripIterator
	UpdateTrip(context.Context, *fleetenginepb.UpdateTripRequest, ...gax.CallOption) (*fleetenginepb.Trip, error)
}

// TripClient is a client for interacting with Local Rides and Deliveries API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Trip management service.
type TripClient struct {
	// The internal transport-dependent client.
	internalClient internalTripClient

	// The call options for this service.
	CallOptions *TripCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *TripClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *TripClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *TripClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateTrip creates a trip in the Fleet Engine and returns the new trip.
func (c *TripClient) CreateTrip(ctx context.Context, req *fleetenginepb.CreateTripRequest, opts ...gax.CallOption) (*fleetenginepb.Trip, error) {
	return c.internalClient.CreateTrip(ctx, req, opts...)
}

// GetTrip get information about a single trip.
func (c *TripClient) GetTrip(ctx context.Context, req *fleetenginepb.GetTripRequest, opts ...gax.CallOption) (*fleetenginepb.Trip, error) {
	return c.internalClient.GetTrip(ctx, req, opts...)
}

// ReportBillableTrip report billable trip usage.
func (c *TripClient) ReportBillableTrip(ctx context.Context, req *fleetenginepb.ReportBillableTripRequest, opts ...gax.CallOption) error {
	return c.internalClient.ReportBillableTrip(ctx, req, opts...)
}

// SearchTrips get all the trips for a specific vehicle.
func (c *TripClient) SearchTrips(ctx context.Context, req *fleetenginepb.SearchTripsRequest, opts ...gax.CallOption) *TripIterator {
	return c.internalClient.SearchTrips(ctx, req, opts...)
}

// UpdateTrip updates trip data.
func (c *TripClient) UpdateTrip(ctx context.Context, req *fleetenginepb.UpdateTripRequest, opts ...gax.CallOption) (*fleetenginepb.Trip, error) {
	return c.internalClient.UpdateTrip(ctx, req, opts...)
}

// tripGRPCClient is a client for interacting with Local Rides and Deliveries API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type tripGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing TripClient
	CallOptions **TripCallOptions

	// The gRPC API client.
	tripClient fleetenginepb.TripServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewTripClient creates a new trip service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Trip management service.
func NewTripClient(ctx context.Context, opts ...option.ClientOption) (*TripClient, error) {
	clientOpts := defaultTripGRPCClientOptions()
	if newTripClientHook != nil {
		hookOpts, err := newTripClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := TripClient{CallOptions: defaultTripCallOptions()}

	c := &tripGRPCClient{
		connPool:    connPool,
		tripClient:  fleetenginepb.NewTripServiceClient(connPool),
		CallOptions: &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *tripGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *tripGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *tripGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *tripGRPCClient) CreateTrip(ctx context.Context, req *fleetenginepb.CreateTripRequest, opts ...gax.CallOption) (*fleetenginepb.Trip, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateTrip[0:len((*c.CallOptions).CreateTrip):len((*c.CallOptions).CreateTrip)], opts...)
	var resp *fleetenginepb.Trip
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tripClient.CreateTrip(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tripGRPCClient) GetTrip(ctx context.Context, req *fleetenginepb.GetTripRequest, opts ...gax.CallOption) (*fleetenginepb.Trip, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTrip[0:len((*c.CallOptions).GetTrip):len((*c.CallOptions).GetTrip)], opts...)
	var resp *fleetenginepb.Trip
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tripClient.GetTrip(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *tripGRPCClient) ReportBillableTrip(ctx context.Context, req *fleetenginepb.ReportBillableTripRequest, opts ...gax.CallOption) error {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReportBillableTrip[0:len((*c.CallOptions).ReportBillableTrip):len((*c.CallOptions).ReportBillableTrip)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.tripClient.ReportBillableTrip(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *tripGRPCClient) SearchTrips(ctx context.Context, req *fleetenginepb.SearchTripsRequest, opts ...gax.CallOption) *TripIterator {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchTrips[0:len((*c.CallOptions).SearchTrips):len((*c.CallOptions).SearchTrips)], opts...)
	it := &TripIterator{}
	req = proto.Clone(req).(*fleetenginepb.SearchTripsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*fleetenginepb.Trip, string, error) {
		resp := &fleetenginepb.SearchTripsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.tripClient.SearchTrips(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTrips(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *tripGRPCClient) UpdateTrip(ctx context.Context, req *fleetenginepb.UpdateTripRequest, opts ...gax.CallOption) (*fleetenginepb.Trip, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateTrip[0:len((*c.CallOptions).UpdateTrip):len((*c.CallOptions).UpdateTrip)], opts...)
	var resp *fleetenginepb.Trip
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tripClient.UpdateTrip(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
