//go:build linux
// +build linux

package unix

import (
	linux "golang.org/x/sys/unix"
)

const (
	AF_INET                                    = linux.AF_INET
	AF_INET6                                   = linux.AF_INET6
	AF_UNSPEC                                  = linux.AF_UNSPEC
	NETLINK_ROUTE                              = linux.NETLINK_ROUTE
	SizeofIfAddrmsg                            = linux.SizeofIfAddrmsg
	SizeofIfInfomsg                            = linux.SizeofIfInfomsg
	SizeofNdMsg                                = linux.SizeofNdMsg
	SizeofRtMsg                                = linux.SizeofRtMsg
	SizeofRtNexthop                            = linux.SizeofRtNexthop
	RTM_NEWADDR                                = linux.RTM_NEWADDR
	RTM_DELADDR                                = linux.RTM_DELADDR
	RTM_GETADDR                                = linux.RTM_GETADDR
	RTM_NEWLINK                                = linux.RTM_NEWLINK
	RTM_DELLINK                                = linux.RTM_DELLINK
	RTM_GETLINK                                = linux.RTM_GETLINK
	RTM_SETLINK                                = linux.RTM_SETLINK
	RTM_NEWROUTE                               = linux.RTM_NEWROUTE
	RTM_DELROUTE                               = linux.RTM_DELROUTE
	RTM_GETROUTE                               = linux.RTM_GETROUTE
	RTM_NEWNEIGH                               = linux.RTM_NEWNEIGH
	RTM_DELNEIGH                               = linux.RTM_DELNEIGH
	RTM_GETNEIGH                               = linux.RTM_GETNEIGH
	IFA_UNSPEC                                 = linux.IFA_UNSPEC
	IFA_ADDRESS                                = linux.IFA_ADDRESS
	IFA_LOCAL                                  = linux.IFA_LOCAL
	IFA_LABEL                                  = linux.IFA_LABEL
	IFA_BROADCAST                              = linux.IFA_BROADCAST
	IFA_ANYCAST                                = linux.IFA_ANYCAST
	IFA_CACHEINFO                              = linux.IFA_CACHEINFO
	IFA_MULTICAST                              = linux.IFA_MULTICAST
	IFA_FLAGS                                  = linux.IFA_FLAGS
	IFA_RT_PRIORITY                            = linux.IFA_RT_PRIORITY
	IFF_UP                                     = linux.IFF_UP
	IFF_BROADCAST                              = linux.IFF_BROADCAST
	IFF_LOOPBACK                               = linux.IFF_LOOPBACK
	IFF_POINTOPOINT                            = linux.IFF_POINTOPOINT
	IFF_MULTICAST                              = linux.IFF_MULTICAST
	IFLA_UNSPEC                                = linux.IFLA_UNSPEC
	IFLA_ADDRESS                               = linux.IFLA_ADDRESS
	IFLA_BR_UNSPEC                             = linux.IFLA_BR_UNSPEC
	IFLA_BR_FORWARD_DELAY                      = linux.IFLA_BR_FORWARD_DELAY
	IFLA_BR_HELLO_TIME                         = linux.IFLA_BR_HELLO_TIME
	IFLA_BR_MAX_AGE                            = linux.IFLA_BR_MAX_AGE
	IFLA_BR_AGEING_TIME                        = linux.IFLA_BR_AGEING_TIME
	IFLA_BR_STP_STATE                          = linux.IFLA_BR_STP_STATE
	IFLA_BR_PRIORITY                           = linux.IFLA_BR_PRIORITY
	IFLA_BR_VLAN_FILTERING                     = linux.IFLA_BR_VLAN_FILTERING
	IFLA_BR_VLAN_PROTOCOL                      = linux.IFLA_BR_VLAN_PROTOCOL
	IFLA_BR_GROUP_FWD_MASK                     = linux.IFLA_BR_GROUP_FWD_MASK
	IFLA_BR_ROOT_ID                            = linux.IFLA_BR_ROOT_ID
	IFLA_BR_BRIDGE_ID                          = linux.IFLA_BR_BRIDGE_ID
	IFLA_BR_ROOT_PORT                          = linux.IFLA_BR_ROOT_PORT
	IFLA_BR_ROOT_PATH_COST                     = linux.IFLA_BR_ROOT_PATH_COST
	IFLA_BR_TOPOLOGY_CHANGE                    = linux.IFLA_BR_TOPOLOGY_CHANGE
	IFLA_BR_TOPOLOGY_CHANGE_DETECTED           = linux.IFLA_BR_TOPOLOGY_CHANGE_DETECTED
	IFLA_BR_HELLO_TIMER                        = linux.IFLA_BR_HELLO_TIMER
	IFLA_BR_TCN_TIMER                          = linux.IFLA_BR_TCN_TIMER
	IFLA_BR_TOPOLOGY_CHANGE_TIMER              = linux.IFLA_BR_TOPOLOGY_CHANGE_TIMER
	IFLA_BR_GC_TIMER                           = linux.IFLA_BR_GC_TIMER
	IFLA_BR_GROUP_ADDR                         = linux.IFLA_BR_GROUP_ADDR
	IFLA_BR_FDB_FLUSH                          = linux.IFLA_BR_FDB_FLUSH
	IFLA_BR_MCAST_ROUTER                       = linux.IFLA_BR_MCAST_ROUTER
	IFLA_BR_MCAST_SNOOPING                     = linux.IFLA_BR_MCAST_SNOOPING
	IFLA_BR_MCAST_QUERY_USE_IFADDR             = linux.IFLA_BR_MCAST_QUERY_USE_IFADDR
	IFLA_BR_MCAST_QUERIER                      = linux.IFLA_BR_MCAST_QUERIER
	IFLA_BR_MCAST_HASH_ELASTICITY              = linux.IFLA_BR_MCAST_HASH_ELASTICITY
	IFLA_BR_MCAST_HASH_MAX                     = linux.IFLA_BR_MCAST_HASH_MAX
	IFLA_BR_MCAST_LAST_MEMBER_CNT              = linux.IFLA_BR_MCAST_LAST_MEMBER_CNT
	IFLA_BR_MCAST_STARTUP_QUERY_CNT            = linux.IFLA_BR_MCAST_STARTUP_QUERY_CNT
	IFLA_BR_MCAST_LAST_MEMBER_INTVL            = linux.IFLA_BR_MCAST_LAST_MEMBER_INTVL
	IFLA_BR_MCAST_MEMBERSHIP_INTVL             = linux.IFLA_BR_MCAST_MEMBERSHIP_INTVL
	IFLA_BR_MCAST_QUERIER_INTVL                = linux.IFLA_BR_MCAST_QUERIER_INTVL
	IFLA_BR_MCAST_QUERY_INTVL                  = linux.IFLA_BR_MCAST_QUERY_INTVL
	IFLA_BR_MCAST_QUERY_RESPONSE_INTVL         = linux.IFLA_BR_MCAST_QUERY_RESPONSE_INTVL
	IFLA_BR_MCAST_STARTUP_QUERY_INTVL          = linux.IFLA_BR_MCAST_STARTUP_QUERY_INTVL
	IFLA_BR_NF_CALL_IPTABLES                   = linux.IFLA_BR_NF_CALL_IPTABLES
	IFLA_BR_NF_CALL_IP6TABLES                  = linux.IFLA_BR_NF_CALL_IP6TABLES
	IFLA_BR_NF_CALL_ARPTABLES                  = linux.IFLA_BR_NF_CALL_ARPTABLES
	IFLA_BR_VLAN_DEFAULT_PVID                  = linux.IFLA_BR_VLAN_DEFAULT_PVID
	IFLA_BR_PAD                                = linux.IFLA_BR_PAD
	IFLA_BR_VLAN_STATS_ENABLED                 = linux.IFLA_BR_VLAN_STATS_ENABLED
	IFLA_BR_MCAST_STATS_ENABLED                = linux.IFLA_BR_MCAST_STATS_ENABLED
	IFLA_BR_MCAST_IGMP_VERSION                 = linux.IFLA_BR_MCAST_IGMP_VERSION
	IFLA_BR_MCAST_MLD_VERSION                  = linux.IFLA_BR_MCAST_MLD_VERSION
	IFLA_BR_VLAN_STATS_PER_PORT                = linux.IFLA_BR_VLAN_STATS_PER_PORT
	IFLA_BR_MULTI_BOOLOPT                      = linux.IFLA_BR_MULTI_BOOLOPT
	IFLA_BR_MCAST_QUERIER_STATE                = linux.IFLA_BR_MCAST_QUERIER_STATE
	IFLA_BR_FDB_N_LEARNED                      = linux.IFLA_BR_FDB_N_LEARNED
	IFLA_BR_FDB_MAX_LEARNED                    = linux.IFLA_BR_FDB_MAX_LEARNED
	IFLA_BRPORT_UNSPEC                         = linux.IFLA_BRPORT_UNSPEC
	IFLA_BRPORT_STATE                          = linux.IFLA_BRPORT_STATE
	IFLA_BRPORT_PRIORITY                       = linux.IFLA_BRPORT_PRIORITY
	IFLA_BRPORT_COST                           = linux.IFLA_BRPORT_COST
	IFLA_BRPORT_MODE                           = linux.IFLA_BRPORT_MODE
	IFLA_BRPORT_GUARD                          = linux.IFLA_BRPORT_GUARD
	IFLA_BRPORT_PROTECT                        = linux.IFLA_BRPORT_PROTECT
	IFLA_BRPORT_FAST_LEAVE                     = linux.IFLA_BRPORT_FAST_LEAVE
	IFLA_BRPORT_LEARNING                       = linux.IFLA_BRPORT_LEARNING
	IFLA_BRPORT_UNICAST_FLOOD                  = linux.IFLA_BRPORT_UNICAST_FLOOD
	IFLA_BRPORT_PROXYARP                       = linux.IFLA_BRPORT_PROXYARP
	IFLA_BRPORT_LEARNING_SYNC                  = linux.IFLA_BRPORT_LEARNING_SYNC
	IFLA_BRPORT_PROXYARP_WIFI                  = linux.IFLA_BRPORT_PROXYARP_WIFI
	IFLA_BRPORT_ROOT_ID                        = linux.IFLA_BRPORT_ROOT_ID
	IFLA_BRPORT_BRIDGE_ID                      = linux.IFLA_BRPORT_BRIDGE_ID
	IFLA_BRPORT_DESIGNATED_PORT                = linux.IFLA_BRPORT_DESIGNATED_PORT
	IFLA_BRPORT_DESIGNATED_COST                = linux.IFLA_BRPORT_DESIGNATED_COST
	IFLA_BRPORT_ID                             = linux.IFLA_BRPORT_ID
	IFLA_BRPORT_NO                             = linux.IFLA_BRPORT_NO
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK            = linux.IFLA_BRPORT_TOPOLOGY_CHANGE_ACK
	IFLA_BRPORT_CONFIG_PENDING                 = linux.IFLA_BRPORT_CONFIG_PENDING
	IFLA_BRPORT_MESSAGE_AGE_TIMER              = linux.IFLA_BRPORT_MESSAGE_AGE_TIMER
	IFLA_BRPORT_FORWARD_DELAY_TIMER            = linux.IFLA_BRPORT_FORWARD_DELAY_TIMER
	IFLA_BRPORT_HOLD_TIMER                     = linux.IFLA_BRPORT_HOLD_TIMER
	IFLA_BRPORT_FLUSH                          = linux.IFLA_BRPORT_FLUSH
	IFLA_BRPORT_MULTICAST_ROUTER               = linux.IFLA_BRPORT_MULTICAST_ROUTER
	IFLA_BRPORT_PAD                            = linux.IFLA_BRPORT_PAD
	IFLA_BRPORT_MCAST_FLOOD                    = linux.IFLA_BRPORT_MCAST_FLOOD
	IFLA_BRPORT_MCAST_TO_UCAST                 = linux.IFLA_BRPORT_MCAST_TO_UCAST
	IFLA_BRPORT_VLAN_TUNNEL                    = linux.IFLA_BRPORT_VLAN_TUNNEL
	IFLA_BRPORT_BCAST_FLOOD                    = linux.IFLA_BRPORT_BCAST_FLOOD
	IFLA_BRPORT_GROUP_FWD_MASK                 = linux.IFLA_BRPORT_GROUP_FWD_MASK
	IFLA_BRPORT_NEIGH_SUPPRESS                 = linux.IFLA_BRPORT_NEIGH_SUPPRESS
	IFLA_BRPORT_ISOLATED                       = linux.IFLA_BRPORT_ISOLATED
	IFLA_BRPORT_BACKUP_PORT                    = linux.IFLA_BRPORT_BACKUP_PORT
	IFLA_BRPORT_MRP_RING_OPEN                  = linux.IFLA_BRPORT_MRP_RING_OPEN
	IFLA_BRPORT_MRP_IN_OPEN                    = linux.IFLA_BRPORT_MRP_IN_OPEN
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT          = linux.IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT            = linux.IFLA_BRPORT_MCAST_EHT_HOSTS_CNT
	IFLA_BRPORT_LOCKED                         = linux.IFLA_BRPORT_LOCKED
	IFLA_BRPORT_MAB                            = linux.IFLA_BRPORT_MAB
	IFLA_BRPORT_MCAST_N_GROUPS                 = linux.IFLA_BRPORT_MCAST_N_GROUPS
	IFLA_BRPORT_MCAST_MAX_GROUPS               = linux.IFLA_BRPORT_MCAST_MAX_GROUPS
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS            = linux.IFLA_BRPORT_NEIGH_VLAN_SUPPRESS
	IFLA_BRPORT_BACKUP_NHID                    = linux.IFLA_BRPORT_BACKUP_NHID
	IFLA_BOND_UNSPEC                           = linux.IFLA_BOND_UNSPEC
	IFLA_BOND_MODE                             = linux.IFLA_BOND_MODE
	IFLA_BOND_ACTIVE_SLAVE                     = linux.IFLA_BOND_ACTIVE_SLAVE
	IFLA_BOND_MIIMON                           = linux.IFLA_BOND_MIIMON
	IFLA_BOND_UPDELAY                          = linux.IFLA_BOND_UPDELAY
	IFLA_BOND_DOWNDELAY                        = linux.IFLA_BOND_DOWNDELAY
	IFLA_BOND_USE_CARRIER                      = linux.IFLA_BOND_USE_CARRIER
	IFLA_BOND_ARP_INTERVAL                     = linux.IFLA_BOND_ARP_INTERVAL
	IFLA_BOND_ARP_IP_TARGET                    = linux.IFLA_BOND_ARP_IP_TARGET
	IFLA_BOND_ARP_VALIDATE                     = linux.IFLA_BOND_ARP_VALIDATE
	IFLA_BOND_ARP_ALL_TARGETS                  = linux.IFLA_BOND_ARP_ALL_TARGETS
	IFLA_BOND_PRIMARY                          = linux.IFLA_BOND_PRIMARY
	IFLA_BOND_PRIMARY_RESELECT                 = linux.IFLA_BOND_PRIMARY_RESELECT
	IFLA_BOND_FAIL_OVER_MAC                    = linux.IFLA_BOND_FAIL_OVER_MAC
	IFLA_BOND_XMIT_HASH_POLICY                 = linux.IFLA_BOND_XMIT_HASH_POLICY
	IFLA_BOND_RESEND_IGMP                      = linux.IFLA_BOND_RESEND_IGMP
	IFLA_BOND_NUM_PEER_NOTIF                   = linux.IFLA_BOND_NUM_PEER_NOTIF
	IFLA_BOND_ALL_SLAVES_ACTIVE                = linux.IFLA_BOND_ALL_SLAVES_ACTIVE
	IFLA_BOND_MIN_LINKS                        = linux.IFLA_BOND_MIN_LINKS
	IFLA_BOND_LP_INTERVAL                      = linux.IFLA_BOND_LP_INTERVAL
	IFLA_BOND_PACKETS_PER_SLAVE                = linux.IFLA_BOND_PACKETS_PER_SLAVE
	IFLA_BOND_AD_LACP_RATE                     = linux.IFLA_BOND_AD_LACP_RATE
	IFLA_BOND_AD_SELECT                        = linux.IFLA_BOND_AD_SELECT
	IFLA_BOND_AD_INFO                          = linux.IFLA_BOND_AD_INFO
	IFLA_BOND_AD_ACTOR_SYS_PRIO                = linux.IFLA_BOND_AD_ACTOR_SYS_PRIO
	IFLA_BOND_AD_USER_PORT_KEY                 = linux.IFLA_BOND_AD_USER_PORT_KEY
	IFLA_BOND_AD_ACTOR_SYSTEM                  = linux.IFLA_BOND_AD_ACTOR_SYSTEM
	IFLA_BOND_TLB_DYNAMIC_LB                   = linux.IFLA_BOND_TLB_DYNAMIC_LB
	IFLA_BOND_PEER_NOTIF_DELAY                 = linux.IFLA_BOND_PEER_NOTIF_DELAY
	IFLA_BOND_AD_LACP_ACTIVE                   = linux.IFLA_BOND_AD_LACP_ACTIVE
	IFLA_BOND_MISSED_MAX                       = linux.IFLA_BOND_MISSED_MAX
	IFLA_BOND_NS_IP6_TARGET                    = linux.IFLA_BOND_NS_IP6_TARGET
	IFLA_BOND_AD_INFO_UNSPEC                   = linux.IFLA_BOND_AD_INFO_UNSPEC
	IFLA_BOND_AD_INFO_AGGREGATOR               = linux.IFLA_BOND_AD_INFO_AGGREGATOR
	IFLA_BOND_AD_INFO_NUM_PORTS                = linux.IFLA_BOND_AD_INFO_NUM_PORTS
	IFLA_BOND_AD_INFO_ACTOR_KEY                = linux.IFLA_BOND_AD_INFO_ACTOR_KEY
	IFLA_BOND_AD_INFO_PARTNER_KEY              = linux.IFLA_BOND_AD_INFO_PARTNER_KEY
	IFLA_BOND_AD_INFO_PARTNER_MAC              = linux.IFLA_BOND_AD_INFO_PARTNER_MAC
	IFLA_BOND_SLAVE_UNSPEC                     = linux.IFLA_BOND_SLAVE_UNSPEC
	IFLA_BOND_SLAVE_STATE                      = linux.IFLA_BOND_SLAVE_STATE
	IFLA_BOND_SLAVE_MII_STATUS                 = linux.IFLA_BOND_SLAVE_MII_STATUS
	IFLA_BOND_SLAVE_LINK_FAILURE_COUNT         = linux.IFLA_BOND_SLAVE_LINK_FAILURE_COUNT
	IFLA_BOND_SLAVE_PERM_HWADDR                = linux.IFLA_BOND_SLAVE_PERM_HWADDR
	IFLA_BOND_SLAVE_QUEUE_ID                   = linux.IFLA_BOND_SLAVE_QUEUE_ID
	IFLA_BOND_SLAVE_AD_AGGREGATOR_ID           = linux.IFLA_BOND_SLAVE_AD_AGGREGATOR_ID
	IFLA_BOND_SLAVE_AD_ACTOR_OPER_PORT_STATE   = linux.IFLA_BOND_SLAVE_AD_ACTOR_OPER_PORT_STATE
	IFLA_BOND_SLAVE_AD_PARTNER_OPER_PORT_STATE = linux.IFLA_BOND_SLAVE_AD_PARTNER_OPER_PORT_STATE
	IFLA_BOND_SLAVE_PRIO                       = linux.IFLA_BOND_SLAVE_PRIO
	IFLA_BROADCAST                             = linux.IFLA_BROADCAST
	IFLA_IFNAME                                = linux.IFLA_IFNAME
	IFLA_MTU                                   = linux.IFLA_MTU
	IFLA_LINK                                  = linux.IFLA_LINK
	IFLA_QDISC                                 = linux.IFLA_QDISC
	IFLA_OPERSTATE                             = linux.IFLA_OPERSTATE
	IFLA_STATS                                 = linux.IFLA_STATS
	IFLA_STATS64                               = linux.IFLA_STATS64
	IFLA_TXQLEN                                = linux.IFLA_TXQLEN
	IFLA_GROUP                                 = linux.IFLA_GROUP
	IFLA_LINKINFO                              = linux.IFLA_LINKINFO
	IFLA_LINKMODE                              = linux.IFLA_LINKMODE
	IFLA_IFALIAS                               = linux.IFLA_IFALIAS
	IFLA_PROP_LIST                             = linux.IFLA_PROP_LIST
	IFLA_ALT_IFNAME                            = linux.IFLA_ALT_IFNAME
	IFLA_MASTER                                = linux.IFLA_MASTER
	IFLA_CARRIER                               = linux.IFLA_CARRIER
	IFLA_CARRIER_CHANGES                       = linux.IFLA_CARRIER_CHANGES
	IFLA_CARRIER_UP_COUNT                      = linux.IFLA_CARRIER_UP_COUNT
	IFLA_CARRIER_DOWN_COUNT                    = linux.IFLA_CARRIER_DOWN_COUNT
	IFLA_PHYS_PORT_ID                          = linux.IFLA_PHYS_PORT_ID
	IFLA_PHYS_SWITCH_ID                        = linux.IFLA_PHYS_SWITCH_ID
	IFLA_PHYS_PORT_NAME                        = linux.IFLA_PHYS_PORT_NAME
	IFLA_INFO_KIND                             = linux.IFLA_INFO_KIND
	IFLA_INFO_SLAVE_KIND                       = linux.IFLA_INFO_SLAVE_KIND
	IFLA_INFO_DATA                             = linux.IFLA_INFO_DATA
	IFLA_INFO_SLAVE_DATA                       = linux.IFLA_INFO_SLAVE_DATA
	IFLA_NET_NS_PID                            = linux.IFLA_NET_NS_PID
	IFLA_NET_NS_FD                             = linux.IFLA_NET_NS_FD
	IFLA_VLAN_UNSPEC                           = linux.IFLA_VLAN_UNSPEC
	IFLA_VLAN_ID                               = linux.IFLA_VLAN_ID
	IFLA_VLAN_FLAGS                            = linux.IFLA_VLAN_FLAGS
	IFLA_VLAN_EGRESS_QOS                       = linux.IFLA_VLAN_EGRESS_QOS
	IFLA_VLAN_INGRESS_QOS                      = linux.IFLA_VLAN_INGRESS_QOS
	IFLA_VLAN_PROTOCOL                         = linux.IFLA_VLAN_PROTOCOL
	IFLA_VLAN_QOS_UNSPEC                       = linux.IFLA_VLAN_QOS_UNSPEC
	IFLA_VLAN_QOS_MAPPING                      = linux.IFLA_VLAN_QOS_MAPPING
	IFLA_MACVLAN_UNSPEC                        = linux.IFLA_MACVLAN_UNSPEC
	IFLA_MACVLAN_MODE                          = linux.IFLA_MACVLAN_MODE
	IFLA_MACVLAN_FLAGS                         = linux.IFLA_MACVLAN_FLAGS
	IFLA_MACVLAN_MACADDR_MODE                  = linux.IFLA_MACVLAN_MACADDR_MODE
	IFLA_MACVLAN_MACADDR                       = linux.IFLA_MACVLAN_MACADDR
	IFLA_MACVLAN_MACADDR_DATA                  = linux.IFLA_MACVLAN_MACADDR_DATA
	IFLA_MACVLAN_MACADDR_COUNT                 = linux.IFLA_MACVLAN_MACADDR_COUNT
	IFLA_MACVLAN_BC_QUEUE_LEN                  = linux.IFLA_MACVLAN_BC_QUEUE_LEN
	IFLA_MACVLAN_BC_QUEUE_LEN_USED             = linux.IFLA_MACVLAN_BC_QUEUE_LEN_USED
	IFLA_MACVLAN_BC_CUTOFF                     = linux.IFLA_MACVLAN_BC_CUTOFF
	IFLA_NETKIT_UNSPEC                         = linux.IFLA_NETKIT_UNSPEC
	IFLA_NETKIT_PEER_INFO                      = linux.IFLA_NETKIT_PEER_INFO
	IFLA_NETKIT_PRIMARY                        = linux.IFLA_NETKIT_PRIMARY
	IFLA_NETKIT_POLICY                         = linux.IFLA_NETKIT_POLICY
	IFLA_NETKIT_PEER_POLICY                    = linux.IFLA_NETKIT_PEER_POLICY
	IFLA_NETKIT_MODE                           = linux.IFLA_NETKIT_MODE
	IFLA_VXLAN_UNSPEC                          = linux.IFLA_VXLAN_UNSPEC
	IFLA_VXLAN_ID                              = linux.IFLA_VXLAN_ID
	IFLA_VXLAN_GROUP                           = linux.IFLA_VXLAN_GROUP
	IFLA_VXLAN_LINK                            = linux.IFLA_VXLAN_LINK
	IFLA_VXLAN_LOCAL                           = linux.IFLA_VXLAN_LOCAL
	IFLA_VXLAN_TTL                             = linux.IFLA_VXLAN_TTL
	IFLA_VXLAN_TOS                             = linux.IFLA_VXLAN_TOS
	IFLA_VXLAN_LEARNING                        = linux.IFLA_VXLAN_LEARNING
	IFLA_VXLAN_AGEING                          = linux.IFLA_VXLAN_AGEING
	IFLA_VXLAN_LIMIT                           = linux.IFLA_VXLAN_LIMIT
	IFLA_VXLAN_PORT_RANGE                      = linux.IFLA_VXLAN_PORT_RANGE
	IFLA_VXLAN_PROXY                           = linux.IFLA_VXLAN_PROXY
	IFLA_VXLAN_RSC                             = linux.IFLA_VXLAN_RSC
	IFLA_VXLAN_L2MISS                          = linux.IFLA_VXLAN_L2MISS
	IFLA_VXLAN_L3MISS                          = linux.IFLA_VXLAN_L3MISS
	IFLA_VXLAN_PORT                            = linux.IFLA_VXLAN_PORT
	IFLA_VXLAN_GROUP6                          = linux.IFLA_VXLAN_GROUP6
	IFLA_VXLAN_LOCAL6                          = linux.IFLA_VXLAN_LOCAL6
	IFLA_VXLAN_UDP_CSUM                        = linux.IFLA_VXLAN_UDP_CSUM
	IFLA_VXLAN_UDP_ZERO_CSUM6_TX               = linux.IFLA_VXLAN_UDP_ZERO_CSUM6_TX
	IFLA_VXLAN_UDP_ZERO_CSUM6_RX               = linux.IFLA_VXLAN_UDP_ZERO_CSUM6_RX
	IFLA_VXLAN_REMCSUM_TX                      = linux.IFLA_VXLAN_REMCSUM_TX
	IFLA_VXLAN_REMCSUM_RX                      = linux.IFLA_VXLAN_REMCSUM_RX
	IFLA_VXLAN_GBP                             = linux.IFLA_VXLAN_GBP
	IFLA_VXLAN_REMCSUM_NOPARTIAL               = linux.IFLA_VXLAN_REMCSUM_NOPARTIAL
	IFLA_VXLAN_COLLECT_METADATA                = linux.IFLA_VXLAN_COLLECT_METADATA
	IFLA_VXLAN_LABEL                           = linux.IFLA_VXLAN_LABEL
	IFLA_VXLAN_GPE                             = linux.IFLA_VXLAN_GPE
	IFLA_VXLAN_TTL_INHERIT                     = linux.IFLA_VXLAN_TTL_INHERIT
	IFLA_VXLAN_DF                              = linux.IFLA_VXLAN_DF
	IFLA_VXLAN_VNIFILTER                       = linux.IFLA_VXLAN_VNIFILTER
	IFLA_VXLAN_LOCALBYPASS                     = linux.IFLA_VXLAN_LOCALBYPASS
	IFLA_VXLAN_LABEL_POLICY                    = linux.IFLA_VXLAN_LABEL_POLICY
	IFLA_XDP                                   = linux.IFLA_XDP
	IFLA_XDP_FD                                = linux.IFLA_XDP_FD
	IFLA_XDP_ATTACHED                          = linux.IFLA_XDP_ATTACHED
	IFLA_XDP_FLAGS                             = linux.IFLA_XDP_FLAGS
	IFLA_XDP_PROG_ID                           = linux.IFLA_XDP_PROG_ID
	IFLA_XDP_EXPECTED_FD                       = linux.IFLA_XDP_EXPECTED_FD
	XDP_FLAGS_DRV_MODE                         = linux.XDP_FLAGS_DRV_MODE
	XDP_FLAGS_SKB_MODE                         = linux.XDP_FLAGS_SKB_MODE
	XDP_FLAGS_HW_MODE                          = linux.XDP_FLAGS_HW_MODE
	XDP_FLAGS_MODES                            = linux.XDP_FLAGS_MODES
	XDP_FLAGS_MASK                             = linux.XDP_FLAGS_MASK
	XDP_FLAGS_REPLACE                          = linux.XDP_FLAGS_REPLACE
	XDP_FLAGS_UPDATE_IF_NOEXIST                = linux.XDP_FLAGS_UPDATE_IF_NOEXIST
	LWTUNNEL_ENCAP_MPLS                        = linux.LWTUNNEL_ENCAP_MPLS
	MPLS_IPTUNNEL_DST                          = linux.MPLS_IPTUNNEL_DST
	MPLS_IPTUNNEL_TTL                          = linux.MPLS_IPTUNNEL_TTL
	NDA_UNSPEC                                 = linux.NDA_UNSPEC
	NDA_DST                                    = linux.NDA_DST
	NDA_LLADDR                                 = linux.NDA_LLADDR
	NDA_CACHEINFO                              = linux.NDA_CACHEINFO
	NDA_IFINDEX                                = linux.NDA_IFINDEX
	RTA_UNSPEC                                 = linux.RTA_UNSPEC
	RTA_DST                                    = linux.RTA_DST
	RTA_ENCAP                                  = linux.RTA_ENCAP
	RTA_ENCAP_TYPE                             = linux.RTA_ENCAP_TYPE
	RTA_PREFSRC                                = linux.RTA_PREFSRC
	RTA_GATEWAY                                = linux.RTA_GATEWAY
	RTA_OIF                                    = linux.RTA_OIF
	RTA_PRIORITY                               = linux.RTA_PRIORITY
	RTA_TABLE                                  = linux.RTA_TABLE
	RTA_MARK                                   = linux.RTA_MARK
	RTA_EXPIRES                                = linux.RTA_EXPIRES
	RTA_METRICS                                = linux.RTA_METRICS
	RTA_MULTIPATH                              = linux.RTA_MULTIPATH
	RTA_PREF                                   = linux.RTA_PREF
	RTAX_ADVMSS                                = linux.RTAX_ADVMSS
	RTAX_FEATURES                              = linux.RTAX_FEATURES
	RTAX_INITCWND                              = linux.RTAX_INITCWND
	RTAX_INITRWND                              = linux.RTAX_INITRWND
	RTAX_MTU                                   = linux.RTAX_MTU
	NTF_PROXY                                  = linux.NTF_PROXY
	RTN_UNICAST                                = linux.RTN_UNICAST
	RT_TABLE_MAIN                              = linux.RT_TABLE_MAIN
	RTPROT_BOOT                                = linux.RTPROT_BOOT
	RTPROT_STATIC                              = linux.RTPROT_STATIC
	RT_SCOPE_UNIVERSE                          = linux.RT_SCOPE_UNIVERSE
	RT_SCOPE_HOST                              = linux.RT_SCOPE_HOST
	RT_SCOPE_LINK                              = linux.RT_SCOPE_LINK
	RTM_NEWRULE                                = linux.RTM_NEWRULE
	RTM_GETRULE                                = linux.RTM_GETRULE
	RTM_DELRULE                                = linux.RTM_DELRULE
	FRA_UNSPEC                                 = linux.FRA_UNSPEC
	FRA_DST                                    = linux.FRA_DST
	FRA_SRC                                    = linux.FRA_SRC
	FRA_IIFNAME                                = linux.FRA_IIFNAME
	FRA_GOTO                                   = linux.FRA_GOTO
	FRA_UNUSED2                                = linux.FRA_UNUSED2
	FRA_PRIORITY                               = linux.FRA_PRIORITY
	FRA_UNUSED3                                = linux.FRA_UNUSED3
	FRA_UNUSED4                                = linux.FRA_UNUSED4
	FRA_UNUSED5                                = linux.FRA_UNUSED5
	FRA_FWMARK                                 = linux.FRA_FWMARK
	FRA_FLOW                                   = linux.FRA_FLOW
	FRA_TUN_ID                                 = linux.FRA_TUN_ID
	FRA_SUPPRESS_IFGROUP                       = linux.FRA_SUPPRESS_IFGROUP
	FRA_SUPPRESS_PREFIXLEN                     = linux.FRA_SUPPRESS_PREFIXLEN
	FRA_TABLE                                  = linux.FRA_TABLE
	FRA_FWMASK                                 = linux.FRA_FWMASK
	FRA_OIFNAME                                = linux.FRA_OIFNAME
	FRA_PAD                                    = linux.FRA_PAD
	FRA_L3MDEV                                 = linux.FRA_L3MDEV
	FRA_UID_RANGE                              = linux.FRA_UID_RANGE
	FRA_PROTOCOL                               = linux.FRA_PROTOCOL
	FRA_IP_PROTO                               = linux.FRA_IP_PROTO
	FRA_SPORT_RANGE                            = linux.FRA_SPORT_RANGE
	FRA_DPORT_RANGE                            = linux.FRA_DPORT_RANGE
	NETKIT_NEXT                                = linux.NETKIT_NEXT
	NETKIT_PASS                                = linux.NETKIT_PASS
	NETKIT_DROP                                = linux.NETKIT_DROP
	NETKIT_REDIRECT                            = linux.NETKIT_REDIRECT
	NETKIT_L2                                  = linux.NETKIT_L2
	NETKIT_L3                                  = linux.NETKIT_L3
	CLONE_NEWNET                               = linux.CLONE_NEWNET
	O_RDONLY                                   = linux.O_RDONLY
	O_CLOEXEC                                  = linux.O_CLOEXEC
	NUD_NONE                                   = linux.NUD_NONE
	NUD_NOARP                                  = linux.NUD_NOARP
)

var Gettid = linux.Gettid
var Unshare = linux.Unshare
