//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevtestlabs_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devtestlabs/armdevtestlabs"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_ListBySubscription.json
func ExampleLabsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLabsClient().NewListBySubscriptionPager(&armdevtestlabs.LabsClientListBySubscriptionOptions{Expand: nil,
		Filter:  nil,
		Top:     nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LabList = armdevtestlabs.LabList{
		// 	Value: []*armdevtestlabs.Lab{
		// 		{
		// 			Name: to.Ptr("{labName1}"),
		// 			Type: to.Ptr("Microsoft.DevTestLab/labs"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName1}"),
		// 			Location: to.Ptr("westcentralus"),
		// 			Tags: map[string]*string{
		// 				"tagName1": to.Ptr("tagValue1"),
		// 			},
		// 			Properties: &armdevtestlabs.LabProperties{
		// 				Announcement: &armdevtestlabs.LabAnnouncementProperties{
		// 					Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
		// 					Expired: to.Ptr(false),
		// 					Markdown: to.Ptr(""),
		// 					Title: to.Ptr(""),
		// 				},
		// 				ArtifactsStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-30T15:38:13.197Z"); return t}()),
		// 				DefaultPremiumStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
		// 				DefaultStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
		// 				EnvironmentPermission: to.Ptr(armdevtestlabs.EnvironmentPermissionReader),
		// 				LabStorageType: to.Ptr(armdevtestlabs.StorageTypePremium),
		// 				MandatoryArtifactsResourceIDsLinux: []*string{
		// 				},
		// 				MandatoryArtifactsResourceIDsWindows: []*string{
		// 				},
		// 				PremiumDataDiskStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
		// 				PremiumDataDisks: to.Ptr(armdevtestlabs.PremiumDataDiskDisabled),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				Support: &armdevtestlabs.LabSupportProperties{
		// 					Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
		// 					Markdown: to.Ptr(""),
		// 				},
		// 				UniqueIdentifier: to.Ptr("{uniqueIdentifier}"),
		// 				VaultName: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.KeyVault/vaults/{keyVaultName}"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("{labName2}"),
		// 			Type: to.Ptr("Microsoft.DevTestLab/labs"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName2}/providers/microsoft.devtestlab/labs/{labName2}"),
		// 			Location: to.Ptr("japaneast"),
		// 			Tags: map[string]*string{
		// 				"tagName1": to.Ptr("tagValue1"),
		// 			},
		// 			Properties: &armdevtestlabs.LabProperties{
		// 				Announcement: &armdevtestlabs.LabAnnouncementProperties{
		// 					Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
		// 					Expired: to.Ptr(false),
		// 					Markdown: to.Ptr(""),
		// 					Title: to.Ptr(""),
		// 				},
		// 				ArtifactsStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName2}/providers/Microsoft.Storage/storageAccounts/{storageAccountName2}"),
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-30T16:37:52.967Z"); return t}()),
		// 				DefaultPremiumStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName2}/providers/Microsoft.Storage/storageAccounts/{storageAccountName2}"),
		// 				DefaultStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName2}/providers/Microsoft.Storage/storageAccounts/{storageAccountName2}"),
		// 				EnvironmentPermission: to.Ptr(armdevtestlabs.EnvironmentPermissionReader),
		// 				LabStorageType: to.Ptr(armdevtestlabs.StorageTypePremium),
		// 				MandatoryArtifactsResourceIDsLinux: []*string{
		// 				},
		// 				MandatoryArtifactsResourceIDsWindows: []*string{
		// 				},
		// 				PremiumDataDiskStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName2}/providers/Microsoft.Storage/storageAccounts/{storageAccountName2}"),
		// 				PremiumDataDisks: to.Ptr(armdevtestlabs.PremiumDataDiskDisabled),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				Support: &armdevtestlabs.LabSupportProperties{
		// 					Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
		// 					Markdown: to.Ptr(""),
		// 				},
		// 				UniqueIdentifier: to.Ptr("{uniqueIdentifier}"),
		// 				VaultName: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName2}/providers/Microsoft.KeyVault/vaults/{keyVaultName2}"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_ListByResourceGroup.json
func ExampleLabsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLabsClient().NewListByResourceGroupPager("resourceGroupName", &armdevtestlabs.LabsClientListByResourceGroupOptions{Expand: nil,
		Filter:  nil,
		Top:     nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LabList = armdevtestlabs.LabList{
		// 	Value: []*armdevtestlabs.Lab{
		// 		{
		// 			Name: to.Ptr("{labName}"),
		// 			Type: to.Ptr("Microsoft.DevTestLab/labs"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}"),
		// 			Location: to.Ptr("{location}"),
		// 			Tags: map[string]*string{
		// 				"tagName1": to.Ptr("tagValue1"),
		// 			},
		// 			Properties: &armdevtestlabs.LabProperties{
		// 				Announcement: &armdevtestlabs.LabAnnouncementProperties{
		// 					Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
		// 					Expired: to.Ptr(false),
		// 					Markdown: to.Ptr(""),
		// 					Title: to.Ptr(""),
		// 				},
		// 				CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-02T17:23:20.957Z"); return t}()),
		// 				EnvironmentPermission: to.Ptr(armdevtestlabs.EnvironmentPermissionReader),
		// 				LabStorageType: to.Ptr(armdevtestlabs.StorageTypeStandard),
		// 				MandatoryArtifactsResourceIDsLinux: []*string{
		// 				},
		// 				MandatoryArtifactsResourceIDsWindows: []*string{
		// 				},
		// 				PremiumDataDisks: to.Ptr(armdevtestlabs.PremiumDataDiskDisabled),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				Support: &armdevtestlabs.LabSupportProperties{
		// 					Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
		// 					Markdown: to.Ptr(""),
		// 				},
		// 				UniqueIdentifier: to.Ptr("{uniqueIdentifier}"),
		// 				VaultName: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.KeyVault/vaults/{keyVaultName}"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_Get.json
func ExampleLabsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLabsClient().Get(ctx, "resourceGroupName", "{labName}", &armdevtestlabs.LabsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Lab = armdevtestlabs.Lab{
	// 	Name: to.Ptr("{labName}"),
	// 	Type: to.Ptr("Microsoft.DevTestLab/labs"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}"),
	// 	Location: to.Ptr("{location}"),
	// 	Tags: map[string]*string{
	// 		"tagName1": to.Ptr("tagValue1"),
	// 	},
	// 	Properties: &armdevtestlabs.LabProperties{
	// 		Announcement: &armdevtestlabs.LabAnnouncementProperties{
	// 			Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
	// 			Expired: to.Ptr(false),
	// 			Markdown: to.Ptr(""),
	// 			Title: to.Ptr(""),
	// 		},
	// 		ArtifactsStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-02T01:40:48.173Z"); return t}()),
	// 		DefaultPremiumStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
	// 		DefaultStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
	// 		EnvironmentPermission: to.Ptr(armdevtestlabs.EnvironmentPermissionReader),
	// 		LabStorageType: to.Ptr(armdevtestlabs.StorageTypeStandard),
	// 		MandatoryArtifactsResourceIDsLinux: []*string{
	// 		},
	// 		MandatoryArtifactsResourceIDsWindows: []*string{
	// 		},
	// 		PremiumDataDiskStorageAccount: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/{storageAccountName}"),
	// 		PremiumDataDisks: to.Ptr(armdevtestlabs.PremiumDataDiskDisabled),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Support: &armdevtestlabs.LabSupportProperties{
	// 			Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
	// 			Markdown: to.Ptr(""),
	// 		},
	// 		UniqueIdentifier: to.Ptr("{uniqueIdentifier}"),
	// 		VaultName: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.KeyVault/vaults/{keyVaultName}"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_CreateOrUpdate.json
func ExampleLabsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLabsClient().BeginCreateOrUpdate(ctx, "resourceGroupName", "{labName}", armdevtestlabs.Lab{
		Location: to.Ptr("{location}"),
		Tags: map[string]*string{
			"tagName1": to.Ptr("tagValue1"),
		},
		Properties: &armdevtestlabs.LabProperties{
			LabStorageType: to.Ptr(armdevtestlabs.StorageType("{Standard|Premium}")),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Lab = armdevtestlabs.Lab{
	// 	Name: to.Ptr("{labName}"),
	// 	Type: to.Ptr("Microsoft.DevTestLab/labs"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}"),
	// 	Location: to.Ptr("{location}"),
	// 	Tags: map[string]*string{
	// 		"tagName1": to.Ptr("tagValue1"),
	// 	},
	// 	Properties: &armdevtestlabs.LabProperties{
	// 		Announcement: &armdevtestlabs.LabAnnouncementProperties{
	// 			Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
	// 			Expired: to.Ptr(false),
	// 			Markdown: to.Ptr(""),
	// 			Title: to.Ptr(""),
	// 		},
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-02T01:40:48.173Z"); return t}()),
	// 		EnvironmentPermission: to.Ptr(armdevtestlabs.EnvironmentPermissionReader),
	// 		LabStorageType: to.Ptr(armdevtestlabs.StorageTypeStandard),
	// 		MandatoryArtifactsResourceIDsLinux: []*string{
	// 		},
	// 		MandatoryArtifactsResourceIDsWindows: []*string{
	// 		},
	// 		PremiumDataDisks: to.Ptr(armdevtestlabs.PremiumDataDiskDisabled),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Support: &armdevtestlabs.LabSupportProperties{
	// 			Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
	// 			Markdown: to.Ptr(""),
	// 		},
	// 		UniqueIdentifier: to.Ptr("{uniqueIdentifier}"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_Delete.json
func ExampleLabsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLabsClient().BeginDelete(ctx, "resourceGroupName", "{labName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_Update.json
func ExampleLabsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLabsClient().Update(ctx, "resourceGroupName", "{labName}", armdevtestlabs.LabFragment{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Lab = armdevtestlabs.Lab{
	// 	Name: to.Ptr("{labName}"),
	// 	Type: to.Ptr("Microsoft.DevTestLab/labs"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}"),
	// 	Location: to.Ptr("{location}"),
	// 	Tags: map[string]*string{
	// 		"tagName1": to.Ptr("tagValue1"),
	// 	},
	// 	Properties: &armdevtestlabs.LabProperties{
	// 		Announcement: &armdevtestlabs.LabAnnouncementProperties{
	// 			Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
	// 			Expired: to.Ptr(false),
	// 			Markdown: to.Ptr(""),
	// 			Title: to.Ptr(""),
	// 		},
	// 		CreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-10-02T01:40:48.173Z"); return t}()),
	// 		EnvironmentPermission: to.Ptr(armdevtestlabs.EnvironmentPermissionReader),
	// 		LabStorageType: to.Ptr(armdevtestlabs.StorageTypeStandard),
	// 		MandatoryArtifactsResourceIDsLinux: []*string{
	// 		},
	// 		MandatoryArtifactsResourceIDsWindows: []*string{
	// 		},
	// 		PremiumDataDisks: to.Ptr(armdevtestlabs.PremiumDataDiskDisabled),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Support: &armdevtestlabs.LabSupportProperties{
	// 			Enabled: to.Ptr(armdevtestlabs.EnableStatusDisabled),
	// 			Markdown: to.Ptr(""),
	// 		},
	// 		UniqueIdentifier: to.Ptr("{uniqueIdentifier}"),
	// 		VaultName: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/resourceGroupName/providers/Microsoft.KeyVault/vaults/{keyVaultName}"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_ClaimAnyVm.json
func ExampleLabsClient_BeginClaimAnyVM() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLabsClient().BeginClaimAnyVM(ctx, "resourceGroupName", "{labName}", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_CreateEnvironment.json
func ExampleLabsClient_BeginCreateEnvironment() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLabsClient().BeginCreateEnvironment(ctx, "resourceGroupName", "{labName}", armdevtestlabs.LabVirtualMachineCreationParameter{
		Name:     to.Ptr("{vmName}"),
		Location: to.Ptr("{location}"),
		Properties: &armdevtestlabs.LabVirtualMachineCreationParameterProperties{
			AllowClaim:              to.Ptr(true),
			DisallowPublicIPAddress: to.Ptr(true),
			GalleryImageReference: &armdevtestlabs.GalleryImageReference{
				Offer:     to.Ptr("UbuntuServer"),
				OSType:    to.Ptr("Linux"),
				Publisher: to.Ptr("Canonical"),
				SKU:       to.Ptr("16.04-LTS"),
				Version:   to.Ptr("Latest"),
			},
			LabSubnetName:       to.Ptr("{virtualnetwork-subnet-name}"),
			LabVirtualNetworkID: to.Ptr("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualnetworks/{virtualNetworkName}"),
			Password:            to.Ptr("{userPassword}"),
			Size:                to.Ptr("Standard_A2_v2"),
			StorageType:         to.Ptr("Standard"),
			UserName:            to.Ptr("{userName}"),
		},
		Tags: map[string]*string{
			"tagName1": to.Ptr("tagValue1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_ExportResourceUsage.json
func ExampleLabsClient_BeginExportResourceUsage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLabsClient().BeginExportResourceUsage(ctx, "resourceGroupName", "{labName}", armdevtestlabs.ExportResourceUsageParameters{
		BlobStorageAbsoluteSasURI: to.Ptr("https://invalid.blob.core.windows.net/export.blob?sv=2015-07-08&sig={sas}&sp=rcw"),
		UsageStartDate:            to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-01T00:00:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_GenerateUploadUri.json
func ExampleLabsClient_GenerateUploadURI() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLabsClient().GenerateUploadURI(ctx, "resourceGroupName", "{labName}", armdevtestlabs.GenerateUploadURIParameter{
		BlobName: to.Ptr("{blob-name}"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GenerateUploadURIResponse = armdevtestlabs.GenerateUploadURIResponse{
	// 	UploadURI: to.Ptr("https://{storageName}.blob.core.windows.net/uploads/{blobName}?sv=2017-04-17&sr=b&sig={signature}&st=2018-10-02T01:55:24Z&se=2018-10-03T02:10:23Z&sp=rcw"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_ImportVirtualMachine.json
func ExampleLabsClient_BeginImportVirtualMachine() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLabsClient().BeginImportVirtualMachine(ctx, "resourceGroupName", "{labName}", armdevtestlabs.ImportLabVirtualMachineRequest{
		DestinationVirtualMachineName:  to.Ptr("{vmName}"),
		SourceVirtualMachineResourceID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{otherResourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/devtestlabs/resource-manager/Microsoft.DevTestLab/stable/2018-09-15/examples/Labs_ListVhds.json
func ExampleLabsClient_NewListVhdsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevtestlabs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLabsClient().NewListVhdsPager("resourceGroupName", "{labName}", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LabVhdList = armdevtestlabs.LabVhdList{
		// 	Value: []*armdevtestlabs.LabVhd{
		// 		{
		// 			ID: to.Ptr("https://{labStorageAccountName}.blob.core.windows.net/vhds/vhd1"),
		// 		},
		// 		{
		// 			ID: to.Ptr("https://{labStorageAccountName}.blob.core.windows.net/vhds/vhd2"),
		// 	}},
		// }
	}
}
