//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/communication/armcommunication/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SuppressionListAddressesServer is a fake server for instances of the armcommunication.SuppressionListAddressesClient type.
type SuppressionListAddressesServer struct {
	// CreateOrUpdate is the fake for method SuppressionListAddressesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, parameters armcommunication.SuppressionListAddressResource, options *armcommunication.SuppressionListAddressesClientCreateOrUpdateOptions) (resp azfake.Responder[armcommunication.SuppressionListAddressesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SuppressionListAddressesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, options *armcommunication.SuppressionListAddressesClientDeleteOptions) (resp azfake.Responder[armcommunication.SuppressionListAddressesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SuppressionListAddressesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, options *armcommunication.SuppressionListAddressesClientGetOptions) (resp azfake.Responder[armcommunication.SuppressionListAddressesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SuppressionListAddressesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, options *armcommunication.SuppressionListAddressesClientListOptions) (resp azfake.PagerResponder[armcommunication.SuppressionListAddressesClientListResponse])
}

// NewSuppressionListAddressesServerTransport creates a new instance of SuppressionListAddressesServerTransport with the provided implementation.
// The returned SuppressionListAddressesServerTransport instance is connected to an instance of armcommunication.SuppressionListAddressesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSuppressionListAddressesServerTransport(srv *SuppressionListAddressesServer) *SuppressionListAddressesServerTransport {
	return &SuppressionListAddressesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armcommunication.SuppressionListAddressesClientListResponse]](),
	}
}

// SuppressionListAddressesServerTransport connects instances of armcommunication.SuppressionListAddressesClient to instances of SuppressionListAddressesServer.
// Don't use this type directly, use NewSuppressionListAddressesServerTransport instead.
type SuppressionListAddressesServerTransport struct {
	srv          *SuppressionListAddressesServer
	newListPager *tracker[azfake.PagerResponder[armcommunication.SuppressionListAddressesClientListResponse]]
}

// Do implements the policy.Transporter interface for SuppressionListAddressesServerTransport.
func (s *SuppressionListAddressesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SuppressionListAddressesClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "SuppressionListAddressesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SuppressionListAddressesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SuppressionListAddressesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SuppressionListAddressesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionLists/(?P<suppressionListName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionListAddresses/(?P<addressId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcommunication.SuppressionListAddressResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	suppressionListNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("suppressionListName")])
	if err != nil {
		return nil, err
	}
	addressIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("addressId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, emailServiceNameParam, domainNameParam, suppressionListNameParam, addressIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SuppressionListAddressResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SuppressionListAddressesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionLists/(?P<suppressionListName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionListAddresses/(?P<addressId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	suppressionListNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("suppressionListName")])
	if err != nil {
		return nil, err
	}
	addressIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("addressId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, emailServiceNameParam, domainNameParam, suppressionListNameParam, addressIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SuppressionListAddressesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionLists/(?P<suppressionListName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionListAddresses/(?P<addressId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
	if err != nil {
		return nil, err
	}
	domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
	if err != nil {
		return nil, err
	}
	suppressionListNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("suppressionListName")])
	if err != nil {
		return nil, err
	}
	addressIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("addressId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, emailServiceNameParam, domainNameParam, suppressionListNameParam, addressIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SuppressionListAddressResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SuppressionListAddressesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Communication/emailServices/(?P<emailServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/domains/(?P<domainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionLists/(?P<suppressionListName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/suppressionListAddresses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		emailServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("emailServiceName")])
		if err != nil {
			return nil, err
		}
		domainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("domainName")])
		if err != nil {
			return nil, err
		}
		suppressionListNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("suppressionListName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, emailServiceNameParam, domainNameParam, suppressionListNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcommunication.SuppressionListAddressesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
