//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbilling_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingProfilesListByBillingAccount.json
func ExampleProfilesClient_NewListByBillingAccountPager_billingProfilesListByBillingAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProfilesClient().NewListByBillingAccountPager("{billingAccountName}", &armbilling.ProfilesClientListByBillingAccountOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProfileListResult = armbilling.ProfileListResult{
		// 	Value: []*armbilling.Profile{
		// 		{
		// 			Name: to.Ptr("11000000-0000-0000-0000-000000000000"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 			Properties: &armbilling.ProfileProperties{
		// 				BillTo: &armbilling.AddressDetails{
		// 					AddressLine1: to.Ptr("Test Address1"),
		// 					AddressLine2: to.Ptr("Test Address2"),
		// 					AddressLine3: to.Ptr("Test Address3"),
		// 					City: to.Ptr("City"),
		// 					CompanyName: to.Ptr("Contoso"),
		// 					Country: to.Ptr("US"),
		// 					Email: to.Ptr("abc@contoso.com"),
		// 					FirstName: to.Ptr("Test"),
		// 					LastName: to.Ptr("User"),
		// 					PhoneNumber: to.Ptr("000-000-0000"),
		// 					PostalCode: to.Ptr("00000"),
		// 					Region: to.Ptr("WA"),
		// 				},
		// 				BillingRelationshipType: to.Ptr(armbilling.BillingRelationshipTypeDirect),
		// 				Currency: to.Ptr("USD"),
		// 				DisplayName: to.Ptr("BillingProfile1"),
		// 				EnabledAzurePlans: []*armbilling.AzurePlan{
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 						SKUID: to.Ptr("0001"),
		// 					},
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
		// 						SKUID: to.Ptr("0002"),
		// 				}},
		// 				HasReadAccess: to.Ptr(true),
		// 				InvoiceDay: to.Ptr[int32](5),
		// 				InvoiceEmailOptIn: to.Ptr(true),
		// 				PoNumber: to.Ptr("ABC12345"),
		// 				SpendingLimit: to.Ptr(armbilling.SpendingLimitOn),
		// 				Status: to.Ptr(armbilling.BillingProfileStatusWarned),
		// 				StatusReasonCode: to.Ptr(armbilling.StatusReasonCodePastDue),
		// 				SystemID: to.Ptr("1XXX-11XX-XX1-XXXX-XXX"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("11000000-0000-0000-0000-000000000001"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000001"),
		// 			Properties: &armbilling.ProfileProperties{
		// 				BillTo: &armbilling.AddressDetails{
		// 					AddressLine1: to.Ptr("Test Address1"),
		// 					AddressLine2: to.Ptr("Test Address2"),
		// 					AddressLine3: to.Ptr("Test Address3"),
		// 					City: to.Ptr("City"),
		// 					CompanyName: to.Ptr("Contoso"),
		// 					Country: to.Ptr("US"),
		// 					Email: to.Ptr("abc@contoso.com"),
		// 					FirstName: to.Ptr("Test"),
		// 					LastName: to.Ptr("User"),
		// 					PhoneNumber: to.Ptr("000-000-0000"),
		// 					PostalCode: to.Ptr("00000"),
		// 					Region: to.Ptr("WA"),
		// 				},
		// 				BillingRelationshipType: to.Ptr(armbilling.BillingRelationshipTypeIndirectCustomer),
		// 				Currency: to.Ptr("USD"),
		// 				DisplayName: to.Ptr("BillingProfile2"),
		// 				EnabledAzurePlans: []*armbilling.AzurePlan{
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 						SKUID: to.Ptr("0001"),
		// 					},
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
		// 						SKUID: to.Ptr("0002"),
		// 				}},
		// 				HasReadAccess: to.Ptr(true),
		// 				IndirectRelationshipInfo: &armbilling.IndirectRelationshipInfo{
		// 					BillingAccountName: to.Ptr("30000000-0000-0000-0000-000000000001_00000000-0000-0000-0000-000000000000"),
		// 					BillingProfileName: to.Ptr("33000000-0000-0000-0000-000000000001"),
		// 					DisplayName: to.Ptr("Partner1"),
		// 				},
		// 				InvoiceDay: to.Ptr[int32](5),
		// 				InvoiceEmailOptIn: to.Ptr(true),
		// 				PoNumber: to.Ptr("ABC12345"),
		// 				SpendingLimit: to.Ptr(armbilling.SpendingLimitOff),
		// 				Status: to.Ptr(armbilling.BillingProfileStatusActive),
		// 				SystemID: to.Ptr("2XXX-22XX-XX1-XXXX-XXX"),
		// 				TargetClouds: []*armbilling.TargetCloud{
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingProfilesListWithExpand.json
func ExampleProfilesClient_NewListByBillingAccountPager_billingProfilesListWithExpand() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProfilesClient().NewListByBillingAccountPager("{billingAccountName}", &armbilling.ProfilesClientListByBillingAccountOptions{Expand: to.Ptr("invoiceSections")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProfileListResult = armbilling.ProfileListResult{
		// 	Value: []*armbilling.Profile{
		// 		{
		// 			Name: to.Ptr("11000000-0000-0000-0000-000000000000"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000"),
		// 			Properties: &armbilling.ProfileProperties{
		// 				BillTo: &armbilling.AddressDetails{
		// 					AddressLine1: to.Ptr("Test Address1"),
		// 					AddressLine2: to.Ptr("Test Address2"),
		// 					AddressLine3: to.Ptr("Test Address3"),
		// 					City: to.Ptr("City"),
		// 					CompanyName: to.Ptr("Contoso"),
		// 					Country: to.Ptr("US"),
		// 					Email: to.Ptr("abc@contoso.com"),
		// 					FirstName: to.Ptr("Test"),
		// 					LastName: to.Ptr("User"),
		// 					PhoneNumber: to.Ptr("000-000-0000"),
		// 					PostalCode: to.Ptr("00000"),
		// 					Region: to.Ptr("WA"),
		// 				},
		// 				BillingRelationshipType: to.Ptr(armbilling.BillingRelationshipTypeDirect),
		// 				Currency: to.Ptr("USD"),
		// 				DisplayName: to.Ptr("BillingProfile1"),
		// 				EnabledAzurePlans: []*armbilling.AzurePlan{
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 						SKUID: to.Ptr("0001"),
		// 					},
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
		// 						SKUID: to.Ptr("0002"),
		// 				}},
		// 				HasReadAccess: to.Ptr(true),
		// 				InvoiceDay: to.Ptr[int32](5),
		// 				InvoiceEmailOptIn: to.Ptr(true),
		// 				InvoiceSections: &armbilling.InvoiceSectionsOnExpand{
		// 					HasMoreResults: to.Ptr(false),
		// 					Value: []*armbilling.InvoiceSection{
		// 						{
		// 							Name: to.Ptr("invoiceSectionId1"),
		// 							Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles/invoiceSections"),
		// 							ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000000/invoiceSections/invoiceSectionId1"),
		// 							Properties: &armbilling.InvoiceSectionProperties{
		// 								DisplayName: to.Ptr("invoiceSectionName1"),
		// 								Labels: map[string]*string{
		// 									"costCategory": to.Ptr("Support"),
		// 									"pcCode": to.Ptr("A123456"),
		// 								},
		// 								State: to.Ptr(armbilling.InvoiceSectionStateActive),
		// 								SystemID: to.Ptr("9XXX-11XX-XX1-XXXX-XXX"),
		// 							},
		// 					}},
		// 				},
		// 				PoNumber: to.Ptr("ABC12345"),
		// 				SpendingLimit: to.Ptr(armbilling.SpendingLimitOn),
		// 				Status: to.Ptr(armbilling.BillingProfileStatusWarned),
		// 				StatusReasonCode: to.Ptr(armbilling.StatusReasonCodePastDue),
		// 				SystemID: to.Ptr("1XXX-11XX-XX1-XXXX-XXX"),
		// 				TargetClouds: []*armbilling.TargetCloud{
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("11000000-0000-0000-0000-000000000001"),
		// 			Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles"),
		// 			ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000001"),
		// 			Properties: &armbilling.ProfileProperties{
		// 				BillTo: &armbilling.AddressDetails{
		// 					AddressLine1: to.Ptr("Test Address1"),
		// 					AddressLine2: to.Ptr("Test Address2"),
		// 					AddressLine3: to.Ptr("Test Address3"),
		// 					City: to.Ptr("City"),
		// 					CompanyName: to.Ptr("Contoso"),
		// 					Country: to.Ptr("US"),
		// 					Email: to.Ptr("abc@contoso.com"),
		// 					FirstName: to.Ptr("Test"),
		// 					LastName: to.Ptr("User"),
		// 					PhoneNumber: to.Ptr("000-000-0000"),
		// 					PostalCode: to.Ptr("00000"),
		// 					Region: to.Ptr("WA"),
		// 				},
		// 				BillingRelationshipType: to.Ptr(armbilling.BillingRelationshipTypeIndirectCustomer),
		// 				Currency: to.Ptr("USD"),
		// 				DisplayName: to.Ptr("BillingProfile2"),
		// 				EnabledAzurePlans: []*armbilling.AzurePlan{
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan"),
		// 						SKUID: to.Ptr("0001"),
		// 					},
		// 					{
		// 						SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
		// 						SKUID: to.Ptr("0002"),
		// 				}},
		// 				HasReadAccess: to.Ptr(true),
		// 				IndirectRelationshipInfo: &armbilling.IndirectRelationshipInfo{
		// 					BillingAccountName: to.Ptr("30000000-0000-0000-0000-000000000001_00000000-0000-0000-0000-000000000000"),
		// 					BillingProfileName: to.Ptr("33000000-0000-0000-0000-000000000001"),
		// 					DisplayName: to.Ptr("Partner1"),
		// 				},
		// 				InvoiceDay: to.Ptr[int32](5),
		// 				InvoiceEmailOptIn: to.Ptr(true),
		// 				InvoiceSections: &armbilling.InvoiceSectionsOnExpand{
		// 					HasMoreResults: to.Ptr(false),
		// 					Value: []*armbilling.InvoiceSection{
		// 						{
		// 							Name: to.Ptr("invoiceSectionId2"),
		// 							Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles/invoiceSections"),
		// 							ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/11000000-0000-0000-0000-000000000001/invoiceSections/invoiceSectionId2"),
		// 							Properties: &armbilling.InvoiceSectionProperties{
		// 								DisplayName: to.Ptr("invoiceSectionName2"),
		// 								Labels: map[string]*string{
		// 									"costCategory": to.Ptr("Marketing"),
		// 									"pcCode": to.Ptr("Z223456"),
		// 								},
		// 								State: to.Ptr(armbilling.InvoiceSectionStateActive),
		// 								SystemID: to.Ptr("9XXX-22XX-XX1-XXXX-XXX"),
		// 							},
		// 					}},
		// 				},
		// 				PoNumber: to.Ptr("ABC12345"),
		// 				SpendingLimit: to.Ptr(armbilling.SpendingLimitOn),
		// 				Status: to.Ptr(armbilling.BillingProfileStatusWarned),
		// 				StatusReasonCode: to.Ptr(armbilling.StatusReasonCodePastDue),
		// 				SystemID: to.Ptr("2XXX-22XX-XX1-XXXX-XXX"),
		// 				TargetClouds: []*armbilling.TargetCloud{
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingProfile.json
func ExampleProfilesClient_Get_billingProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Get(ctx, "{billingAccountName}", "{billingProfileName}", &armbilling.ProfilesClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armbilling.Profile{
	// 	Name: to.Ptr("{billingProfileName}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
	// 	Properties: &armbilling.ProfileProperties{
	// 		BillTo: &armbilling.AddressDetails{
	// 			AddressLine1: to.Ptr("Test Address1"),
	// 			AddressLine2: to.Ptr("Test Address2"),
	// 			AddressLine3: to.Ptr("Test Address3"),
	// 			City: to.Ptr("City"),
	// 			CompanyName: to.Ptr("Contoso"),
	// 			Country: to.Ptr("US"),
	// 			Email: to.Ptr("abc@contoso.com"),
	// 			FirstName: to.Ptr("Test"),
	// 			LastName: to.Ptr("User"),
	// 			PhoneNumber: to.Ptr("000-000-0000"),
	// 			PostalCode: to.Ptr("00000"),
	// 			Region: to.Ptr("WA"),
	// 		},
	// 		BillingRelationshipType: to.Ptr(armbilling.BillingRelationshipTypeDirect),
	// 		Currency: to.Ptr("USD"),
	// 		DisplayName: to.Ptr("Billing Profile1"),
	// 		EnabledAzurePlans: []*armbilling.AzurePlan{
	// 			{
	// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
	// 				SKUID: to.Ptr("0001"),
	// 			},
	// 			{
	// 				SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
	// 				SKUID: to.Ptr("0002"),
	// 		}},
	// 		HasReadAccess: to.Ptr(true),
	// 		InvoiceDay: to.Ptr[int32](5),
	// 		InvoiceEmailOptIn: to.Ptr(true),
	// 		PoNumber: to.Ptr("ABC12345"),
	// 		SpendingLimit: to.Ptr(armbilling.SpendingLimitOn),
	// 		Status: to.Ptr(armbilling.BillingProfileStatusWarned),
	// 		StatusReasonCode: to.Ptr(armbilling.StatusReasonCodePastDue),
	// 		SystemID: to.Ptr("1XXX-11XX-XX1-XXXX-XXX"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/BillingProfileWithExpand.json
func ExampleProfilesClient_Get_billingProfileWithExpand() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProfilesClient().Get(ctx, "{billingAccountName}", "{billingProfileName}", &armbilling.ProfilesClientGetOptions{Expand: to.Ptr("invoiceSections")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armbilling.Profile{
	// 	Name: to.Ptr("{billingProfileName}"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}"),
	// 	Properties: &armbilling.ProfileProperties{
	// 		BillTo: &armbilling.AddressDetails{
	// 			AddressLine1: to.Ptr("Test Address1"),
	// 			AddressLine2: to.Ptr("Test Address2"),
	// 			AddressLine3: to.Ptr("Test Address3"),
	// 			City: to.Ptr("City"),
	// 			CompanyName: to.Ptr("Contoso"),
	// 			Country: to.Ptr("US"),
	// 			Email: to.Ptr("abc@contoso.com"),
	// 			FirstName: to.Ptr("Test"),
	// 			LastName: to.Ptr("User"),
	// 			PhoneNumber: to.Ptr("000-000-0000"),
	// 			PostalCode: to.Ptr("00000"),
	// 			Region: to.Ptr("WA"),
	// 		},
	// 		BillingRelationshipType: to.Ptr(armbilling.BillingRelationshipTypeDirect),
	// 		Currency: to.Ptr("USD"),
	// 		DisplayName: to.Ptr("Billing Profile1"),
	// 		EnabledAzurePlans: []*armbilling.AzurePlan{
	// 			{
	// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
	// 				SKUID: to.Ptr("0001"),
	// 			},
	// 			{
	// 				SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
	// 				SKUID: to.Ptr("0002"),
	// 		}},
	// 		HasReadAccess: to.Ptr(true),
	// 		InvoiceDay: to.Ptr[int32](5),
	// 		InvoiceEmailOptIn: to.Ptr(true),
	// 		InvoiceSections: &armbilling.InvoiceSectionsOnExpand{
	// 			HasMoreResults: to.Ptr(false),
	// 			Value: []*armbilling.InvoiceSection{
	// 				{
	// 					Name: to.Ptr("invoiceSectionId1"),
	// 					Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles/invoiceSections"),
	// 					ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/invoiceSectionId1"),
	// 					Properties: &armbilling.InvoiceSectionProperties{
	// 						DisplayName: to.Ptr("invoiceSectionName1"),
	// 						Labels: map[string]*string{
	// 							"costCategory": to.Ptr("Support"),
	// 							"pcCode": to.Ptr("A123456"),
	// 						},
	// 						State: to.Ptr(armbilling.InvoiceSectionStateActive),
	// 						SystemID: to.Ptr("9XXX-11XX-XX1-XXXX-XXX"),
	// 					},
	// 			}},
	// 		},
	// 		PoNumber: to.Ptr("ABC12345"),
	// 		SpendingLimit: to.Ptr(armbilling.SpendingLimitOn),
	// 		Status: to.Ptr(armbilling.BillingProfileStatusWarned),
	// 		StatusReasonCode: to.Ptr(armbilling.StatusReasonCodePastDue),
	// 		SystemID: to.Ptr("1XXX-11XX-XX1-XXXX-XXX"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/billing/resource-manager/Microsoft.Billing/stable/2020-05-01/examples/PutBillingProfile.json
func ExampleProfilesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbilling.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProfilesClient().BeginCreateOrUpdate(ctx, "{billingAccountName}", "{billingProfileName}", armbilling.Profile{
		Properties: &armbilling.ProfileProperties{
			BillTo: &armbilling.AddressDetails{
				AddressLine1: to.Ptr("Test Address 1"),
				City:         to.Ptr("Redmond"),
				Country:      to.Ptr("US"),
				FirstName:    to.Ptr("Test"),
				LastName:     to.Ptr("User"),
				PostalCode:   to.Ptr("12345"),
				Region:       to.Ptr("WA"),
			},
			DisplayName: to.Ptr("Finance"),
			EnabledAzurePlans: []*armbilling.AzurePlan{
				{
					SKUID: to.Ptr("0001"),
				},
				{
					SKUID: to.Ptr("0002"),
				}},
			InvoiceEmailOptIn: to.Ptr(true),
			PoNumber:          to.Ptr("ABC12345"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Profile = armbilling.Profile{
	// 	Name: to.Ptr("billingProfileId1"),
	// 	Type: to.Ptr("Microsoft.Billing/billingAccounts/billingProfiles"),
	// 	ID: to.Ptr("/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/billingProfileId1"),
	// 	Properties: &armbilling.ProfileProperties{
	// 		BillTo: &armbilling.AddressDetails{
	// 			AddressLine1: to.Ptr("Test Address 1"),
	// 			City: to.Ptr("Redmond"),
	// 			Country: to.Ptr("US"),
	// 			FirstName: to.Ptr("Test"),
	// 			LastName: to.Ptr("User"),
	// 			PostalCode: to.Ptr("12345"),
	// 			Region: to.Ptr("WA"),
	// 		},
	// 		Currency: to.Ptr("USD"),
	// 		DisplayName: to.Ptr("Finance"),
	// 		EnabledAzurePlans: []*armbilling.AzurePlan{
	// 			{
	// 				SKUDescription: to.Ptr("Microsoft Azure Plan"),
	// 				SKUID: to.Ptr("0001"),
	// 			},
	// 			{
	// 				SKUDescription: to.Ptr("Microsoft Azure Plan for DevTest"),
	// 				SKUID: to.Ptr("0002"),
	// 		}},
	// 		HasReadAccess: to.Ptr(true),
	// 		InvoiceDay: to.Ptr[int32](5),
	// 		InvoiceEmailOptIn: to.Ptr(true),
	// 		PoNumber: to.Ptr("ABC12345"),
	// 		SpendingLimit: to.Ptr(armbilling.SpendingLimitOff),
	// 		Status: to.Ptr(armbilling.BillingProfileStatusActive),
	// 		SystemID: to.Ptr("1XXX-11XX-XX1-XXXX-XXX"),
	// 	},
	// }
}
