/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationPresentation
implements TextAnnotationPresentation {
    @NotNull
    private final FileAnnotation myFileAnnotation;
    @NotNull
    private final UpToDateLineNumberProvider myUpToDateLineNumberProvider;
    @Nullable
    private final AnnotationSourceSwitcher mySwitcher;
    private final ArrayList<AnAction> myActions;
    @NotNull
    private final Disposable myDisposable;
    private boolean myDisposed;

    AnnotationPresentation(@NotNull FileAnnotation fileAnnotation, @NotNull UpToDateLineNumberProvider upToDateLineNumberProvider, @Nullable AnnotationSourceSwitcher switcher, @NotNull Disposable disposable) {
        if (fileAnnotation == null) {
            AnnotationPresentation.$$$reportNull$$$0(0);
        }
        if (upToDateLineNumberProvider == null) {
            AnnotationPresentation.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            AnnotationPresentation.$$$reportNull$$$0(2);
        }
        this.myActions = new ArrayList();
        this.myDisposed = false;
        this.myUpToDateLineNumberProvider = upToDateLineNumberProvider;
        this.myFileAnnotation = fileAnnotation;
        this.mySwitcher = switcher;
        this.myDisposable = disposable;
    }

    @NotNull
    FileAnnotation getFileAnnotation() {
        FileAnnotation fileAnnotation = this.myFileAnnotation;
        if (fileAnnotation == null) {
            AnnotationPresentation.$$$reportNull$$$0(3);
        }
        return fileAnnotation;
    }

    @Override
    public int getAnnotationLine(int editorLine) {
        return this.getAnnotationLine(editorLine, false);
    }

    @Override
    public int getAnnotationLine(int editorLine, boolean approximate) {
        return this.myUpToDateLineNumberProvider.getLineNumber(editorLine, approximate);
    }

    @Override
    public EditorFontType getFontType(int line) {
        return this.isLastCommit(line) ? EditorFontType.BOLD : EditorFontType.PLAIN;
    }

    private boolean isLastCommit(int line) {
        VcsRevisionNumber revision = this.myFileAnnotation.originalRevision(line);
        VcsRevisionNumber currentRevision = this.myFileAnnotation.getCurrentRevision();
        return currentRevision != null && currentRevision.equals(revision);
    }

    @Override
    public ColorKey getColor(int line) {
        if (this.mySwitcher == null) {
            return AnnotationSource.LOCAL.getColor(this.isLastCommit(line));
        }
        return this.mySwitcher.getAnnotationSource(line).getColor();
    }

    @Override
    public List<AnAction> getActions(int line) {
        int correctedNumber = this.getAnnotationLine(line);
        for (AnAction action : this.myActions) {
            LineNumberListener listener2;
            UpToDateLineNumberListener upToDateListener = (UpToDateLineNumberListener)ObjectUtils.tryCast((Object)action, UpToDateLineNumberListener.class);
            if (upToDateListener != null) {
                upToDateListener.consume((Object)correctedNumber);
            }
            if ((listener2 = (LineNumberListener)ObjectUtils.tryCast((Object)action, LineNumberListener.class)) == null) continue;
            listener2.consume((Object)line);
        }
        return this.myActions;
    }

    @NotNull
    public List<AnAction> getActions() {
        ArrayList<AnAction> arrayList = this.myActions;
        if (arrayList == null) {
            AnnotationPresentation.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void addAction(@NotNull AnAction action) {
        if (action == null) {
            AnnotationPresentation.$$$reportNull$$$0(5);
        }
        this.myActions.add(action);
    }

    public void addAction(@NotNull AnAction action, int index) {
        if (action == null) {
            AnnotationPresentation.$$$reportNull$$$0(6);
        }
        this.myActions.add(index, action);
    }

    @Override
    public void gutterClosed() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upToDateLineNumberProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotationPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotationPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

