/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.util;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpDeserializerBase;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.util.BinaryData;
import org.opensearch.client.util.NoCopyByteArrayOutputStream;

@JsonpDeserializable
public class ByteArrayBinaryData
implements BinaryData {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private final String contentType;
    public static final JsonpDeserializer<ByteArrayBinaryData> _DESERIALIZER = new Deserializer();

    public ByteArrayBinaryData(byte[] bytes, int offset, int length, String contentType) {
        this.contentType = contentType;
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public ByteArrayBinaryData(byte[] bytes, String contentType) {
        this.contentType = contentType;
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public ByteArrayBinaryData(BinaryData data) throws IOException {
        NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream();
        data.writeTo(out);
        this.contentType = data.contentType();
        this.bytes = out.array();
        this.offset = 0;
        this.length = out.size();
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes, this.offset, this.length);
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.offset, this.length);
    }

    @Override
    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.length);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        try (InputStream in = this.asInputStream();){
            JsonParser parser = mapper.jsonProvider().createParser(in);
            JsonpUtils.copy(parser, generator);
            parser.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize BinaryData", e);
        }
    }

    private static class Deserializer
    extends JsonpDeserializerBase<ByteArrayBinaryData> {
        Deserializer() {
            super(EnumSet.allOf(JsonParser.Event.class));
        }

        @Override
        public ByteArrayBinaryData deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)baos);
            JsonpUtils.copy(parser, generator, event);
            generator.close();
            return new ByteArrayBinaryData(baos.toByteArray(), "application/json");
        }
    }
}

