/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper.size;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.common.Explicit;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;

public class SizeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_size";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new SizeFieldMapper((Explicit<Boolean>)new Explicit((Object)false, false), (MappedFieldType)new NumberFieldMapper.NumberFieldType(NAME, NumberFieldMapper.NumberType.INTEGER)), c -> new Builder());
    private final Explicit<Boolean> enabled;

    private static SizeFieldMapper toType(FieldMapper in) {
        return (SizeFieldMapper)in;
    }

    private SizeFieldMapper(Explicit<Boolean> enabled, MappedFieldType mappedFieldType) {
        super(mappedFieldType);
        this.enabled = enabled;
    }

    protected String contentType() {
        return NAME;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.value();
    }

    public void postParse(ParseContext context) throws IOException {
        if (!((Boolean)this.enabled.value()).booleanValue()) {
            return;
        }
        int value = context.sourceToParse().source().length();
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.name(), (Number)value, true, true, false, true));
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder().init((FieldMapper)this);
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam((String)"enabled", m -> SizeFieldMapper.toType((FieldMapper)m).enabled, (boolean)false);

        private Builder() {
            super(SizeFieldMapper.NAME);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.enabled);
        }

        public SizeFieldMapper build(Mapper.BuilderContext context) {
            return new SizeFieldMapper((Explicit<Boolean>)((Explicit)this.enabled.getValue()), (MappedFieldType)new NumberFieldMapper.NumberFieldType(SizeFieldMapper.NAME, NumberFieldMapper.NumberType.INTEGER));
        }
    }
}

