"use strict";

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^opensearch-dashboards/public$': '<rootDir>/../../src/core/public'
  },
  testEnvironment: 'jest-environment-jsdom',
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.js', '!<rootDir>/public/app.js', '!<rootDir>/index.js', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  modulePathIgnorePatterns: ['<rootDir>/offline-module-cache/'],
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  transformIgnorePatterns: ['<rootDir>/node_modules'],
  globalSetup: '<rootDir>/global-setup.js',
  /**
   * This configuration specifies different file extensions 
   * and the corresponding transformers to be used
   */
  transform: {
    '\\.[jt]sx?$': 'babel-jest',
    '^.+\\.svg$': '<rootDir>/test/mocks/transformMock.ts',
    '^.+\\.html$': '<rootDir>/test/mocks/transformMock.ts'
  },
  setupFiles: ["jest-canvas-mock"]
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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