/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.correlation;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public final class Anomaly {
    private final String modelId;
    private final String configId;
    private final Instant dataStartTime;
    private final Instant dataEndTime;

    public Anomaly(String modelId, String configId, Instant dataStartTime, Instant dataEndTime) {
        this.modelId = Objects.requireNonNull(modelId, "modelId");
        this.configId = Objects.requireNonNull(configId, "configId");
        this.dataStartTime = Objects.requireNonNull(dataStartTime, "dataStartTime");
        this.dataEndTime = Objects.requireNonNull(dataEndTime, "dataEndTime");
        if (!dataEndTime.isAfter(dataStartTime)) {
            throw new IllegalArgumentException("dataEndTime must be after dataStartTime");
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public Instant getDataStartTime() {
        return this.dataStartTime;
    }

    public Instant getDataEndTime() {
        return this.dataEndTime;
    }

    public Duration getDuration() {
        return Duration.between(this.dataStartTime, this.dataEndTime);
    }

    public String getConfigId() {
        return this.configId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Anomaly anomaly = (Anomaly)o;
        return this.modelId.equals(anomaly.modelId) && this.dataStartTime.equals(anomaly.dataStartTime) && this.dataEndTime.equals(anomaly.dataEndTime);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.dataStartTime, this.dataEndTime);
    }

    public String toString() {
        return "Anomaly{id='" + this.modelId + "', detectorName='" + this.configId + "', dataStartTime=" + String.valueOf(this.dataStartTime) + ", dataEndTime=" + String.valueOf(this.dataEndTime) + "}";
    }
}

