/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;

public class CriteriaBasedDocValuesWriter
extends DocValuesConsumer {
    private final DocValuesConsumer delegate;
    private final String bucket;

    public CriteriaBasedDocValuesWriter(DocValuesConsumer delegate, String bucket) throws IOException {
        this.delegate = delegate;
        this.bucket = bucket;
    }

    public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addNumericField(field, valuesProducer);
        if (field.name.equals("_seq_no") && this.bucket != null) {
            field.putAttribute("bucket", this.bucket);
        }
    }

    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addBinaryField(field, valuesProducer);
    }

    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedField(field, valuesProducer);
    }

    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedNumericField(field, valuesProducer);
    }

    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedSetField(field, valuesProducer);
    }

    public void merge(MergeState mergeState) throws IOException {
        super.merge(mergeState);
        mergeState.segmentInfo.putAttribute("bucket", mergeState.mergeFieldInfos.fieldInfo("_seq_no").getAttribute("bucket"));
        mergeState.segmentInfo.putAttribute("merge", "true");
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

