/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.expression;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.render.ValueRenderer;
import com.github.fge.uritemplate.vars.VariableMap;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class TemplateExpression
implements URITemplateExpression {
    private final ExpressionType expressionType;
    private final List<VariableSpec> variableSpecs;

    public TemplateExpression(ExpressionType expressionType, List<VariableSpec> variableSpecs) {
        this.expressionType = expressionType;
        this.variableSpecs = ImmutableList.copyOf(variableSpecs);
    }

    @Override
    public String expand(VariableMap vars) throws URITemplateException {
        ArrayList<String> expansions = Lists.newArrayList();
        for (VariableSpec varspec : this.variableSpecs) {
            VariableValue value = vars.get(varspec.getName());
            if (value == null) continue;
            ValueRenderer renderer = value.getType().selectRenderer(this.expressionType);
            expansions.addAll(renderer.render(varspec, value));
        }
        if (expansions.isEmpty()) {
            return "";
        }
        Joiner joiner = Joiner.on(this.expressionType.getSeparator());
        StringBuilder sb = new StringBuilder(this.expressionType.getPrefix());
        joiner.appendTo(sb, (Iterable<? extends Object>)expansions);
        return sb.toString();
    }

    public int hashCode() {
        return 31 * this.expressionType.hashCode() + this.variableSpecs.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateExpression other = (TemplateExpression)obj;
        return this.expressionType == other.expressionType && this.variableSpecs.equals(other.variableSpecs);
    }
}

