/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.creator.Modifier;
import io.quarkus.gizmo2.creator.ModifierLocation;
import java.util.List;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ModifierFlag implements Modifier
{
    ABSTRACT(1024){

        @Override
        public void forEachExclusive(Consumer<ModifierFlag> action) {
            action.accept(FINAL);
        }
    }
    ,
    BRIDGE(64),
    FINAL(16){

        @Override
        public void forEachExclusive(Consumer<ModifierFlag> action) {
            action.accept(ABSTRACT);
            action.accept(VOLATILE);
        }
    }
    ,
    MANDATED(32768),
    STATIC(8),
    SYNCHRONIZED(32),
    SYNTHETIC(4096),
    TRANSIENT(128),
    VARARGS(128),
    VOLATILE(64){

        @Override
        public void forEachExclusive(Consumer<ModifierFlag> action) {
            action.accept(FINAL);
        }
    };

    public static final List<ModifierFlag> values;
    private final int sets;

    private ModifierFlag(int sets) {
        this.sets = sets;
    }

    @Override
    public boolean validIn(ModifierLocation location) {
        return location.supports(this);
    }

    @Override
    public int mask() {
        return this.sets;
    }

    public void forEachExclusive(Consumer<ModifierFlag> action) {
    }

    static {
        values = List.of(ModifierFlag.values());
    }
}

