/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.Validator;
import org.keycloak.validate.ValidatorConfig;
import org.keycloak.validate.ValidatorFactory;

public class Validators {
    private final KeycloakSession session;

    public Validators(KeycloakSession session) {
        this.session = session;
    }

    public Validator validator(String id) {
        return Validators.validator(this.session, id);
    }

    public ValidatorFactory validatorFactory(String id) {
        return Validators.validatorFactory(this.session, id);
    }

    public ValidationResult validateConfig(String id, ValidatorConfig config) {
        return Validators.validateConfig(this.session, id, config);
    }

    public static Validator validator(KeycloakSession session, String id) {
        if (session == null) {
            throw new IllegalArgumentException("KeycloakSession must be not null");
        }
        return session.getProvider(Validator.class, id);
    }

    public static ValidatorFactory validatorFactory(KeycloakSession session, String id) {
        if (session == null) {
            throw new IllegalArgumentException("KeycloakSession must be not null");
        }
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        return (ValidatorFactory)sessionFactory.getProviderFactory(Validator.class, id);
    }

    public static ValidationResult validateConfig(KeycloakSession session, String id, ValidatorConfig config) {
        ValidatorFactory validatorFactory = Validators.validatorFactory(session, id);
        if (validatorFactory != null) {
            return validatorFactory.validateConfig(session, config);
        }
        return ValidationResult.OK;
    }
}

