/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.LivenessPath;
import sun.jvm.hotspot.utilities.LivenessPathElement;
import sun.jvm.hotspot.utilities.LivenessPathList;
import sun.jvm.hotspot.utilities.ReversePtrs;

public class LivenessAnalysis {
    private static final boolean DEBUG = false;

    private LivenessAnalysis() {
    }

    public static LivenessPathList computeAllLivenessPaths(Oop target) {
        LivenessPathList list = LivenessAnalysis.computeAllLivenessPaths(target, true);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    private static LivenessPathList computeAllLivenessPaths(Oop target, boolean trimPathsThroughPopularObjects) {
        ReversePtrs rev = VM.getVM().getRevPtrs();
        if (rev == null) {
            throw new RuntimeException("LivenessAnalysis requires ReversePtrs to have been computed");
        }
        if (rev.get(target) == null) {
            return null;
        }
        HashSet<Oop> visitedOops = new HashSet<Oop>();
        IdentityHashMap<LivenessPathElement, LivenessPathElement> visitedRoots = new IdentityHashMap<LivenessPathElement, LivenessPathElement>();
        visitedOops.add(target);
        LivenessPathList list = new LivenessPathList();
        LivenessPath path = new LivenessPath();
        path.push(new LivenessPathElement(target, null));
        list.add(path);
        block2: while (true) {
            path = null;
            for (int i = list.size() - 1; i >= 0; --i) {
                LivenessPath tmp = list.get(i);
                if (tmp.isComplete()) continue;
                path = tmp;
                break;
            }
            if (path == null) {
                return list;
            }
            list.remove(path);
            try {
                LivenessPathElement nextElement;
                ArrayList nextPtrs = rev.get(path.peek().getObj());
                if (nextPtrs == null) continue;
                Iterator iter = nextPtrs.iterator();
                do {
                    if (!iter.hasNext()) continue block2;
                } while ((!(nextElement = (LivenessPathElement)iter.next()).isRoot() || visitedRoots.get(nextElement) != null) && (nextElement.isRoot() || visitedOops.contains(nextElement.getObj())));
                if (nextElement.isRoot()) {
                    visitedRoots.put(nextElement, nextElement);
                } else {
                    visitedOops.add(nextElement.getObj());
                }
                LivenessPath nextPath = path.copy();
                nextPath.push(nextElement);
                list.add(path);
                list.add(nextPath);
                if (!trimPathsThroughPopularObjects || !nextElement.isRoot()) continue;
                int i = 1;
                while (true) {
                    if (i >= nextPath.size() - 1) continue block2;
                    LivenessPathElement el = nextPath.get(i);
                    int j = 0;
                    while (j < list.size()) {
                        LivenessPath curPath = list.get(j);
                        if (curPath.peek() == el) {
                            list.remove(curPath);
                            continue;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println("LivenessAnalysis: WARNING: " + e + " during traversal");
                continue;
            }
            break;
        }
    }
}

