/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaErrorCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaSimpleFunctionCall;
import org.jetbrains.kotlin.analysis.api.signatures.KaFunctionSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00c8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\t*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\t*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\t*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\t*\u00020\u0015\u001a\"\u0010\u0017\u001a\u00020\u0018*\u00020\u00152\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001a\u001am\u0010\u001c\u001a\u0002H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u0002H\u001d2\u0006\u0010\"\u001a\u0002H\u001d2\u001f\b\u0002\u0010#\u001a\u0019\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001d0$\u00a2\u0006\u0002\b%2\u001d\u0010&\u001a\u0019\u0012\u0004\u0012\u0002H\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0'0\u001a\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\u0010(\u001a'\u0010)\u001a\u00020\t*\u00020\u00152\b\b\u0002\u0010,\u001a\u00020\tH\u0007R\u00020*j\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0002\u0010-\u001a\u000e\u0010.\u001a\u0004\u0018\u00010/*\u000200H\u0007\u001a\f\u00101\u001a\u0004\u0018\u00010\u001e*\u00020\u0010\u001aF\u00102\u001a\u00020\t*\u00020\u001e2\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u000205042%\u00106\u001a!\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020504\u0012\u0004\u0012\u00020\t0$\u00a2\u0006\u0002\b%\u00a2\u0006\u0002\u00107\u001a\n\u00108\u001a\u00020\u0018*\u00020\u0010\u001a\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u001e0'*\u00020\u00022\b\b\u0002\u0010:\u001a\u00020\t\u001a.\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001e0'*\u00020\u00022\b\b\u0002\u0010:\u001a\u00020\t2\b\b\u0002\u0010<\u001a\u00020\t2\b\b\u0002\u0010=\u001a\u00020\t\u001a\u001c\u0010>\u001a\u00020\u001e*\u00020?2\u0006\u0010@\u001a\u00020\u001e2\b\b\u0002\u0010A\u001a\u00020\t\u001a<\u0010B\u001a\u00020\u0018*\u00020C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070E2\u000e\b\u0002\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00180G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00180G\u001a\n\u0010I\u001a\u00020\t*\u00020J\u001a\n\u0010I\u001a\u00020\t*\u00020K\u001a\f\u0010L\u001a\u0004\u0018\u00010\u0014*\u00020\u0015\u001a \u0010M\u001a\u00020\u0018*\b\u0012\u0004\u0012\u0002000N2\u0006\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u0007\u001a\f\u0010Q\u001a\u00020\u0018*\u00020\u0002H\u0007\u00a8\u0006R"}, d2={"nameDeterminant", "Lcom/intellij/psi/PsiNamedElement;", "Lcom/intellij/psi/PsiElement;", "getContainer", "createTempCopy", "Lorg/jetbrains/kotlin/psi/KtFile;", "text", "", "canRefactorElement", "", "isOpen", "Lorg/jetbrains/kotlin/psi/KtClass;", "isInterfaceClass", "isAbstract", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isCompanionMemberOf", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getLastLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isComplexCallWithLambdaArgument", "moveFunctionLiteralOutsideParentheses", "", "moveCaretTo", "Lkotlin/Function1;", "", "replaceListPsiAndKeepDelimiters", "ListType", "Lorg/jetbrains/kotlin/psi/KtElement;", "changeInfo", "Lcom/intellij/refactoring/changeSignature/ChangeInfo;", "originalList", "newList", "listReplacer", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "itemsFun", "", "(Lcom/intellij/refactoring/changeSignature/ChangeInfo;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/psi/KtElement;", "canMoveLambdaOutsideParentheses", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "KaSession", "skipComplexCalls", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;Z)Z", "parentLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getDeclarationBody", "isInsideOfCallerBody", "allUsages", "", "Lcom/intellij/usageView/UsageInfo;", "isCaller", "(Lorg/jetbrains/kotlin/psi/KtElement;[Lcom/intellij/usageView/UsageInfo;Lkotlin/jvm/functions/Function2;)Z", "deleteWithCompanion", "getAllExtractionContainers", "strict", "getExtractionContainers", "includeAll", "acceptScript", "addElement", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "element", "addNewLine", "checkConflictsInteractively", "Lcom/intellij/openapi/project/Project;", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "onShowConflicts", "Lkotlin/Function0;", "onAccept", "hasIdentifiersOnly", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/kotlin/name/FqName;", "singleLambdaArgumentExpression", "appendCallOrQualifiedExpression", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "call", "newFunctionName", "removeOverrideModifier", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nkotlinCommonRefactoringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinCommonRefactoringUtil.kt\norg/jetbrains/kotlin/idea/refactoring/KotlinCommonRefactoringUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 7 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,443:1\n12637#2,2:444\n5298#2,7:467\n11228#2:476\n11563#2,3:477\n1310#2,2:520\n1788#3,4:446\n1761#3,3:452\n1869#3,2:455\n1869#3,2:457\n1761#3,3:459\n1869#3,2:462\n1869#3,2:464\n1869#3,2:474\n1869#3,2:482\n808#3,11:485\n1740#3,3:496\n808#3,11:502\n1740#3,3:514\n1740#3,3:517\n183#4,2:450\n1255#4,2:480\n183#4,2:500\n1#5:466\n213#6:484\n213#6:499\n73#7:513\n*S KotlinDebug\n*F\n+ 1 kotlinCommonRefactoringUtil.kt\norg/jetbrains/kotlin/idea/refactoring/KotlinCommonRefactoringUtilKt\n*L\n66#1:444,2\n158#1:467,7\n166#1:476\n166#1:477,3\n438#1:520,2\n102#1:446,4\n129#1:452,3\n131#1:455,2\n132#1:457,2\n135#1:459,3\n136#1:462,2\n137#1:464,2\n158#1:474,2\n179#1:482,2\n245#1:485,11\n248#1:496,3\n356#1:502,11\n405#1:514,3\n406#1:517,3\n116#1:450,2\n167#1:480,2\n288#1:500,2\n222#1:484\n273#1:499\n390#1:513\n*E\n"})
public final class KotlinCommonRefactoringUtilKt {
    @NotNull
    public static final PsiNamedElement nameDeterminant(@NotNull PsiElement $this$nameDeterminant) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$nameDeterminant, (String)"<this>");
        if ($this$nameDeterminant instanceof KtConstructor) {
            KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$nameDeterminant));
            if (ktClass == null) {
                throw new IllegalStateException("Constructor had no containing class".toString());
            }
            psiElement = (PsiElement)ktClass;
        } else if ($this$nameDeterminant instanceof PsiMethod && ((PsiMethod)$this$nameDeterminant).isConstructor()) {
            PsiClass psiClass = ((PsiMethod)$this$nameDeterminant).getContainingClass();
            if (psiClass == null) {
                throw new IllegalStateException("Constructor had no containing class".toString());
            }
            psiElement = (PsiElement)psiClass;
        } else {
            psiElement = $this$nameDeterminant;
        }
        return (PsiNamedElement)psiElement;
    }

    @NotNull
    public static final PsiElement getContainer(@NotNull PsiElement $this$getContainer) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$getContainer, (String)"<this>");
        if ($this$getContainer instanceof KtElement) {
            Class[] classArray = new Class[]{KtPropertyAccessor.class, KtParameter.class, KtProperty.class, KtNamedFunction.class, KtConstructor.class, KtClassOrObject.class};
            KtDeclarationStub ktDeclarationStub = (KtDeclarationStub)PsiTreeUtil.getParentOfType((PsiElement)$this$getContainer, (Class[])classArray);
            NavigatablePsiElement navigatablePsiElement = ktDeclarationStub != null ? (NavigatablePsiElement)ktDeclarationStub : (NavigatablePsiElement)((KtElement)$this$getContainer).getContainingFile();
            Intrinsics.checkNotNull((Object)navigatablePsiElement);
            psiElement = (PsiElement)navigatablePsiElement;
        } else {
            PsiElement psiElement2 = ConflictsUtil.getContainer((PsiElement)$this$getContainer);
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getContainer(...)");
        }
        return psiElement;
    }

    @NotNull
    public static final KtFile createTempCopy(@NotNull KtFile $this$createTempCopy, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)$this$createTempCopy, (String)"<this>");
        KtPsiFactory ktPsiFactory = KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)((PsiElement)$this$createTempCopy), (boolean)false, (boolean)false, (int)6, null);
        String string = $this$createTempCopy.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = text;
        if (string2 == null && (string2 = $this$createTempCopy.getText()) == null) {
            string2 = "";
        }
        KtFile tmpFile = ktPsiFactory.createFile(string, string2);
        tmpFile.setOriginalFile((PsiFile)$this$createTempCopy);
        return tmpFile;
    }

    public static /* synthetic */ KtFile createTempCopy$default(KtFile ktFile2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return KotlinCommonRefactoringUtilKt.createTempCopy(ktFile2, string);
    }

    public static final boolean canRefactorElement(@NotNull PsiElement $this$canRefactorElement) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$canRefactorElement, (String)"<this>");
            if (!$this$canRefactorElement.isValid()) {
                bl = false;
            } else if ($this$canRefactorElement instanceof PsiPackage) {
                PsiDirectory[] psiDirectoryArray = ((PsiPackage)$this$canRefactorElement).getDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                Object[] $this$any$iv = psiDirectoryArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiDirectory it = (PsiDirectory)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!KotlinCommonRefactoringUtilKt.canRefactorElement((PsiElement)it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            } else {
                bl = $this$canRefactorElement instanceof KtElement || $this$canRefactorElement instanceof PsiMember && Intrinsics.areEqual((Object)((PsiMember)$this$canRefactorElement).getLanguage(), (Object)JavaLanguage.INSTANCE) || $this$canRefactorElement instanceof PsiDirectory ? SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, true, false, 47, null), $this$canRefactorElement) : false;
            }
        }
        return bl;
    }

    public static final boolean isOpen(@NotNull KtClass $this$isOpen) {
        Intrinsics.checkNotNullParameter((Object)$this$isOpen, (String)"<this>");
        return $this$isOpen.hasModifier(KtTokens.OPEN_KEYWORD) || KotlinCommonRefactoringUtilKt.isAbstract((KtDeclaration)$this$isOpen) || KotlinCommonRefactoringUtilKt.isInterfaceClass((PsiElement)$this$isOpen) || $this$isOpen.isSealed();
    }

    public static final boolean isInterfaceClass(@NotNull PsiElement $this$isInterfaceClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterfaceClass, (String)"<this>");
        PsiElement psiElement = $this$isInterfaceClass;
        return psiElement instanceof KtClass ? ((KtClass)$this$isInterfaceClass).isInterface() : (psiElement instanceof PsiClass ? ((PsiClass)$this$isInterfaceClass).isInterface() : (psiElement instanceof KtPsiClassWrapper ? ((KtPsiClassWrapper)$this$isInterfaceClass).getPsiClass().isInterface() : false));
    }

    public static final boolean isAbstract(@NotNull KtDeclaration $this$isAbstract) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isAbstract, (String)"<this>");
        if ($this$isAbstract.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = true;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)$this$isAbstract);
            boolean bl2 = ktClassOrObject != null ? KotlinCommonRefactoringUtilKt.isInterfaceClass((PsiElement)ktClassOrObject) : false;
            bl = !bl2 ? false : ($this$isAbstract instanceof KtProperty ? ((KtProperty)$this$isAbstract).getInitializer() == null && ((KtProperty)$this$isAbstract).getDelegate() == null && ((KtProperty)$this$isAbstract).getAccessors().isEmpty() : ($this$isAbstract instanceof KtNamedFunction ? !((KtNamedFunction)$this$isAbstract).hasBody() : false));
        }
        return bl;
    }

    public static final boolean isCompanionMemberOf(@NotNull KtNamedDeclaration $this$isCompanionMemberOf, @NotNull KtClassOrObject klass) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompanionMemberOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isCompanionMemberOf));
        KtObjectDeclaration ktObjectDeclaration = ktClassOrObject instanceof KtObjectDeclaration ? (KtObjectDeclaration)ktClassOrObject : null;
        if (ktObjectDeclaration == null) {
            return false;
        }
        KtObjectDeclaration containingObject = ktObjectDeclaration;
        return containingObject.isCompanion() && Intrinsics.areEqual((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)containingObject)), (Object)klass);
    }

    @Nullable
    public static final KtLambdaExpression getLastLambdaExpression(@NotNull KtCallExpression $this$getLastLambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastLambdaExpression, (String)"<this>");
        List list2 = $this$getLastLambdaExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        if (!((Collection)list2).isEmpty()) {
            return null;
        }
        List list3 = $this$getLastLambdaExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull((List)list3);
        return ktValueArgument != null && (ktValueArgument = ktValueArgument.getArgumentExpression()) != null ? KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktValueArgument, (boolean)false, (int)1, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isComplexCallWithLambdaArgument(@NotNull KtCallExpression $this$isComplexCallWithLambdaArgument) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isComplexCallWithLambdaArgument, (String)"<this>");
        List list2 = $this$isComplexCallWithLambdaArgument.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull((List)list2);
        boolean bl2 = ktValueArgument != null ? ktValueArgument.isNamed() : false;
        if (bl2) {
            bl = true;
        } else {
            boolean bl3;
            List list3 = $this$isComplexCallWithLambdaArgument.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueArguments(...)");
            Iterable $this$count$iv = list3;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                bl3 = false;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KtValueArgument it = (KtValueArgument)element$iv;
                    boolean bl4 = false;
                    KtExpression ktExpression = it.getArgumentExpression();
                    if (!((ktExpression != null ? KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktExpression, (boolean)false, (int)1, null) : null) != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                bl3 = var3_3;
            }
            bl = bl3 > true;
        }
        return bl;
    }

    public static final void moveFunctionLiteralOutsideParentheses(@NotNull KtCallExpression $this$moveFunctionLiteralOutsideParentheses, @Nullable Function1<? super Integer, Unit> moveCaretTo) {
        block27: {
            KtExpression it;
            KtValueArgument argument2;
            List arguments2;
            KtValueArgumentList argumentList;
            block26: {
                boolean bl;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                PsiElement it2;
                List nextComments2;
                block25: {
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    KtLambdaArgument functionLiteralArgument;
                    KtPsiFactory psiFactory;
                    List prevComments2;
                    block24: {
                        List list22;
                        List list3;
                        PsiElement $i$f$firstOrNull2;
                        List list4;
                        PsiElement prevComma;
                        PsiElement psiElement;
                        Object v4;
                        PsiElement it3;
                        Object element$iv;
                        Iterator iterator2;
                        KtExpression expression;
                        block23: {
                            boolean bl3;
                            Intrinsics.checkNotNullParameter((Object)$this$moveFunctionLiteralOutsideParentheses, (String)"<this>");
                            boolean bl4 = $this$moveFunctionLiteralOutsideParentheses.getLambdaArguments().isEmpty();
                            if (_Assertions.ENABLED && !bl4) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            KtValueArgumentList ktValueArgumentList = $this$moveFunctionLiteralOutsideParentheses.getValueArgumentList();
                            Intrinsics.checkNotNull((Object)ktValueArgumentList);
                            argumentList = ktValueArgumentList;
                            List list5 = argumentList.getArguments();
                            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getArguments(...)");
                            arguments2 = list5;
                            argument2 = (KtValueArgument)CollectionsKt.last((List)arguments2);
                            KtExpression ktExpression = argument2.getArgumentExpression();
                            Intrinsics.checkNotNull((Object)ktExpression);
                            expression = ktExpression;
                            boolean bl5 = bl3 = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)expression, (boolean)false, (int)1, null) != null;
                            if (_Assertions.ENABLED && !bl3) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            Intrinsics.checkNotNull((Object)argument2);
                            Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)argument2), (boolean)false, (boolean)false);
                            boolean $i$f$firstOrNull2 = false;
                            iterator2 = $this$firstOrNull$iv.iterator();
                            while (iterator2.hasNext()) {
                                element$iv = iterator2.next();
                                it3 = (PsiElement)element$iv;
                                boolean list22 = false;
                                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it3), (Object)KtTokens.COMMA)) continue;
                                v4 = element$iv;
                                break block23;
                            }
                            v4 = null;
                        }
                        if ((psiElement = (prevComma = (PsiElement)v4)) == null) {
                            psiElement = argumentList.getLeftParenthesis();
                        }
                        if ((list4 = ($i$f$firstOrNull2 = psiElement) != null && (iterator2 = PsiUtilsKt.siblings((PsiElement)$i$f$firstOrNull2, (boolean)true, (boolean)false)) != null && (element$iv = SequencesKt.takeWhile((Sequence)iterator2, (Function1)moveFunctionLiteralOutsideParentheses.prevComments.1.INSTANCE)) != null ? SequencesKt.toList(element$iv) : null) == null) {
                            list4 = prevComments2 = CollectionsKt.emptyList();
                        }
                        if ((list3 = (iterator2 = argumentList.getRightParenthesis()) != null && (element$iv = PsiUtilsKt.siblings((PsiElement)iterator2, (boolean)false, (boolean)false)) != null && (it3 = SequencesKt.takeWhile(element$iv, (Function1)moveFunctionLiteralOutsideParentheses.nextComments.1.INSTANCE)) != null && (list22 = SequencesKt.toList((Sequence)it3)) != null ? CollectionsKt.reversed((Iterable)list22) : null) == null) {
                            list3 = CollectionsKt.emptyList();
                        }
                        nextComments2 = list3;
                        Project project = $this$moveFunctionLiteralOutsideParentheses.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        psiFactory = new KtPsiFactory(project, false, 2, null);
                        KtExpression ktExpression = psiFactory.createExpression("foo() {}");
                        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                        KtCallExpression dummyCall2 = (KtCallExpression)ktExpression;
                        List list6 = dummyCall2.getLambdaArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getLambdaArguments(...)");
                        functionLiteralArgument = (KtLambdaArgument)CollectionsKt.single((List)list6);
                        KtExpression ktExpression2 = functionLiteralArgument.getArgumentExpression();
                        if (ktExpression2 != null) {
                            ktExpression2.replace((PsiElement)expression);
                        }
                        $this$any$iv = prevComments2;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it2 = (PsiElement)element$iv2;
                                boolean bl6 = false;
                                if (!(it2 instanceof PsiComment)) continue;
                                bl2 = true;
                                break block24;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        if (!(CollectionsKt.firstOrNull((List)prevComments2) instanceof PsiWhiteSpace)) {
                            $this$moveFunctionLiteralOutsideParentheses.add(psiFactory.createWhiteSpace());
                        }
                        $this$forEach$iv = prevComments2;
                        $i$f$forEach = false;
                        for (Object element$iv2 : $this$forEach$iv) {
                            it2 = (PsiElement)element$iv2;
                            boolean bl7 = false;
                            $this$moveFunctionLiteralOutsideParentheses.add(it2);
                        }
                        $this$forEach$iv = prevComments2;
                        $i$f$forEach = false;
                        for (Object element$iv2 : $this$forEach$iv) {
                            it2 = (PsiElement)element$iv2;
                            boolean bl8 = false;
                            if (!(it2 instanceof PsiComment)) continue;
                            it2.delete();
                        }
                    }
                    $this$moveFunctionLiteralOutsideParentheses.add((PsiElement)functionLiteralArgument);
                    $this$any$iv = nextComments2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it2 = (PsiElement)element$iv2;
                            boolean bl9 = false;
                            if (!(it2 instanceof PsiComment)) continue;
                            bl = true;
                            break block25;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    $this$forEach$iv = nextComments2;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        it2 = (PsiElement)element$iv2;
                        boolean bl10 = false;
                        $this$moveFunctionLiteralOutsideParentheses.add(it2);
                    }
                    $this$forEach$iv = nextComments2;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        it2 = (PsiElement)element$iv2;
                        boolean bl11 = false;
                        if (!(it2 instanceof PsiComment)) continue;
                        it2.delete();
                    }
                }
                if (argumentList.getArguments().size() != 1 || $this$moveFunctionLiteralOutsideParentheses.getCalleeExpression() instanceof KtCallExpression) break block26;
                argumentList.delete();
                KtExpression ktExpression = $this$moveFunctionLiteralOutsideParentheses.getCalleeExpression();
                if (ktExpression == null) break block27;
                it = ktExpression;
                boolean bl12 = false;
                Function1<? super Integer, Unit> function1 = moveCaretTo;
                if (function1 != null) {
                    function1.invoke((Object)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
                }
                break block27;
            }
            argumentList.removeArgument(argument2);
            if (arguments2.size() <= 1) break block27;
            KtValueArgument ktValueArgument = (KtValueArgument)arguments2.get(arguments2.size() - 2);
            if (ktValueArgument != null) {
                it = ktValueArgument;
                boolean bl = false;
                Function1<? super Integer, Unit> function1 = moveCaretTo;
                if (function1 != null) {
                    function1.invoke((Object)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)));
                }
            }
        }
    }

    public static /* synthetic */ void moveFunctionLiteralOutsideParentheses$default(KtCallExpression ktCallExpression, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses(ktCallExpression, (Function1<? super Integer, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <ListType extends KtElement> ListType replaceListPsiAndKeepDelimiters(@NotNull ChangeInfo changeInfo, @NotNull ListType originalList, @NotNull ListType newList, @NotNull Function2<? super ListType, ? super ListType, ? extends ListType> listReplacer, @NotNull Function1<? super ListType, ? extends List<? extends KtElement>> itemsFun) {
        block22: {
            PsiElement psiElement;
            boolean withMultiline;
            int commonCount;
            int newCount;
            List newParameters2;
            List list2;
            block21: {
                boolean keepComments;
                boolean bl;
                List originalIndexes;
                PsiElement it;
                int oldCount;
                block20: {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)changeInfo, (String)"changeInfo");
                    Intrinsics.checkNotNullParameter(originalList, (String)"originalList");
                    Intrinsics.checkNotNullParameter(newList, (String)"newList");
                    Intrinsics.checkNotNullParameter(listReplacer, (String)"listReplacer");
                    Intrinsics.checkNotNullParameter(itemsFun, (String)"itemsFun");
                    PsiElement[] psiElementArray = ((PsiElement)originalList).getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    Object[] objectArray = psiElementArray;
                    boolean $i$f$takeWhile = false;
                    ArrayList list$iv = new ArrayList();
                    for (Object item$iv : objectArray) {
                        PsiElement it2 = (PsiElement)item$iv;
                        boolean bl2 = false;
                        if (!(it2 instanceof PsiErrorElement)) break;
                        list$iv.add(item$iv);
                    }
                    Iterable iterable = list$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : iterable) {
                        PsiElement it3 = (PsiElement)element$iv;
                        boolean bl3 = false;
                        it3.delete();
                    }
                    list2 = CollectionsKt.toMutableList((Collection)((Collection)itemsFun.invoke(originalList)));
                    newParameters2 = (List)itemsFun.invoke(newList);
                    oldCount = list2.size();
                    newCount = newParameters2.size();
                    commonCount = Math.min(oldCount, newCount);
                    ParameterInfo[] parameterInfoArray = changeInfo.getNewParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)parameterInfoArray, (String)"getNewParameters(...)");
                    Object[] $this$map$iv = parameterInfoArray;
                    boolean $i$f$map = false;
                    Object[] objectArray2 = $this$map$iv;
                    Iterator destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        ParameterInfo parameterInfo = (ParameterInfo)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(it.getOldIndex());
                    }
                    originalIndexes = (List)((Object)destination$iv$iv);
                    Sequence $this$any$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)originalList));
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it4 = (PsiElement)element$iv;
                        boolean bl5 = false;
                        if (!(it4 instanceof PsiComment)) continue;
                        bl = true;
                        break block20;
                    }
                    bl = false;
                }
                boolean bl2 = keepComments = bl && oldCount > commonCount && Intrinsics.areEqual((Object)originalIndexes, (Object)CollectionsKt.sorted((Iterable)originalIndexes));
                if (!keepComments) {
                    for (int i2 = 0; i2 < commonCount; ++i2) {
                        PsiElement psiElement2 = ((KtElement)list2.get(i2)).replace((PsiElement)newParameters2.get(i2));
                        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                        list2.set(i2, (KtElement)psiElement2);
                    }
                }
                if (commonCount == 0 && !keepComments) {
                    return (ListType)((KtElement)listReplacer.invoke(originalList, newList));
                }
                if (oldCount <= commonCount) break block21;
                if (keepComments) {
                    Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)((Iterable)RangesKt.until((int)0, (int)list2.size())), (Iterable)originalIndexes);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiElement nextComma;
                        int index2 = ((Number)element$iv).intValue();
                        boolean bl7 = false;
                        KtElement oldParameter = (KtElement)list2.get(index2);
                        if (PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)oldParameter), (boolean)false, (int)1, null) != null) {
                            PsiElement it5 = it;
                            boolean bl8 = false;
                            v5 = Intrinsics.areEqual((Object)it5.getNode().getElementType(), (Object)KtTokens.COMMA) ? it : null;
                        } else {
                            v5 = nextComma = null;
                        }
                        if (nextComma != null) {
                            nextComma.delete();
                        } else {
                            Object object = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)oldParameter), (boolean)false, (int)1, null);
                            if (object != null) {
                                PsiElement psiElement3;
                                PsiElement it6 = psiElement3 = object;
                                boolean bl9 = false;
                                object = Intrinsics.areEqual((Object)it6.getNode().getElementType(), (Object)KtTokens.COMMA) ? psiElement3 : null;
                                if (object != null) {
                                    object.delete();
                                }
                            }
                        }
                        oldParameter.delete();
                    }
                } else {
                    ((PsiElement)originalList).deleteChildRange(((KtElement)list2.get(commonCount - 1)).getNextSibling(), (PsiElement)CollectionsKt.last((List)list2));
                }
                break block22;
            }
            if (newCount <= commonCount) break block22;
            KtElement lastOriginalParameter = (KtElement)CollectionsKt.last((List)list2);
            PsiElement psiBeforeLastParameter = lastOriginalParameter.getPrevSibling();
            boolean bl = withMultiline = (psiBeforeLastParameter instanceof PsiWhiteSpace || psiBeforeLastParameter instanceof PsiComment) && psiBeforeLastParameter.textContains('\n');
            if (withMultiline) {
                Project project = ((PsiElement)originalList).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiElement = new KtPsiFactory(project, false, 2, null).createNewLine();
            } else {
                psiElement = null;
            }
            PsiElement extraSpace = psiElement;
            ((PsiElement)originalList).addRangeAfter(((KtElement)newParameters2.get(commonCount - 1)).getNextSibling(), (PsiElement)CollectionsKt.last((List)newParameters2), (PsiElement)lastOriginalParameter);
            if (extraSpace != null) {
                List addedItems = ((List)itemsFun.invoke(originalList)).subList(commonCount, newCount);
                for (KtElement addedItem : addedItems) {
                    PsiElement elementBefore = addedItem.getPrevSibling();
                    if ((elementBefore instanceof PsiWhiteSpace || elementBefore instanceof PsiComment) && elementBefore.textContains('\n')) continue;
                    addedItem.getParent().addBefore(extraSpace, (PsiElement)addedItem);
                }
            }
        }
        return originalList;
    }

    public static /* synthetic */ KtElement replaceListPsiAndKeepDelimiters$default(ChangeInfo changeInfo, KtElement ktElement, KtElement ktElement2, Function2 function2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = KotlinCommonRefactoringUtilKt::replaceListPsiAndKeepDelimiters$lambda$11;
        }
        return KotlinCommonRefactoringUtilKt.replaceListPsiAndKeepDelimiters(changeInfo, ktElement, ktElement2, function2, function1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public static final boolean canMoveLambdaOutsideParentheses(@NotNull KaSession $context_receiver_0, @NotNull KtCallExpression $this$canMoveLambdaOutsideParentheses, boolean skipComplexCalls) {
        KaVariableSignature<KaValueParameterSymbol> lastParameter;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)$this$canMoveLambdaOutsideParentheses, (String)"<this>");
        if (skipComplexCalls && KotlinCommonRefactoringUtilKt.isComplexCallWithLambdaArgument($this$canMoveLambdaOutsideParentheses)) {
            return false;
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$canMoveLambdaOutsideParentheses;
        boolean $i$f$getStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDelegatedSuperTypeEntry.class, (boolean)true) != null) {
            return false;
        }
        KtLambdaExpression ktLambdaExpression = KotlinCommonRefactoringUtilKt.getLastLambdaExpression($this$canMoveLambdaOutsideParentheses);
        if (ktLambdaExpression == null) {
            return false;
        }
        KtLambdaExpression lastLambdaExpression = ktLambdaExpression;
        KtLabeledExpression ktLabeledExpression = KotlinCommonRefactoringUtilKt.parentLabeledExpression((KtExpression)lastLambdaExpression);
        if ((ktLabeledExpression != null ? KotlinCommonRefactoringUtilKt.parentLabeledExpression((KtExpression)ktLabeledExpression) : null) != null) {
            return false;
        }
        KtExpression callee = $this$canMoveLambdaOutsideParentheses.getCalleeExpression();
        if (!(callee instanceof KtNameReferenceExpression)) {
            return true;
        }
        KaCallInfo kaCallInfo = $context_receiver_0.resolveToCall((KtElement)callee);
        if (kaCallInfo == null) {
            return false;
        }
        KaCallInfo resolveCall = kaCallInfo;
        KaFunctionCall<?> call2 = KaCallInfoKt.successfulFunctionCallOrNull(resolveCall);
        if (call2 == null) {
            boolean bl;
            List list2;
            KaType paramType;
            KaLifetimeOwner kaLifetimeOwner = KaCallInfoKt.successfulVariableAccessCall(resolveCall);
            KaType kaType = kaLifetimeOwner != null && (kaLifetimeOwner = kaLifetimeOwner.getPartiallyAppliedSymbol()) != null && (kaLifetimeOwner = (KaVariableSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaLifetimeOwner)) != null ? ((KaCallableSymbol)kaLifetimeOwner).getReturnType() : (paramType = null);
            if (paramType != null && KotlinCommonRefactoringUtilKt.canMoveLambdaOutsideParentheses$isFunctionalType(paramType, $context_receiver_0)) {
                return true;
            }
            Object object = resolveCall instanceof KaErrorCallInfo ? (KaErrorCallInfo)resolveCall : null;
            if (object != null && (object = object.getCandidateCalls()) != null) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = (Iterable)object;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KaSimpleFunctionCall)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List calls = list2;
            if (calls.isEmpty()) return true;
            Iterable $this$all$iv = calls;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                KaVariableSignature lastParameter2;
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                KaSimpleFunctionCall functionalCall = (KaSimpleFunctionCall)element$iv;
                boolean bl2 = false;
                KaVariableSignature kaVariableSignature = lastParameter2 = (KaVariableSignature)CollectionsKt.lastOrNull(((KaFunctionSignature)functionalCall.getPartiallyAppliedSymbol().getSignature()).getValueParameters());
                if (kaVariableSignature == null) return false;
                KaType kaType2 = kaVariableSignature.getReturnType();
                KaType lastParameterType = kaType2;
                if (lastParameterType == null) return false;
                if (!KotlinCommonRefactoringUtilKt.canMoveLambdaOutsideParentheses$isFunctionalType(lastParameterType, $context_receiver_0)) return false;
                bl = true;
            } while (bl);
            return false;
        }
        KaVariableSignature<KaValueParameterSymbol> kaVariableSignature = call2.getArgumentMapping().get(lastLambdaExpression);
        if (kaVariableSignature == null) {
            KtLabeledExpression ktLabeledExpression2 = KotlinCommonRefactoringUtilKt.parentLabeledExpression((KtExpression)lastLambdaExpression);
            if (ktLabeledExpression2 == null) return false;
            KtLabeledExpression ktLabeledExpression3 = ktLabeledExpression2;
            Map<KtExpression, KaVariableSignature<KaValueParameterSymbol>> map2 = call2.getArgumentMapping();
            KtExpression p0 = (KtExpression)ktLabeledExpression3;
            boolean bl = false;
            KaVariableSignature<KaValueParameterSymbol> kaVariableSignature2 = map2.get(p0);
            kaVariableSignature = kaVariableSignature2;
            if (kaVariableSignature2 == null) {
                return false;
            }
        }
        if (((KaValueParameterSymbol)(lastParameter = kaVariableSignature).getSymbol()).isVararg()) {
            return false;
        }
        KaVariableSignature kaVariableSignature3 = (KaVariableSignature)CollectionsKt.lastOrNull(((KaFunctionSignature)call2.getPartiallyAppliedSymbol().getSignature()).getValueParameters());
        if (!Intrinsics.areEqual(lastParameter.getSymbol(), (Object)(kaVariableSignature3 != null ? (KaValueParameterSymbol)kaVariableSignature3.getSymbol() : null))) {
            return false;
        }
        boolean bl = KotlinCommonRefactoringUtilKt.canMoveLambdaOutsideParentheses$isFunctionalType(lastParameter.getReturnType(), $context_receiver_0);
        return bl;
    }

    public static /* synthetic */ boolean canMoveLambdaOutsideParentheses$default(KaSession kaSession, KtCallExpression ktCallExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return KotlinCommonRefactoringUtilKt.canMoveLambdaOutsideParentheses(kaSession, ktCallExpression, bl);
    }

    @ApiStatus.Internal
    @Nullable
    public static final KtLabeledExpression parentLabeledExpression(@NotNull KtExpression $this$parentLabeledExpression) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$parentLabeledExpression, (String)"<this>");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$parentLabeledExpression;
        boolean $i$f$getStrictParentOfType = false;
        KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtLabeledExpression.class, (boolean)true);
        if (ktLabeledExpression != null) {
            KtLabeledExpression ktLabeledExpression2;
            KtLabeledExpression it = ktLabeledExpression2 = ktLabeledExpression;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getBaseExpression(), (Object)$this$parentLabeledExpression) ? ktLabeledExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final KtElement getDeclarationBody(@NotNull KtNamedDeclaration $this$getDeclarationBody) {
        Intrinsics.checkNotNullParameter((Object)$this$getDeclarationBody, (String)"<this>");
        KtNamedDeclaration ktNamedDeclaration = $this$getDeclarationBody;
        return ktNamedDeclaration instanceof KtClassOrObject ? (KtElement)((KtClassOrObject)$this$getDeclarationBody).getSuperTypeList() : (ktNamedDeclaration instanceof KtPrimaryConstructor ? (KtElement)((KtPrimaryConstructor)$this$getDeclarationBody).getContainingClassOrObject().getSuperTypeList() : (ktNamedDeclaration instanceof KtSecondaryConstructor ? (KtElement)((KtSecondaryConstructor)$this$getDeclarationBody).getDelegationCall() : (ktNamedDeclaration instanceof KtNamedFunction ? (KtElement)((KtNamedFunction)$this$getDeclarationBody).getBodyExpression() : null)));
    }

    public static final boolean isInsideOfCallerBody(@NotNull KtElement $this$isInsideOfCallerBody, @NotNull UsageInfo[] allUsages, @NotNull Function2<? super PsiElement, ? super UsageInfo[], Boolean> isCaller) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isInsideOfCallerBody, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)allUsages, (String)"allUsages");
            Intrinsics.checkNotNullParameter(isCaller, (String)"isCaller");
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)$this$isInsideOfCallerBody));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtNamedFunction || it instanceof KtConstructor || it instanceof KtClassOrObject)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Object var5_9 = v0;
        KtNamedDeclaration ktNamedDeclaration = var5_9 instanceof KtNamedDeclaration ? (KtNamedDeclaration)var5_9 : null;
        if (ktNamedDeclaration == null) {
            return false;
        }
        KtNamedDeclaration container = ktNamedDeclaration;
        KtElement ktElement = KotlinCommonRefactoringUtilKt.getDeclarationBody(container);
        if (ktElement == null) {
            return false;
        }
        KtElement body2 = ktElement;
        return body2.getTextRange().contains($this$isInsideOfCallerBody.getTextRange()) && (Boolean)isCaller.invoke((Object)container, (Object)allUsages) != false;
    }

    public static final void deleteWithCompanion(@NotNull KtNamedDeclaration $this$deleteWithCompanion) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteWithCompanion, (String)"<this>");
        KtClassOrObject containingClass = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$deleteWithCompanion));
        if (containingClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClass).isCompanion() && ((KtObjectDeclaration)containingClass).getDeclarations().size() == 1 && ((KtObjectDeclaration)containingClass).getSuperTypeList() == null) {
            ((KtObjectDeclaration)containingClass).delete();
        } else {
            $this$deleteWithCompanion.delete();
        }
    }

    @NotNull
    public static final List<KtElement> getAllExtractionContainers(@NotNull PsiElement $this$getAllExtractionContainers, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllExtractionContainers, (String)"<this>");
        ArrayList<KtElement> containers = new ArrayList<KtElement>();
        boolean objectOrNonInnerNestedClassFound = false;
        Sequence parents = strict ? PsiUtilsKt.getParents((PsiElement)$this$getAllExtractionContainers) : PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getAllExtractionContainers);
        for (PsiElement element : parents) {
            PsiElement psiElement = element;
            boolean bl = psiElement instanceof KtFile ? true : (psiElement instanceof KtClassBody ? !objectOrNonInnerNestedClassFound || ((KtClassBody)element).getParent() instanceof KtObjectDeclaration : (psiElement instanceof KtBlockExpression ? !objectOrNonInnerNestedClassFound : false));
            boolean isValidContainer = bl;
            if (!isValidContainer) continue;
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            containers.add((KtElement)element);
            if (objectOrNonInnerNestedClassFound) continue;
            PsiElement psiElement2 = element;
            KtClassBody ktClassBody = psiElement2 instanceof KtClassBody ? (KtClassBody)psiElement2 : null;
            PsiElement bodyParent = ktClassBody != null ? ktClassBody.getParent() : null;
            objectOrNonInnerNestedClassFound = bodyParent instanceof KtObjectDeclaration && !((KtObjectDeclaration)bodyParent).isObjectLiteral() || bodyParent instanceof KtClass && !((KtClass)bodyParent).isInner();
        }
        return containers;
    }

    public static /* synthetic */ List getAllExtractionContainers$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinCommonRefactoringUtilKt.getAllExtractionContainers(psiElement, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtElement> getExtractionContainers(@NotNull PsiElement $this$getExtractionContainers, boolean strict, boolean includeAll, boolean acceptScript) {
        List<Object> list2;
        PsiElement enclosingDeclaration;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$getExtractionContainers, (String)"<this>");
        if (includeAll) {
            return KotlinCommonRefactoringUtilKt.getAllExtractionContainers($this$getExtractionContainers, strict);
        }
        PsiElement psiElement2 = KotlinCommonRefactoringUtilKt.getExtractionContainers$getEnclosingDeclaration(acceptScript, $this$getExtractionContainers, strict);
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            psiElement = it instanceof KtDeclarationWithBody || it instanceof KtAnonymousInitializer ? KotlinCommonRefactoringUtilKt.getExtractionContainers$getEnclosingDeclaration(acceptScript, it, true) : it;
        } else {
            psiElement = null;
        }
        PsiElement psiElement3 = enclosingDeclaration = psiElement;
        if (psiElement3 instanceof KtFile) {
            List<PsiElement> list3 = Collections.singletonList(enclosingDeclaration);
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"singletonList(...)");
        } else if (psiElement3 instanceof KtScript) {
            List<PsiElement> list4 = Collections.singletonList(enclosingDeclaration);
            list2 = list4;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"singletonList(...)");
        } else if (psiElement3 instanceof KtClassBody) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = KotlinCommonRefactoringUtilKt.getAllExtractionContainers($this$getExtractionContainers, strict);
            boolean $i$f$filterIsInstance = false;
            Iterable bl = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtClassBody)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            PsiElement psiElement4 = enclosingDeclaration;
            KtExpression targetContainer = psiElement4 instanceof KtDeclarationWithBody ? ((KtDeclarationWithBody)enclosingDeclaration).getBodyExpression() : (psiElement4 instanceof KtAnonymousInitializer ? ((KtAnonymousInitializer)enclosingDeclaration).getBody() : null);
            List<Object> list5 = targetContainer instanceof KtBlockExpression ? Collections.singletonList(targetContainer) : Collections.emptyList();
            Intrinsics.checkNotNull(list5);
            list2 = list5;
        }
        return list2;
    }

    public static /* synthetic */ List getExtractionContainers$default(PsiElement psiElement, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return KotlinCommonRefactoringUtilKt.getExtractionContainers(psiElement, bl, bl2, bl3);
    }

    @NotNull
    public static final KtElement addElement(@NotNull KtBlockExpression $this$addElement, @NotNull KtElement element, boolean addNewLine) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement rBrace = $this$addElement.getRBrace();
        Project project = $this$addElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement newLine = new KtPsiFactory(project, false, 2, null).createNewLine();
        if (rBrace == null) {
            PsiElement lastChild = $this$addElement.getLastChild();
            PsiWhiteSpace psiWhiteSpace = lastChild instanceof PsiWhiteSpace ? (PsiWhiteSpace)lastChild : null;
            if (psiWhiteSpace != null) {
                psiElement = (PsiElement)psiWhiteSpace;
            } else {
                PsiElement psiElement2 = $this$addElement.addAfter(newLine, lastChild);
                psiElement = psiElement2;
                Intrinsics.checkNotNull((Object)psiElement2);
            }
        } else {
            PsiElement psiElement3 = rBrace.getPrevSibling();
            psiElement = psiElement3;
            Intrinsics.checkNotNull((Object)psiElement3);
        }
        PsiElement anchor = psiElement;
        PsiElement psiElement4 = $this$addElement.addAfter((PsiElement)element, anchor);
        Intrinsics.checkNotNull((Object)psiElement4);
        KtElement addedElement = (KtElement)psiElement4;
        if (addNewLine) {
            $this$addElement.addAfter(newLine, (PsiElement)addedElement);
        }
        return addedElement;
    }

    public static /* synthetic */ KtElement addElement$default(KtBlockExpression ktBlockExpression, KtElement ktElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KotlinCommonRefactoringUtilKt.addElement(ktBlockExpression, ktElement, bl);
    }

    public static final void checkConflictsInteractively(@NotNull Project $this$checkConflictsInteractively, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Function0<Unit> onShowConflicts, @NotNull Function0<Unit> onAccept) {
        Intrinsics.checkNotNullParameter((Object)$this$checkConflictsInteractively, (String)"<this>");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Intrinsics.checkNotNullParameter(onShowConflicts, (String)"onShowConflicts");
        Intrinsics.checkNotNullParameter(onAccept, (String)"onAccept");
        if (!conflicts.isEmpty()) {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog dialog2 = new ConflictsDialog($this$checkConflictsInteractively, conflicts, () -> KotlinCommonRefactoringUtilKt.checkConflictsInteractively$lambda$25(onAccept));
            dialog2.show();
            if (!dialog2.isOK()) {
                if (dialog2.isShowConflicts()) {
                    onShowConflicts.invoke();
                }
                return;
            }
        }
        onAccept.invoke();
    }

    public static /* synthetic */ void checkConflictsInteractively$default(Project project, MultiMap multiMap, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = KotlinCommonRefactoringUtilKt::checkConflictsInteractively$lambda$24;
        }
        KotlinCommonRefactoringUtilKt.checkConflictsInteractively(project, (MultiMap<PsiElement, String>)multiMap, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    public static final boolean hasIdentifiersOnly(@NotNull FqNameUnsafe $this$hasIdentifiersOnly) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasIdentifiersOnly, (String)"<this>");
            Iterable $this$all$iv = $this$hasIdentifiersOnly.pathSegments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    String string = it.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    if (KtPsiUtilKt.isIdentifier((String)KtPsiUtilKt.quoteIfNeeded((String)string))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean hasIdentifiersOnly(@NotNull FqName $this$hasIdentifiersOnly) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasIdentifiersOnly, (String)"<this>");
            Iterable $this$all$iv = $this$hasIdentifiersOnly.pathSegments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    String string = it.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    if (KtPsiUtilKt.isIdentifier((String)KtPsiUtilKt.quoteIfNeeded((String)string))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public static final KtLambdaExpression singleLambdaArgumentExpression(@NotNull KtCallExpression $this$singleLambdaArgumentExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$singleLambdaArgumentExpression, (String)"<this>");
        List list2 = $this$singleLambdaArgumentExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getArgumentExpression()) == null || (ktLambdaArgument = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktLambdaArgument, (boolean)false, (int)1, null)) == null) {
            ktLambdaArgument = KotlinCommonRefactoringUtilKt.getLastLambdaExpression($this$singleLambdaArgumentExpression);
        }
        return ktLambdaArgument;
    }

    public static final void appendCallOrQualifiedExpression(@NotNull BuilderByPattern<KtExpression> $this$appendCallOrQualifiedExpression, @NotNull KtCallExpression call2, @NotNull String newFunctionName) {
        block4: {
            KtValueArgumentList it;
            KtExpression callOrQualified;
            Intrinsics.checkNotNullParameter($this$appendCallOrQualifiedExpression, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            Intrinsics.checkNotNullParameter((Object)newFunctionName, (String)"newFunctionName");
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)call2));
            KtExpression ktExpression = callOrQualified = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)call2;
            if (callOrQualified instanceof KtQualifiedExpression) {
                $this$appendCallOrQualifiedExpression.appendExpression(((KtQualifiedExpression)callOrQualified).getReceiverExpression());
                if (callOrQualified instanceof KtSafeQualifiedExpression) {
                    $this$appendCallOrQualifiedExpression.appendFixedText("?");
                }
                $this$appendCallOrQualifiedExpression.appendFixedText(".");
            }
            $this$appendCallOrQualifiedExpression.appendNonFormattedText(newFunctionName);
            KtValueArgumentList ktValueArgumentList = call2.getValueArgumentList();
            if (ktValueArgumentList != null) {
                it = ktValueArgumentList;
                boolean bl = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                $this$appendCallOrQualifiedExpression.appendNonFormattedText(string);
            }
            List list2 = call2.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list2);
            if (ktLambdaArgument == null) break block4;
            it = ktLambdaArgument;
            boolean bl = false;
            if (it.getArgumentExpression() instanceof KtLabeledExpression) {
                $this$appendCallOrQualifiedExpression.appendFixedText(" ");
            }
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            $this$appendCallOrQualifiedExpression.appendNonFormattedText(string);
        }
    }

    @ApiStatus.Internal
    public static final void removeOverrideModifier(@NotNull PsiElement $this$removeOverrideModifier) {
        Intrinsics.checkNotNullParameter((Object)$this$removeOverrideModifier, (String)"<this>");
        PsiElement psiElement = $this$removeOverrideModifier;
        if (psiElement instanceof KtNamedFunction || psiElement instanceof KtProperty) {
            KtModifierList ktModifierList = ((KtModifierListOwner)$this$removeOverrideModifier).getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) != null) {
                ktModifierList.delete();
            }
        } else if (psiElement instanceof PsiMethod) {
            Object object;
            block6: {
                PsiAnnotation[] psiAnnotationArray = ((PsiMethod)$this$removeOverrideModifier).getModifierList().getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                Object[] $this$firstOrNull$iv = psiAnnotationArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiAnnotation annotation = (PsiAnnotation)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    object = element$iv;
                    break block6;
                }
                object = null;
            }
            PsiAnnotation psiAnnotation = (PsiAnnotation)object;
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }
    }

    private static final boolean moveFunctionLiteralOutsideParentheses$isWhiteSpaceOrComment(PsiElement e) {
        return e instanceof PsiWhiteSpace || e instanceof PsiComment;
    }

    private static final KtElement replaceListPsiAndKeepDelimiters$lambda$11(KtElement ktElement, KtElement it) {
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = ((PsiElement)ktElement).replace((PsiElement)it);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type ListType of org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt.replaceListPsiAndKeepDelimiters");
        return (KtElement)psiElement;
    }

    private static final boolean canMoveLambdaOutsideParentheses$isFunctionalType(KaType $this$canMoveLambdaOutsideParentheses_u24isFunctionalType, KaSession $$context_receiver_0) {
        return $this$canMoveLambdaOutsideParentheses_u24isFunctionalType instanceof KaTypeParameterType || $$context_receiver_0.isSuspendFunctionType($this$canMoveLambdaOutsideParentheses_u24isFunctionalType) || $$context_receiver_0.isFunctionType($this$canMoveLambdaOutsideParentheses_u24isFunctionalType) || $$context_receiver_0.isFunctionalInterface($this$canMoveLambdaOutsideParentheses_u24isFunctionalType);
    }

    private static final boolean getExtractionContainers$getEnclosingDeclaration$lambda$22(boolean $acceptScript, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtDeclarationWithBody && !(it instanceof KtFunctionLiteral) && (!(it instanceof KtNamedFunction) || ((KtNamedFunction)it).getName() != null) || it instanceof KtAnonymousInitializer || it instanceof KtClassBody || it instanceof KtFile || $acceptScript && it instanceof KtScript;
    }

    private static final PsiElement getExtractionContainers$getEnclosingDeclaration(boolean $acceptScript, PsiElement element, boolean strict) {
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)(strict ? PsiUtilsKt.getParents((PsiElement)element) : PsiUtilsKt.getParentsWithSelf((PsiElement)element)), arg_0 -> KotlinCommonRefactoringUtilKt.getExtractionContainers$getEnclosingDeclaration$lambda$22($acceptScript, arg_0)));
    }

    private static final Unit checkConflictsInteractively$lambda$24() {
        return Unit.INSTANCE;
    }

    private static final void checkConflictsInteractively$lambda$25(Function0 $onAccept) {
        $onAccept.invoke();
    }

    public static final /* synthetic */ boolean access$moveFunctionLiteralOutsideParentheses$isWhiteSpaceOrComment(PsiElement e) {
        return KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses$isWhiteSpaceOrComment(e);
    }
}

