/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.KotlinExpectActualLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.MarkersKt;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0012\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0013H\u0002J$\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0012\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0013H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinExpectActualLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "getName", "", "getOptions", "", "Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "()[Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "collectActualMarkers", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "collectExpectMarkers", "kotlin.code-insight.line-markers.k2"})
@SourceDebugExtension(value={"SMAP\nKotlinExpectActualLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExpectActualLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinExpectActualLineMarkerProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class KotlinExpectActualLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return KotlinBundle.message((String)"highlighter.name.expect.actual.line.markers", (Object[])new Object[0]);
    }

    @NotNull
    public GutterIconDescriptor.Option[] getOptions() {
        GutterIconDescriptor.Option[] optionArray = new GutterIconDescriptor.Option[]{KotlinLineMarkerOptions.INSTANCE.getExpectOption(), KotlinLineMarkerOptions.INSTANCE.getActualOption()};
        return optionArray;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        KtNamedDeclaration declaration;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (elements.isEmpty()) {
            return;
        }
        boolean expectEnabled = KotlinLineMarkerOptions.INSTANCE.getExpectOption().isEnabled();
        boolean actualEnabled = KotlinLineMarkerOptions.INSTANCE.getActualOption().isEnabled();
        if (!expectEnabled && !actualEnabled) {
            return;
        }
        PsiElement first2 = (PsiElement)CollectionsKt.first(elements);
        Project project = first2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return;
        }
        for (PsiElement psiElement : elements) {
            if ((psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null) == null) continue;
            declaration = declaration;
            if (!expectEnabled || KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)declaration)) || !KotlinPsiUtils.isEffectivelyActual$default((KtDeclaration)declaration, false, 1, null)) continue;
            this.collectExpectMarkers(declaration, result2);
        }
        for (PsiElement psiElement : elements) {
            if ((psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null) == null) continue;
            declaration = declaration;
            if (!actualEnabled || !KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)declaration))) continue;
            this.collectActualMarkers(declaration, result2);
        }
    }

    private final boolean collectActualMarkers(KtNamedDeclaration declaration, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter = KotlinLineMarkerOptions.INSTANCE.getActualOption();
        if (!gutter.isEnabled()) {
            return false;
        }
        if (MarkersKt.areMarkersForbidden$default(declaration, null, 1, null)) {
            return false;
        }
        if (!PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            if (!(ktClassOrObject != null ? PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)ktClassOrObject)) : false)) {
                return false;
            }
        }
        PsiElement anchor = MarkersKt.getExpectOrActualAnchor(declaration);
        KtDeclaration ktDeclaration = MarkersKt.getMarkerDeclaration(anchor);
        Collection<Object> navigatableActualDeclarations = ktDeclaration != null ? MarkersKt.allNavigatableActualDeclarations(ktDeclaration) : null;
        Collection<SmartPsiElementPointer<KtDeclaration>> collection = navigatableActualDeclarations;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        GutterIconNavigationHandler navigationHandler = (arg_0, arg_1) -> KotlinExpectActualLineMarkerProvider.collectActualMarkers$lambda$1(navigatableActualDeclarations, arg_0, arg_1);
        TextRange textRange = anchor.getTextRange();
        Icon icon2 = gutter.getIcon();
        Intrinsics.checkNotNull((Object)icon2);
        LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon2, arg_0 -> KotlinExpectActualLineMarkerProvider.collectActualMarkers$lambda$4(arg_0 -> KotlinExpectActualLineMarkerProvider.collectActualMarkers$lambda$3(navigatableActualDeclarations, arg_0), arg_0), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)navigationHandler, navigatableActualDeclarations){
            final /* synthetic */ GutterIconNavigationHandler<PsiElement> $navigationHandler;
            final /* synthetic */ Collection<SmartPsiElementPointer<KtDeclaration>> $navigatableActualDeclarations;
            {
                this.$navigationHandler = $navigationHandler;
                this.$navigatableActualDeclarations = $navigatableActualDeclarations;
            }

            public void navigate(MouseEvent e, PsiElement elt) {
                this.$navigationHandler.navigate(e, elt);
            }

            public NavigationPopupDescriptor getTargetsPopupDescriptor(PsiElement element) {
                return KotlinExpectActualLineMarkerProviderKt.buildNavigateToActualDeclarationsPopup(element, this.$navigatableActualDeclarations);
            }
        }, GutterIconRenderer.Alignment.RIGHT, () -> KotlinExpectActualLineMarkerProvider.collectActualMarkers$lambda$5(gutter));
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)KotlinBundle.message((String)"highlighter.action.text.go.to.actual.declarations", (Object[])new Object[0]), (String)"GotoRelated");
        result2.add(lineMarkerInfo2);
        return true;
    }

    private final boolean collectExpectMarkers(KtNamedDeclaration declaration, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter = KotlinLineMarkerOptions.INSTANCE.getExpectOption();
        if (!gutter.isEnabled()) {
            return false;
        }
        if (MarkersKt.areMarkersForbidden$default(declaration, null, 1, null)) {
            return false;
        }
        if (!PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
            return false;
        }
        if (!MarkersKt.hasExpectForActual((KtDeclaration)declaration)) {
            return false;
        }
        PsiElement anchor = MarkersKt.getExpectOrActualAnchor(declaration);
        KtDeclaration ktDeclaration = MarkersKt.getMarkerDeclaration(anchor);
        List<SmartPsiElementPointer<KtDeclaration>> navigatableExpectedDeclarations = ktDeclaration != null ? MarkersKt.allNavigatableExpectedDeclarations(ktDeclaration) : null;
        GutterIconNavigationHandler navigationHandler = (arg_0, arg_1) -> KotlinExpectActualLineMarkerProvider.collectExpectMarkers$lambda$6(navigatableExpectedDeclarations, arg_0, arg_1);
        TextRange textRange = anchor.getTextRange();
        Icon icon2 = gutter.getIcon();
        Intrinsics.checkNotNull((Object)icon2);
        LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon2, arg_0 -> KotlinExpectActualLineMarkerProvider.collectExpectMarkers$lambda$8(arg_0 -> KotlinExpectActualLineMarkerProvider.collectExpectMarkers$lambda$7(navigatableExpectedDeclarations, arg_0), arg_0), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)navigationHandler, navigatableExpectedDeclarations){
            final /* synthetic */ GutterIconNavigationHandler<PsiElement> $navigationHandler;
            final /* synthetic */ List<SmartPsiElementPointer<KtDeclaration>> $navigatableExpectedDeclarations;
            {
                this.$navigationHandler = $navigationHandler;
                this.$navigatableExpectedDeclarations = $navigatableExpectedDeclarations;
            }

            public void navigate(MouseEvent e, PsiElement elt) {
                this.$navigationHandler.navigate(e, elt);
            }

            public NavigationPopupDescriptor getTargetsPopupDescriptor(PsiElement element) {
                return KotlinExpectActualLineMarkerProviderKt.buildNavigateToExpectedDeclarationsPopup(element, this.$navigatableExpectedDeclarations);
            }
        }, GutterIconRenderer.Alignment.RIGHT, () -> KotlinExpectActualLineMarkerProvider.collectExpectMarkers$lambda$9(gutter));
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)KotlinBundle.message((String)"highlighter.action.text.go.to.expected.declaration", (Object[])new Object[0]), null);
        result2.add(lineMarkerInfo2);
        return true;
    }

    private static final void collectActualMarkers$lambda$1(Collection $navigatableActualDeclarations, MouseEvent e, PsiElement element) {
        block1: {
            MouseEvent mouseEvent = e;
            if (mouseEvent == null) break block1;
            MouseEvent it = mouseEvent;
            boolean bl = false;
            NavigationPopupDescriptor navigationPopupDescriptor = KotlinExpectActualLineMarkerProviderKt.buildNavigateToActualDeclarationsPopup(element, $navigatableActualDeclarations);
            if (navigationPopupDescriptor != null) {
                navigationPopupDescriptor.showPopup(e);
            }
        }
    }

    private static final String collectActualMarkers$lambda$3(Collection $navigatableActualDeclarations, PsiElement el) {
        String string;
        Intrinsics.checkNotNull((Object)el);
        KtDeclaration ktDeclaration = MarkersKt.getMarkerDeclaration(el);
        if (ktDeclaration != null) {
            KtDeclaration it = ktDeclaration;
            boolean bl = false;
            string = KotlinExpectActualLineMarkerProviderKt.actualTooltip($navigatableActualDeclarations);
        } else {
            string = null;
        }
        return string;
    }

    private static final String collectActualMarkers$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String collectActualMarkers$lambda$5(GutterIconDescriptor.Option $gutter) {
        return $gutter.getName();
    }

    private static final void collectExpectMarkers$lambda$6(List $navigatableExpectedDeclarations, MouseEvent e, PsiElement element) {
        block1: {
            if (e == null) break block1;
            NavigationPopupDescriptor navigationPopupDescriptor = KotlinExpectActualLineMarkerProviderKt.buildNavigateToExpectedDeclarationsPopup(element, $navigatableExpectedDeclarations);
            if (navigationPopupDescriptor != null) {
                navigationPopupDescriptor.showPopup(e);
            }
        }
    }

    private static final String collectExpectMarkers$lambda$7(List $navigatableExpectedDeclarations, PsiElement el) {
        Intrinsics.checkNotNull((Object)el);
        return MarkersKt.getMarkerDeclaration(el) != null ? KotlinExpectActualLineMarkerProviderKt.expectTooltip($navigatableExpectedDeclarations) : null;
    }

    private static final String collectExpectMarkers$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String collectExpectMarkers$lambda$9(GutterIconDescriptor.Option $gutter) {
        return $gutter.getName();
    }
}

