/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenConstantListConverter;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J!\u0010\t\u001a\u0004\u0018\u00010\u00062\r\u0010\n\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenModelVersionConverter;", "Lorg/jetbrains/idea/maven/dom/converters/MavenConstantListConverter;", "<init>", "()V", "getValues", "", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "fromString", "s", "Lorg/jetbrains/annotations/NonNls;", "getErrorMessage", "Companion", "intellij.maven"})
public final class MavenModelVersionConverter
extends MavenConstantListConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> VALUES_MAVEN_3 = CollectionsKt.listOf((Object)"4.0.0");
    @NotNull
    private static final List<String> VALUES_MAVEN_4;

    @Override
    @NotNull
    protected Collection<String> getValues(@NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        VirtualFile virtualFile = context2.getFile().getVirtualFile();
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return MavenDomUtil.isAtLeastMaven4(virtualFile, project) ? (Collection)VALUES_MAVEN_4 : (Collection)VALUES_MAVEN_3;
    }

    @Override
    @Nullable
    public String fromString(@Nullable String s, @NotNull ConvertContext context2) {
        XmlTag xmlTag;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (s != null) {
            return super.fromString(s, context2);
        }
        XmlTag rootTag = context2.getFile().getRootTag();
        XmlTag xmlTag2 = rootTag;
        if (MavenUtil.INSTANCE.isMaven410(xmlTag2 != null && (xmlTag2 = xmlTag2.getAttribute("xmlns")) != null ? xmlTag2.getValue() : null, (xmlTag = rootTag) != null && (xmlTag = xmlTag.getAttribute("xsi:schemaLocation")) != null ? xmlTag.getValue() : null)) {
            return "4.1.0";
        }
        return null;
    }

    @Override
    @Nullable
    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[]{this.getValues(context2)};
        return MavenDomBundle.message("inspection.message.unsupported.model.version.only.version.supported", objectArray);
    }

    static {
        Object[] objectArray = new String[]{"4.0.0", "4.1.0"};
        VALUES_MAVEN_4 = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenModelVersionConverter$Companion;", "", "<init>", "()V", "VALUES_MAVEN_3", "", "", "VALUES_MAVEN_4", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

