/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskUiUtil {
    private static final Logger LOG = Logger.getInstance(TaskUiUtil.class);

    private TaskUiUtil() {
    }

    public static abstract class ComboBoxUpdater<T>
    extends RemoteFetchTask<Collection<T>> {
        protected final JComboBox<T> myComboBox;

        public ComboBoxUpdater(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, @NotNull JComboBox<T> comboBox) {
            if (title == null) {
                ComboBoxUpdater.$$$reportNull$$$0(0);
            }
            if (comboBox == null) {
                ComboBoxUpdater.$$$reportNull$$$0(1);
            }
            super(project, title, ModalityState.any());
            this.myComboBox = comboBox;
        }

        @Nullable
        public T getExtraItem() {
            return null;
        }

        @Nullable
        public T getSelectedItem() {
            return this.getExtraItem();
        }

        protected boolean addSelectedItemIfMissing() {
            return false;
        }

        @Override
        protected void updateUI() {
            if (this.myResult != null) {
                this.myComboBox.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray((Collection)((Collection)this.myResult))));
                T extra = this.getExtraItem();
                if (extra != null) {
                    this.myComboBox.insertItemAt(extra, 0);
                }
                this.myComboBox.setSelectedItem(null);
                T selected = this.getSelectedItem();
                if (selected != null) {
                    if (!selected.equals(extra) && !((Collection)this.myResult).contains(selected)) {
                        if (this.addSelectedItemIfMissing()) {
                            this.myComboBox.addItem(selected);
                            this.myComboBox.setSelectedItem(selected);
                        } else {
                            this.selectFirstItem();
                        }
                    } else {
                        this.myComboBox.setSelectedItem(selected);
                    }
                } else {
                    this.selectFirstItem();
                }
            } else {
                this.handleError();
            }
        }

        private void selectFirstItem() {
            if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }

        protected void handleError() {
            this.myComboBox.removeAllItems();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "comboBox";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/impl/TaskUiUtil$ComboBoxUpdater";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class RemoteFetchTask<T>
    extends Task.Backgroundable {
        protected T myResult;
        protected Exception myException;
        private final ModalityState myModalityState;

        protected RemoteFetchTask(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title) {
            if (title == null) {
                RemoteFetchTask.$$$reportNull$$$0(0);
            }
            this(project, title, ModalityState.current());
        }

        protected RemoteFetchTask(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, @NotNull ModalityState modalityState) {
            if (title == null) {
                RemoteFetchTask.$$$reportNull$$$0(1);
            }
            if (modalityState == null) {
                RemoteFetchTask.$$$reportNull$$$0(2);
            }
            super(project, title);
            this.myModalityState = modalityState;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                RemoteFetchTask.$$$reportNull$$$0(3);
            }
            try {
                this.myResult = this.fetch(indicator);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myException = e;
            }
        }

        @Nullable
        public final Task.NotificationInfo notifyFinished() {
            ApplicationManager.getApplication().invokeLater(() -> this.updateUI(), this.myModalityState);
            return null;
        }

        @NotNull
        protected abstract T fetch(@NotNull ProgressIndicator var1) throws Exception;

        protected abstract void updateUI();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modalityState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/tasks/impl/TaskUiUtil$RemoteFetchTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

