/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class RecordVarExprent
extends VarExprent {
    @NotNull
    private final List<RecordVarExprent> components = new ArrayList<RecordVarExprent>();

    public RecordVarExprent(VarExprent v) {
        super(v.getIndex(), v.getVarType(), v.getProcessor());
        if (v.isClassDef()) {
            throw new UnsupportedOperationException("Expect only var definition");
        }
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        if (this.components.isEmpty()) {
            this.setDefinition(true);
            return super.toJava(indent, tracer);
        }
        TextBuffer buffer = new TextBuffer();
        this.appendDefinitionType(buffer);
        buffer.append("(");
        for (int i = 0; i < this.components.size(); ++i) {
            buffer.append(this.components.get(i).toJava(0, tracer));
            if (i == this.components.size() - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer;
    }

    public void addComponent(@NotNull RecordVarExprent exprent) {
        if (exprent == null) {
            RecordVarExprent.$$$reportNull$$$0(0);
        }
        this.components.add(exprent);
    }

    @Override
    public RecordVarExprent copy() {
        VarExprent copy = (VarExprent)super.copy();
        RecordVarExprent newRoot = new RecordVarExprent(copy);
        newRoot.setLVTEntry(copy.getLVTEntry());
        for (RecordVarExprent component : this.components) {
            newRoot.addComponent(component.copy());
        }
        return newRoot;
    }

    public boolean copyFrom(@NotNull VarExprent varExprent) {
        if (varExprent == null) {
            RecordVarExprent.$$$reportNull$$$0(1);
        }
        if (varExprent instanceof RecordVarExprent) {
            RecordVarExprent recordVarExprent = (RecordVarExprent)varExprent;
            if (!this.components.isEmpty()) {
                return false;
            }
            this.components.addAll(recordVarExprent.components);
        }
        this.setVarType(varExprent.getVarType());
        this.setIndex(varExprent.getIndex());
        this.setVersion(varExprent.getVersion());
        this.setLVTEntry(varExprent.getLVTEntry());
        return true;
    }

    public List<RecordVarExprent> getComponents() {
        return new ArrayList<RecordVarExprent>(this.components);
    }

    @Nullable
    public RecordVarExprent getDirectComponent(@Nullable Exprent exprent) {
        for (RecordVarExprent component : this.components) {
            if (!component.equals(exprent)) continue;
            return component;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varExprent";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/exps/RecordVarExprent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

