/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import java.util.Arrays;
import korlibs.crypto.CipherPaddingANSIX923;
import korlibs.crypto.CipherPaddingISO10126;
import korlibs.crypto.CipherPaddingNo;
import korlibs.crypto.CipherPaddingPKCS7;
import korlibs.crypto.CipherPaddingZero;
import korlibs.crypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0014J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0010"}, d2={"Lkorlibs/crypto/CipherPadding;", "", "()V", "add", "", "data", "blockSize", "", "addInternal", "", "result", "dataSize", "paddingSize", "remove", "removeInternal", "Companion", "krypto"})
public abstract class CipherPadding {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] add(@NotNull byte[] data, int blockSize) {
        int paddingSize = this.paddingSize(data.length, blockSize);
        byte[] result = new byte[data.length + paddingSize];
        KryptoToolsKt.arraycopy(data, 0, result, 0, data.length);
        this.addInternal(result, data.length, paddingSize);
        return result;
    }

    @NotNull
    public final byte[] remove(@NotNull byte[] data) {
        byte[] byArray = Arrays.copyOf(data, data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        byte[] result = byArray;
        int size = this.removeInternal(data);
        byte[] byArray2 = Arrays.copyOf(result, size);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
        return byArray2;
    }

    protected int paddingSize(int dataSize, int blockSize) {
        return blockSize - dataSize % blockSize;
    }

    protected void addInternal(@NotNull byte[] result, int dataSize, int paddingSize) {
    }

    protected int removeInternal(@NotNull byte[] data) {
        return data.length - (data[data.length - 1] & 0xFF);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u000f\u001a\u00060\u0004j\u0002`\u0014J\u001a\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\n\u0010\u000f\u001a\u00060\u0004j\u0002`\u0014R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lkorlibs/crypto/CipherPadding$Companion;", "", "()V", "ANSIX923Padding", "Lkorlibs/crypto/CipherPadding;", "getANSIX923Padding", "()Lkorlibs/crypto/CipherPadding;", "ISO10126Padding", "getISO10126Padding", "NoPadding", "getNoPadding", "PKCS7Padding", "getPKCS7Padding", "ZeroPadding", "getZeroPadding", "padding", "", "data", "blockSize", "", "Lkorlibs/crypto/Padding;", "removePadding", "krypto"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CipherPadding getNoPadding() {
            return CipherPaddingNo.INSTANCE;
        }

        @NotNull
        public final CipherPadding getPKCS7Padding() {
            return CipherPaddingPKCS7.INSTANCE;
        }

        @NotNull
        public final CipherPadding getANSIX923Padding() {
            return CipherPaddingANSIX923.INSTANCE;
        }

        @NotNull
        public final CipherPadding getISO10126Padding() {
            return CipherPaddingISO10126.INSTANCE;
        }

        @NotNull
        public final CipherPadding getZeroPadding() {
            return CipherPaddingZero.INSTANCE;
        }

        @NotNull
        public final byte[] padding(@NotNull byte[] data, int blockSize, @NotNull CipherPadding padding) {
            return padding.add(data, blockSize);
        }

        @NotNull
        public final byte[] removePadding(@NotNull byte[] data, @NotNull CipherPadding padding) {
            return padding.remove(data);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

