/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;

public final class InterruptibleRunnable
implements Runnable {
    private final Lock stateLock = new ReentrantLock();
    private final Runnable delegate;
    private boolean interrupted;
    private @Nullable Thread thread;

    public InterruptibleRunnable(Runnable delegate) {
        this.delegate = delegate;
    }

    @Override
    public void run() {
        this.beforeRun();
        try {
            this.delegate.run();
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.stateLock.lock();
        try {
            this.thread = Thread.currentThread();
            if (this.interrupted) {
                this.thread.interrupt();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void afterRun() {
        this.stateLock.lock();
        try {
            Thread.interrupted();
            this.thread = null;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void interrupt() {
        this.stateLock.lock();
        try {
            if (this.thread == null) {
                this.interrupted = true;
            } else {
                this.thread.interrupt();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }
}

