---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: スニペットを使用して、ブラウザからコード、テキスト、ファイルを保存および共有します。スニペットは、バージョン管理、コメント、埋め込みをサポートしています。
title: スニペット
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabスニペットを使用すると、コードやテキストの一部を保存し、他のユーザーと共有できます。スニペットでは、[コメント](#comment-on-snippets)を付けたり、[クローン](#clone-snippets)を作成したり、[バージョン管理](#versioned-snippets)を使用したりできます。[複数のファイルを含める](#add-or-remove-multiple-files)こともできます。また、[構文ハイライト](#filenames) 、[埋め込み](#embed-snippets) 、[ダウンロード](#download-snippets)もサポートしており、[スニペットAPI](../api/snippets.md)を使用してスニペットを管理できます。

スニペットの作成と管理は、以下の方法で行います:

- GitLabユーザーインターフェース。
- [VS Code用GitLab Workflow拡張機能](../editor_extensions/visual_studio_code/_index.md#create-a-snippet)。
- [`glab`コマンドラインインターフェース（CLI）](../editor_extensions/gitlab_cli/_index.md)。

![GitLabのサンプルコンテンツを示すコードスニペット](img/snippet_sample_v16_6.png)

GitLabでは、次の2種類のスニペットを利用できます:

- パーソナルスニペット: プロジェクトとは独立して作成されます。スニペットの[表示レベル](public_access.md)（公開または非公開）を設定できます。
- プロジェクトスニペット: 必ず特定のプロジェクトに関連付けられています。プロジェクトスニペットは、一般に公開することも、プロジェクトメンバーのみに公開することもできます。

{{< alert type="note" >}}

2019年7月以降、`Internal`の表示レベル設定は、GitLab.comの新しいプロジェクト、グループ、およびスニペットに対しては無効になっています。`Internal`表示レベル設定を使用している既存のスニペットは、この設定を保持します。変更の詳細については、[関連するイシュー](https://gitlab.com/gitlab-org/gitlab/-/issues/12388)を参照してください。

{{< /alert >}}

## スニペットを作成する {#create-snippets}

スニペットを作成する方法は複数ありますが、パーソナルスニペットとプロジェクトスニペットのどちらを作成するかによってその方法は異なります:

1. 作成するスニペットの種類を選択します:
   - パーソナルスニペットを作成するには、次のいずれかを実行します:
     - [スニペットダッシュボード](https://gitlab.com/dashboard/snippets)で、**新しいスニペット**を選択します。
     - プロジェクトから作成する場合: 左側のサイドバーで、**新規作成**（{{< icon name="plus" >}}）を選択します。**GitLab全体で**から、**新しいスニペット**を選択します。
     - その他のページから作成する場合: 左側のサイドバーで、**新規作成**（{{< icon name="plus" >}}）を選択し、**新しいスニペット**を選択します。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このボタンは右上隅にあります。
     - `glab` CLIから[`glab snippet create`](https://gitlab.com/gitlab-org/cli/-/blob/main/docs/source/snippet/create.md)コマンドを使用します。詳細な手順については、コマンドのドキュメントを参照してください。
     - [VS Code用GitLab Workflow拡張機能](../editor_extensions/visual_studio_code/_index.md)をインストールしている場合は、[`Gitlab: Create snippet`コマンド](https://marketplace.visualstudio.com/items?itemName=GitLab.gitlab-workflow#create-snippet)を使用します。
   - プロジェクトスニペットを作成するには、: プロジェクトのページに移動します。**新規作成**（{{< icon name="plus" >}}）を選択します。**このプロジェクト内で**から、**新しいスニペット**を選択します。
1. **タイトル**に、スニペットのタイトルを入力します。
1. オプション。**説明**に、スニペットの説明を入力します。
1. **ファイル**に、`example.rb`や`index.html`など、適切なファイル名と拡張子を入力します。適切な拡張子を持つファイル名の場合、[ハイライトした構文](#filenames)で表示されます。ファイル名を追加しないと、既知の[コピーアンドペーストのバグ](https://gitlab.com/gitlab-org/gitlab/-/issues/22870)が発生する可能性があります。ファイル名を指定しない場合、GitLabが[名前を作成](#filenames)します。
1. オプション。[複数のファイル](#add-or-remove-multiple-files)をスニペットに追加します。
1. 表示レベルを選択し、**スニペットを作成**を選択します。

スニペットを作成した後でも、[ファイルを追加する](#add-or-remove-multiple-files)ことができます。スニペットは、[デフォルトでバージョン管理されます](#versioned-snippets)。

## スニペットを見つける {#discover-snippets}

GitLabで自分に表示されるすべてのスニペットを見つけるには、次の操作を行います:

- プロジェクトのスニペットを表示する:
  1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
  1. **コード** > **スニペット**を選択します。
- 作成したすべてのスニペットを表示する:
  1. 左側のサイドバーで、**検索または移動先**を選択します。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
  1. **あなたの作業**を選択します。
  1. **スニペット**を選択します。

  GitLab.comでは、[スニペットに直接アクセスする](https://gitlab.com/dashboard/snippets)こともできます。

- すべてのパブリックスニペットを探す:
  1. 左側のサイドバーで、**検索または移動先**を選択します。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
  1. **検索**を選択します。
  1. **スニペット**を選択します。

  GitLab.comでは、[すべてのパブリックスニペットに直接アクセスする](https://gitlab.com/explore/snippets)こともできます。

## スニペットのデフォルトの表示レベルを変更する {#change-default-visibility-of-snippets}

プロジェクトスニペットはデフォルトで有効になっており、利用できます。デフォルトの表示レベルを変更するには、次の手順を実行します:

1. プロジェクトで、**設定** > **一般**に移動します。
1. **可視性、プロジェクトの機能、権限**セクションを展開し、**スニペット**までスクロールします。
1. デフォルトの表示レベルを切り替えることで、スニペットを誰でも閲覧できるようにするか、プロジェクトメンバーのみが閲覧できるようにするかを選択します。
1. **変更を保存**を選択します。

## スニペットのバージョン管理 {#versioned-snippets}

パーソナルスニペットとプロジェクトスニペットは、どちらもデフォルトでバージョン管理が適用されます。

つまり、各スニペットの作成時に、そのスニペット専用の基盤リポジトリが作成され、デフォルトブランチが用意された状態で初期化されます。スニペットへの変更を保存するたびに、デフォルトブランチに新しいコミットが記録されます。コミットメッセージは自動的に生成されます。スニペットのリポジトリには、1つのブランチしかありません。このブランチを削除したり、他のブランチを作成したりすることはできません。

## ファイル名 {#filenames}

スニペットは、指定されたファイル名と拡張子に基づいて、ハイライトした構文をサポートします。ファイル名と拡張子を指定せずにスニペットを送信することもできますが、リポジトリにファイルとしてコンテンツを作成するには、有効なファイル名が必要です。

スニペットにファイル名と拡張子が指定されていない場合、GitLabは`snippetfile<x>.txt`形式でファイル名を作成します。ここで`<x>`は1から始まる番号で、ファイル名に付加されます。この番号は、名前のないスニペットを追加するたびに増加します。

以前のバージョンのGitLabから13.0にアップグレードする場合、サポートされていないファイル名の既存のスニペットは、互換性のある形式のファイル名に変更されます。たとえば、スニペットのファイル名が`http://a-weird-filename.me`の場合、スニペットのリポジトリに含めるために`http-a-weird-filename-me`に変更されます。スニペットはIDに基づいて保存されるため、ファイル名を変更すると、そのスニペットへの直接リンクや埋め込みリンクは機能しなくなります。

## 複数のファイルを追加または削除する {#add-or-remove-multiple-files}

1つのスニペットで最大10個のファイルをサポートできます。これにより、次のような関連性のあるファイルをまとめて管理できます:

- スクリプトとその出力を含むスニペット。
- HTML、CSS、JavaScriptコードを含むスニペット。
- `docker-compose.yml`ファイルとそれに関連する`.env`ファイルを含むスニペット。
- `gulpfile.js`ファイルと`package.json`ファイル。これらを組み合わせて、プロジェクトをブートストラップし、その依存関係を管理できます。

スニペットに10個を超えるファイルが必要な場合は、代わりに[Wiki](project/wiki/_index.md)を作成する必要があります。Wikiは、すべてのサブスクリプションレベルのプロジェクトで利用でき、[GitLab Premium](https://about.gitlab.com/pricing/)では[グループ](project/wiki/group.md)で利用できます。

複数のファイルを含むスニペットは、[スニペットリスト](https://gitlab.com/dashboard/snippets)にファイル数が表示されます:

![GitLabスニペットの詳細を表示するツールチップ](img/snippet_tooltip_v17_4.png)

スニペットは、Git（Gitリポジトリで[バージョン管理](#versioned-snippets)されているため）、[スニペットAPI](../api/snippets.md)、およびGitLab UIを使用して管理できます。

GitLab UIを使用してスニペットに新しいファイルを追加するには:

1. GitLab UIでスニペットに移動します。
1. 右上隅にある**編集**を選択します。
1. **Add another file**（別のファイルを追加）を選択します。
1. 表示されたフォームフィールドに、新しいファイルの内容を入力します。
1. **変更を保存**を選択します。

GitLab UIを使用してスニペットからファイルを削除するには:

1. GitLab UIでスニペットに移動します。
1. 右上隅にある**編集**を選択します。
1. 削除する各ファイルのファイル名の横にある**ファイルを削除**を選択します。
1. **変更を保存**を選択します。

## スニペットのクローンを作成する {#clone-snippets}

更新を確実に受け取るには、スニペットをローカルにコピーするのではなく、スニペットのクローンを作成します。クローンを作成することで、スニペットのリポジトリとの接続が維持されます。

スニペットのクローンを作成するには:

- **Clone**（クローン）を選択し、SSHまたはHTTPSでクローンを作成するためのURLをコピーします。

クローンが作成されたスニペットに対して変更をコミットし、その変更をGitLabにプッシュできます。

## スニペットを埋め込む {#embed-snippets}

パブリックスニペットは、任意のWebサイトで共有や埋め込みができます。GitLabスニペットは複数の場所で再利用できます。ソースに対する変更は、埋め込まれたスニペットに反映されます。埋め込まれている場合、ユーザーはスニペットをダウンロードしたり、raw形式で表示したりできます。

スニペットを埋め込むには:

1. スニペットが公開されていることを確認します:
   - プロジェクトスニペットの場合、プロジェクトはパブリックである必要があります。
   - スニペットは公開されています。
   - プロジェクトで、**設定** > **一般**に移動します。**可視性、プロジェクトの機能、権限**セクションを展開し、**スニペット**までスクロールします。スニペットの権限を**Everyone with access**（アクセスできる人すべて）に設定します。
1. スニペットの**埋め込み**セクションで、**コピー**を選択し、任意のWebサイトまたはブログ記事に追加できる1行のスクリプトをコピーします。例は次のとおりです:

   ```html
   <script src="https://gitlab.com/namespace/project/snippets/SNIPPET_ID.js"></script>
   ```

1. スクリプトをファイルに追加します。

埋め込まれたスニペットには、次の情報を示すヘッダーが表示されます:

- ファイル名（定義されている場合）。
- スニペットのサイズ。
- GitLabへのリンク。
- 実際のスニペットの内容。

例は次のとおりです:

<script src="https://gitlab.com/gitlab-org/gitlab-foss/snippets/1717978.js"></script>

## スニペットをダウンロードする {#download-snippets}

スニペットのrawコンテンツをダウンロードできます。デフォルトでは、Linuxスタイルの改行コード（`LF`）でダウンロードされます。元の改行コードを保持する場合は、パラメータ`line_ending=raw`を追加する必要があります（例: `https://gitlab.com/snippets/SNIPPET_ID/raw?line_ending=raw`）。スニペットがGitLab Webインターフェースを使用して作成された場合、元の改行コードはWindowsスタイル（`CRLF`）となります。

## スニペットにコメントを付ける {#comment-on-snippets}

スニペットでは、そのコードについてコメントをやり取りでき、ユーザー間のコラボレーションを促進できます。

## スニペットをスパムとしてマークする {#mark-snippet-as-spam}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLab Self-Managedの管理者は、スニペットをスパムとしてマークできます。

前提要件:

- インスタンスの管理者である必要があります。
- インスタンスで[Akismet](../integration/akismet.md)スパム対策が有効になっている必要があります。

このタスクを実行するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。[新しいナビゲーションをオン](interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **コード** > **スニペット**を選択します。
1. スパムとして報告するスニペットを選択します。
1. **スパムとしてレポート**を選択します。

GitLabはスパムをAkismetに転送します。

## トラブルシューティング {#troubleshooting}

### スニペットの制限事項 {#snippet-limitations}

- 作成できるスニペットの数に制限はありません。
- バイナリファイルはサポートされていません。
- ブランチの作成または削除はサポートされていません。デフォルトブランチのみが使用されます。
- Gitタグは、スニペットリポジトリではサポートされていません。
- スニペットリポジトリは、最大10ファイルに制限されています。10ファイルを超えてプッシュしようとすると、エラーが発生します。
- リビジョンはGitLab UIではユーザーに表示されませんが、更新に関する[イシューが存在](https://gitlab.com/gitlab-org/gitlab/-/issues/39271)します。
- 2024-04-17現在、デフォルトでは、[スニペットの最大サイズ](../administration/snippets/_index.md)は50 MBです。
- Git LFSはサポートされていません。

### スニペットリポジトリのサイズを縮小する {#reduce-snippets-repository-size}

バージョン管理されたスニペットは[ネームスペースのストレージサイズ](../administration/settings/account_and_limit_settings.md)の一部として扱われるため、スニペットのリポジトリをできるだけコンパクトに保つことを推奨します。

リポジトリをコンパクトにするツールの詳細については、[リポジトリサイズの縮小](project/repository/repository_size.md#methods-to-reduce-repository-size)に関するドキュメントを参照してください。

### スニペットのテキストボックスにテキストを入力できない {#cannot-enter-text-into-the-snippet-text-box}

ファイル名フィールドの後のテキストエリアが無効化されており、新しいスニペットを作成できない場合は、次の回避策を使用してください:

1. スニペットのタイトルを入力します。
1. **ファイル**フィールドの一番下までスクロールし、**Add another file**（別のファイルを追加）を選択します。GitLabに、2番目のファイルを追加するための2番目のフィールドセットが表示されます。
1. 2番目のファイルのファイル名フィールドにファイル名を入力し、[既知のコピーアンドペーストのバグ](https://gitlab.com/gitlab-org/gitlab/-/issues/22870)を回避します。
1. 2番目のファイルのテキストエリアに任意の文字列を入力します。
1. 最初のファイル名までスクロールして、**ファイルを削除**を選択します。
1. ファイルの残りの部分を作成し、完了したら**スニペットを作成**を選択します。

## 関連トピック {#related-topics}

- GitLab Self-Managedで[スニペットを設定する](../administration/snippets/_index.md)
