---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: グループのリポジトリ分析
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループのリポジトリ分析は、グループ内のすべてのプロジェクトのテストカバレッジデータを提供します。

グループリポジトリ分析を使用して、以下を実行できます:

- グループ内のすべてのプロジェクトのコードカバレッジの傾向を監視します。
- カバレッジレポートを生成するプロジェクトとジョブの総数を追跡します。
- 分析のために履歴カバレッジデータをダウンロードします。

サブグループのサポートは、[issue 273527](https://gitlab.com/gitlab-org/gitlab/-/issues/273527)で提案されています。

## グループリポジトリ分析を表示 {#view-group-repository-analytics}

前提要件:

- グループ内のプロジェクトは、テストカバレッジデータを収集するように構成されている必要があります。

グループのリポジトリ分析を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。[新しいナビゲーションをオン](../../interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **分析** > **リポジトリ分析**を選択します。

## カバレッジメトリクス {#coverage-metrics}

グループの**リポジトリ分析**ページには、以下が表示されます:

- **Current group code coverage**（現在のグループコードカバレッジ）:
  - カバレッジレポートがあるプロジェクトの数。
  - すべてのプロジェクトの平均カバレッジ率。
  - カバレッジレポートを生成するパイプラインジョブの総数。

- **平均テストカバレッジ**: 過去30日間のグループ内のすべてのプロジェクトの平均テストカバレッジを示すグラフ。

- **最新のテストカバレッジ結果**: グループ内の各プロジェクトの最新のカバレッジデータのリスト。ドロップダウンリストからプロジェクトを選択して、結果をフィルタリングします。

## カバレッジデータをダウンロード {#download-coverage-data}

グループ内のプロジェクトの履歴カバレッジデータを含むCSVファイルをダウンロードできます。

CSVレポート:

- 最大1000件のレコードが含まれています。
- 各プロジェクトのデフォルトブランチのデータが含まれています。
- カバレッジがレポートされた日付ごとに1つの行が表示されます。
- 複数のカバレッジレポートが生成された場合は、その日の最後の値を使用します。
- 各カバレッジレポートについて、次の情報が含まれています:
  - カバレッジジョブが実行された日付
  - レポートを生成したジョブの名前
  - プロジェクト名
  - カバレッジのパーセンテージ

カバレッジデータをダウンロードするには:

1. グループの**リポジトリ分析**ページで、**過去のテストカバレッジデータをCSV形式でダウンロード**を選択します。
1. 含めるプロジェクトを選択します:
   - **プロジェクト**ドロップダウンリストから、特定のプロジェクトを選択します。プロジェクトのドロップダウンリストには、最大100個のプロジェクトが表示されます。
   - オプション。グループ内のすべてのプロジェクトを含めるには、**すべて選択**を選択します。
1. **日付範囲**ドロップダウンリストから、含める期間を選択します。
1. **テストカバレッジデータをCSV形式でダウンロード**を選択します。

## 関連トピック {#related-topics}

- [プロジェクトのリポジトリ分析](../../analytics/repository_analytics.md)
- [コードカバレッジ](../../../ci/testing/code_coverage/_index.md)
