# frozen_string_literal: true

class QueueBackfillOccurrenceIdToVulnerabilityIssueLinks < Gitlab::Database::Migration[2.3]
  milestone '18.7'

  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION = "BackfillOccurrenceIdToVulnerabilityIssueLinks"

  def up
    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_issue_links,
      :id
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, :vulnerability_issue_links, :id, [])
  end
end
