﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/cleanroomsml/model/Dataset.h>
#include <aws/cleanroomsml/model/TrainingDatasetStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CleanRoomsML {
namespace Model {
class GetTrainingDatasetResult {
 public:
  AWS_CLEANROOMSML_API GetTrainingDatasetResult() = default;
  AWS_CLEANROOMSML_API GetTrainingDatasetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLEANROOMSML_API GetTrainingDatasetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The time at which the training dataset was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  GetTrainingDatasetResult& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The most recent time at which the training dataset was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  GetTrainingDatasetResult& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the training dataset.</p>
   */
  inline const Aws::String& GetTrainingDatasetArn() const { return m_trainingDatasetArn; }
  template <typename TrainingDatasetArnT = Aws::String>
  void SetTrainingDatasetArn(TrainingDatasetArnT&& value) {
    m_trainingDatasetArnHasBeenSet = true;
    m_trainingDatasetArn = std::forward<TrainingDatasetArnT>(value);
  }
  template <typename TrainingDatasetArnT = Aws::String>
  GetTrainingDatasetResult& WithTrainingDatasetArn(TrainingDatasetArnT&& value) {
    SetTrainingDatasetArn(std::forward<TrainingDatasetArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the training dataset.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetTrainingDatasetResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Metadata about the requested training data. </p>
   */
  inline const Aws::Vector<Dataset>& GetTrainingData() const { return m_trainingData; }
  template <typename TrainingDataT = Aws::Vector<Dataset>>
  void SetTrainingData(TrainingDataT&& value) {
    m_trainingDataHasBeenSet = true;
    m_trainingData = std::forward<TrainingDataT>(value);
  }
  template <typename TrainingDataT = Aws::Vector<Dataset>>
  GetTrainingDatasetResult& WithTrainingData(TrainingDataT&& value) {
    SetTrainingData(std::forward<TrainingDataT>(value));
    return *this;
  }
  template <typename TrainingDataT = Dataset>
  GetTrainingDatasetResult& AddTrainingData(TrainingDataT&& value) {
    m_trainingDataHasBeenSet = true;
    m_trainingData.emplace_back(std::forward<TrainingDataT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the training dataset.</p>
   */
  inline TrainingDatasetStatus GetStatus() const { return m_status; }
  inline void SetStatus(TrainingDatasetStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetTrainingDatasetResult& WithStatus(TrainingDatasetStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IAM role used to read the training data.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  GetTrainingDatasetResult& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags that are assigned to this training dataset.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  GetTrainingDatasetResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  GetTrainingDatasetResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the training dataset.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetTrainingDatasetResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTrainingDatasetResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createTime{};

  Aws::Utils::DateTime m_updateTime{};

  Aws::String m_trainingDatasetArn;

  Aws::String m_name;

  Aws::Vector<Dataset> m_trainingData;

  TrainingDatasetStatus m_status{TrainingDatasetStatus::NOT_SET};

  Aws::String m_roleArn;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::String m_description;

  Aws::String m_requestId;
  bool m_createTimeHasBeenSet = false;
  bool m_updateTimeHasBeenSet = false;
  bool m_trainingDatasetArnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_trainingDataHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRoomsML
}  // namespace Aws
