﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/savingsplans/SavingsPlans_EXPORTS.h>
#include <aws/savingsplans/model/SavingsPlanOfferingRate.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SavingsPlans {
namespace Model {
class DescribeSavingsPlansOfferingRatesResult {
 public:
  AWS_SAVINGSPLANS_API DescribeSavingsPlansOfferingRatesResult() = default;
  AWS_SAVINGSPLANS_API DescribeSavingsPlansOfferingRatesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAVINGSPLANS_API DescribeSavingsPlansOfferingRatesResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the Savings Plans offering rates.</p>
   */
  inline const Aws::Vector<SavingsPlanOfferingRate>& GetSearchResults() const { return m_searchResults; }
  template <typename SearchResultsT = Aws::Vector<SavingsPlanOfferingRate>>
  void SetSearchResults(SearchResultsT&& value) {
    m_searchResultsHasBeenSet = true;
    m_searchResults = std::forward<SearchResultsT>(value);
  }
  template <typename SearchResultsT = Aws::Vector<SavingsPlanOfferingRate>>
  DescribeSavingsPlansOfferingRatesResult& WithSearchResults(SearchResultsT&& value) {
    SetSearchResults(std::forward<SearchResultsT>(value));
    return *this;
  }
  template <typename SearchResultsT = SavingsPlanOfferingRate>
  DescribeSavingsPlansOfferingRatesResult& AddSearchResults(SearchResultsT&& value) {
    m_searchResultsHasBeenSet = true;
    m_searchResults.emplace_back(std::forward<SearchResultsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is null
   * when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeSavingsPlansOfferingRatesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeSavingsPlansOfferingRatesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<SavingsPlanOfferingRate> m_searchResults;
  bool m_searchResultsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SavingsPlans
}  // namespace Aws
