/*
 * Copyright (C) 2026 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Autogenerated, do not modify.
*/

#pragma once

#include "ArithProfile.h"
#include "ArrayAllocationProfile.h"
#include "BytecodeDumper.h"
#include "Fits.h"
#include "GetByIdMetadata.h"
#include "Instruction.h"
#include "IterationModeMetadata.h"
#include "JSPropertyNameEnumerator.h"
#include "Opcode.h"
#include "PrivateFieldPutKind.h"
#include "PutByStatus.h"
#include "PutByIdFlags.h"
#include "ToThisStatus.h"

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN

namespace JSC {

class BasicBlockLocation;

void dumpBytecode(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset, const JSInstruction*);

#if ENABLE(WEBASSEMBLY)
void dumpWasm(BytecodeDumperBase<WasmInstructionStream>* dumper, WasmInstructionStream::Offset, const WasmInstruction*);
#endif // ENABLE(WEBASSEMBLY)


struct OpTailCallVarargs : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_tail_call_varargs;
    static constexpr size_t length = 7;
    enum Tmps : uint8_t {
        argCountIncludingThis,
    };
    enum Checkpoints : uint8_t {
        determiningArgCount,
        makeCall,
        numberOfCheckpoints,
    };


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**tail_call_varargs"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("arguments", m_arguments, false);
        dumper->dumpOperand("firstFree", m_firstFree, false);
        dumper->dumpOperand("firstVarArg", m_firstVarArg, false);
    }

    OpTailCallVarargs(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpTailCallVarargs(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpTailCallVarargs(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpTailCallVarargs decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_tail_call_varargs;
        Metadata(const OpTailCallVarargs&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_metadataID;
};
static_assert(OpTailCallVarargs::length + 1 > OpTailCallVarargs::numberOfCheckpoints, "FullBytecodeLivess relies on the length of OpTailCallVarargs being greater than the number of checkpoints");

struct OpCallVarargs : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_call_varargs;
    static constexpr size_t length = 8;
    enum Tmps : uint8_t {
        argCountIncludingThis,
    };
    enum Checkpoints : uint8_t {
        determiningArgCount,
        makeCall,
        numberOfCheckpoints,
    };


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**call_varargs"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("arguments", m_arguments, false);
        dumper->dumpOperand("firstFree", m_firstFree, false);
        dumper->dumpOperand("firstVarArg", m_firstVarArg, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpCallVarargs(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCallVarargs(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCallVarargs(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCallVarargs decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<int, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_call_varargs;
        Metadata(const OpCallVarargs&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};
static_assert(OpCallVarargs::length + 1 > OpCallVarargs::numberOfCheckpoints, "FullBytecodeLivess relies on the length of OpCallVarargs being greater than the number of checkpoints");

struct OpIteratorNext : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_iterator_next;
    static constexpr size_t length = 10;
    enum Tmps : uint8_t {
        nextResult,
    };
    enum Checkpoints : uint8_t {
        computeNext,
        getDone,
        getValue,
        numberOfCheckpoints,
    };


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister done, VirtualRegister value, VirtualRegister iterable, VirtualRegister next, VirtualRegister iterator, unsigned stackOffset, unsigned nextResultValueProfile, unsigned doneValueProfile, unsigned valueValueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister done, VirtualRegister value, VirtualRegister iterable, VirtualRegister next, VirtualRegister iterator, unsigned stackOffset, unsigned nextResultValueProfile, unsigned doneValueProfile, unsigned valueValueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister done, VirtualRegister value, VirtualRegister iterable, VirtualRegister next, VirtualRegister iterator, unsigned stackOffset, unsigned nextResultValueProfile, unsigned doneValueProfile, unsigned valueValueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister done, VirtualRegister value, VirtualRegister iterable, VirtualRegister next, VirtualRegister iterator, unsigned stackOffset, unsigned nextResultValueProfile, unsigned doneValueProfile, unsigned valueValueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister done, VirtualRegister value, VirtualRegister iterable, VirtualRegister next, VirtualRegister iterator, unsigned stackOffset, unsigned nextResultValueProfile, unsigned doneValueProfile, unsigned valueValueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& done, VirtualRegister& value, VirtualRegister& iterable, VirtualRegister& next, VirtualRegister& iterator, unsigned& stackOffset, unsigned& nextResultValueProfile, unsigned& doneValueProfile, unsigned& valueValueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(done)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(iterable)
            && Fits<VirtualRegister, __size>::check(next)
            && Fits<VirtualRegister, __size>::check(iterator)
            && Fits<unsigned, __size>::check(stackOffset)
            && Fits<unsigned, __size>::check(nextResultValueProfile)
            && Fits<unsigned, __size>::check(doneValueProfile)
            && Fits<unsigned, __size>::check(valueValueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister done, VirtualRegister value, VirtualRegister iterable, VirtualRegister next, VirtualRegister iterator, unsigned stackOffset, unsigned nextResultValueProfile, unsigned doneValueProfile, unsigned valueValueProfile, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, done, value, iterable, next, iterator, stackOffset, nextResultValueProfile, doneValueProfile, valueValueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(done));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(iterable));
            gen->write(Fits<VirtualRegister, __size>::convert(next));
            gen->write(Fits<VirtualRegister, __size>::convert(iterator));
            gen->write(Fits<unsigned, __size>::convert(stackOffset));
            gen->write(Fits<unsigned, __size>::convert(nextResultValueProfile));
            gen->write(Fits<unsigned, __size>::convert(doneValueProfile));
            gen->write(Fits<unsigned, __size>::convert(valueValueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**iterator_next"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("done", m_done, true);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("iterable", m_iterable, false);
        dumper->dumpOperand("next", m_next, false);
        dumper->dumpOperand("iterator", m_iterator, false);
        dumper->dumpOperand("stackOffset", m_stackOffset, false);
        dumper->dumpOperand("nextResultValueProfile", m_nextResultValueProfile, false);
        dumper->dumpOperand("doneValueProfile", m_doneValueProfile, false);
        dumper->dumpOperand("valueValueProfile", m_valueValueProfile, false);
    }

    OpIteratorNext(const uint8_t* stream)
        : m_done(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_iterable(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_next(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_iterator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_stackOffset(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
        , m_nextResultValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_doneValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
        , m_valueValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[8]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[9]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpIteratorNext(const uint16_t* stream)
        : m_done(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_iterable(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_next(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_iterator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_stackOffset(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
        , m_nextResultValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_doneValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
        , m_valueValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[8]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[9]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpIteratorNext(const uint32_t* stream)
        : m_done(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_iterable(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_next(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_iterator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_stackOffset(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
        , m_nextResultValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_doneValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
        , m_valueValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[8]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[9]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpIteratorNext decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDone(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDone<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDone<OpcodeSize::Wide16>(value, func);
        else
            setDone<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDone(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIterable(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIterable<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIterable<OpcodeSize::Wide16>(value, func);
        else
            setIterable<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIterable(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setNext(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setNext<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setNext<OpcodeSize::Wide16>(value, func);
        else
            setNext<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setNext(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIterator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIterator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIterator<OpcodeSize::Wide16>(value, func);
        else
            setIterator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIterator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setStackOffset(unsigned value, Functor func)
    {
        if (isWide32())
            setStackOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setStackOffset<OpcodeSize::Wide16>(value, func);
        else
            setStackOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setStackOffset(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setNextResultValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setNextResultValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setNextResultValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setNextResultValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setNextResultValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setDoneValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setDoneValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDoneValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setDoneValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDoneValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 7 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 8 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_iterator_next;
        Metadata(const OpIteratorNext&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        GetByIdModeMetadata m_doneModeMetadata;
        GetByIdModeMetadata m_valueModeMetadata;
        ArrayProfile m_iterableProfile;
        IterationModeMetadata m_iterationMetadata;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
        static constexpr ptrdiff_t offsetOfDoneModeMetadata() { return OBJECT_OFFSETOF(Metadata, m_doneModeMetadata); }
        static constexpr ptrdiff_t offsetOfValueModeMetadata() { return OBJECT_OFFSETOF(Metadata, m_valueModeMetadata); }
        static constexpr ptrdiff_t offsetOfIterableProfile() { return OBJECT_OFFSETOF(Metadata, m_iterableProfile); }
        static constexpr ptrdiff_t offsetOfIterationMetadata() { return OBJECT_OFFSETOF(Metadata, m_iterationMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_done;
    VirtualRegister m_value;
    VirtualRegister m_iterable;
    VirtualRegister m_next;
    VirtualRegister m_iterator;
    unsigned m_stackOffset;
    unsigned m_nextResultValueProfile;
    unsigned m_doneValueProfile;
    unsigned m_valueValueProfile;
    unsigned m_metadataID;
};
static_assert(OpIteratorNext::length + 1 > OpIteratorNext::numberOfCheckpoints, "FullBytecodeLivess relies on the length of OpIteratorNext being greater than the number of checkpoints");

struct OpConstructVarargs : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_construct_varargs;
    static constexpr size_t length = 8;
    enum Tmps : uint8_t {
        argCountIncludingThis,
    };
    enum Checkpoints : uint8_t {
        determiningArgCount,
        makeCall,
        numberOfCheckpoints,
    };


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**construct_varargs"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("arguments", m_arguments, false);
        dumper->dumpOperand("firstFree", m_firstFree, false);
        dumper->dumpOperand("firstVarArg", m_firstVarArg, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpConstructVarargs(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpConstructVarargs(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpConstructVarargs(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpConstructVarargs decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<int, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_construct_varargs;
        Metadata(const OpConstructVarargs&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};
static_assert(OpConstructVarargs::length + 1 > OpConstructVarargs::numberOfCheckpoints, "FullBytecodeLivess relies on the length of OpConstructVarargs being greater than the number of checkpoints");

struct OpSuperConstructVarargs : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_super_construct_varargs;
    static constexpr size_t length = 8;
    enum Tmps : uint8_t {
        argCountIncludingThis,
    };
    enum Checkpoints : uint8_t {
        determiningArgCount,
        makeCall,
        numberOfCheckpoints,
    };


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned valueProfile, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**super_construct_varargs"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("arguments", m_arguments, false);
        dumper->dumpOperand("firstFree", m_firstFree, false);
        dumper->dumpOperand("firstVarArg", m_firstVarArg, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpSuperConstructVarargs(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpSuperConstructVarargs(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpSuperConstructVarargs(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpSuperConstructVarargs decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<int, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_super_construct_varargs;
        Metadata(const OpSuperConstructVarargs&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        WriteBarrier<JSCell> m_cachedCallee;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
        static constexpr ptrdiff_t offsetOfCachedCallee() { return OBJECT_OFFSETOF(Metadata, m_cachedCallee); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};
static_assert(OpSuperConstructVarargs::length + 1 > OpSuperConstructVarargs::numberOfCheckpoints, "FullBytecodeLivess relies on the length of OpSuperConstructVarargs being greater than the number of checkpoints");

struct OpIteratorOpen : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_iterator_open;
    static constexpr size_t length = 9;
    
    enum Checkpoints : uint8_t {
        symbolCall,
        getNext,
        numberOfCheckpoints,
    };


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister iterator, VirtualRegister next, VirtualRegister symbolIterator, VirtualRegister iterable, unsigned stackOffset, unsigned iterableValueProfile, unsigned iteratorValueProfile, unsigned nextValueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister iterator, VirtualRegister next, VirtualRegister symbolIterator, VirtualRegister iterable, unsigned stackOffset, unsigned iterableValueProfile, unsigned iteratorValueProfile, unsigned nextValueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister iterator, VirtualRegister next, VirtualRegister symbolIterator, VirtualRegister iterable, unsigned stackOffset, unsigned iterableValueProfile, unsigned iteratorValueProfile, unsigned nextValueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister iterator, VirtualRegister next, VirtualRegister symbolIterator, VirtualRegister iterable, unsigned stackOffset, unsigned iterableValueProfile, unsigned iteratorValueProfile, unsigned nextValueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister iterator, VirtualRegister next, VirtualRegister symbolIterator, VirtualRegister iterable, unsigned stackOffset, unsigned iterableValueProfile, unsigned iteratorValueProfile, unsigned nextValueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& iterator, VirtualRegister& next, VirtualRegister& symbolIterator, VirtualRegister& iterable, unsigned& stackOffset, unsigned& iterableValueProfile, unsigned& iteratorValueProfile, unsigned& nextValueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(iterator)
            && Fits<VirtualRegister, __size>::check(next)
            && Fits<VirtualRegister, __size>::check(symbolIterator)
            && Fits<VirtualRegister, __size>::check(iterable)
            && Fits<unsigned, __size>::check(stackOffset)
            && Fits<unsigned, __size>::check(iterableValueProfile)
            && Fits<unsigned, __size>::check(iteratorValueProfile)
            && Fits<unsigned, __size>::check(nextValueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister iterator, VirtualRegister next, VirtualRegister symbolIterator, VirtualRegister iterable, unsigned stackOffset, unsigned iterableValueProfile, unsigned iteratorValueProfile, unsigned nextValueProfile, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, iterator, next, symbolIterator, iterable, stackOffset, iterableValueProfile, iteratorValueProfile, nextValueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(iterator));
            gen->write(Fits<VirtualRegister, __size>::convert(next));
            gen->write(Fits<VirtualRegister, __size>::convert(symbolIterator));
            gen->write(Fits<VirtualRegister, __size>::convert(iterable));
            gen->write(Fits<unsigned, __size>::convert(stackOffset));
            gen->write(Fits<unsigned, __size>::convert(iterableValueProfile));
            gen->write(Fits<unsigned, __size>::convert(iteratorValueProfile));
            gen->write(Fits<unsigned, __size>::convert(nextValueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**iterator_open"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("iterator", m_iterator, true);
        dumper->dumpOperand("next", m_next, false);
        dumper->dumpOperand("symbolIterator", m_symbolIterator, false);
        dumper->dumpOperand("iterable", m_iterable, false);
        dumper->dumpOperand("stackOffset", m_stackOffset, false);
        dumper->dumpOperand("iterableValueProfile", m_iterableValueProfile, false);
        dumper->dumpOperand("iteratorValueProfile", m_iteratorValueProfile, false);
        dumper->dumpOperand("nextValueProfile", m_nextValueProfile, false);
    }

    OpIteratorOpen(const uint8_t* stream)
        : m_iterator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_next(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_symbolIterator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_iterable(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_stackOffset(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_iterableValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
        , m_iteratorValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_nextValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[8]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpIteratorOpen(const uint16_t* stream)
        : m_iterator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_next(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_symbolIterator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_iterable(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_stackOffset(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_iterableValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
        , m_iteratorValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_nextValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[8]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpIteratorOpen(const uint32_t* stream)
        : m_iterator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_next(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_symbolIterator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_iterable(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_stackOffset(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_iterableValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
        , m_iteratorValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_nextValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[8]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpIteratorOpen decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setIterator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIterator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIterator<OpcodeSize::Wide16>(value, func);
        else
            setIterator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIterator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setNext(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setNext<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setNext<OpcodeSize::Wide16>(value, func);
        else
            setNext<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setNext(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSymbolIterator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setSymbolIterator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSymbolIterator<OpcodeSize::Wide16>(value, func);
        else
            setSymbolIterator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSymbolIterator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIterable(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIterable<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIterable<OpcodeSize::Wide16>(value, func);
        else
            setIterable<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIterable(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setStackOffset(unsigned value, Functor func)
    {
        if (isWide32())
            setStackOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setStackOffset<OpcodeSize::Wide16>(value, func);
        else
            setStackOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setStackOffset(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setIterableValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setIterableValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIterableValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setIterableValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIterableValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setIteratorValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setIteratorValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIteratorValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setIteratorValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIteratorValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setNextValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setNextValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setNextValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setNextValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setNextValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 7 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_iterator_open;
        Metadata(const OpIteratorOpen&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        GetByIdModeMetadata m_modeMetadata;
        ArrayProfile m_arrayProfile;
        IterationModeMetadata m_iterationMetadata;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
        static constexpr ptrdiff_t offsetOfModeMetadata() { return OBJECT_OFFSETOF(Metadata, m_modeMetadata); }
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
        static constexpr ptrdiff_t offsetOfIterationMetadata() { return OBJECT_OFFSETOF(Metadata, m_iterationMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_iterator;
    VirtualRegister m_next;
    VirtualRegister m_symbolIterator;
    VirtualRegister m_iterable;
    unsigned m_stackOffset;
    unsigned m_iterableValueProfile;
    unsigned m_iteratorValueProfile;
    unsigned m_nextValueProfile;
    unsigned m_metadataID;
};
static_assert(OpIteratorOpen::length + 1 > OpIteratorOpen::numberOfCheckpoints, "FullBytecodeLivess relies on the length of OpIteratorOpen being greater than the number of checkpoints");

struct OpInstanceof : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_instanceof;
    static constexpr size_t length = 7;
    
    enum Checkpoints : uint8_t {
        getHasInstance,
        getPrototype,
        instanceof,
        numberOfCheckpoints,
    };


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceOrPrototype, unsigned hasInstanceValueProfile, unsigned prototypeValueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceOrPrototype, unsigned hasInstanceValueProfile, unsigned prototypeValueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceOrPrototype, unsigned hasInstanceValueProfile, unsigned prototypeValueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceOrPrototype, unsigned hasInstanceValueProfile, unsigned prototypeValueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceOrPrototype, unsigned hasInstanceValueProfile, unsigned prototypeValueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& value, VirtualRegister& constructor, VirtualRegister& hasInstanceOrPrototype, unsigned& hasInstanceValueProfile, unsigned& prototypeValueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(constructor)
            && Fits<VirtualRegister, __size>::check(hasInstanceOrPrototype)
            && Fits<unsigned, __size>::check(hasInstanceValueProfile)
            && Fits<unsigned, __size>::check(prototypeValueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceOrPrototype, unsigned hasInstanceValueProfile, unsigned prototypeValueProfile, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, value, constructor, hasInstanceOrPrototype, hasInstanceValueProfile, prototypeValueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(constructor));
            gen->write(Fits<VirtualRegister, __size>::convert(hasInstanceOrPrototype));
            gen->write(Fits<unsigned, __size>::convert(hasInstanceValueProfile));
            gen->write(Fits<unsigned, __size>::convert(prototypeValueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**instanceof"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("constructor", m_constructor, false);
        dumper->dumpOperand("hasInstanceOrPrototype", m_hasInstanceOrPrototype, false);
        dumper->dumpOperand("hasInstanceValueProfile", m_hasInstanceValueProfile, false);
        dumper->dumpOperand("prototypeValueProfile", m_prototypeValueProfile, false);
    }

    OpInstanceof(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_hasInstanceOrPrototype(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_hasInstanceValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_prototypeValueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpInstanceof(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_hasInstanceOrPrototype(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_hasInstanceValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_prototypeValueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpInstanceof(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_hasInstanceOrPrototype(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_hasInstanceValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_prototypeValueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpInstanceof decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setConstructor(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setConstructor<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setConstructor<OpcodeSize::Wide16>(value, func);
        else
            setConstructor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setConstructor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setHasInstanceOrPrototype(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setHasInstanceOrPrototype<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setHasInstanceOrPrototype<OpcodeSize::Wide16>(value, func);
        else
            setHasInstanceOrPrototype<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setHasInstanceOrPrototype(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setHasInstanceValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setHasInstanceValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setHasInstanceValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setHasInstanceValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setHasInstanceValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setPrototypeValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setPrototypeValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setPrototypeValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setPrototypeValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPrototypeValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_instanceof;
        Metadata(const OpInstanceof&) { }

        GetByIdModeMetadata m_hasInstanceModeMetadata;
        GetByIdModeMetadata m_prototypeModeMetadata;
        static constexpr ptrdiff_t offsetOfHasInstanceModeMetadata() { return OBJECT_OFFSETOF(Metadata, m_hasInstanceModeMetadata); }
        static constexpr ptrdiff_t offsetOfPrototypeModeMetadata() { return OBJECT_OFFSETOF(Metadata, m_prototypeModeMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_value;
    VirtualRegister m_constructor;
    VirtualRegister m_hasInstanceOrPrototype;
    unsigned m_hasInstanceValueProfile;
    unsigned m_prototypeValueProfile;
    unsigned m_metadataID;
};
static_assert(OpInstanceof::length + 1 > OpInstanceof::numberOfCheckpoints, "FullBytecodeLivess relies on the length of OpInstanceof being greater than the number of checkpoints");

struct OpSetPrivateBrand : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_set_private_brand;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, brand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, brand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, brand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, brand, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, brand, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, brand, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, brand, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& brand, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(brand)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, brand, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(brand));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**set_private_brand"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("brand", m_brand, false);
    }

    OpSetPrivateBrand(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpSetPrivateBrand(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpSetPrivateBrand(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpSetPrivateBrand decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBrand(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBrand<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBrand<OpcodeSize::Wide16>(value, func);
        else
            setBrand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBrand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_set_private_brand;
        Metadata(const OpSetPrivateBrand&) { }

        StructureID m_oldStructureID;
        StructureID m_newStructureID;
        WriteBarrier<JSCell> m_brand;
        static constexpr ptrdiff_t offsetOfOldStructureID() { return OBJECT_OFFSETOF(Metadata, m_oldStructureID); }
        static constexpr ptrdiff_t offsetOfNewStructureID() { return OBJECT_OFFSETOF(Metadata, m_newStructureID); }
        static constexpr ptrdiff_t offsetOfBrand() { return OBJECT_OFFSETOF(Metadata, m_brand); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_brand;
    unsigned m_metadataID;
};


struct OpCheckPrivateBrand : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_check_private_brand;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, brand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, brand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, brand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, brand, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, brand, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, brand, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, brand, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& brand, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(brand)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister brand, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, brand, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(brand));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**check_private_brand"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("brand", m_brand, false);
    }

    OpCheckPrivateBrand(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCheckPrivateBrand(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCheckPrivateBrand(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCheckPrivateBrand decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBrand(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBrand<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBrand<OpcodeSize::Wide16>(value, func);
        else
            setBrand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBrand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_check_private_brand;
        Metadata(const OpCheckPrivateBrand&) { }

        StructureID m_structureID;
        WriteBarrier<JSCell> m_brand;
        static constexpr ptrdiff_t offsetOfStructureID() { return OBJECT_OFFSETOF(Metadata, m_structureID); }
        static constexpr ptrdiff_t offsetOfBrand() { return OBJECT_OFFSETOF(Metadata, m_brand); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_brand;
    unsigned m_metadataID;
};


struct OpPutById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_by_id;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value, flags);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, property, value, flags, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, property, value, flags, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, flags, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, flags, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, flags, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, flags, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, VirtualRegister& value, PutByIdFlags& flags, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<PutByIdFlags, __size>::check(flags)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, flags, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<PutByIdFlags, __size>::convert(flags));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("flags", m_flags, false);
    }

    OpPutById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_flags(Fits<PutByIdFlags, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_flags(Fits<PutByIdFlags, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_flags(Fits<PutByIdFlags, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFlags(PutByIdFlags value, Functor func)
    {
        if (isWide32())
            setFlags<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFlags<OpcodeSize::Wide16>(value, func);
        else
            setFlags<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFlags(PutByIdFlags value, Functor func)
    {
        if (!Fits<PutByIdFlags, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<PutByIdFlags, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_put_by_id;
        Metadata(const OpPutById&) { }

        StructureID m_oldStructureID;
        unsigned m_offset;
        StructureID m_newStructureID;
        WriteBarrierBase<StructureChain> m_structureChain;
        static constexpr ptrdiff_t offsetOfOldStructureID() { return OBJECT_OFFSETOF(Metadata, m_oldStructureID); }
        static constexpr ptrdiff_t offsetOfOffset() { return OBJECT_OFFSETOF(Metadata, m_offset); }
        static constexpr ptrdiff_t offsetOfNewStructureID() { return OBJECT_OFFSETOF(Metadata, m_newStructureID); }
        static constexpr ptrdiff_t offsetOfStructureChain() { return OBJECT_OFFSETOF(Metadata, m_structureChain); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    unsigned m_property;
    VirtualRegister m_value;
    PutByIdFlags m_flags;
    unsigned m_metadataID;
};


struct OpConstruct : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_construct;
    static constexpr size_t length = 6;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**construct"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("argc", m_argc, false);
        dumper->dumpOperand("argv", m_argv, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpConstruct(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpConstruct(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpConstruct(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpConstruct decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_construct;
        Metadata(const OpConstruct&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpSuperConstruct : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_super_construct;
    static constexpr size_t length = 6;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**super_construct"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("argc", m_argc, false);
        dumper->dumpOperand("argv", m_argv, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpSuperConstruct(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpSuperConstruct(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpSuperConstruct(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpSuperConstruct decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_super_construct;
        Metadata(const OpSuperConstruct&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        WriteBarrier<JSCell> m_cachedCallee;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
        static constexpr ptrdiff_t offsetOfCachedCallee() { return OBJECT_OFFSETOF(Metadata, m_cachedCallee); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpTailCall : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_tail_call;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**tail_call"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("argc", m_argc, false);
        dumper->dumpOperand("argv", m_argv, false);
    }

    OpTailCall(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpTailCall(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpTailCall(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpTailCall decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_tail_call;
        Metadata(const OpTailCall&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_metadataID;
};


struct OpCallDirectEval : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_call_direct_eval;
    static constexpr size_t length = 9;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, VirtualRegister thisValue, VirtualRegister scope, unsigned lexicallyScopedFeatures, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, VirtualRegister thisValue, VirtualRegister scope, unsigned lexicallyScopedFeatures, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, VirtualRegister thisValue, VirtualRegister scope, unsigned lexicallyScopedFeatures, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, VirtualRegister thisValue, VirtualRegister scope, unsigned lexicallyScopedFeatures, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, VirtualRegister thisValue, VirtualRegister scope, unsigned lexicallyScopedFeatures, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, VirtualRegister& thisValue, VirtualRegister& scope, unsigned& lexicallyScopedFeatures, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(scope)
            && Fits<unsigned, __size>::check(lexicallyScopedFeatures)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, VirtualRegister thisValue, VirtualRegister scope, unsigned lexicallyScopedFeatures, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, thisValue, scope, lexicallyScopedFeatures, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(scope));
            gen->write(Fits<unsigned, __size>::convert(lexicallyScopedFeatures));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**call_direct_eval"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("argc", m_argc, false);
        dumper->dumpOperand("argv", m_argv, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("scope", m_scope, false);
        dumper->dumpOperand("lexicallyScopedFeatures", m_lexicallyScopedFeatures, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpCallDirectEval(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[5]))
        , m_lexicallyScopedFeatures(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[8]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCallDirectEval(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[5]))
        , m_lexicallyScopedFeatures(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[8]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCallDirectEval(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[5]))
        , m_lexicallyScopedFeatures(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[8]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCallDirectEval decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setScope<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setScope<OpcodeSize::Wide16>(value, func);
        else
            setScope<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLexicallyScopedFeatures(unsigned value, Functor func)
    {
        if (isWide32())
            setLexicallyScopedFeatures<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLexicallyScopedFeatures<OpcodeSize::Wide16>(value, func);
        else
            setLexicallyScopedFeatures<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLexicallyScopedFeatures(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 7 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_call_direct_eval;
        Metadata(const OpCallDirectEval&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    VirtualRegister m_thisValue;
    VirtualRegister m_scope;
    unsigned m_lexicallyScopedFeatures;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpTailCallForwardArguments : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_tail_call_forward_arguments;
    static constexpr size_t length = 7;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**tail_call_forward_arguments"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("arguments", m_arguments, false);
        dumper->dumpOperand("firstFree", m_firstFree, false);
        dumper->dumpOperand("firstVarArg", m_firstVarArg, false);
    }

    OpTailCallForwardArguments(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpTailCallForwardArguments(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpTailCallForwardArguments(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpTailCallForwardArguments decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_tail_call_forward_arguments;
        Metadata(const OpTailCallForwardArguments&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_metadataID;
};


struct OpCreateGenerator : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_create_generator;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_generator"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
    }

    OpCreateGenerator(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCreateGenerator(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCreateGenerator(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCreateGenerator decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_create_generator;
        Metadata(const OpCreateGenerator&) { }

        WriteBarrier<JSCell> m_cachedCallee;
        static constexpr ptrdiff_t offsetOfCachedCallee() { return OBJECT_OFFSETOF(Metadata, m_cachedCallee); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_metadataID;
};


struct OpCreateAsyncGenerator : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_create_async_generator;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_async_generator"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
    }

    OpCreateAsyncGenerator(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCreateAsyncGenerator(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCreateAsyncGenerator(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCreateAsyncGenerator decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_create_async_generator;
        Metadata(const OpCreateAsyncGenerator&) { }

        WriteBarrier<JSCell> m_cachedCallee;
        static constexpr ptrdiff_t offsetOfCachedCallee() { return OBJECT_OFFSETOF(Metadata, m_cachedCallee); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_metadataID;
};


struct OpCreatePromise : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_create_promise;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, isInternalPromise);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, isInternalPromise, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, isInternalPromise, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, isInternalPromise, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, isInternalPromise, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, isInternalPromise, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, isInternalPromise, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, bool& isInternalPromise, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<bool, __size>::check(isInternalPromise)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, isInternalPromise, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<bool, __size>::convert(isInternalPromise));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_promise"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("isInternalPromise", m_isInternalPromise, false);
    }

    OpCreatePromise(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_isInternalPromise(Fits<bool, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCreatePromise(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_isInternalPromise(Fits<bool, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCreatePromise(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_isInternalPromise(Fits<bool, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCreatePromise decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIsInternalPromise(bool value, Functor func)
    {
        if (isWide32())
            setIsInternalPromise<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIsInternalPromise<OpcodeSize::Wide16>(value, func);
        else
            setIsInternalPromise<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIsInternalPromise(bool value, Functor func)
    {
        if (!Fits<bool, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<bool, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_create_promise;
        Metadata(const OpCreatePromise&) { }

        WriteBarrier<JSCell> m_cachedCallee;
        static constexpr ptrdiff_t offsetOfCachedCallee() { return OBJECT_OFFSETOF(Metadata, m_cachedCallee); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    bool m_isInternalPromise;
    unsigned m_metadataID;
};


struct OpCatch : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_catch;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, exception, thrownValue);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, exception, thrownValue, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, exception, thrownValue, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, exception, thrownValue, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, exception, thrownValue, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, exception, thrownValue, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, exception, thrownValue, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& exception, VirtualRegister& thrownValue, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(exception)
            && Fits<VirtualRegister, __size>::check(thrownValue)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, exception, thrownValue, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(exception));
            gen->write(Fits<VirtualRegister, __size>::convert(thrownValue));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**catch"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("exception", m_exception, true);
        dumper->dumpOperand("thrownValue", m_thrownValue, false);
    }

    OpCatch(const uint8_t* stream)
        : m_exception(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_thrownValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCatch(const uint16_t* stream)
        : m_exception(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_thrownValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCatch(const uint32_t* stream)
        : m_exception(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_thrownValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCatch decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setException(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setException<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setException<OpcodeSize::Wide16>(value, func);
        else
            setException<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setException(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThrownValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThrownValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThrownValue<OpcodeSize::Wide16>(value, func);
        else
            setThrownValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThrownValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_catch;
        Metadata(const OpCatch&) { }

        ValueProfileAndVirtualRegisterBuffer* m_buffer;
        static constexpr ptrdiff_t offsetOfBuffer() { return OBJECT_OFFSETOF(Metadata, m_buffer); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_exception;
    VirtualRegister m_thrownValue;
    unsigned m_metadataID;
};


struct OpNewArrayWithSize : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_new_array_with_size;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, length);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, length, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, length, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, length, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, length, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, length, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, length, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& length, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(length)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, length, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(length));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_array_with_size"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("length", m_length, false);
    }

    OpNewArrayWithSize(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpNewArrayWithSize(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpNewArrayWithSize(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpNewArrayWithSize decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLength(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLength<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLength<OpcodeSize::Wide16>(value, func);
        else
            setLength<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLength(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_new_array_with_size;
        Metadata(const OpNewArrayWithSize&) { }

        ArrayAllocationProfile m_arrayAllocationProfile;
        static constexpr ptrdiff_t offsetOfArrayAllocationProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayAllocationProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_length;
    unsigned m_metadataID;
};


struct OpNewArrayBuffer : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_new_array_buffer;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, immutableButterfly, recommendedIndexingType);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& immutableButterfly, IndexingType& recommendedIndexingType, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(immutableButterfly)
            && Fits<IndexingType, __size>::check(recommendedIndexingType)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(immutableButterfly));
            gen->write(Fits<IndexingType, __size>::convert(recommendedIndexingType));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_array_buffer"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("immutableButterfly", m_immutableButterfly, false);
        dumper->dumpOperand("recommendedIndexingType", m_recommendedIndexingType, false);
    }

    OpNewArrayBuffer(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_immutableButterfly(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpNewArrayBuffer(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_immutableButterfly(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpNewArrayBuffer(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_immutableButterfly(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpNewArrayBuffer decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setImmutableButterfly(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setImmutableButterfly<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setImmutableButterfly<OpcodeSize::Wide16>(value, func);
        else
            setImmutableButterfly<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setImmutableButterfly(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (isWide32())
            setRecommendedIndexingType<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRecommendedIndexingType<OpcodeSize::Wide16>(value, func);
        else
            setRecommendedIndexingType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (!Fits<IndexingType, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<IndexingType, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_new_array_buffer;
        Metadata(const OpNewArrayBuffer&) { }

        ArrayAllocationProfile m_arrayAllocationProfile;
        static constexpr ptrdiff_t offsetOfArrayAllocationProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayAllocationProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_immutableButterfly;
    IndexingType m_recommendedIndexingType;
    unsigned m_metadataID;
};


struct OpGetById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_by_id;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_get_by_id;
        Metadata(const OpGetById&) { }

        GetByIdModeMetadata m_modeMetadata;
        static constexpr ptrdiff_t offsetOfModeMetadata() { return OBJECT_OFFSETOF(Metadata, m_modeMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpGetLength : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_length;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_length"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetLength(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetLength(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetLength(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetLength decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_get_length;
        Metadata(const OpGetLength&) { }

        GetByIdModeMetadata m_modeMetadata;
        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfModeMetadata() { return OBJECT_OFFSETOF(Metadata, m_modeMetadata); }
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpProfileType : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_profile_type;
    static constexpr size_t length = 6;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& targetVirtualRegister, SymbolTableOrScopeDepth& symbolTableOrScopeDepth, ProfileTypeBytecodeFlag& flag, unsigned& identifier, ResolveType& resolveType, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(targetVirtualRegister)
            && Fits<SymbolTableOrScopeDepth, __size>::check(symbolTableOrScopeDepth)
            && Fits<ProfileTypeBytecodeFlag, __size>::check(flag)
            && Fits<unsigned, __size>::check(identifier)
            && Fits<ResolveType, __size>::check(resolveType)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(targetVirtualRegister));
            gen->write(Fits<SymbolTableOrScopeDepth, __size>::convert(symbolTableOrScopeDepth));
            gen->write(Fits<ProfileTypeBytecodeFlag, __size>::convert(flag));
            gen->write(Fits<unsigned, __size>::convert(identifier));
            gen->write(Fits<ResolveType, __size>::convert(resolveType));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**profile_type"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("targetVirtualRegister", m_targetVirtualRegister, true);
        dumper->dumpOperand("symbolTableOrScopeDepth", m_symbolTableOrScopeDepth, false);
        dumper->dumpOperand("flag", m_flag, false);
        dumper->dumpOperand("identifier", m_identifier, false);
        dumper->dumpOperand("resolveType", m_resolveType, false);
    }

    OpProfileType(const uint8_t* stream)
        : m_targetVirtualRegister(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Narrow>::convert(stream[1]))
        , m_flag(Fits<ProfileTypeBytecodeFlag, OpcodeSize::Narrow>::convert(stream[2]))
        , m_identifier(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpProfileType(const uint16_t* stream)
        : m_targetVirtualRegister(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide16>::convert(stream[1]))
        , m_flag(Fits<ProfileTypeBytecodeFlag, OpcodeSize::Wide16>::convert(stream[2]))
        , m_identifier(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpProfileType(const uint32_t* stream)
        : m_targetVirtualRegister(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide32>::convert(stream[1]))
        , m_flag(Fits<ProfileTypeBytecodeFlag, OpcodeSize::Wide32>::convert(stream[2]))
        , m_identifier(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpProfileType decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setTargetVirtualRegister(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setTargetVirtualRegister<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetVirtualRegister<OpcodeSize::Wide16>(value, func);
        else
            setTargetVirtualRegister<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetVirtualRegister(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (isWide32())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setSymbolTableOrScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (!Fits<SymbolTableOrScopeDepth, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<SymbolTableOrScopeDepth, size>::convert(value);
    }

    template<typename Functor>
    void setFlag(ProfileTypeBytecodeFlag value, Functor func)
    {
        if (isWide32())
            setFlag<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setFlag<OpcodeSize::Wide16>(value, func);
        else
            setFlag<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFlag(ProfileTypeBytecodeFlag value, Functor func)
    {
        if (!Fits<ProfileTypeBytecodeFlag, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ProfileTypeBytecodeFlag, size>::convert(value);
    }

    template<typename Functor>
    void setIdentifier(unsigned value, Functor func)
    {
        if (isWide32())
            setIdentifier<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIdentifier<OpcodeSize::Wide16>(value, func);
        else
            setIdentifier<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIdentifier(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (isWide32())
            setResolveType<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setResolveType<OpcodeSize::Wide16>(value, func);
        else
            setResolveType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (!Fits<ResolveType, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ResolveType, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_profile_type;
        Metadata(const OpProfileType&) { }

        TypeLocation* m_typeLocation;
        static constexpr ptrdiff_t offsetOfTypeLocation() { return OBJECT_OFFSETOF(Metadata, m_typeLocation); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_targetVirtualRegister;
    SymbolTableOrScopeDepth m_symbolTableOrScopeDepth;
    ProfileTypeBytecodeFlag m_flag;
    unsigned m_identifier;
    ResolveType m_resolveType;
    unsigned m_metadataID;
};


struct OpProfileControlFlow : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_profile_control_flow;
    static constexpr size_t length = 2;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, int textOffset)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, textOffset);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, int textOffset)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, textOffset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, int textOffset)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, textOffset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, int textOffset, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, textOffset, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, int textOffset)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, textOffset, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, textOffset, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, textOffset, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, int& textOffset, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<int, __size>::check(textOffset)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, int textOffset, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, textOffset, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<int, __size>::convert(textOffset));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**profile_control_flow"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("textOffset", m_textOffset, true);
    }

    OpProfileControlFlow(const uint8_t* stream)
        : m_textOffset(Fits<int, OpcodeSize::Narrow>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpProfileControlFlow(const uint16_t* stream)
        : m_textOffset(Fits<int, OpcodeSize::Wide16>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpProfileControlFlow(const uint32_t* stream)
        : m_textOffset(Fits<int, OpcodeSize::Wide32>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpProfileControlFlow decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setTextOffset(int value, Functor func)
    {
        if (isWide32())
            setTextOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTextOffset<OpcodeSize::Wide16>(value, func);
        else
            setTextOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTextOffset(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_profile_control_flow;
        Metadata(const OpProfileControlFlow&) { }

        BasicBlockLocation* m_basicBlockLocation;
        static constexpr ptrdiff_t offsetOfBasicBlockLocation() { return OBJECT_OFFSETOF(Metadata, m_basicBlockLocation); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    int m_textOffset;
    unsigned m_metadataID;
};


struct OpNewArrayWithSpecies : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_new_array_with_species;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, VirtualRegister array, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, length, array, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, VirtualRegister array, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, length, array, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, VirtualRegister array, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, length, array, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, VirtualRegister array, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, length, array, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, VirtualRegister array, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, length, array, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, length, array, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, length, array, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& length, VirtualRegister& array, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(length)
            && Fits<VirtualRegister, __size>::check(array)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, VirtualRegister array, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, length, array, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(length));
            gen->write(Fits<VirtualRegister, __size>::convert(array));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_array_with_species"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("length", m_length, false);
        dumper->dumpOperand("array", m_array, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpNewArrayWithSpecies(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_array(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpNewArrayWithSpecies(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_array(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpNewArrayWithSpecies(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_array(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpNewArrayWithSpecies decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLength(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLength<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLength<OpcodeSize::Wide16>(value, func);
        else
            setLength<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLength(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArray(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArray<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArray<OpcodeSize::Wide16>(value, func);
        else
            setArray<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArray(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_new_array_with_species;
        Metadata(const OpNewArrayWithSpecies&) { }

        ArrayAllocationProfile m_arrayAllocationProfile;
        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfArrayAllocationProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayAllocationProfile); }
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_length;
    VirtualRegister m_array;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpCall : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_call;
    static constexpr size_t length = 6;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**call"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("argc", m_argc, false);
        dumper->dumpOperand("argv", m_argv, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpCall(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCall(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCall(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCall decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_call;
        Metadata(const OpCall&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpCallIgnoreResult : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_call_ignore_result;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, callee, argc, argv);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, callee, argc, argv, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, callee, argc, argv, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, callee, argc, argv, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, callee, argc, argv, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, callee, argc, argv, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**call_ignore_result"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("callee", m_callee, true);
        dumper->dumpOperand("argc", m_argc, false);
        dumper->dumpOperand("argv", m_argv, false);
    }

    OpCallIgnoreResult(const uint8_t* stream)
        : m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCallIgnoreResult(const uint16_t* stream)
        : m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCallIgnoreResult(const uint32_t* stream)
        : m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCallIgnoreResult decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_call_ignore_result;
        Metadata(const OpCallIgnoreResult&) { }

        DataOnlyCallLinkInfo m_callLinkInfo;
        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfCallLinkInfo() { return OBJECT_OFFSETOF(Metadata, m_callLinkInfo); }
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_metadataID;
};


struct OpResolveScope : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_resolve_scope;
    static constexpr size_t length = 6;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, scope, var, resolveType, localScopeDepth);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& scope, unsigned& var, ResolveType& resolveType, unsigned& localScopeDepth, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(scope)
            && Fits<unsigned, __size>::check(var)
            && Fits<ResolveType, __size>::check(resolveType)
            && Fits<unsigned, __size>::check(localScopeDepth)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(scope));
            gen->write(Fits<unsigned, __size>::convert(var));
            gen->write(Fits<ResolveType, __size>::convert(resolveType));
            gen->write(Fits<unsigned, __size>::convert(localScopeDepth));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**resolve_scope"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("scope", m_scope, false);
        dumper->dumpOperand("var", m_var, false);
        dumper->dumpOperand("resolveType", m_resolveType, false);
        dumper->dumpOperand("localScopeDepth", m_localScopeDepth, false);
    }

    OpResolveScope(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Narrow>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpResolveScope(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide16>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpResolveScope(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide32>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpResolveScope decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setScope<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setScope<OpcodeSize::Wide16>(value, func);
        else
            setScope<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (isWide32())
            setVar<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setVar<OpcodeSize::Wide16>(value, func);
        else
            setVar<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (isWide32())
            setResolveType<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setResolveType<OpcodeSize::Wide16>(value, func);
        else
            setResolveType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (!Fits<ResolveType, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ResolveType, size>::convert(value);
    }

    template<typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (isWide32())
            setLocalScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLocalScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setLocalScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_resolve_scope;
        Metadata(const OpResolveScope&) { }

        ResolveType m_resolveType;
        union {
            unsigned m_localScopeDepth;
            unsigned m_globalLexicalBindingEpoch;
        };
        union {
            WriteBarrierBase<JSCell> m_lexicalEnvironment;
            WriteBarrierBase<SymbolTable> m_symbolTable;
            WriteBarrierBase<JSScope> m_constantScope;
            WriteBarrierBase<JSGlobalLexicalEnvironment> m_globalLexicalEnvironment;
            WriteBarrierBase<JSGlobalObject> m_globalObject;
        };
        static constexpr ptrdiff_t offsetOfResolveType() { return OBJECT_OFFSETOF(Metadata, m_resolveType); }
        static constexpr ptrdiff_t offsetOfLocalScopeDepth() { return OBJECT_OFFSETOF(Metadata, m_localScopeDepth); }
        static constexpr ptrdiff_t offsetOfGlobalLexicalBindingEpoch() { return OBJECT_OFFSETOF(Metadata, m_globalLexicalBindingEpoch); }
        static constexpr ptrdiff_t offsetOfLexicalEnvironment() { return OBJECT_OFFSETOF(Metadata, m_lexicalEnvironment); }
        static constexpr ptrdiff_t offsetOfSymbolTable() { return OBJECT_OFFSETOF(Metadata, m_symbolTable); }
        static constexpr ptrdiff_t offsetOfConstantScope() { return OBJECT_OFFSETOF(Metadata, m_constantScope); }
        static constexpr ptrdiff_t offsetOfGlobalLexicalEnvironment() { return OBJECT_OFFSETOF(Metadata, m_globalLexicalEnvironment); }
        static constexpr ptrdiff_t offsetOfGlobalObject() { return OBJECT_OFFSETOF(Metadata, m_globalObject); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_scope;
    unsigned m_var;
    ResolveType m_resolveType;
    unsigned m_localScopeDepth;
    unsigned m_metadataID;
};


struct OpGetFromScope : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_from_scope;
    static constexpr size_t length = 8;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& scope, unsigned& var, GetPutInfo& getPutInfo, unsigned& localScopeDepth, unsigned& offset, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(scope)
            && Fits<unsigned, __size>::check(var)
            && Fits<GetPutInfo, __size>::check(getPutInfo)
            && Fits<unsigned, __size>::check(localScopeDepth)
            && Fits<unsigned, __size>::check(offset)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(scope));
            gen->write(Fits<unsigned, __size>::convert(var));
            gen->write(Fits<GetPutInfo, __size>::convert(getPutInfo));
            gen->write(Fits<unsigned, __size>::convert(localScopeDepth));
            gen->write(Fits<unsigned, __size>::convert(offset));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_from_scope"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("scope", m_scope, false);
        dumper->dumpOperand("var", m_var, false);
        dumper->dumpOperand("getPutInfo", m_getPutInfo, false);
        dumper->dumpOperand("localScopeDepth", m_localScopeDepth, false);
        dumper->dumpOperand("offset", m_offset, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetFromScope(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Narrow>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetFromScope(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide16>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetFromScope(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide32>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetFromScope decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setScope<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setScope<OpcodeSize::Wide16>(value, func);
        else
            setScope<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (isWide32())
            setVar<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setVar<OpcodeSize::Wide16>(value, func);
        else
            setVar<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (isWide32())
            setGetPutInfo<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setGetPutInfo<OpcodeSize::Wide16>(value, func);
        else
            setGetPutInfo<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (!Fits<GetPutInfo, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<GetPutInfo, size>::convert(value);
    }

    template<typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (isWide32())
            setLocalScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLocalScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setLocalScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (isWide32())
            setOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setOffset<OpcodeSize::Wide16>(value, func);
        else
            setOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_get_from_scope;
        Metadata(const OpGetFromScope& __op)
            : m_getPutInfo(__op.m_getPutInfo)
            , m_operand(__op.m_offset)
        { }

        GetPutInfo m_getPutInfo;
        union {
            WatchpointSet* m_watchpointSet;
            WriteBarrierBase<Structure> m_structure;
        };
        uintptr_t m_operand;
        static constexpr ptrdiff_t offsetOfGetPutInfo() { return OBJECT_OFFSETOF(Metadata, m_getPutInfo); }
        static constexpr ptrdiff_t offsetOfWatchpointSet() { return OBJECT_OFFSETOF(Metadata, m_watchpointSet); }
        static constexpr ptrdiff_t offsetOfStructure() { return OBJECT_OFFSETOF(Metadata, m_structure); }
        static constexpr ptrdiff_t offsetOfOperand() { return OBJECT_OFFSETOF(Metadata, m_operand); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_scope;
    unsigned m_var;
    GetPutInfo m_getPutInfo;
    unsigned m_localScopeDepth;
    unsigned m_offset;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpPutToScope : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_to_scope;
    static constexpr size_t length = 7;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& scope, unsigned& var, VirtualRegister& value, GetPutInfo& getPutInfo, SymbolTableOrScopeDepth& symbolTableOrScopeDepth, unsigned& offset, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(scope)
            && Fits<unsigned, __size>::check(var)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<GetPutInfo, __size>::check(getPutInfo)
            && Fits<SymbolTableOrScopeDepth, __size>::check(symbolTableOrScopeDepth)
            && Fits<unsigned, __size>::check(offset)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(scope));
            gen->write(Fits<unsigned, __size>::convert(var));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<GetPutInfo, __size>::convert(getPutInfo));
            gen->write(Fits<SymbolTableOrScopeDepth, __size>::convert(symbolTableOrScopeDepth));
            gen->write(Fits<unsigned, __size>::convert(offset));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_to_scope"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("scope", m_scope, true);
        dumper->dumpOperand("var", m_var, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("getPutInfo", m_getPutInfo, false);
        dumper->dumpOperand("symbolTableOrScopeDepth", m_symbolTableOrScopeDepth, false);
        dumper->dumpOperand("offset", m_offset, false);
    }

    OpPutToScope(const uint8_t* stream)
        : m_scope(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_var(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Narrow>::convert(stream[3]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Narrow>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutToScope(const uint16_t* stream)
        : m_scope(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_var(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide16>::convert(stream[3]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide16>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutToScope(const uint32_t* stream)
        : m_scope(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_var(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide32>::convert(stream[3]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide32>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutToScope decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setScope<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setScope<OpcodeSize::Wide16>(value, func);
        else
            setScope<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (isWide32())
            setVar<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setVar<OpcodeSize::Wide16>(value, func);
        else
            setVar<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (isWide32())
            setGetPutInfo<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setGetPutInfo<OpcodeSize::Wide16>(value, func);
        else
            setGetPutInfo<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (!Fits<GetPutInfo, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<GetPutInfo, size>::convert(value);
    }

    template<typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (isWide32())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setSymbolTableOrScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (!Fits<SymbolTableOrScopeDepth, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<SymbolTableOrScopeDepth, size>::convert(value);
    }

    template<typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (isWide32())
            setOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setOffset<OpcodeSize::Wide16>(value, func);
        else
            setOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_put_to_scope;
        Metadata(const OpPutToScope& __op)
            : m_getPutInfo(__op.m_getPutInfo)
            , m_operand(__op.m_offset)
        { }

        GetPutInfo m_getPutInfo;
        union {
            WriteBarrierBase<Structure> m_structure;
            WatchpointSet* m_watchpointSet;
        };
        uintptr_t m_operand;
        static constexpr ptrdiff_t offsetOfGetPutInfo() { return OBJECT_OFFSETOF(Metadata, m_getPutInfo); }
        static constexpr ptrdiff_t offsetOfStructure() { return OBJECT_OFFSETOF(Metadata, m_structure); }
        static constexpr ptrdiff_t offsetOfWatchpointSet() { return OBJECT_OFFSETOF(Metadata, m_watchpointSet); }
        static constexpr ptrdiff_t offsetOfOperand() { return OBJECT_OFFSETOF(Metadata, m_operand); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_scope;
    unsigned m_var;
    VirtualRegister m_value;
    GetPutInfo m_getPutInfo;
    SymbolTableOrScopeDepth m_symbolTableOrScopeDepth;
    unsigned m_offset;
    unsigned m_metadataID;
};


struct OpCreateThis : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_create_this;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, inlineCapacity);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, inlineCapacity, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, inlineCapacity, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, inlineCapacity, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, inlineCapacity, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& inlineCapacity, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(inlineCapacity)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, inlineCapacity, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(inlineCapacity));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("callee", m_callee, false);
        dumper->dumpOperand("inlineCapacity", m_inlineCapacity, false);
    }

    OpCreateThis(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpCreateThis(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpCreateThis(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpCreateThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (isWide32())
            setInlineCapacity<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setInlineCapacity<OpcodeSize::Wide16>(value, func);
        else
            setInlineCapacity<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_create_this;
        Metadata(const OpCreateThis&) { }

        WriteBarrier<JSCell> m_cachedCallee;
        static constexpr ptrdiff_t offsetOfCachedCallee() { return OBJECT_OFFSETOF(Metadata, m_cachedCallee); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_inlineCapacity;
    unsigned m_metadataID;
};


struct OpNewObject : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_new_object;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, inlineCapacity);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, inlineCapacity, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, inlineCapacity, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, inlineCapacity, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, inlineCapacity, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, unsigned& inlineCapacity, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<unsigned, __size>::check(inlineCapacity)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, inlineCapacity, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<unsigned, __size>::convert(inlineCapacity));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_object"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("inlineCapacity", m_inlineCapacity, false);
    }

    OpNewObject(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpNewObject(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpNewObject(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpNewObject decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (isWide32())
            setInlineCapacity<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setInlineCapacity<OpcodeSize::Wide16>(value, func);
        else
            setInlineCapacity<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_new_object;
        Metadata(const OpNewObject&) { }

        ObjectAllocationProfile m_objectAllocationProfile;
        static constexpr ptrdiff_t offsetOfObjectAllocationProfile() { return OBJECT_OFFSETOF(Metadata, m_objectAllocationProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    unsigned m_inlineCapacity;
    unsigned m_metadataID;
};


struct OpNewArray : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_new_array;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, argv, argc, recommendedIndexingType);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, argv, argc, recommendedIndexingType, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, argv, argc, recommendedIndexingType, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& argv, unsigned& argc, IndexingType& recommendedIndexingType, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(argv)
            && Fits<unsigned, __size>::check(argc)
            && Fits<IndexingType, __size>::check(recommendedIndexingType)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, argv, argc, recommendedIndexingType, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<IndexingType, __size>::convert(recommendedIndexingType));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_array"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("argv", m_argv, false);
        dumper->dumpOperand("argc", m_argc, false);
        dumper->dumpOperand("recommendedIndexingType", m_recommendedIndexingType, false);
    }

    OpNewArray(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_argv(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpNewArray(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_argv(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpNewArray(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_argv(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpNewArray decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (isWide32())
            setRecommendedIndexingType<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRecommendedIndexingType<OpcodeSize::Wide16>(value, func);
        else
            setRecommendedIndexingType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (!Fits<IndexingType, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<IndexingType, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_new_array;
        Metadata(const OpNewArray&) { }

        ArrayAllocationProfile m_arrayAllocationProfile;
        static constexpr ptrdiff_t offsetOfArrayAllocationProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayAllocationProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_argv;
    unsigned m_argc;
    IndexingType m_recommendedIndexingType;
    unsigned m_metadataID;
};


struct OpPutPrivateName : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_private_name;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, PrivateFieldPutKind putKind)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value, putKind);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, PrivateFieldPutKind putKind)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, property, value, putKind, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, PrivateFieldPutKind putKind)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, property, value, putKind, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, PrivateFieldPutKind putKind, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, putKind, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, PrivateFieldPutKind putKind)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, putKind, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, putKind, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, putKind, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& value, PrivateFieldPutKind& putKind, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<PrivateFieldPutKind, __size>::check(putKind)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, PrivateFieldPutKind putKind, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, putKind, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<PrivateFieldPutKind, __size>::convert(putKind));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_private_name"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("putKind", m_putKind, false);
    }

    OpPutPrivateName(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_putKind(Fits<PrivateFieldPutKind, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutPrivateName(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_putKind(Fits<PrivateFieldPutKind, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutPrivateName(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_putKind(Fits<PrivateFieldPutKind, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutPrivateName decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setPutKind(PrivateFieldPutKind value, Functor func)
    {
        if (isWide32())
            setPutKind<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setPutKind<OpcodeSize::Wide16>(value, func);
        else
            setPutKind<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPutKind(PrivateFieldPutKind value, Functor func)
    {
        if (!Fits<PrivateFieldPutKind, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<PrivateFieldPutKind, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_put_private_name;
        Metadata(const OpPutPrivateName&) { }

        WriteBarrier<JSCell> m_property;
        StructureID m_oldStructureID;
        unsigned m_offset;
        StructureID m_newStructureID;
        static constexpr ptrdiff_t offsetOfProperty() { return OBJECT_OFFSETOF(Metadata, m_property); }
        static constexpr ptrdiff_t offsetOfOldStructureID() { return OBJECT_OFFSETOF(Metadata, m_oldStructureID); }
        static constexpr ptrdiff_t offsetOfOffset() { return OBJECT_OFFSETOF(Metadata, m_offset); }
        static constexpr ptrdiff_t offsetOfNewStructureID() { return OBJECT_OFFSETOF(Metadata, m_newStructureID); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_value;
    PrivateFieldPutKind m_putKind;
    unsigned m_metadataID;
};


struct OpGetPrivateName : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_private_name;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_private_name"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetPrivateName(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetPrivateName(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetPrivateName(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetPrivateName decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_get_private_name;
        Metadata(const OpGetPrivateName&) { }

        StructureID m_structureID;
        unsigned m_offset;
        WriteBarrier<JSCell> m_property;
        static constexpr ptrdiff_t offsetOfStructureID() { return OBJECT_OFFSETOF(Metadata, m_structureID); }
        static constexpr ptrdiff_t offsetOfOffset() { return OBJECT_OFFSETOF(Metadata, m_offset); }
        static constexpr ptrdiff_t offsetOfProperty() { return OBJECT_OFFSETOF(Metadata, m_property); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpGetByValWithThis : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_by_val_with_this;
    static constexpr size_t length = 6;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, thisValue, property, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, thisValue, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, thisValue, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, thisValue, property, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, thisValue, property, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& thisValue, VirtualRegister& property, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, thisValue, property, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_val_with_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetByValWithThis(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetByValWithThis(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetByValWithThis(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetByValWithThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_get_by_val_with_this;
        Metadata(const OpGetByValWithThis&) { }

        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_thisValue;
    VirtualRegister m_property;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpGetByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_by_val;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_get_by_val;
        Metadata(const OpGetByVal&) { }

        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpPutByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_by_val;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value, ecmaMode);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, property, value, ecmaMode, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, property, value, ecmaMode, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, ecmaMode, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, ecmaMode, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, ecmaMode, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, ecmaMode, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& value, ECMAMode& ecmaMode, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, ecmaMode, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
    }

    OpPutByVal(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutByVal(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutByVal(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_put_by_val;
        Metadata(const OpPutByVal&) { }

        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_value;
    ECMAMode m_ecmaMode;
    unsigned m_metadataID;
};


struct OpPutByValDirect : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_by_val_direct;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value, ecmaMode);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, property, value, ecmaMode, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, property, value, ecmaMode, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, ecmaMode, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, ecmaMode, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, ecmaMode, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, ecmaMode, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& value, ECMAMode& ecmaMode, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, ecmaMode, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_val_direct"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
    }

    OpPutByValDirect(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutByValDirect(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutByValDirect(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutByValDirect decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_put_by_val_direct;
        Metadata(const OpPutByValDirect&) { }

        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_value;
    ECMAMode m_ecmaMode;
    unsigned m_metadataID;
};


struct OpInByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_in_by_val;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**in_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
    }

    OpInByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpInByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpInByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpInByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_in_by_val;
        Metadata(const OpInByVal&) { }

        ArrayProfile m_arrayProfile;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_metadataID;
};


struct OpEnumeratorNext : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_enumerator_next;
    static constexpr size_t length = 6;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister propertyName, VirtualRegister mode, VirtualRegister index, VirtualRegister base, VirtualRegister enumerator)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, propertyName, mode, index, base, enumerator);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister propertyName, VirtualRegister mode, VirtualRegister index, VirtualRegister base, VirtualRegister enumerator)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, propertyName, mode, index, base, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister propertyName, VirtualRegister mode, VirtualRegister index, VirtualRegister base, VirtualRegister enumerator)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, propertyName, mode, index, base, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister propertyName, VirtualRegister mode, VirtualRegister index, VirtualRegister base, VirtualRegister enumerator, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, propertyName, mode, index, base, enumerator, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister propertyName, VirtualRegister mode, VirtualRegister index, VirtualRegister base, VirtualRegister enumerator)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, propertyName, mode, index, base, enumerator, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, propertyName, mode, index, base, enumerator, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, propertyName, mode, index, base, enumerator, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& propertyName, VirtualRegister& mode, VirtualRegister& index, VirtualRegister& base, VirtualRegister& enumerator, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(propertyName)
            && Fits<VirtualRegister, __size>::check(mode)
            && Fits<VirtualRegister, __size>::check(index)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(enumerator)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister propertyName, VirtualRegister mode, VirtualRegister index, VirtualRegister base, VirtualRegister enumerator, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, propertyName, mode, index, base, enumerator, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(propertyName));
            gen->write(Fits<VirtualRegister, __size>::convert(mode));
            gen->write(Fits<VirtualRegister, __size>::convert(index));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(enumerator));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**enumerator_next"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("propertyName", m_propertyName, true);
        dumper->dumpOperand("mode", m_mode, false);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("enumerator", m_enumerator, false);
    }

    OpEnumeratorNext(const uint8_t* stream)
        : m_propertyName(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpEnumeratorNext(const uint16_t* stream)
        : m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpEnumeratorNext(const uint32_t* stream)
        : m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpEnumeratorNext decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setPropertyName<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setPropertyName<OpcodeSize::Wide16>(value, func);
        else
            setPropertyName<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setMode<OpcodeSize::Wide16>(value, func);
        else
            setMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setEnumerator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEnumerator<OpcodeSize::Wide16>(value, func);
        else
            setEnumerator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_enumerator_next;
        Metadata(const OpEnumeratorNext&) { }

        ArrayProfile m_arrayProfile;
        EnumeratorMetadata m_enumeratorMetadata;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
        static constexpr ptrdiff_t offsetOfEnumeratorMetadata() { return OBJECT_OFFSETOF(Metadata, m_enumeratorMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_propertyName;
    VirtualRegister m_mode;
    VirtualRegister m_index;
    VirtualRegister m_base;
    VirtualRegister m_enumerator;
    unsigned m_metadataID;
};


struct OpEnumeratorInByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_enumerator_in_by_val;
    static constexpr size_t length = 7;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& mode, VirtualRegister& propertyName, VirtualRegister& index, VirtualRegister& enumerator, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(mode)
            && Fits<VirtualRegister, __size>::check(propertyName)
            && Fits<VirtualRegister, __size>::check(index)
            && Fits<VirtualRegister, __size>::check(enumerator)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(mode));
            gen->write(Fits<VirtualRegister, __size>::convert(propertyName));
            gen->write(Fits<VirtualRegister, __size>::convert(index));
            gen->write(Fits<VirtualRegister, __size>::convert(enumerator));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**enumerator_in_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("mode", m_mode, false);
        dumper->dumpOperand("propertyName", m_propertyName, false);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("enumerator", m_enumerator, false);
    }

    OpEnumeratorInByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpEnumeratorInByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpEnumeratorInByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpEnumeratorInByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setMode<OpcodeSize::Wide16>(value, func);
        else
            setMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setPropertyName<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setPropertyName<OpcodeSize::Wide16>(value, func);
        else
            setPropertyName<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setEnumerator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEnumerator<OpcodeSize::Wide16>(value, func);
        else
            setEnumerator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_enumerator_in_by_val;
        Metadata(const OpEnumeratorInByVal&) { }

        ArrayProfile m_arrayProfile;
        EnumeratorMetadata m_enumeratorMetadata;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
        static constexpr ptrdiff_t offsetOfEnumeratorMetadata() { return OBJECT_OFFSETOF(Metadata, m_enumeratorMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_mode;
    VirtualRegister m_propertyName;
    VirtualRegister m_index;
    VirtualRegister m_enumerator;
    unsigned m_metadataID;
};


struct OpEnumeratorHasOwnProperty : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_enumerator_has_own_property;
    static constexpr size_t length = 7;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& mode, VirtualRegister& propertyName, VirtualRegister& index, VirtualRegister& enumerator, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(mode)
            && Fits<VirtualRegister, __size>::check(propertyName)
            && Fits<VirtualRegister, __size>::check(index)
            && Fits<VirtualRegister, __size>::check(enumerator)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, mode, propertyName, index, enumerator, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(mode));
            gen->write(Fits<VirtualRegister, __size>::convert(propertyName));
            gen->write(Fits<VirtualRegister, __size>::convert(index));
            gen->write(Fits<VirtualRegister, __size>::convert(enumerator));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**enumerator_has_own_property"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("mode", m_mode, false);
        dumper->dumpOperand("propertyName", m_propertyName, false);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("enumerator", m_enumerator, false);
    }

    OpEnumeratorHasOwnProperty(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpEnumeratorHasOwnProperty(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpEnumeratorHasOwnProperty(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpEnumeratorHasOwnProperty decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setMode<OpcodeSize::Wide16>(value, func);
        else
            setMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setPropertyName<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setPropertyName<OpcodeSize::Wide16>(value, func);
        else
            setPropertyName<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setEnumerator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEnumerator<OpcodeSize::Wide16>(value, func);
        else
            setEnumerator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_enumerator_has_own_property;
        Metadata(const OpEnumeratorHasOwnProperty&) { }

        ArrayProfile m_arrayProfile;
        EnumeratorMetadata m_enumeratorMetadata;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
        static constexpr ptrdiff_t offsetOfEnumeratorMetadata() { return OBJECT_OFFSETOF(Metadata, m_enumeratorMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_mode;
    VirtualRegister m_propertyName;
    VirtualRegister m_index;
    VirtualRegister m_enumerator;
    unsigned m_metadataID;
};


struct OpEnumeratorPutByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_enumerator_put_by_val;
    static constexpr size_t length = 8;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, VirtualRegister value, ECMAMode ecmaMode)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, VirtualRegister value, ECMAMode ecmaMode)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, VirtualRegister value, ECMAMode ecmaMode)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, VirtualRegister value, ECMAMode ecmaMode, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, VirtualRegister value, ECMAMode ecmaMode)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& mode, VirtualRegister& propertyName, VirtualRegister& index, VirtualRegister& enumerator, VirtualRegister& value, ECMAMode& ecmaMode, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(mode)
            && Fits<VirtualRegister, __size>::check(propertyName)
            && Fits<VirtualRegister, __size>::check(index)
            && Fits<VirtualRegister, __size>::check(enumerator)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, VirtualRegister value, ECMAMode ecmaMode, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, mode, propertyName, index, enumerator, value, ecmaMode, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(mode));
            gen->write(Fits<VirtualRegister, __size>::convert(propertyName));
            gen->write(Fits<VirtualRegister, __size>::convert(index));
            gen->write(Fits<VirtualRegister, __size>::convert(enumerator));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**enumerator_put_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("mode", m_mode, false);
        dumper->dumpOperand("propertyName", m_propertyName, false);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("enumerator", m_enumerator, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
    }

    OpEnumeratorPutByVal(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[5]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpEnumeratorPutByVal(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[5]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpEnumeratorPutByVal(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[5]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpEnumeratorPutByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setMode<OpcodeSize::Wide16>(value, func);
        else
            setMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setPropertyName<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setPropertyName<OpcodeSize::Wide16>(value, func);
        else
            setPropertyName<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setEnumerator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEnumerator<OpcodeSize::Wide16>(value, func);
        else
            setEnumerator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_enumerator_put_by_val;
        Metadata(const OpEnumeratorPutByVal&) { }

        ArrayProfile m_arrayProfile;
        EnumeratorMetadata m_enumeratorMetadata;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
        static constexpr ptrdiff_t offsetOfEnumeratorMetadata() { return OBJECT_OFFSETOF(Metadata, m_enumeratorMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_mode;
    VirtualRegister m_propertyName;
    VirtualRegister m_index;
    VirtualRegister m_enumerator;
    VirtualRegister m_value;
    ECMAMode m_ecmaMode;
    unsigned m_metadataID;
};


struct OpToThis : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_to_this;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister srcDst, ECMAMode ecmaMode, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, srcDst, ecmaMode, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst, ECMAMode ecmaMode, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, srcDst, ecmaMode, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister srcDst, ECMAMode ecmaMode, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, srcDst, ecmaMode, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst, ECMAMode ecmaMode, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, srcDst, ecmaMode, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister srcDst, ECMAMode ecmaMode, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, srcDst, ecmaMode, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, srcDst, ecmaMode, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, srcDst, ecmaMode, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& srcDst, ECMAMode& ecmaMode, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(srcDst)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister srcDst, ECMAMode ecmaMode, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, srcDst, ecmaMode, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(srcDst));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**to_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("srcDst", m_srcDst, true);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpToThis(const uint8_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpToThis(const uint16_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpToThis(const uint32_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpToThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setSrcDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSrcDst<OpcodeSize::Wide16>(value, func);
        else
            setSrcDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_to_this;
        Metadata(const OpToThis&) { }

        StructureID m_cachedStructureID;
        ToThisStatus m_toThisStatus;
        static constexpr ptrdiff_t offsetOfCachedStructureID() { return OBJECT_OFFSETOF(Metadata, m_cachedStructureID); }
        static constexpr ptrdiff_t offsetOfToThisStatus() { return OBJECT_OFFSETOF(Metadata, m_toThisStatus); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_srcDst;
    ECMAMode m_ecmaMode;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpEnumeratorGetByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_enumerator_get_by_val;
    static constexpr size_t length = 8;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& mode, VirtualRegister& propertyName, VirtualRegister& index, VirtualRegister& enumerator, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(mode)
            && Fits<VirtualRegister, __size>::check(propertyName)
            && Fits<VirtualRegister, __size>::check(index)
            && Fits<VirtualRegister, __size>::check(enumerator)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister mode, VirtualRegister propertyName, VirtualRegister index, VirtualRegister enumerator, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, mode, propertyName, index, enumerator, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(mode));
            gen->write(Fits<VirtualRegister, __size>::convert(propertyName));
            gen->write(Fits<VirtualRegister, __size>::convert(index));
            gen->write(Fits<VirtualRegister, __size>::convert(enumerator));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**enumerator_get_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("mode", m_mode, false);
        dumper->dumpOperand("propertyName", m_propertyName, false);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("enumerator", m_enumerator, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpEnumeratorGetByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpEnumeratorGetByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpEnumeratorGetByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_mode(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_propertyName(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[5]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[7]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpEnumeratorGetByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setMode<OpcodeSize::Wide16>(value, func);
        else
            setMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setMode(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setPropertyName<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setPropertyName<OpcodeSize::Wide16>(value, func);
        else
            setPropertyName<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPropertyName(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setEnumerator<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEnumerator<OpcodeSize::Wide16>(value, func);
        else
            setEnumerator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 6 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_enumerator_get_by_val;
        Metadata(const OpEnumeratorGetByVal&) { }

        ArrayProfile m_arrayProfile;
        EnumeratorMetadata m_enumeratorMetadata;
        static constexpr ptrdiff_t offsetOfArrayProfile() { return OBJECT_OFFSETOF(Metadata, m_arrayProfile); }
        static constexpr ptrdiff_t offsetOfEnumeratorMetadata() { return OBJECT_OFFSETOF(Metadata, m_enumeratorMetadata); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_mode;
    VirtualRegister m_propertyName;
    VirtualRegister m_index;
    VirtualRegister m_enumerator;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpGetByIdDirect : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_by_id_direct;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_id_direct"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetByIdDirect(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetByIdDirect(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetByIdDirect(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetByIdDirect decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_get_by_id_direct;
        Metadata(const OpGetByIdDirect&) { }

        StructureID m_structureID;
        unsigned m_offset;
        static constexpr ptrdiff_t offsetOfStructureID() { return OBJECT_OFFSETOF(Metadata, m_structureID); }
        static constexpr ptrdiff_t offsetOfOffset() { return OBJECT_OFFSETOF(Metadata, m_offset); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpTryGetById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_try_get_by_id;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, valueProfile, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, valueProfile, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, valueProfile, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property, unsigned& valueProfile, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(valueProfile)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned valueProfile, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, valueProfile, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**try_get_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpTryGetById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpTryGetById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpTryGetById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpTryGetById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_try_get_by_id;
        Metadata(const OpTryGetById&) { }

        StructureID m_structureID;
        unsigned m_offset;
        static constexpr ptrdiff_t offsetOfStructureID() { return OBJECT_OFFSETOF(Metadata, m_structureID); }
        static constexpr ptrdiff_t offsetOfOffset() { return OBJECT_OFFSETOF(Metadata, m_offset); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_valueProfile;
    unsigned m_metadataID;
};


struct OpJneqPtr : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jneq_ptr;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, specialPointer, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, value, specialPointer, targetLabel, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, value, specialPointer, targetLabel, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, specialPointer, targetLabel, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, specialPointer, targetLabel, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, specialPointer, targetLabel, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, specialPointer, targetLabel, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, VirtualRegister& specialPointer, BoundLabel& targetLabel, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(specialPointer)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, specialPointer, targetLabel, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(specialPointer));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jneq_ptr"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("value", m_value, true);
        dumper->dumpOperand("specialPointer", m_specialPointer, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJneqPtr(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJneqPtr(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJneqPtr(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJneqPtr decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSpecialPointer(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setSpecialPointer<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSpecialPointer<OpcodeSize::Wide16>(value, func);
        else
            setSpecialPointer<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSpecialPointer(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        static constexpr OpcodeID opcodeID = op_jneq_ptr;
        Metadata(const OpJneqPtr&) { }

        bool m_hasJumped;
        static constexpr ptrdiff_t offsetOfHasJumped() { return OBJECT_OFFSETOF(Metadata, m_hasJumped); }
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_value;
    VirtualRegister m_specialPointer;
    BoundLabel m_targetLabel;
    unsigned m_metadataID;
};


struct OpGetArgument : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_argument;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, int index, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, index, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, int index, unsigned valueProfile)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, index, valueProfile);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, int index, unsigned valueProfile)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, index, valueProfile))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, index, valueProfile))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, index, valueProfile);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, int& index, unsigned& valueProfile)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<int, __size>::check(index)
            && Fits<unsigned, __size>::check(valueProfile)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, int index, unsigned valueProfile)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, index, valueProfile)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<int, __size>::convert(index));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_argument"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetArgument(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_index(Fits<int, OpcodeSize::Narrow>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetArgument(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_index(Fits<int, OpcodeSize::Wide16>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetArgument(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_index(Fits<int, OpcodeSize::Wide32>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetArgument decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(int value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<int, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    int m_index;
    unsigned m_valueProfile;
};


struct OpGetFromArguments : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_from_arguments;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, arguments, index, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index, unsigned valueProfile)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, arguments, index, valueProfile);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index, unsigned valueProfile)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, arguments, index, valueProfile))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, arguments, index, valueProfile))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, arguments, index, valueProfile);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& arguments, unsigned& index, unsigned& valueProfile)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<unsigned, __size>::check(index)
            && Fits<unsigned, __size>::check(valueProfile)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index, unsigned valueProfile)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, arguments, index, valueProfile)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<unsigned, __size>::convert(index));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_from_arguments"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("arguments", m_arguments, false);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetFromArguments(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetFromArguments(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetFromArguments(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetFromArguments decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_arguments;
    unsigned m_index;
    unsigned m_valueProfile;
};


struct OpGetPrototypeOf : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_prototype_of;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, value, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, unsigned valueProfile)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, value, valueProfile);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, unsigned valueProfile)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, value, valueProfile))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, value, valueProfile))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, value, valueProfile);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& value, unsigned& valueProfile)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<unsigned, __size>::check(valueProfile)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, unsigned valueProfile)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, value, valueProfile)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_prototype_of"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetPrototypeOf(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetPrototypeOf(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetPrototypeOf(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetPrototypeOf decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_value;
    unsigned m_valueProfile;
};


struct OpGetInternalField : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_internal_field;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, index, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index, unsigned valueProfile)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, index, valueProfile);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index, unsigned valueProfile)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, index, valueProfile))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, index, valueProfile))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, index, valueProfile);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& index, unsigned& valueProfile)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(index)
            && Fits<unsigned, __size>::check(valueProfile)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index, unsigned valueProfile)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, index, valueProfile)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(index));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_internal_field"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("index", m_index, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetInternalField(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetInternalField(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetInternalField(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetInternalField decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (isWide32())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_index;
    unsigned m_valueProfile;
};


struct OpGetByIdWithThis : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_get_by_id_with_this;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, thisValue, property, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property, unsigned valueProfile)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, thisValue, property, valueProfile);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property, unsigned valueProfile)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, valueProfile))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, valueProfile))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, thisValue, property, valueProfile);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& thisValue, unsigned& property, unsigned& valueProfile)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(valueProfile)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property, unsigned valueProfile)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, thisValue, property, valueProfile)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_id_with_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpGetByIdWithThis(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpGetByIdWithThis(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpGetByIdWithThis(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpGetByIdWithThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_thisValue;
    unsigned m_property;
    unsigned m_valueProfile;
};


struct OpToObject : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_to_object;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message, unsigned valueProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand, message, valueProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message, unsigned valueProfile)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand, message, valueProfile);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message, unsigned valueProfile)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand, message, valueProfile))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand, message, valueProfile))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand, message, valueProfile);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand, unsigned& message, unsigned& valueProfile)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && Fits<unsigned, __size>::check(message)
            && Fits<unsigned, __size>::check(valueProfile)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message, unsigned valueProfile)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand, message, valueProfile)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            gen->write(Fits<unsigned, __size>::convert(message));
            gen->write(Fits<unsigned, __size>::convert(valueProfile));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**to_object"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("operand", m_operand, false);
        dumper->dumpOperand("message", m_message, false);
        dumper->dumpOperand("valueProfile", m_valueProfile, false);
    }

    OpToObject(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_message(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpToObject(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_message(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpToObject(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_message(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_valueProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpToObject decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setMessage(unsigned value, Functor func)
    {
        if (isWide32())
            setMessage<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setMessage<OpcodeSize::Wide16>(value, func);
        else
            setMessage<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setMessage(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (isWide32())
            setValueProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValueProfile<OpcodeSize::Wide16>(value, func);
        else
            setValueProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValueProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
    unsigned m_message;
    unsigned m_valueProfile;
};


struct OpInById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_in_by_id;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**in_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
    }

    OpInById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpInById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpInById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpInById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
};


struct OpHasPrivateName : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_has_private_name;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**has_private_name"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
    }

    OpHasPrivateName(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpHasPrivateName(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpHasPrivateName(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpHasPrivateName decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
};


struct OpHasPrivateBrand : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_has_private_brand;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister brand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, brand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister brand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, brand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister brand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, brand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, brand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, brand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& brand)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(brand)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister brand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, brand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(brand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**has_private_brand"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("brand", m_brand, false);
    }

    OpHasPrivateBrand(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpHasPrivateBrand(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpHasPrivateBrand(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_brand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpHasPrivateBrand decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBrand(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBrand<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBrand<OpcodeSize::Wide16>(value, func);
        else
            setBrand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBrand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_brand;
};


struct OpPutByIdWithThis : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_by_id_with_this;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, unsigned property, VirtualRegister value, ECMAMode ecmaMode)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, thisValue, property, value, ecmaMode);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, unsigned property, VirtualRegister value, ECMAMode ecmaMode)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, thisValue, property, value, ecmaMode);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, unsigned property, VirtualRegister value, ECMAMode ecmaMode)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, thisValue, property, value, ecmaMode))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, thisValue, property, value, ecmaMode))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, thisValue, property, value, ecmaMode);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& thisValue, unsigned& property, VirtualRegister& value, ECMAMode& ecmaMode)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<unsigned, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, unsigned property, VirtualRegister value, ECMAMode ecmaMode)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, thisValue, property, value, ecmaMode)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_id_with_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
    }

    OpPutByIdWithThis(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutByIdWithThis(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutByIdWithThis(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutByIdWithThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_thisValue;
    unsigned m_property;
    VirtualRegister m_value;
    ECMAMode m_ecmaMode;
};


struct OpDelById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_del_by_id;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, ECMAMode ecmaMode)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, ecmaMode);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, ECMAMode ecmaMode)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, ecmaMode);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, ECMAMode ecmaMode)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, ecmaMode))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, ecmaMode))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, ecmaMode);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property, ECMAMode& ecmaMode)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, ECMAMode ecmaMode)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, ecmaMode)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**del_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
    }

    OpDelById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpDelById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpDelById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpDelById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
    ECMAMode m_ecmaMode;
};


struct OpPutByValWithThis : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_by_val_with_this;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, thisValue, property, value, ecmaMode);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, thisValue, property, value, ecmaMode);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, thisValue, property, value, ecmaMode))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, thisValue, property, value, ecmaMode))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, thisValue, property, value, ecmaMode);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& thisValue, VirtualRegister& property, VirtualRegister& value, ECMAMode& ecmaMode)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value, ECMAMode ecmaMode)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, thisValue, property, value, ecmaMode)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_val_with_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("thisValue", m_thisValue, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
    }

    OpPutByValWithThis(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutByValWithThis(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutByValWithThis(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutByValWithThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_thisValue;
    VirtualRegister m_property;
    VirtualRegister m_value;
    ECMAMode m_ecmaMode;
};


struct OpDelByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_del_by_val;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, ECMAMode ecmaMode)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, ecmaMode);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, ECMAMode ecmaMode)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, ecmaMode);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, ECMAMode ecmaMode)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, ecmaMode))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, ecmaMode))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, ecmaMode);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, ECMAMode& ecmaMode)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<ECMAMode, __size>::check(ecmaMode)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, ECMAMode ecmaMode)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, ecmaMode)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<ECMAMode, __size>::convert(ecmaMode));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**del_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("dst", m_dst, true);
        dumper->dumpOperand("base", m_base, false);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("ecmaMode", m_ecmaMode, false);
    }

    OpDelByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpDelByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpDelByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_ecmaMode(Fits<ECMAMode, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpDelByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (isWide32())
            setEcmaMode<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setEcmaMode<OpcodeSize::Wide16>(value, func);
        else
            setEcmaMode<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEcmaMode(ECMAMode value, Functor func)
    {
        if (!Fits<ECMAMode, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<ECMAMode, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    ECMAMode m_ecmaMode;
};


struct OpPutGetterById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_getter_by_id;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_getter_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("attributes", m_attributes, false);
        dumper->dumpOperand("accessor", m_accessor, false);
    }

    OpPutGetterById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutGetterById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutGetterById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutGetterById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};


struct OpPutSetterById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_setter_by_id;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_setter_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("attributes", m_attributes, false);
        dumper->dumpOperand("accessor", m_accessor, false);
    }

    OpPutSetterById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutSetterById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutSetterById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutSetterById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};


struct OpPutGetterSetterById : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_getter_setter_by_id;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, getter, setter);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, getter, setter);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, getter, setter))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, getter, setter))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, getter, setter);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, unsigned& attributes, VirtualRegister& getter, VirtualRegister& setter)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(getter)
            && Fits<VirtualRegister, __size>::check(setter)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, getter, setter)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(getter));
            gen->write(Fits<VirtualRegister, __size>::convert(setter));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_getter_setter_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("attributes", m_attributes, false);
        dumper->dumpOperand("getter", m_getter, false);
        dumper->dumpOperand("setter", m_setter, false);
    }

    OpPutGetterSetterById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutGetterSetterById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutGetterSetterById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutGetterSetterById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setGetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setGetter<OpcodeSize::Wide16>(value, func);
        else
            setGetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setSetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSetter<OpcodeSize::Wide16>(value, func);
        else
            setSetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_attributes;
    VirtualRegister m_getter;
    VirtualRegister m_setter;
};


struct OpPutGetterByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_getter_by_val;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_getter_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("attributes", m_attributes, false);
        dumper->dumpOperand("accessor", m_accessor, false);
    }

    OpPutGetterByVal(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutGetterByVal(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutGetterByVal(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutGetterByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};


struct OpPutSetterByVal : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_put_setter_by_val;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_setter_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("attributes", m_attributes, false);
        dumper->dumpOperand("accessor", m_accessor, false);
    }

    OpPutSetterByVal(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpPutSetterByVal(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpPutSetterByVal(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpPutSetterByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};


struct OpDefineDataProperty : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_define_data_property;
    static constexpr size_t length = 4;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value, attributes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, attributes);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, attributes))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, attributes))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, attributes);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& value, VirtualRegister& attributes)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(attributes)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, attributes)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(attributes));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**define_data_property"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("value", m_value, false);
        dumper->dumpOperand("attributes", m_attributes, false);
    }

    OpDefineDataProperty(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpDefineDataProperty(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpDefineDataProperty(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpDefineDataProperty decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_value;
    VirtualRegister m_attributes;
};


struct OpDefineAccessorProperty : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_define_accessor_property;
    static constexpr size_t length = 5;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, getter, setter, attributes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, getter, setter, attributes);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, getter, setter, attributes))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, getter, setter, attributes))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, getter, setter, attributes);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& getter, VirtualRegister& setter, VirtualRegister& attributes)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(getter)
            && Fits<VirtualRegister, __size>::check(setter)
            && Fits<VirtualRegister, __size>::check(attributes)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, getter, setter, attributes)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(getter));
            gen->write(Fits<VirtualRegister, __size>::convert(setter));
            gen->write(Fits<VirtualRegister, __size>::convert(attributes));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**define_accessor_property"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("base", m_base, true);
        dumper->dumpOperand("property", m_property, false);
        dumper->dumpOperand("getter", m_getter, false);
        dumper->dumpOperand("setter", m_setter, false);
        dumper->dumpOperand("attributes", m_attributes, false);
    }

    OpDefineAccessorProperty(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpDefineAccessorProperty(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpDefineAccessorProperty(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpDefineAccessorProperty decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setGetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setGetter<OpcodeSize::Wide16>(value, func);
        else
            setGetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setSetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSetter<OpcodeSize::Wide16>(value, func);
        else
            setSetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_getter;
    VirtualRegister m_setter;
    VirtualRegister m_attributes;
};


struct OpJmp : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jmp;
    static constexpr size_t length = 1;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jmp"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("targetLabel", m_targetLabel, true);
    }

    OpJmp(const uint8_t* stream)
        : m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[0]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJmp(const uint16_t* stream)
        : m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[0]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJmp(const uint32_t* stream)
        : m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[0]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJmp decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    BoundLabel m_targetLabel;
};


struct OpJtrue : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jtrue;
    static constexpr size_t length = 2;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, condition, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, condition, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, condition, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& condition, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(condition)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, condition, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(condition));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jtrue"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("condition", m_condition, true);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJtrue(const uint8_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJtrue(const uint16_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJtrue(const uint32_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJtrue decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCondition<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCondition<OpcodeSize::Wide16>(value, func);
        else
            setCondition<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_condition;
    BoundLabel m_targetLabel;
};


struct OpJfalse : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jfalse;
    static constexpr size_t length = 2;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, condition, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, condition, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, condition, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& condition, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(condition)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, condition, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(condition));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jfalse"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("condition", m_condition, true);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJfalse(const uint8_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJfalse(const uint16_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJfalse(const uint32_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJfalse decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setCondition<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setCondition<OpcodeSize::Wide16>(value, func);
        else
            setCondition<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_condition;
    BoundLabel m_targetLabel;
};


struct OpJeqNull : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jeq_null;
    static constexpr size_t length = 2;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jeq_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("value", m_value, true);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJeqNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJeqNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJeqNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJeqNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};


struct OpJneqNull : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jneq_null;
    static constexpr size_t length = 2;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jneq_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("value", m_value, true);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJneqNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJneqNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJneqNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJneqNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};


struct OpJundefinedOrNull : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jundefined_or_null;
    static constexpr size_t length = 2;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jundefined_or_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("value", m_value, true);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJundefinedOrNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJundefinedOrNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJundefinedOrNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJundefinedOrNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};


struct OpJnundefinedOrNull : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jnundefined_or_null;
    static constexpr size_t length = 2;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jnundefined_or_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("value", m_value, true);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJnundefinedOrNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJnundefinedOrNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJnundefinedOrNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJnundefinedOrNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};


struct OpJeqPtr : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jeq_ptr;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, specialPointer, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, specialPointer, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, specialPointer, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, specialPointer, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, specialPointer, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, VirtualRegister& specialPointer, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(specialPointer)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, specialPointer, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(specialPointer));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jeq_ptr"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("value", m_value, true);
        dumper->dumpOperand("specialPointer", m_specialPointer, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJeqPtr(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJeqPtr(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJeqPtr(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJeqPtr decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSpecialPointer(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setSpecialPointer<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setSpecialPointer<OpcodeSize::Wide16>(value, func);
        else
            setSpecialPointer<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSpecialPointer(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    VirtualRegister m_specialPointer;
    BoundLabel m_targetLabel;
};


struct OpJeq : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jeq;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jeq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJeq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJeq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJeq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJeq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJstricteq : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jstricteq;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jstricteq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJstricteq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJstricteq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJstricteq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJstricteq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJneq : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jneq;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jneq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJneq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJneq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJneq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJneq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJnstricteq : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jnstricteq;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jnstricteq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJnstricteq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJnstricteq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJnstricteq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJnstricteq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJless : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jless;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jless"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJless(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJless(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJless(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJless decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJlesseq : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jlesseq;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jlesseq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJlesseq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJlesseq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJlesseq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJlesseq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJgreater : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jgreater;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jgreater"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJgreater(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJgreater(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJgreater(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJgreater decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJgreatereq : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jgreatereq;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jgreatereq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJgreatereq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJgreatereq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJgreatereq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJgreatereq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJnless : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jnless;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jnless"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJnless(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJnless(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJnless(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJnless decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};


struct OpJnlesseq : public JSInstruction {
    static constexpr OpcodeID opcodeID = op_jnlesseq;
    static constexpr size_t length = 3;
    
    


    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Narrow ? Fits<OpcodeID, OpcodeSize::Narrow>::check(opcodeID) : Fits<OpcodeID, OpcodeSize::Wide16>::check(opcodeID))
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeIDWidthBySize<JSOpcodeTraits, __size>::opcodeIDSize>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase<JSInstructionStream>* dumper, JSInstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jnlesseq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand("lhs", m_lhs, true);
        dumper->dumpOperand("rhs", m_rhs, false);
        dumper->dumpOperand("targetLabel", m_targetLabel, false);
    }

    OpJnlesseq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    OpJnlesseq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeType*>(stream)[-1]) == opcodeID);
    }


    OpJnlesseq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, static_cast<OpcodeID>(std::bit_cast<const typename OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeType*>(stream)[-1]) == opcodeID);
    }

    static OpJnlesseq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { std::bit_cast<const uint32_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide32>::opcodeIDSize) };
        if (*stream == op_wide16)
            return { std::bit_cast<const uint16_t*>(stream + /* prefix */ 1 + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Wide16>::opcodeIDSize) };
        return { stream + OpcodeIDWidthBySize<JSOpcodeTraits, OpcodeSize::Narrow>::opcodeIDSize };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = std::bit_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + OpcodeIDWidthBySize<JSOpcodeTraits, size>::opcodeIDSize);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream =