/** @file
 * VirtualBox API class wrapper code for IVirtualSystemDescription.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_VIRTUALSYSTEMDESCRIPTION

#include "VirtualSystemDescriptionWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(VirtualSystemDescriptionWrap)

//
// IVirtualSystemDescription properties
//

STDMETHODIMP VirtualSystemDescriptionWrap::COMGETTER(Count)(ULONG *aCount)
{
    LogRelFlow(("{%p} %s: enter aCount=%p\n", this, "VirtualSystemDescription::getCount", aCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GET_COUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCount(aCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GET_COUNT_RETURN(this, hrc, 0 /*normal*/,*aCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GET_COUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GET_COUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCount=%RU32 hrc=%Rhrc\n", this, "VirtualSystemDescription::getCount", *aCount, hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionWrap::COMGETTER(InternalAndReservedAttribute1IVirtualSystemDescription)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionWrap::COMGETTER(InternalAndReservedAttribute2IVirtualSystemDescription)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionWrap::COMGETTER(InternalAndReservedAttribute3IVirtualSystemDescription)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionWrap::COMGETTER(InternalAndReservedAttribute4IVirtualSystemDescription)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IVirtualSystemDescription methods
//

STDMETHODIMP VirtualSystemDescriptionWrap::GetDescription(ComSafeArrayOut(VirtualSystemDescriptionType_T, aTypes),
                                                          ComSafeArrayOut(BSTR, aRefs),
                                                          ComSafeArrayOut(BSTR, aOVFValues),
                                                          ComSafeArrayOut(BSTR, aVBoxValues),
                                                          ComSafeArrayOut(BSTR, aExtraConfigValues))
{
    LogRelFlow(("{%p} %s: enter aTypes=%p aRefs=%p aOVFValues=%p aVBoxValues=%p aExtraConfigValues=%p\n", this, "VirtualSystemDescription::getDescription", aTypes, aRefs, aOVFValues, aVBoxValues, aExtraConfigValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTypes);
        CheckComArgOutPointerValidThrow(aRefs);
        CheckComArgOutPointerValidThrow(aOVFValues);
        CheckComArgOutPointerValidThrow(aVBoxValues);
        CheckComArgOutPointerValidThrow(aExtraConfigValues);


        ArrayOutConverter<VirtualSystemDescriptionType_T> TmpTypes(ComSafeArrayOutArg(aTypes));
        ArrayBSTROutConverter TmpRefs(ComSafeArrayOutArg(aRefs));
        ArrayBSTROutConverter TmpOVFValues(ComSafeArrayOutArg(aOVFValues));
        ArrayBSTROutConverter TmpVBoxValues(ComSafeArrayOutArg(aVBoxValues));
        ArrayBSTROutConverter TmpExtraConfigValues(ComSafeArrayOutArg(aExtraConfigValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpTypes.array(),
                                 TmpRefs.array(),
                                 TmpOVFValues.array(),
                                 TmpVBoxValues.array(),
                                 TmpExtraConfigValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTION_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpTypes.array().size(), NULL /*for now*/, (uint32_t)TmpRefs.array().size(), NULL /*for now*/, (uint32_t)TmpOVFValues.array().size(), NULL /*for now*/, (uint32_t)TmpVBoxValues.array().size(), NULL /*for now*/, (uint32_t)TmpExtraConfigValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTypes=%zu *aRefs=%zu *aOVFValues=%zu *aVBoxValues=%zu *aExtraConfigValues=%zu hrc=%Rhrc\n", this, "VirtualSystemDescription::getDescription", ComSafeArraySize(*aTypes), ComSafeArraySize(*aRefs), ComSafeArraySize(*aOVFValues), ComSafeArraySize(*aVBoxValues), ComSafeArraySize(*aExtraConfigValues), hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionWrap::GetDescriptionByType(VirtualSystemDescriptionType_T aType,
                                                                ComSafeArrayOut(VirtualSystemDescriptionType_T, aTypes),
                                                                ComSafeArrayOut(BSTR, aRefs),
                                                                ComSafeArrayOut(BSTR, aOVFValues),
                                                                ComSafeArrayOut(BSTR, aVBoxValues),
                                                                ComSafeArrayOut(BSTR, aExtraConfigValues))
{
    LogRelFlow(("{%p} %s: enter aType=%RU32 aTypes=%p aRefs=%p aOVFValues=%p aVBoxValues=%p aExtraConfigValues=%p\n", this, "VirtualSystemDescription::getDescriptionByType", aType, aTypes, aRefs, aOVFValues, aVBoxValues, aExtraConfigValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTypes);
        CheckComArgOutPointerValidThrow(aRefs);
        CheckComArgOutPointerValidThrow(aOVFValues);
        CheckComArgOutPointerValidThrow(aVBoxValues);
        CheckComArgOutPointerValidThrow(aExtraConfigValues);


        
        ArrayOutConverter<VirtualSystemDescriptionType_T> TmpTypes(ComSafeArrayOutArg(aTypes));
        ArrayBSTROutConverter TmpRefs(ComSafeArrayOutArg(aRefs));
        ArrayBSTROutConverter TmpOVFValues(ComSafeArrayOutArg(aOVFValues));
        ArrayBSTROutConverter TmpVBoxValues(ComSafeArrayOutArg(aVBoxValues));
        ArrayBSTROutConverter TmpExtraConfigValues(ComSafeArrayOutArg(aExtraConfigValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTIONBYTYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescriptionByType(aType,
                                       TmpTypes.array(),
                                       TmpRefs.array(),
                                       TmpOVFValues.array(),
                                       TmpVBoxValues.array(),
                                       TmpExtraConfigValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTIONBYTYPE_RETURN(this, hrc, 0 /*normal*/, aType, (uint32_t)TmpTypes.array().size(), NULL /*for now*/, (uint32_t)TmpRefs.array().size(), NULL /*for now*/, (uint32_t)TmpOVFValues.array().size(), NULL /*for now*/, (uint32_t)TmpVBoxValues.array().size(), NULL /*for now*/, (uint32_t)TmpExtraConfigValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTIONBYTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aType, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETDESCRIPTIONBYTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aType, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTypes=%zu *aRefs=%zu *aOVFValues=%zu *aVBoxValues=%zu *aExtraConfigValues=%zu hrc=%Rhrc\n", this, "VirtualSystemDescription::getDescriptionByType", ComSafeArraySize(*aTypes), ComSafeArraySize(*aRefs), ComSafeArraySize(*aOVFValues), ComSafeArraySize(*aVBoxValues), ComSafeArraySize(*aExtraConfigValues), hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionWrap::RemoveDescriptionByType(VirtualSystemDescriptionType_T aType)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32\n", this, "VirtualSystemDescription::removeDescriptionByType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_REMOVEDESCRIPTIONBYTYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeDescriptionByType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_REMOVEDESCRIPTIONBYTYPE_RETURN(this, hrc, 0 /*normal*/, aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_REMOVEDESCRIPTIONBYTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_REMOVEDESCRIPTIONBYTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualSystemDescription::removeDescriptionByType", hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionWrap::GetValuesByType(VirtualSystemDescriptionType_T aType,
                                                           VirtualSystemDescriptionValueType_T aWhich,
                                                           ComSafeArrayOut(BSTR, aValues))
{
    LogRelFlow(("{%p} %s: enter aType=%RU32 aWhich=%RU32 aValues=%p\n", this, "VirtualSystemDescription::getValuesByType", aType, aWhich, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValues);


        
        
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETVALUESBYTYPE_ENTER(this, aType, aWhich);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValuesByType(aType,
                                  aWhich,
                                  TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETVALUESBYTYPE_RETURN(this, hrc, 0 /*normal*/, aType, aWhich, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETVALUESBYTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aType, aWhich, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_GETVALUESBYTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aType, aWhich, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValues=%zu hrc=%Rhrc\n", this, "VirtualSystemDescription::getValuesByType", ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionWrap::SetFinalValues(ComSafeArrayIn(BOOL, aEnabled),
                                                          ComSafeArrayIn(IN_BSTR, aVBoxValues),
                                                          ComSafeArrayIn(IN_BSTR, aExtraConfigValues))
{
    LogRelFlow(("{%p} %s: enter aEnabled=%zu aVBoxValues=%zu aExtraConfigValues=%zu\n", this, "VirtualSystemDescription::setFinalValues", aEnabled, aVBoxValues, aExtraConfigValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayInConverter<BOOL> TmpEnabled(ComSafeArrayInArg(aEnabled));
        ArrayBSTRInConverter TmpVBoxValues(ComSafeArrayInArg(aVBoxValues));
        ArrayBSTRInConverter TmpExtraConfigValues(ComSafeArrayInArg(aExtraConfigValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_SETFINALVALUES_ENTER(this, (uint32_t)TmpEnabled.array().size(), NULL /*for now*/, (uint32_t)TmpVBoxValues.array().size(), NULL /*for now*/, (uint32_t)TmpExtraConfigValues.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFinalValues(TmpEnabled.array(),
                                 TmpVBoxValues.array(),
                                 TmpExtraConfigValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_SETFINALVALUES_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpEnabled.array().size(), NULL /*for now*/, (uint32_t)TmpVBoxValues.array().size(), NULL /*for now*/, (uint32_t)TmpExtraConfigValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_SETFINALVALUES_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_SETFINALVALUES_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualSystemDescription::setFinalValues", hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionWrap::AddDescription(VirtualSystemDescriptionType_T aType,
                                                          IN_BSTR aVBoxValue,
                                                          IN_BSTR aExtraConfigValue)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32 aVBoxValue=%ls aExtraConfigValue=%ls\n", this, "VirtualSystemDescription::addDescription", aType, aVBoxValue, aExtraConfigValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        BSTRInConverter TmpVBoxValue(aVBoxValue);
        BSTRInConverter TmpExtraConfigValue(aExtraConfigValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_ADDDESCRIPTION_ENTER(this, aType, TmpVBoxValue.str().c_str(), TmpExtraConfigValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addDescription(aType,
                                 TmpVBoxValue.str(),
                                 TmpExtraConfigValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_ADDDESCRIPTION_RETURN(this, hrc, 0 /*normal*/, aType, TmpVBoxValue.str().c_str(), TmpExtraConfigValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_ADDDESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/, aType, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_VIRTUALSYSTEMDESCRIPTION_ADDDESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aType, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "VirtualSystemDescription::addDescription", hrc));
    return hrc;
}

STDMETHODIMP VirtualSystemDescriptionWrap::InternalAndReservedMethod1IVirtualSystemDescription()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionWrap::InternalAndReservedMethod2IVirtualSystemDescription()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionWrap::InternalAndReservedMethod3IVirtualSystemDescription()
{
    return E_NOTIMPL;
}

STDMETHODIMP VirtualSystemDescriptionWrap::InternalAndReservedMethod4IVirtualSystemDescription()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(VirtualSystemDescriptionWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(VirtualSystemDescriptionWrap, IVirtualSystemDescription)
#endif // VBOX_WITH_XPCOM
