/** @file
 * VirtualBox API class wrapper code for ISystemProperties.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_SYSTEMPROPERTIES

#include "SystemPropertiesWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(SystemPropertiesWrap)

//
// ISystemProperties properties
//

STDMETHODIMP SystemPropertiesWrap::COMGETTER(Platform)(IPlatformProperties **aPlatform)
{
    LogRelFlow(("{%p} %s: enter aPlatform=%p\n", this, "SystemProperties::getPlatform", aPlatform));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPlatform);
        ComTypeOutConverter<IPlatformProperties> TmpPlatform(aPlatform);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PLATFORM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPlatform(TmpPlatform.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PLATFORM_RETURN(this, hrc, 0 /*normal*/,(void *)TmpPlatform.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PLATFORM_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PLATFORM_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPlatform=%p hrc=%Rhrc\n", this, "SystemProperties::getPlatform", *aPlatform, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MinGuestRAM)(ULONG *aMinGuestRAM)
{
    LogRelFlow(("{%p} %s: enter aMinGuestRAM=%p\n", this, "SystemProperties::getMinGuestRAM", aMinGuestRAM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinGuestRAM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTRAM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinGuestRAM(aMinGuestRAM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTRAM_RETURN(this, hrc, 0 /*normal*/,*aMinGuestRAM);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTRAM_RETURN(this, hrc, 1 /*hrc exception*/,*aMinGuestRAM);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTRAM_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinGuestRAM);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinGuestRAM=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getMinGuestRAM", *aMinGuestRAM, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MaxGuestRAM)(ULONG *aMaxGuestRAM)
{
    LogRelFlow(("{%p} %s: enter aMaxGuestRAM=%p\n", this, "SystemProperties::getMaxGuestRAM", aMaxGuestRAM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxGuestRAM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTRAM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxGuestRAM(aMaxGuestRAM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTRAM_RETURN(this, hrc, 0 /*normal*/,*aMaxGuestRAM);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTRAM_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxGuestRAM);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTRAM_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxGuestRAM);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxGuestRAM=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getMaxGuestRAM", *aMaxGuestRAM, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MinGuestVRAM)(ULONG *aMinGuestVRAM)
{
    LogRelFlow(("{%p} %s: enter aMinGuestVRAM=%p\n", this, "SystemProperties::getMinGuestVRAM", aMinGuestVRAM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinGuestVRAM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTVRAM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinGuestVRAM(aMinGuestVRAM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTVRAM_RETURN(this, hrc, 0 /*normal*/,*aMinGuestVRAM);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTVRAM_RETURN(this, hrc, 1 /*hrc exception*/,*aMinGuestVRAM);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTVRAM_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinGuestVRAM);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinGuestVRAM=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getMinGuestVRAM", *aMinGuestVRAM, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MaxGuestVRAM)(ULONG *aMaxGuestVRAM)
{
    LogRelFlow(("{%p} %s: enter aMaxGuestVRAM=%p\n", this, "SystemProperties::getMaxGuestVRAM", aMaxGuestVRAM));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxGuestVRAM);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTVRAM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxGuestVRAM(aMaxGuestVRAM);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTVRAM_RETURN(this, hrc, 0 /*normal*/,*aMaxGuestVRAM);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTVRAM_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxGuestVRAM);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTVRAM_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxGuestVRAM);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxGuestVRAM=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getMaxGuestVRAM", *aMaxGuestVRAM, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MinGuestCPUCount)(ULONG *aMinGuestCPUCount)
{
    LogRelFlow(("{%p} %s: enter aMinGuestCPUCount=%p\n", this, "SystemProperties::getMinGuestCPUCount", aMinGuestCPUCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinGuestCPUCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTCPUCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinGuestCPUCount(aMinGuestCPUCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTCPUCOUNT_RETURN(this, hrc, 0 /*normal*/,*aMinGuestCPUCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTCPUCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aMinGuestCPUCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MINGUESTCPUCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinGuestCPUCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinGuestCPUCount=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getMinGuestCPUCount", *aMinGuestCPUCount, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MaxGuestCPUCount)(ULONG *aMaxGuestCPUCount)
{
    LogRelFlow(("{%p} %s: enter aMaxGuestCPUCount=%p\n", this, "SystemProperties::getMaxGuestCPUCount", aMaxGuestCPUCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxGuestCPUCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTCPUCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxGuestCPUCount(aMaxGuestCPUCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTCPUCOUNT_RETURN(this, hrc, 0 /*normal*/,*aMaxGuestCPUCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTCPUCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxGuestCPUCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTCPUCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxGuestCPUCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxGuestCPUCount=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getMaxGuestCPUCount", *aMaxGuestCPUCount, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MaxGuestMonitors)(ULONG *aMaxGuestMonitors)
{
    LogRelFlow(("{%p} %s: enter aMaxGuestMonitors=%p\n", this, "SystemProperties::getMaxGuestMonitors", aMaxGuestMonitors));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxGuestMonitors);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTMONITORS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxGuestMonitors(aMaxGuestMonitors);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTMONITORS_RETURN(this, hrc, 0 /*normal*/,*aMaxGuestMonitors);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTMONITORS_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxGuestMonitors);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MAXGUESTMONITORS_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxGuestMonitors);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxGuestMonitors=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getMaxGuestMonitors", *aMaxGuestMonitors, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InfoVDSize)(LONG64 *aInfoVDSize)
{
    LogRelFlow(("{%p} %s: enter aInfoVDSize=%p\n", this, "SystemProperties::getInfoVDSize", aInfoVDSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInfoVDSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_INFOVDSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInfoVDSize(aInfoVDSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_INFOVDSIZE_RETURN(this, hrc, 0 /*normal*/,*aInfoVDSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_INFOVDSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aInfoVDSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_INFOVDSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aInfoVDSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInfoVDSize=%RI64 hrc=%Rhrc\n", this, "SystemProperties::getInfoVDSize", *aInfoVDSize, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(DefaultMachineFolder)(BSTR *aDefaultMachineFolder)
{
    LogRelFlow(("{%p} %s: enter aDefaultMachineFolder=%p\n", this, "SystemProperties::getDefaultMachineFolder", aDefaultMachineFolder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultMachineFolder);
        BSTROutConverter TmpDefaultMachineFolder(aDefaultMachineFolder);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTMACHINEFOLDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultMachineFolder(TmpDefaultMachineFolder.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTMACHINEFOLDER_RETURN(this, hrc, 0 /*normal*/,TmpDefaultMachineFolder.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTMACHINEFOLDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTMACHINEFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultMachineFolder=%ls hrc=%Rhrc\n", this, "SystemProperties::getDefaultMachineFolder", *aDefaultMachineFolder, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(DefaultMachineFolder)(IN_BSTR aDefaultMachineFolder)
{
    LogRelFlow(("{%p} %s: enter aDefaultMachineFolder=%ls\n", this, "SystemProperties::setDefaultMachineFolder", aDefaultMachineFolder));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDefaultMachineFolder(aDefaultMachineFolder);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTMACHINEFOLDER_ENTER(this, TmpDefaultMachineFolder.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultMachineFolder(TmpDefaultMachineFolder.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTMACHINEFOLDER_RETURN(this, hrc, 0 /*normal*/,TmpDefaultMachineFolder.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTMACHINEFOLDER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTMACHINEFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setDefaultMachineFolder", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(LoggingLevel)(BSTR *aLoggingLevel)
{
    LogRelFlow(("{%p} %s: enter aLoggingLevel=%p\n", this, "SystemProperties::getLoggingLevel", aLoggingLevel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLoggingLevel);
        BSTROutConverter TmpLoggingLevel(aLoggingLevel);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGGINGLEVEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLoggingLevel(TmpLoggingLevel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGGINGLEVEL_RETURN(this, hrc, 0 /*normal*/,TmpLoggingLevel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGGINGLEVEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGGINGLEVEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLoggingLevel=%ls hrc=%Rhrc\n", this, "SystemProperties::getLoggingLevel", *aLoggingLevel, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(LoggingLevel)(IN_BSTR aLoggingLevel)
{
    LogRelFlow(("{%p} %s: enter aLoggingLevel=%ls\n", this, "SystemProperties::setLoggingLevel", aLoggingLevel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLoggingLevel(aLoggingLevel);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGGINGLEVEL_ENTER(this, TmpLoggingLevel.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLoggingLevel(TmpLoggingLevel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGGINGLEVEL_RETURN(this, hrc, 0 /*normal*/,TmpLoggingLevel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGGINGLEVEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGGINGLEVEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setLoggingLevel", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(MediumFormats)(ComSafeArrayOut(IMediumFormat *, aMediumFormats))
{
    LogRelFlow(("{%p} %s: enter aMediumFormats=%p\n", this, "SystemProperties::getMediumFormats", aMediumFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMediumFormats);
        ArrayComTypeOutConverter<IMediumFormat> TmpMediumFormats(ComSafeArrayOutArg(aMediumFormats));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MEDIUMFORMATS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMediumFormats(TmpMediumFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MEDIUMFORMATS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMediumFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MEDIUMFORMATS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_MEDIUMFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMediumFormats=%zu hrc=%Rhrc\n", this, "SystemProperties::getMediumFormats", ComSafeArraySize(*aMediumFormats), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(DefaultHardDiskFormat)(BSTR *aDefaultHardDiskFormat)
{
    LogRelFlow(("{%p} %s: enter aDefaultHardDiskFormat=%p\n", this, "SystemProperties::getDefaultHardDiskFormat", aDefaultHardDiskFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultHardDiskFormat);
        BSTROutConverter TmpDefaultHardDiskFormat(aDefaultHardDiskFormat);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTHARDDISKFORMAT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultHardDiskFormat(TmpDefaultHardDiskFormat.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTHARDDISKFORMAT_RETURN(this, hrc, 0 /*normal*/,TmpDefaultHardDiskFormat.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTHARDDISKFORMAT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTHARDDISKFORMAT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultHardDiskFormat=%ls hrc=%Rhrc\n", this, "SystemProperties::getDefaultHardDiskFormat", *aDefaultHardDiskFormat, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(DefaultHardDiskFormat)(IN_BSTR aDefaultHardDiskFormat)
{
    LogRelFlow(("{%p} %s: enter aDefaultHardDiskFormat=%ls\n", this, "SystemProperties::setDefaultHardDiskFormat", aDefaultHardDiskFormat));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDefaultHardDiskFormat(aDefaultHardDiskFormat);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTHARDDISKFORMAT_ENTER(this, TmpDefaultHardDiskFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultHardDiskFormat(TmpDefaultHardDiskFormat.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTHARDDISKFORMAT_RETURN(this, hrc, 0 /*normal*/,TmpDefaultHardDiskFormat.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTHARDDISKFORMAT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTHARDDISKFORMAT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setDefaultHardDiskFormat", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(FreeDiskSpaceWarning)(LONG64 *aFreeDiskSpaceWarning)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpaceWarning=%p\n", this, "SystemProperties::getFreeDiskSpaceWarning", aFreeDiskSpaceWarning));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFreeDiskSpaceWarning);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEWARNING_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFreeDiskSpaceWarning(aFreeDiskSpaceWarning);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEWARNING_RETURN(this, hrc, 0 /*normal*/,*aFreeDiskSpaceWarning);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEWARNING_RETURN(this, hrc, 1 /*hrc exception*/,*aFreeDiskSpaceWarning);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEWARNING_RETURN(this, hrc, 9 /*unhandled exception*/,*aFreeDiskSpaceWarning);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFreeDiskSpaceWarning=%RI64 hrc=%Rhrc\n", this, "SystemProperties::getFreeDiskSpaceWarning", *aFreeDiskSpaceWarning, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(FreeDiskSpaceWarning)(LONG64 aFreeDiskSpaceWarning)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpaceWarning=%RI64\n", this, "SystemProperties::setFreeDiskSpaceWarning", aFreeDiskSpaceWarning));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEWARNING_ENTER(this, aFreeDiskSpaceWarning);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFreeDiskSpaceWarning(aFreeDiskSpaceWarning);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEWARNING_RETURN(this, hrc, 0 /*normal*/,aFreeDiskSpaceWarning);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEWARNING_RETURN(this, hrc, 1 /*hrc exception*/,aFreeDiskSpaceWarning);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEWARNING_RETURN(this, hrc, 9 /*unhandled exception*/,aFreeDiskSpaceWarning);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setFreeDiskSpaceWarning", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(FreeDiskSpacePercentWarning)(ULONG *aFreeDiskSpacePercentWarning)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpacePercentWarning=%p\n", this, "SystemProperties::getFreeDiskSpacePercentWarning", aFreeDiskSpacePercentWarning));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFreeDiskSpacePercentWarning);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTWARNING_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFreeDiskSpacePercentWarning(aFreeDiskSpacePercentWarning);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTWARNING_RETURN(this, hrc, 0 /*normal*/,*aFreeDiskSpacePercentWarning);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTWARNING_RETURN(this, hrc, 1 /*hrc exception*/,*aFreeDiskSpacePercentWarning);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTWARNING_RETURN(this, hrc, 9 /*unhandled exception*/,*aFreeDiskSpacePercentWarning);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFreeDiskSpacePercentWarning=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getFreeDiskSpacePercentWarning", *aFreeDiskSpacePercentWarning, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(FreeDiskSpacePercentWarning)(ULONG aFreeDiskSpacePercentWarning)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpacePercentWarning=%RU32\n", this, "SystemProperties::setFreeDiskSpacePercentWarning", aFreeDiskSpacePercentWarning));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTWARNING_ENTER(this, aFreeDiskSpacePercentWarning);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFreeDiskSpacePercentWarning(aFreeDiskSpacePercentWarning);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTWARNING_RETURN(this, hrc, 0 /*normal*/,aFreeDiskSpacePercentWarning);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTWARNING_RETURN(this, hrc, 1 /*hrc exception*/,aFreeDiskSpacePercentWarning);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTWARNING_RETURN(this, hrc, 9 /*unhandled exception*/,aFreeDiskSpacePercentWarning);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setFreeDiskSpacePercentWarning", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(FreeDiskSpaceError)(LONG64 *aFreeDiskSpaceError)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpaceError=%p\n", this, "SystemProperties::getFreeDiskSpaceError", aFreeDiskSpaceError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFreeDiskSpaceError);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEERROR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFreeDiskSpaceError(aFreeDiskSpaceError);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEERROR_RETURN(this, hrc, 0 /*normal*/,*aFreeDiskSpaceError);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEERROR_RETURN(this, hrc, 1 /*hrc exception*/,*aFreeDiskSpaceError);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEERROR_RETURN(this, hrc, 9 /*unhandled exception*/,*aFreeDiskSpaceError);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFreeDiskSpaceError=%RI64 hrc=%Rhrc\n", this, "SystemProperties::getFreeDiskSpaceError", *aFreeDiskSpaceError, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(FreeDiskSpaceError)(LONG64 aFreeDiskSpaceError)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpaceError=%RI64\n", this, "SystemProperties::setFreeDiskSpaceError", aFreeDiskSpaceError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEERROR_ENTER(this, aFreeDiskSpaceError);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFreeDiskSpaceError(aFreeDiskSpaceError);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEERROR_RETURN(this, hrc, 0 /*normal*/,aFreeDiskSpaceError);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEERROR_RETURN(this, hrc, 1 /*hrc exception*/,aFreeDiskSpaceError);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEERROR_RETURN(this, hrc, 9 /*unhandled exception*/,aFreeDiskSpaceError);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setFreeDiskSpaceError", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(FreeDiskSpacePercentError)(ULONG *aFreeDiskSpacePercentError)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpacePercentError=%p\n", this, "SystemProperties::getFreeDiskSpacePercentError", aFreeDiskSpacePercentError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFreeDiskSpacePercentError);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTERROR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFreeDiskSpacePercentError(aFreeDiskSpacePercentError);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTERROR_RETURN(this, hrc, 0 /*normal*/,*aFreeDiskSpacePercentError);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTERROR_RETURN(this, hrc, 1 /*hrc exception*/,*aFreeDiskSpacePercentError);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_FREEDISKSPACEPERCENTERROR_RETURN(this, hrc, 9 /*unhandled exception*/,*aFreeDiskSpacePercentError);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFreeDiskSpacePercentError=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getFreeDiskSpacePercentError", *aFreeDiskSpacePercentError, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(FreeDiskSpacePercentError)(ULONG aFreeDiskSpacePercentError)
{
    LogRelFlow(("{%p} %s: enter aFreeDiskSpacePercentError=%RU32\n", this, "SystemProperties::setFreeDiskSpacePercentError", aFreeDiskSpacePercentError));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTERROR_ENTER(this, aFreeDiskSpacePercentError);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFreeDiskSpacePercentError(aFreeDiskSpacePercentError);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTERROR_RETURN(this, hrc, 0 /*normal*/,aFreeDiskSpacePercentError);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTERROR_RETURN(this, hrc, 1 /*hrc exception*/,aFreeDiskSpacePercentError);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_FREEDISKSPACEPERCENTERROR_RETURN(this, hrc, 9 /*unhandled exception*/,aFreeDiskSpacePercentError);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setFreeDiskSpacePercentError", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(VRDEAuthLibrary)(BSTR *aVRDEAuthLibrary)
{
    LogRelFlow(("{%p} %s: enter aVRDEAuthLibrary=%p\n", this, "SystemProperties::getVRDEAuthLibrary", aVRDEAuthLibrary));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEAuthLibrary);
        BSTROutConverter TmpVRDEAuthLibrary(aVRDEAuthLibrary);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_VRDEAUTHLIBRARY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEAuthLibrary(TmpVRDEAuthLibrary.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_VRDEAUTHLIBRARY_RETURN(this, hrc, 0 /*normal*/,TmpVRDEAuthLibrary.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_VRDEAUTHLIBRARY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_VRDEAUTHLIBRARY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEAuthLibrary=%ls hrc=%Rhrc\n", this, "SystemProperties::getVRDEAuthLibrary", *aVRDEAuthLibrary, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(VRDEAuthLibrary)(IN_BSTR aVRDEAuthLibrary)
{
    LogRelFlow(("{%p} %s: enter aVRDEAuthLibrary=%ls\n", this, "SystemProperties::setVRDEAuthLibrary", aVRDEAuthLibrary));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpVRDEAuthLibrary(aVRDEAuthLibrary);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_VRDEAUTHLIBRARY_ENTER(this, TmpVRDEAuthLibrary.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVRDEAuthLibrary(TmpVRDEAuthLibrary.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_VRDEAUTHLIBRARY_RETURN(this, hrc, 0 /*normal*/,TmpVRDEAuthLibrary.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_VRDEAUTHLIBRARY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_VRDEAUTHLIBRARY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setVRDEAuthLibrary", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(WebServiceAuthLibrary)(BSTR *aWebServiceAuthLibrary)
{
    LogRelFlow(("{%p} %s: enter aWebServiceAuthLibrary=%p\n", this, "SystemProperties::getWebServiceAuthLibrary", aWebServiceAuthLibrary));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWebServiceAuthLibrary);
        BSTROutConverter TmpWebServiceAuthLibrary(aWebServiceAuthLibrary);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_WEBSERVICEAUTHLIBRARY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWebServiceAuthLibrary(TmpWebServiceAuthLibrary.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_WEBSERVICEAUTHLIBRARY_RETURN(this, hrc, 0 /*normal*/,TmpWebServiceAuthLibrary.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_WEBSERVICEAUTHLIBRARY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_WEBSERVICEAUTHLIBRARY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWebServiceAuthLibrary=%ls hrc=%Rhrc\n", this, "SystemProperties::getWebServiceAuthLibrary", *aWebServiceAuthLibrary, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(WebServiceAuthLibrary)(IN_BSTR aWebServiceAuthLibrary)
{
    LogRelFlow(("{%p} %s: enter aWebServiceAuthLibrary=%ls\n", this, "SystemProperties::setWebServiceAuthLibrary", aWebServiceAuthLibrary));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpWebServiceAuthLibrary(aWebServiceAuthLibrary);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_WEBSERVICEAUTHLIBRARY_ENTER(this, TmpWebServiceAuthLibrary.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setWebServiceAuthLibrary(TmpWebServiceAuthLibrary.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_WEBSERVICEAUTHLIBRARY_RETURN(this, hrc, 0 /*normal*/,TmpWebServiceAuthLibrary.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_WEBSERVICEAUTHLIBRARY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_WEBSERVICEAUTHLIBRARY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setWebServiceAuthLibrary", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(DefaultVRDEExtPack)(BSTR *aDefaultVRDEExtPack)
{
    LogRelFlow(("{%p} %s: enter aDefaultVRDEExtPack=%p\n", this, "SystemProperties::getDefaultVRDEExtPack", aDefaultVRDEExtPack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultVRDEExtPack);
        BSTROutConverter TmpDefaultVRDEExtPack(aDefaultVRDEExtPack);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTVRDEEXTPACK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultVRDEExtPack(TmpDefaultVRDEExtPack.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTVRDEEXTPACK_RETURN(this, hrc, 0 /*normal*/,TmpDefaultVRDEExtPack.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTVRDEEXTPACK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTVRDEEXTPACK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultVRDEExtPack=%ls hrc=%Rhrc\n", this, "SystemProperties::getDefaultVRDEExtPack", *aDefaultVRDEExtPack, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(DefaultVRDEExtPack)(IN_BSTR aDefaultVRDEExtPack)
{
    LogRelFlow(("{%p} %s: enter aDefaultVRDEExtPack=%ls\n", this, "SystemProperties::setDefaultVRDEExtPack", aDefaultVRDEExtPack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDefaultVRDEExtPack(aDefaultVRDEExtPack);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTVRDEEXTPACK_ENTER(this, TmpDefaultVRDEExtPack.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultVRDEExtPack(TmpDefaultVRDEExtPack.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTVRDEEXTPACK_RETURN(this, hrc, 0 /*normal*/,TmpDefaultVRDEExtPack.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTVRDEEXTPACK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTVRDEEXTPACK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setDefaultVRDEExtPack", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(DefaultCryptoExtPack)(BSTR *aDefaultCryptoExtPack)
{
    LogRelFlow(("{%p} %s: enter aDefaultCryptoExtPack=%p\n", this, "SystemProperties::getDefaultCryptoExtPack", aDefaultCryptoExtPack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultCryptoExtPack);
        BSTROutConverter TmpDefaultCryptoExtPack(aDefaultCryptoExtPack);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTCRYPTOEXTPACK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultCryptoExtPack(TmpDefaultCryptoExtPack.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTCRYPTOEXTPACK_RETURN(this, hrc, 0 /*normal*/,TmpDefaultCryptoExtPack.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTCRYPTOEXTPACK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTCRYPTOEXTPACK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultCryptoExtPack=%ls hrc=%Rhrc\n", this, "SystemProperties::getDefaultCryptoExtPack", *aDefaultCryptoExtPack, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(DefaultCryptoExtPack)(IN_BSTR aDefaultCryptoExtPack)
{
    LogRelFlow(("{%p} %s: enter aDefaultCryptoExtPack=%ls\n", this, "SystemProperties::setDefaultCryptoExtPack", aDefaultCryptoExtPack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDefaultCryptoExtPack(aDefaultCryptoExtPack);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTCRYPTOEXTPACK_ENTER(this, TmpDefaultCryptoExtPack.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultCryptoExtPack(TmpDefaultCryptoExtPack.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTCRYPTOEXTPACK_RETURN(this, hrc, 0 /*normal*/,TmpDefaultCryptoExtPack.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTCRYPTOEXTPACK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTCRYPTOEXTPACK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setDefaultCryptoExtPack", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(LogHistoryCount)(ULONG *aLogHistoryCount)
{
    LogRelFlow(("{%p} %s: enter aLogHistoryCount=%p\n", this, "SystemProperties::getLogHistoryCount", aLogHistoryCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLogHistoryCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGHISTORYCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLogHistoryCount(aLogHistoryCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGHISTORYCOUNT_RETURN(this, hrc, 0 /*normal*/,*aLogHistoryCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGHISTORYCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aLogHistoryCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LOGHISTORYCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aLogHistoryCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLogHistoryCount=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getLogHistoryCount", *aLogHistoryCount, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(LogHistoryCount)(ULONG aLogHistoryCount)
{
    LogRelFlow(("{%p} %s: enter aLogHistoryCount=%RU32\n", this, "SystemProperties::setLogHistoryCount", aLogHistoryCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGHISTORYCOUNT_ENTER(this, aLogHistoryCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLogHistoryCount(aLogHistoryCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGHISTORYCOUNT_RETURN(this, hrc, 0 /*normal*/,aLogHistoryCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGHISTORYCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,aLogHistoryCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LOGHISTORYCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,aLogHistoryCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setLogHistoryCount", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(DefaultAudioDriver)(AudioDriverType_T *aDefaultAudioDriver)
{
    LogRelFlow(("{%p} %s: enter aDefaultAudioDriver=%p\n", this, "SystemProperties::getDefaultAudioDriver", aDefaultAudioDriver));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultAudioDriver);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTAUDIODRIVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultAudioDriver(aDefaultAudioDriver);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTAUDIODRIVER_RETURN(this, hrc, 0 /*normal*/,*aDefaultAudioDriver);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTAUDIODRIVER_RETURN(this, hrc, 1 /*hrc exception*/,*aDefaultAudioDriver);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTAUDIODRIVER_RETURN(this, hrc, 9 /*unhandled exception*/,*aDefaultAudioDriver);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultAudioDriver=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getDefaultAudioDriver", *aDefaultAudioDriver, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(AutostartDatabasePath)(BSTR *aAutostartDatabasePath)
{
    LogRelFlow(("{%p} %s: enter aAutostartDatabasePath=%p\n", this, "SystemProperties::getAutostartDatabasePath", aAutostartDatabasePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAutostartDatabasePath);
        BSTROutConverter TmpAutostartDatabasePath(aAutostartDatabasePath);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_AUTOSTARTDATABASEPATH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAutostartDatabasePath(TmpAutostartDatabasePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_AUTOSTARTDATABASEPATH_RETURN(this, hrc, 0 /*normal*/,TmpAutostartDatabasePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_AUTOSTARTDATABASEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_AUTOSTARTDATABASEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAutostartDatabasePath=%ls hrc=%Rhrc\n", this, "SystemProperties::getAutostartDatabasePath", *aAutostartDatabasePath, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(AutostartDatabasePath)(IN_BSTR aAutostartDatabasePath)
{
    LogRelFlow(("{%p} %s: enter aAutostartDatabasePath=%ls\n", this, "SystemProperties::setAutostartDatabasePath", aAutostartDatabasePath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpAutostartDatabasePath(aAutostartDatabasePath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_AUTOSTARTDATABASEPATH_ENTER(this, TmpAutostartDatabasePath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAutostartDatabasePath(TmpAutostartDatabasePath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_AUTOSTARTDATABASEPATH_RETURN(this, hrc, 0 /*normal*/,TmpAutostartDatabasePath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_AUTOSTARTDATABASEPATH_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_AUTOSTARTDATABASEPATH_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setAutostartDatabasePath", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(DefaultAdditionsISO)(BSTR *aDefaultAdditionsISO)
{
    LogRelFlow(("{%p} %s: enter aDefaultAdditionsISO=%p\n", this, "SystemProperties::getDefaultAdditionsISO", aDefaultAdditionsISO));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultAdditionsISO);
        BSTROutConverter TmpDefaultAdditionsISO(aDefaultAdditionsISO);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTADDITIONSISO_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultAdditionsISO(TmpDefaultAdditionsISO.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTADDITIONSISO_RETURN(this, hrc, 0 /*normal*/,TmpDefaultAdditionsISO.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTADDITIONSISO_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTADDITIONSISO_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultAdditionsISO=%ls hrc=%Rhrc\n", this, "SystemProperties::getDefaultAdditionsISO", *aDefaultAdditionsISO, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(DefaultAdditionsISO)(IN_BSTR aDefaultAdditionsISO)
{
    LogRelFlow(("{%p} %s: enter aDefaultAdditionsISO=%ls\n", this, "SystemProperties::setDefaultAdditionsISO", aDefaultAdditionsISO));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDefaultAdditionsISO(aDefaultAdditionsISO);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTADDITIONSISO_ENTER(this, TmpDefaultAdditionsISO.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultAdditionsISO(TmpDefaultAdditionsISO.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTADDITIONSISO_RETURN(this, hrc, 0 /*normal*/,TmpDefaultAdditionsISO.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTADDITIONSISO_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTADDITIONSISO_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setDefaultAdditionsISO", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(DefaultFrontend)(BSTR *aDefaultFrontend)
{
    LogRelFlow(("{%p} %s: enter aDefaultFrontend=%p\n", this, "SystemProperties::getDefaultFrontend", aDefaultFrontend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultFrontend);
        BSTROutConverter TmpDefaultFrontend(aDefaultFrontend);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTFRONTEND_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultFrontend(TmpDefaultFrontend.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTFRONTEND_RETURN(this, hrc, 0 /*normal*/,TmpDefaultFrontend.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTFRONTEND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_DEFAULTFRONTEND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultFrontend=%ls hrc=%Rhrc\n", this, "SystemProperties::getDefaultFrontend", *aDefaultFrontend, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(DefaultFrontend)(IN_BSTR aDefaultFrontend)
{
    LogRelFlow(("{%p} %s: enter aDefaultFrontend=%ls\n", this, "SystemProperties::setDefaultFrontend", aDefaultFrontend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDefaultFrontend(aDefaultFrontend);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTFRONTEND_ENTER(this, TmpDefaultFrontend.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultFrontend(TmpDefaultFrontend.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTFRONTEND_RETURN(this, hrc, 0 /*normal*/,TmpDefaultFrontend.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTFRONTEND_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_DEFAULTFRONTEND_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setDefaultFrontend", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(ScreenShotFormats)(ComSafeArrayOut(BitmapFormat_T, aScreenShotFormats))
{
    LogRelFlow(("{%p} %s: enter aScreenShotFormats=%p\n", this, "SystemProperties::getScreenShotFormats", aScreenShotFormats));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScreenShotFormats);
        ArrayOutConverter<BitmapFormat_T> TmpScreenShotFormats(ComSafeArrayOutArg(aScreenShotFormats));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SCREENSHOTFORMATS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreenShotFormats(TmpScreenShotFormats.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SCREENSHOTFORMATS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpScreenShotFormats.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SCREENSHOTFORMATS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SCREENSHOTFORMATS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScreenShotFormats=%zu hrc=%Rhrc\n", this, "SystemProperties::getScreenShotFormats", ComSafeArraySize(*aScreenShotFormats), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(ProxyMode)(ProxyMode_T *aProxyMode)
{
    LogRelFlow(("{%p} %s: enter aProxyMode=%p\n", this, "SystemProperties::getProxyMode", aProxyMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProxyMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProxyMode(aProxyMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYMODE_RETURN(this, hrc, 0 /*normal*/,*aProxyMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aProxyMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aProxyMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProxyMode=%RU32 hrc=%Rhrc\n", this, "SystemProperties::getProxyMode", *aProxyMode, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(ProxyMode)(ProxyMode_T aProxyMode)
{
    LogRelFlow(("{%p} %s: enter aProxyMode=%RU32\n", this, "SystemProperties::setProxyMode", aProxyMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYMODE_ENTER(this, aProxyMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProxyMode(aProxyMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYMODE_RETURN(this, hrc, 0 /*normal*/,aProxyMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYMODE_RETURN(this, hrc, 1 /*hrc exception*/,aProxyMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aProxyMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setProxyMode", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(ProxyURL)(BSTR *aProxyURL)
{
    LogRelFlow(("{%p} %s: enter aProxyURL=%p\n", this, "SystemProperties::getProxyURL", aProxyURL));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProxyURL);
        BSTROutConverter TmpProxyURL(aProxyURL);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYURL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProxyURL(TmpProxyURL.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYURL_RETURN(this, hrc, 0 /*normal*/,TmpProxyURL.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYURL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_PROXYURL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProxyURL=%ls hrc=%Rhrc\n", this, "SystemProperties::getProxyURL", *aProxyURL, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(ProxyURL)(IN_BSTR aProxyURL)
{
    LogRelFlow(("{%p} %s: enter aProxyURL=%ls\n", this, "SystemProperties::setProxyURL", aProxyURL));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpProxyURL(aProxyURL);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYURL_ENTER(this, TmpProxyURL.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProxyURL(TmpProxyURL.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYURL_RETURN(this, hrc, 0 /*normal*/,TmpProxyURL.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYURL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_PROXYURL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setProxyURL", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedPlatformArchitectures)(ComSafeArrayOut(PlatformArchitecture_T, aSupportedPlatformArchitectures))
{
    LogRelFlow(("{%p} %s: enter aSupportedPlatformArchitectures=%p\n", this, "SystemProperties::getSupportedPlatformArchitectures", aSupportedPlatformArchitectures));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedPlatformArchitectures);
        ArrayOutConverter<PlatformArchitecture_T> TmpSupportedPlatformArchitectures(ComSafeArrayOutArg(aSupportedPlatformArchitectures));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPLATFORMARCHITECTURES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedPlatformArchitectures(TmpSupportedPlatformArchitectures.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPLATFORMARCHITECTURES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedPlatformArchitectures.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPLATFORMARCHITECTURES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPLATFORMARCHITECTURES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedPlatformArchitectures=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedPlatformArchitectures", ComSafeArraySize(*aSupportedPlatformArchitectures), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedClipboardModes)(ComSafeArrayOut(ClipboardMode_T, aSupportedClipboardModes))
{
    LogRelFlow(("{%p} %s: enter aSupportedClipboardModes=%p\n", this, "SystemProperties::getSupportedClipboardModes", aSupportedClipboardModes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedClipboardModes);
        ArrayOutConverter<ClipboardMode_T> TmpSupportedClipboardModes(ComSafeArrayOutArg(aSupportedClipboardModes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLIPBOARDMODES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedClipboardModes(TmpSupportedClipboardModes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLIPBOARDMODES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedClipboardModes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLIPBOARDMODES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLIPBOARDMODES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedClipboardModes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedClipboardModes", ComSafeArraySize(*aSupportedClipboardModes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedDnDModes)(ComSafeArrayOut(DnDMode_T, aSupportedDnDModes))
{
    LogRelFlow(("{%p} %s: enter aSupportedDnDModes=%p\n", this, "SystemProperties::getSupportedDnDModes", aSupportedDnDModes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedDnDModes);
        ArrayOutConverter<DnDMode_T> TmpSupportedDnDModes(ComSafeArrayOutArg(aSupportedDnDModes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDDNDMODES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedDnDModes(TmpSupportedDnDModes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDDNDMODES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedDnDModes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDDNDMODES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDDNDMODES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedDnDModes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedDnDModes", ComSafeArraySize(*aSupportedDnDModes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedPointingHIDTypes)(ComSafeArrayOut(PointingHIDType_T, aSupportedPointingHIDTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedPointingHIDTypes=%p\n", this, "SystemProperties::getSupportedPointingHIDTypes", aSupportedPointingHIDTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedPointingHIDTypes);
        ArrayOutConverter<PointingHIDType_T> TmpSupportedPointingHIDTypes(ComSafeArrayOutArg(aSupportedPointingHIDTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPOINTINGHIDTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedPointingHIDTypes(TmpSupportedPointingHIDTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPOINTINGHIDTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedPointingHIDTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPOINTINGHIDTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPOINTINGHIDTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedPointingHIDTypes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedPointingHIDTypes", ComSafeArraySize(*aSupportedPointingHIDTypes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedKeyboardHIDTypes)(ComSafeArrayOut(KeyboardHIDType_T, aSupportedKeyboardHIDTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedKeyboardHIDTypes=%p\n", this, "SystemProperties::getSupportedKeyboardHIDTypes", aSupportedKeyboardHIDTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedKeyboardHIDTypes);
        ArrayOutConverter<KeyboardHIDType_T> TmpSupportedKeyboardHIDTypes(ComSafeArrayOutArg(aSupportedKeyboardHIDTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDKEYBOARDHIDTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedKeyboardHIDTypes(TmpSupportedKeyboardHIDTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDKEYBOARDHIDTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedKeyboardHIDTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDKEYBOARDHIDTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDKEYBOARDHIDTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedKeyboardHIDTypes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedKeyboardHIDTypes", ComSafeArraySize(*aSupportedKeyboardHIDTypes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedVFSTypes)(ComSafeArrayOut(VFSType_T, aSupportedVFSTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedVFSTypes=%p\n", this, "SystemProperties::getSupportedVFSTypes", aSupportedVFSTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedVFSTypes);
        ArrayOutConverter<VFSType_T> TmpSupportedVFSTypes(ComSafeArrayOutArg(aSupportedVFSTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVFSTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedVFSTypes(TmpSupportedVFSTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVFSTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedVFSTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVFSTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVFSTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedVFSTypes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedVFSTypes", ComSafeArraySize(*aSupportedVFSTypes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedImportOptions)(ComSafeArrayOut(ImportOptions_T, aSupportedImportOptions))
{
    LogRelFlow(("{%p} %s: enter aSupportedImportOptions=%p\n", this, "SystemProperties::getSupportedImportOptions", aSupportedImportOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedImportOptions);
        ArrayOutConverter<ImportOptions_T> TmpSupportedImportOptions(ComSafeArrayOutArg(aSupportedImportOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDIMPORTOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedImportOptions(TmpSupportedImportOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDIMPORTOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedImportOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDIMPORTOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDIMPORTOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedImportOptions=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedImportOptions", ComSafeArraySize(*aSupportedImportOptions), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedExportOptions)(ComSafeArrayOut(ExportOptions_T, aSupportedExportOptions))
{
    LogRelFlow(("{%p} %s: enter aSupportedExportOptions=%p\n", this, "SystemProperties::getSupportedExportOptions", aSupportedExportOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedExportOptions);
        ArrayOutConverter<ExportOptions_T> TmpSupportedExportOptions(ComSafeArrayOutArg(aSupportedExportOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDEXPORTOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedExportOptions(TmpSupportedExportOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDEXPORTOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedExportOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDEXPORTOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDEXPORTOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedExportOptions=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedExportOptions", ComSafeArraySize(*aSupportedExportOptions), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedGraphicsFeatures)(ComSafeArrayOut(GraphicsFeature_T, aSupportedGraphicsFeatures))
{
    LogRelFlow(("{%p} %s: enter aSupportedGraphicsFeatures=%p\n", this, "SystemProperties::getSupportedGraphicsFeatures", aSupportedGraphicsFeatures));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedGraphicsFeatures);
        ArrayOutConverter<GraphicsFeature_T> TmpSupportedGraphicsFeatures(ComSafeArrayOutArg(aSupportedGraphicsFeatures));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDGRAPHICSFEATURES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedGraphicsFeatures(TmpSupportedGraphicsFeatures.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDGRAPHICSFEATURES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedGraphicsFeatures.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDGRAPHICSFEATURES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDGRAPHICSFEATURES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedGraphicsFeatures=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedGraphicsFeatures", ComSafeArraySize(*aSupportedGraphicsFeatures), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedRecordingFeatures)(ComSafeArrayOut(RecordingFeature_T, aSupportedRecordingFeatures))
{
    LogRelFlow(("{%p} %s: enter aSupportedRecordingFeatures=%p\n", this, "SystemProperties::getSupportedRecordingFeatures", aSupportedRecordingFeatures));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedRecordingFeatures);
        ArrayOutConverter<RecordingFeature_T> TmpSupportedRecordingFeatures(ComSafeArrayOutArg(aSupportedRecordingFeatures));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGFEATURES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedRecordingFeatures(TmpSupportedRecordingFeatures.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGFEATURES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedRecordingFeatures.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGFEATURES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGFEATURES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedRecordingFeatures=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedRecordingFeatures", ComSafeArraySize(*aSupportedRecordingFeatures), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedRecordingAudioCodecs)(ComSafeArrayOut(RecordingAudioCodec_T, aSupportedRecordingAudioCodecs))
{
    LogRelFlow(("{%p} %s: enter aSupportedRecordingAudioCodecs=%p\n", this, "SystemProperties::getSupportedRecordingAudioCodecs", aSupportedRecordingAudioCodecs));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedRecordingAudioCodecs);
        ArrayOutConverter<RecordingAudioCodec_T> TmpSupportedRecordingAudioCodecs(ComSafeArrayOutArg(aSupportedRecordingAudioCodecs));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGAUDIOCODECS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedRecordingAudioCodecs(TmpSupportedRecordingAudioCodecs.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGAUDIOCODECS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedRecordingAudioCodecs.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGAUDIOCODECS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGAUDIOCODECS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedRecordingAudioCodecs=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedRecordingAudioCodecs", ComSafeArraySize(*aSupportedRecordingAudioCodecs), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedRecordingVideoCodecs)(ComSafeArrayOut(RecordingVideoCodec_T, aSupportedRecordingVideoCodecs))
{
    LogRelFlow(("{%p} %s: enter aSupportedRecordingVideoCodecs=%p\n", this, "SystemProperties::getSupportedRecordingVideoCodecs", aSupportedRecordingVideoCodecs));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedRecordingVideoCodecs);
        ArrayOutConverter<RecordingVideoCodec_T> TmpSupportedRecordingVideoCodecs(ComSafeArrayOutArg(aSupportedRecordingVideoCodecs));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVIDEOCODECS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedRecordingVideoCodecs(TmpSupportedRecordingVideoCodecs.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVIDEOCODECS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedRecordingVideoCodecs.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVIDEOCODECS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVIDEOCODECS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedRecordingVideoCodecs=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedRecordingVideoCodecs", ComSafeArraySize(*aSupportedRecordingVideoCodecs), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedRecordingVSModes)(ComSafeArrayOut(RecordingVideoScalingMode_T, aSupportedRecordingVSModes))
{
    LogRelFlow(("{%p} %s: enter aSupportedRecordingVSModes=%p\n", this, "SystemProperties::getSupportedRecordingVSModes", aSupportedRecordingVSModes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedRecordingVSModes);
        ArrayOutConverter<RecordingVideoScalingMode_T> TmpSupportedRecordingVSModes(ComSafeArrayOutArg(aSupportedRecordingVSModes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVSMODES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedRecordingVSModes(TmpSupportedRecordingVSModes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVSMODES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedRecordingVSModes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVSMODES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVSMODES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedRecordingVSModes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedRecordingVSModes", ComSafeArraySize(*aSupportedRecordingVSModes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedRecordingARCModes)(ComSafeArrayOut(RecordingRateControlMode_T, aSupportedRecordingARCModes))
{
    LogRelFlow(("{%p} %s: enter aSupportedRecordingARCModes=%p\n", this, "SystemProperties::getSupportedRecordingARCModes", aSupportedRecordingARCModes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedRecordingARCModes);
        ArrayOutConverter<RecordingRateControlMode_T> TmpSupportedRecordingARCModes(ComSafeArrayOutArg(aSupportedRecordingARCModes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGARCMODES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedRecordingARCModes(TmpSupportedRecordingARCModes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGARCMODES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedRecordingARCModes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGARCMODES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGARCMODES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedRecordingARCModes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedRecordingARCModes", ComSafeArraySize(*aSupportedRecordingARCModes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedRecordingVRCModes)(ComSafeArrayOut(RecordingRateControlMode_T, aSupportedRecordingVRCModes))
{
    LogRelFlow(("{%p} %s: enter aSupportedRecordingVRCModes=%p\n", this, "SystemProperties::getSupportedRecordingVRCModes", aSupportedRecordingVRCModes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedRecordingVRCModes);
        ArrayOutConverter<RecordingRateControlMode_T> TmpSupportedRecordingVRCModes(ComSafeArrayOutArg(aSupportedRecordingVRCModes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVRCMODES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedRecordingVRCModes(TmpSupportedRecordingVRCModes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVRCMODES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedRecordingVRCModes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVRCMODES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDRECORDINGVRCMODES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedRecordingVRCModes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedRecordingVRCModes", ComSafeArraySize(*aSupportedRecordingVRCModes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedCloneOptions)(ComSafeArrayOut(CloneOptions_T, aSupportedCloneOptions))
{
    LogRelFlow(("{%p} %s: enter aSupportedCloneOptions=%p\n", this, "SystemProperties::getSupportedCloneOptions", aSupportedCloneOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedCloneOptions);
        ArrayOutConverter<CloneOptions_T> TmpSupportedCloneOptions(ComSafeArrayOutArg(aSupportedCloneOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLONEOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedCloneOptions(TmpSupportedCloneOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLONEOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedCloneOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLONEOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDCLONEOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedCloneOptions=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedCloneOptions", ComSafeArraySize(*aSupportedCloneOptions), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedAutostopTypes)(ComSafeArrayOut(AutostopType_T, aSupportedAutostopTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedAutostopTypes=%p\n", this, "SystemProperties::getSupportedAutostopTypes", aSupportedAutostopTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedAutostopTypes);
        ArrayOutConverter<AutostopType_T> TmpSupportedAutostopTypes(ComSafeArrayOutArg(aSupportedAutostopTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUTOSTOPTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedAutostopTypes(TmpSupportedAutostopTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUTOSTOPTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedAutostopTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUTOSTOPTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUTOSTOPTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedAutostopTypes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedAutostopTypes", ComSafeArraySize(*aSupportedAutostopTypes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedVMProcPriorities)(ComSafeArrayOut(VMProcPriority_T, aSupportedVMProcPriorities))
{
    LogRelFlow(("{%p} %s: enter aSupportedVMProcPriorities=%p\n", this, "SystemProperties::getSupportedVMProcPriorities", aSupportedVMProcPriorities));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedVMProcPriorities);
        ArrayOutConverter<VMProcPriority_T> TmpSupportedVMProcPriorities(ComSafeArrayOutArg(aSupportedVMProcPriorities));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVMPROCPRIORITIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedVMProcPriorities(TmpSupportedVMProcPriorities.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVMPROCPRIORITIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedVMProcPriorities.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVMPROCPRIORITIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDVMPROCPRIORITIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedVMProcPriorities=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedVMProcPriorities", ComSafeArraySize(*aSupportedVMProcPriorities), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedNetworkAttachmentTypes)(ComSafeArrayOut(NetworkAttachmentType_T, aSupportedNetworkAttachmentTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedNetworkAttachmentTypes=%p\n", this, "SystemProperties::getSupportedNetworkAttachmentTypes", aSupportedNetworkAttachmentTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedNetworkAttachmentTypes);
        ArrayOutConverter<NetworkAttachmentType_T> TmpSupportedNetworkAttachmentTypes(ComSafeArrayOutArg(aSupportedNetworkAttachmentTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDNETWORKATTACHMENTTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedNetworkAttachmentTypes(TmpSupportedNetworkAttachmentTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDNETWORKATTACHMENTTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedNetworkAttachmentTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDNETWORKATTACHMENTTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDNETWORKATTACHMENTTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedNetworkAttachmentTypes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedNetworkAttachmentTypes", ComSafeArraySize(*aSupportedNetworkAttachmentTypes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedPortModes)(ComSafeArrayOut(PortMode_T, aSupportedPortModes))
{
    LogRelFlow(("{%p} %s: enter aSupportedPortModes=%p\n", this, "SystemProperties::getSupportedPortModes", aSupportedPortModes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedPortModes);
        ArrayOutConverter<PortMode_T> TmpSupportedPortModes(ComSafeArrayOutArg(aSupportedPortModes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPORTMODES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedPortModes(TmpSupportedPortModes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPORTMODES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedPortModes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPORTMODES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDPORTMODES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedPortModes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedPortModes", ComSafeArraySize(*aSupportedPortModes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(SupportedAudioDriverTypes)(ComSafeArrayOut(AudioDriverType_T, aSupportedAudioDriverTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedAudioDriverTypes=%p\n", this, "SystemProperties::getSupportedAudioDriverTypes", aSupportedAudioDriverTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedAudioDriverTypes);
        ArrayOutConverter<AudioDriverType_T> TmpSupportedAudioDriverTypes(ComSafeArrayOutArg(aSupportedAudioDriverTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUDIODRIVERTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedAudioDriverTypes(TmpSupportedAudioDriverTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUDIODRIVERTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedAudioDriverTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUDIODRIVERTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_SUPPORTEDAUDIODRIVERTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedAudioDriverTypes=%zu hrc=%Rhrc\n", this, "SystemProperties::getSupportedAudioDriverTypes", ComSafeArraySize(*aSupportedAudioDriverTypes), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(LanguageId)(BSTR *aLanguageId)
{
    LogRelFlow(("{%p} %s: enter aLanguageId=%p\n", this, "SystemProperties::getLanguageId", aLanguageId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLanguageId);
        BSTROutConverter TmpLanguageId(aLanguageId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LANGUAGEID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLanguageId(TmpLanguageId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LANGUAGEID_RETURN(this, hrc, 0 /*normal*/,TmpLanguageId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LANGUAGEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GET_LANGUAGEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLanguageId=%ls hrc=%Rhrc\n", this, "SystemProperties::getLanguageId", *aLanguageId, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMSETTER(LanguageId)(IN_BSTR aLanguageId)
{
    LogRelFlow(("{%p} %s: enter aLanguageId=%ls\n", this, "SystemProperties::setLanguageId", aLanguageId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpLanguageId(aLanguageId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LANGUAGEID_ENTER(this, TmpLanguageId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLanguageId(TmpLanguageId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LANGUAGEID_RETURN(this, hrc, 0 /*normal*/,TmpLanguageId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LANGUAGEID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_SET_LANGUAGEID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "SystemProperties::setLanguageId", hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute1ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute2ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute3ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute4ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute5ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute6ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute7ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute8ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute9ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute10ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute11ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute12ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute13ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute14ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute15ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::COMGETTER(InternalAndReservedAttribute16ISystemProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ISystemProperties methods
//

STDMETHODIMP SystemPropertiesWrap::GetDefaultIoCacheSettingForStorageController(StorageControllerType_T aControllerType,
                                                                                BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aControllerType=%RU32 aEnabled=%p\n", this, "SystemProperties::getDefaultIoCacheSettingForStorageController", aControllerType, aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETDEFAULTSTORAGECTRLCACHESETTING_ENTER(this, aControllerType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultIoCacheSettingForStorageController(aControllerType,
                                                               aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETDEFAULTSTORAGECTRLCACHESETTING_RETURN(this, hrc, 0 /*normal*/, aControllerType, *aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETDEFAULTSTORAGECTRLCACHESETTING_RETURN(this, hrc, 1 /*hrc exception*/, aControllerType, *aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETDEFAULTSTORAGECTRLCACHESETTING_RETURN(this, hrc, 9 /*unhandled exception*/, aControllerType, *aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aEnabled=%RTbool hrc=%Rhrc\n", this, "SystemProperties::getDefaultIoCacheSettingForStorageController", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::GetCPUProfiles(CPUArchitecture_T aArchitecture,
                                                  IN_BSTR aNamePattern,
                                                  ComSafeArrayOut(ICPUProfile *, aProfiles))
{
    LogRelFlow(("{%p} %s: enter aArchitecture=%RU32 aNamePattern=%ls aProfiles=%p\n", this, "SystemProperties::getCPUProfiles", aArchitecture, aNamePattern, aProfiles));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProfiles);


        
        BSTRInConverter TmpNamePattern(aNamePattern);
        ArrayComTypeOutConverter<ICPUProfile> TmpProfiles(ComSafeArrayOutArg(aProfiles));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETCPUPROFILES_ENTER(this, aArchitecture, TmpNamePattern.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCPUProfiles(aArchitecture,
                                 TmpNamePattern.str(),
                                 TmpProfiles.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETCPUPROFILES_RETURN(this, hrc, 0 /*normal*/, aArchitecture, TmpNamePattern.str().c_str(), (uint32_t)TmpProfiles.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETCPUPROFILES_RETURN(this, hrc, 1 /*hrc exception*/, aArchitecture, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETCPUPROFILES_RETURN(this, hrc, 9 /*unhandled exception*/, aArchitecture, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProfiles=%zu hrc=%Rhrc\n", this, "SystemProperties::getCPUProfiles", ComSafeArraySize(*aProfiles), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::GetExecutionEnginesForVmCpuArchitecture(CPUArchitecture_T aCpuArchitecture,
                                                                           ComSafeArrayOut(VMExecutionEngine_T, aExecutionEngine))
{
    LogRelFlow(("{%p} %s: enter aCpuArchitecture=%RU32 aExecutionEngine=%p\n", this, "SystemProperties::getExecutionEnginesForVmCpuArchitecture", aCpuArchitecture, aExecutionEngine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExecutionEngine);


        
        ArrayOutConverter<VMExecutionEngine_T> TmpExecutionEngine(ComSafeArrayOutArg(aExecutionEngine));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETEXECUTIONENGINESFORVMCPUARCHITECTURE_ENTER(this, aCpuArchitecture);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExecutionEnginesForVmCpuArchitecture(aCpuArchitecture,
                                                          TmpExecutionEngine.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETEXECUTIONENGINESFORVMCPUARCHITECTURE_RETURN(this, hrc, 0 /*normal*/, aCpuArchitecture, (uint32_t)TmpExecutionEngine.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETEXECUTIONENGINESFORVMCPUARCHITECTURE_RETURN(this, hrc, 1 /*hrc exception*/, aCpuArchitecture, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_SYSTEMPROPERTIES_GETEXECUTIONENGINESFORVMCPUARCHITECTURE_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuArchitecture, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExecutionEngine=%zu hrc=%Rhrc\n", this, "SystemProperties::getExecutionEnginesForVmCpuArchitecture", ComSafeArraySize(*aExecutionEngine), hrc));
    return hrc;
}

STDMETHODIMP SystemPropertiesWrap::InternalAndReservedMethod1ISystemProperties()
{
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::InternalAndReservedMethod2ISystemProperties()
{
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::InternalAndReservedMethod3ISystemProperties()
{
    return E_NOTIMPL;
}

STDMETHODIMP SystemPropertiesWrap::InternalAndReservedMethod4ISystemProperties()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(SystemPropertiesWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(SystemPropertiesWrap, ISystemProperties)
#endif // VBOX_WITH_XPCOM
