/** @file
 * VirtualBox API class wrapper code for IStorageController.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_STORAGECONTROLLER

#include "StorageControllerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(StorageControllerWrap)

//
// IStorageController properties
//

STDMETHODIMP StorageControllerWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "StorageController::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "StorageController::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "StorageController::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "StorageController::setName", hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(MaxDevicesPerPortCount)(ULONG *aMaxDevicesPerPortCount)
{
    LogRelFlow(("{%p} %s: enter aMaxDevicesPerPortCount=%p\n", this, "StorageController::getMaxDevicesPerPortCount", aMaxDevicesPerPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxDevicesPerPortCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXDEVICESPERPORTCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxDevicesPerPortCount(aMaxDevicesPerPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXDEVICESPERPORTCOUNT_RETURN(this, hrc, 0 /*normal*/,*aMaxDevicesPerPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXDEVICESPERPORTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxDevicesPerPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXDEVICESPERPORTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxDevicesPerPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxDevicesPerPortCount=%RU32 hrc=%Rhrc\n", this, "StorageController::getMaxDevicesPerPortCount", *aMaxDevicesPerPortCount, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(MinPortCount)(ULONG *aMinPortCount)
{
    LogRelFlow(("{%p} %s: enter aMinPortCount=%p\n", this, "StorageController::getMinPortCount", aMinPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinPortCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MINPORTCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinPortCount(aMinPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MINPORTCOUNT_RETURN(this, hrc, 0 /*normal*/,*aMinPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MINPORTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aMinPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MINPORTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinPortCount=%RU32 hrc=%Rhrc\n", this, "StorageController::getMinPortCount", *aMinPortCount, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(MaxPortCount)(ULONG *aMaxPortCount)
{
    LogRelFlow(("{%p} %s: enter aMaxPortCount=%p\n", this, "StorageController::getMaxPortCount", aMaxPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxPortCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXPORTCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxPortCount(aMaxPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXPORTCOUNT_RETURN(this, hrc, 0 /*normal*/,*aMaxPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXPORTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_MAXPORTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxPortCount=%RU32 hrc=%Rhrc\n", this, "StorageController::getMaxPortCount", *aMaxPortCount, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(Instance)(ULONG *aInstance)
{
    LogRelFlow(("{%p} %s: enter aInstance=%p\n", this, "StorageController::getInstance", aInstance));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInstance);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_INSTANCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInstance(aInstance);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_INSTANCE_RETURN(this, hrc, 0 /*normal*/,*aInstance);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_INSTANCE_RETURN(this, hrc, 1 /*hrc exception*/,*aInstance);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_INSTANCE_RETURN(this, hrc, 9 /*unhandled exception*/,*aInstance);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInstance=%RU32 hrc=%Rhrc\n", this, "StorageController::getInstance", *aInstance, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMSETTER(Instance)(ULONG aInstance)
{
    LogRelFlow(("{%p} %s: enter aInstance=%RU32\n", this, "StorageController::setInstance", aInstance));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_INSTANCE_ENTER(this, aInstance);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setInstance(aInstance);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_INSTANCE_RETURN(this, hrc, 0 /*normal*/,aInstance);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_INSTANCE_RETURN(this, hrc, 1 /*hrc exception*/,aInstance);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_INSTANCE_RETURN(this, hrc, 9 /*unhandled exception*/,aInstance);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "StorageController::setInstance", hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(PortCount)(ULONG *aPortCount)
{
    LogRelFlow(("{%p} %s: enter aPortCount=%p\n", this, "StorageController::getPortCount", aPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPortCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_PORTCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPortCount(aPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_PORTCOUNT_RETURN(this, hrc, 0 /*normal*/,*aPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_PORTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_PORTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPortCount=%RU32 hrc=%Rhrc\n", this, "StorageController::getPortCount", *aPortCount, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMSETTER(PortCount)(ULONG aPortCount)
{
    LogRelFlow(("{%p} %s: enter aPortCount=%RU32\n", this, "StorageController::setPortCount", aPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_PORTCOUNT_ENTER(this, aPortCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setPortCount(aPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_PORTCOUNT_RETURN(this, hrc, 0 /*normal*/,aPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_PORTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,aPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_PORTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,aPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "StorageController::setPortCount", hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(Bus)(StorageBus_T *aBus)
{
    LogRelFlow(("{%p} %s: enter aBus=%p\n", this, "StorageController::getBus", aBus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBus(aBus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BUS_RETURN(this, hrc, 0 /*normal*/,*aBus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BUS_RETURN(this, hrc, 1 /*hrc exception*/,*aBus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aBus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBus=%RU32 hrc=%Rhrc\n", this, "StorageController::getBus", *aBus, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(ControllerType)(StorageControllerType_T *aControllerType)
{
    LogRelFlow(("{%p} %s: enter aControllerType=%p\n", this, "StorageController::getControllerType", aControllerType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aControllerType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_CONTROLLERTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getControllerType(aControllerType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_CONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/,*aControllerType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_CONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aControllerType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_CONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aControllerType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aControllerType=%RU32 hrc=%Rhrc\n", this, "StorageController::getControllerType", *aControllerType, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMSETTER(ControllerType)(StorageControllerType_T aControllerType)
{
    LogRelFlow(("{%p} %s: enter aControllerType=%RU32\n", this, "StorageController::setControllerType", aControllerType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_CONTROLLERTYPE_ENTER(this, aControllerType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setControllerType(aControllerType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_CONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/,aControllerType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_CONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aControllerType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_CONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aControllerType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "StorageController::setControllerType", hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(UseHostIOCache)(BOOL *aUseHostIOCache)
{
    LogRelFlow(("{%p} %s: enter aUseHostIOCache=%p\n", this, "StorageController::getUseHostIOCache", aUseHostIOCache));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUseHostIOCache);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_USEHOSTIOCACHE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUseHostIOCache(aUseHostIOCache);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_USEHOSTIOCACHE_RETURN(this, hrc, 0 /*normal*/,*aUseHostIOCache != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_USEHOSTIOCACHE_RETURN(this, hrc, 1 /*hrc exception*/,*aUseHostIOCache != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_USEHOSTIOCACHE_RETURN(this, hrc, 9 /*unhandled exception*/,*aUseHostIOCache != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUseHostIOCache=%RTbool hrc=%Rhrc\n", this, "StorageController::getUseHostIOCache", *aUseHostIOCache, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMSETTER(UseHostIOCache)(BOOL aUseHostIOCache)
{
    LogRelFlow(("{%p} %s: enter aUseHostIOCache=%RTbool\n", this, "StorageController::setUseHostIOCache", aUseHostIOCache));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_USEHOSTIOCACHE_ENTER(this, aUseHostIOCache != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setUseHostIOCache(aUseHostIOCache != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_USEHOSTIOCACHE_RETURN(this, hrc, 0 /*normal*/,aUseHostIOCache != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_USEHOSTIOCACHE_RETURN(this, hrc, 1 /*hrc exception*/,aUseHostIOCache != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_SET_USEHOSTIOCACHE_RETURN(this, hrc, 9 /*unhandled exception*/,aUseHostIOCache != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "StorageController::setUseHostIOCache", hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(Bootable)(BOOL *aBootable)
{
    LogRelFlow(("{%p} %s: enter aBootable=%p\n", this, "StorageController::getBootable", aBootable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBootable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BOOTABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBootable(aBootable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BOOTABLE_RETURN(this, hrc, 0 /*normal*/,*aBootable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BOOTABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aBootable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_STORAGECONTROLLER_GET_BOOTABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aBootable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBootable=%RTbool hrc=%Rhrc\n", this, "StorageController::getBootable", *aBootable, hrc));
    return hrc;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute1IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute2IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute3IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute4IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute5IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute6IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute7IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::COMGETTER(InternalAndReservedAttribute8IStorageController)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IStorageController methods
//

STDMETHODIMP StorageControllerWrap::InternalAndReservedMethod1IStorageController()
{
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::InternalAndReservedMethod2IStorageController()
{
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::InternalAndReservedMethod3IStorageController()
{
    return E_NOTIMPL;
}

STDMETHODIMP StorageControllerWrap::InternalAndReservedMethod4IStorageController()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(StorageControllerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(StorageControllerWrap, IStorageController)
#endif // VBOX_WITH_XPCOM
