/** @file
 * VirtualBox API class wrapper code for IGuestSession.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTSESSION

#include "GuestSessionWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestSessionWrap)

//
// IGuestSession properties
//

STDMETHODIMP GuestSessionWrap::COMGETTER(User)(BSTR *aUser)
{
    LogRelFlow(("{%p} %s: enter aUser=%p\n", this, "GuestSession::getUser", aUser));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUser);
        BSTROutConverter TmpUser(aUser);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUser(TmpUser.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USER_RETURN(this, hrc, 0 /*normal*/,TmpUser.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUser=%ls hrc=%Rhrc\n", this, "GuestSession::getUser", *aUser, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Domain)(BSTR *aDomain)
{
    LogRelFlow(("{%p} %s: enter aDomain=%p\n", this, "GuestSession::getDomain", aDomain));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDomain);
        BSTROutConverter TmpDomain(aDomain);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DOMAIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDomain(TmpDomain.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DOMAIN_RETURN(this, hrc, 0 /*normal*/,TmpDomain.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DOMAIN_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DOMAIN_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDomain=%ls hrc=%Rhrc\n", this, "GuestSession::getDomain", *aDomain, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "GuestSession::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "GuestSession::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Id)(ULONG *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "GuestSession::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(aId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ID_RETURN(this, hrc, 0 /*normal*/,*aId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,*aId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,*aId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%RU32 hrc=%Rhrc\n", this, "GuestSession::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Timeout)(ULONG *aTimeout)
{
    LogRelFlow(("{%p} %s: enter aTimeout=%p\n", this, "GuestSession::getTimeout", aTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTimeout);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_TIMEOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTimeout(aTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_TIMEOUT_RETURN(this, hrc, 0 /*normal*/,*aTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_TIMEOUT_RETURN(this, hrc, 1 /*hrc exception*/,*aTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_TIMEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,*aTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTimeout=%RU32 hrc=%Rhrc\n", this, "GuestSession::getTimeout", *aTimeout, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMSETTER(Timeout)(ULONG aTimeout)
{
    LogRelFlow(("{%p} %s: enter aTimeout=%RU32\n", this, "GuestSession::setTimeout", aTimeout));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_TIMEOUT_ENTER(this, aTimeout);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTimeout(aTimeout);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_TIMEOUT_RETURN(this, hrc, 0 /*normal*/,aTimeout);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_TIMEOUT_RETURN(this, hrc, 1 /*hrc exception*/,aTimeout);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_TIMEOUT_RETURN(this, hrc, 9 /*unhandled exception*/,aTimeout);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::setTimeout", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(ProtocolVersion)(ULONG *aProtocolVersion)
{
    LogRelFlow(("{%p} %s: enter aProtocolVersion=%p\n", this, "GuestSession::getProtocolVersion", aProtocolVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProtocolVersion);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROTOCOLVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProtocolVersion(aProtocolVersion);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROTOCOLVERSION_RETURN(this, hrc, 0 /*normal*/,*aProtocolVersion);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROTOCOLVERSION_RETURN(this, hrc, 1 /*hrc exception*/,*aProtocolVersion);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROTOCOLVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,*aProtocolVersion);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProtocolVersion=%RU32 hrc=%Rhrc\n", this, "GuestSession::getProtocolVersion", *aProtocolVersion, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Status)(GuestSessionStatus_T *aStatus)
{
    LogRelFlow(("{%p} %s: enter aStatus=%p\n", this, "GuestSession::getStatus", aStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStatus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_STATUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStatus(aStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_STATUS_RETURN(this, hrc, 0 /*normal*/,*aStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_STATUS_RETURN(this, hrc, 1 /*hrc exception*/,*aStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_STATUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStatus=%RU32 hrc=%Rhrc\n", this, "GuestSession::getStatus", *aStatus, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(EnvironmentChanges)(ComSafeArrayOut(BSTR, aEnvironmentChanges))
{
    LogRelFlow(("{%p} %s: enter aEnvironmentChanges=%p\n", this, "GuestSession::getEnvironmentChanges", aEnvironmentChanges));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnvironmentChanges);
        ArrayBSTROutConverter TmpEnvironmentChanges(ComSafeArrayOutArg(aEnvironmentChanges));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTCHANGES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnvironmentChanges(TmpEnvironmentChanges.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTCHANGES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTCHANGES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTCHANGES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnvironmentChanges=%zu hrc=%Rhrc\n", this, "GuestSession::getEnvironmentChanges", ComSafeArraySize(*aEnvironmentChanges), hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMSETTER(EnvironmentChanges)(ComSafeArrayIn(IN_BSTR, aEnvironmentChanges))
{
    LogRelFlow(("{%p} %s: enter aEnvironmentChanges=%zu\n", this, "GuestSession::setEnvironmentChanges", ComSafeArraySize(aEnvironmentChanges)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayBSTRInConverter TmpEnvironmentChanges(ComSafeArrayInArg(aEnvironmentChanges));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_ENVIRONMENTCHANGES_ENTER(this, (uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnvironmentChanges(TmpEnvironmentChanges.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_ENVIRONMENTCHANGES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_ENVIRONMENTCHANGES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_ENVIRONMENTCHANGES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::setEnvironmentChanges", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(EnvironmentBase)(ComSafeArrayOut(BSTR, aEnvironmentBase))
{
    LogRelFlow(("{%p} %s: enter aEnvironmentBase=%p\n", this, "GuestSession::getEnvironmentBase", aEnvironmentBase));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnvironmentBase);
        ArrayBSTROutConverter TmpEnvironmentBase(ComSafeArrayOutArg(aEnvironmentBase));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTBASE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnvironmentBase(TmpEnvironmentBase.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTBASE_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpEnvironmentBase.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTBASE_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_ENVIRONMENTBASE_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnvironmentBase=%zu hrc=%Rhrc\n", this, "GuestSession::getEnvironmentBase", ComSafeArraySize(*aEnvironmentBase), hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Processes)(ComSafeArrayOut(IGuestProcess *, aProcesses))
{
    LogRelFlow(("{%p} %s: enter aProcesses=%p\n", this, "GuestSession::getProcesses", aProcesses));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProcesses);
        ArrayComTypeOutConverter<IGuestProcess> TmpProcesses(ComSafeArrayOutArg(aProcesses));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROCESSES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcesses(TmpProcesses.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROCESSES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpProcesses.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROCESSES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PROCESSES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProcesses=%zu hrc=%Rhrc\n", this, "GuestSession::getProcesses", ComSafeArraySize(*aProcesses), hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(PathStyle)(PathStyle_T *aPathStyle)
{
    LogRelFlow(("{%p} %s: enter aPathStyle=%p\n", this, "GuestSession::getPathStyle", aPathStyle));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPathStyle);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PATHSTYLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPathStyle(aPathStyle);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PATHSTYLE_RETURN(this, hrc, 0 /*normal*/,*aPathStyle);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PATHSTYLE_RETURN(this, hrc, 1 /*hrc exception*/,*aPathStyle);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_PATHSTYLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aPathStyle);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPathStyle=%RU32 hrc=%Rhrc\n", this, "GuestSession::getPathStyle", *aPathStyle, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(CurrentDirectory)(BSTR *aCurrentDirectory)
{
    LogRelFlow(("{%p} %s: enter aCurrentDirectory=%p\n", this, "GuestSession::getCurrentDirectory", aCurrentDirectory));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCurrentDirectory);
        BSTROutConverter TmpCurrentDirectory(aCurrentDirectory);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_CURRENTDIRECTORY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCurrentDirectory(TmpCurrentDirectory.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_CURRENTDIRECTORY_RETURN(this, hrc, 0 /*normal*/,TmpCurrentDirectory.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_CURRENTDIRECTORY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_CURRENTDIRECTORY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCurrentDirectory=%ls hrc=%Rhrc\n", this, "GuestSession::getCurrentDirectory", *aCurrentDirectory, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMSETTER(CurrentDirectory)(IN_BSTR aCurrentDirectory)
{
    LogRelFlow(("{%p} %s: enter aCurrentDirectory=%ls\n", this, "GuestSession::setCurrentDirectory", aCurrentDirectory));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpCurrentDirectory(aCurrentDirectory);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_CURRENTDIRECTORY_ENTER(this, TmpCurrentDirectory.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setCurrentDirectory(TmpCurrentDirectory.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_CURRENTDIRECTORY_RETURN(this, hrc, 0 /*normal*/,TmpCurrentDirectory.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_CURRENTDIRECTORY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SET_CURRENTDIRECTORY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::setCurrentDirectory", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(UserHome)(BSTR *aUserHome)
{
    LogRelFlow(("{%p} %s: enter aUserHome=%p\n", this, "GuestSession::getUserHome", aUserHome));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUserHome);
        BSTROutConverter TmpUserHome(aUserHome);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERHOME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUserHome(TmpUserHome.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERHOME_RETURN(this, hrc, 0 /*normal*/,TmpUserHome.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERHOME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERHOME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUserHome=%ls hrc=%Rhrc\n", this, "GuestSession::getUserHome", *aUserHome, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(UserDocuments)(BSTR *aUserDocuments)
{
    LogRelFlow(("{%p} %s: enter aUserDocuments=%p\n", this, "GuestSession::getUserDocuments", aUserDocuments));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUserDocuments);
        BSTROutConverter TmpUserDocuments(aUserDocuments);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERDOCUMENTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUserDocuments(TmpUserDocuments.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERDOCUMENTS_RETURN(this, hrc, 0 /*normal*/,TmpUserDocuments.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERDOCUMENTS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_USERDOCUMENTS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUserDocuments=%ls hrc=%Rhrc\n", this, "GuestSession::getUserDocuments", *aUserDocuments, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(MountPoints)(ComSafeArrayOut(BSTR, aMountPoints))
{
    LogRelFlow(("{%p} %s: enter aMountPoints=%p\n", this, "GuestSession::getMountPoints", aMountPoints));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMountPoints);
        ArrayBSTROutConverter TmpMountPoints(ComSafeArrayOutArg(aMountPoints));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_MOUNTPOINTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMountPoints(TmpMountPoints.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_MOUNTPOINTS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpMountPoints.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_MOUNTPOINTS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_MOUNTPOINTS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMountPoints=%zu hrc=%Rhrc\n", this, "GuestSession::getMountPoints", ComSafeArraySize(*aMountPoints), hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Directories)(ComSafeArrayOut(IGuestDirectory *, aDirectories))
{
    LogRelFlow(("{%p} %s: enter aDirectories=%p\n", this, "GuestSession::getDirectories", aDirectories));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDirectories);
        ArrayComTypeOutConverter<IGuestDirectory> TmpDirectories(ComSafeArrayOutArg(aDirectories));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DIRECTORIES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDirectories(TmpDirectories.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DIRECTORIES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDirectories.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DIRECTORIES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_DIRECTORIES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDirectories=%zu hrc=%Rhrc\n", this, "GuestSession::getDirectories", ComSafeArraySize(*aDirectories), hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(Files)(ComSafeArrayOut(IGuestFile *, aFiles))
{
    LogRelFlow(("{%p} %s: enter aFiles=%p\n", this, "GuestSession::getFiles", aFiles));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFiles);
        ArrayComTypeOutConverter<IGuestFile> TmpFiles(ComSafeArrayOutArg(aFiles));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_FILES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFiles(TmpFiles.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_FILES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFiles.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_FILES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_FILES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFiles=%zu hrc=%Rhrc\n", this, "GuestSession::getFiles", ComSafeArraySize(*aFiles), hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "GuestSession::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "GuestSession::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute1IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute2IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute3IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute4IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute5IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute6IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute7IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute8IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute9IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute10IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute11IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::COMGETTER(InternalAndReservedAttribute12IGuestSession)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IGuestSession methods
//

STDMETHODIMP GuestSessionWrap::Close()
{
    LogRelFlow(("{%p} %s: enter\n", this, "GuestSession::close"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_CLOSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = close();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_CLOSE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_CLOSE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_CLOSE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::close", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::CopyFromGuest(ComSafeArrayIn(IN_BSTR, aSources),
                                             ComSafeArrayIn(IN_BSTR, aFilters),
                                             ComSafeArrayIn(IN_BSTR, aFlags),
                                             IN_BSTR aDestination,
                                             IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSources=%zu aFilters=%zu aFlags=%zu aDestination=%ls aProgress=%p\n", this, "GuestSession::copyFromGuest", aSources, aFilters, aFlags, aDestination, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayBSTRInConverter TmpSources(ComSafeArrayInArg(aSources));
        ArrayBSTRInConverter TmpFilters(ComSafeArrayInArg(aFilters));
        ArrayBSTRInConverter TmpFlags(ComSafeArrayInArg(aFlags));
        BSTRInConverter TmpDestination(aDestination);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYFROMGUEST_ENTER(this, (uint32_t)TmpSources.array().size(), NULL /*for now*/, (uint32_t)TmpFilters.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, TmpDestination.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = copyFromGuest(TmpSources.array(),
                                TmpFilters.array(),
                                TmpFlags.array(),
                                TmpDestination.str(),
                                TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYFROMGUEST_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSources.array().size(), NULL /*for now*/, (uint32_t)TmpFilters.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, TmpDestination.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYFROMGUEST_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYFROMGUEST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::copyFromGuest", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::CopyToGuest(ComSafeArrayIn(IN_BSTR, aSources),
                                           ComSafeArrayIn(IN_BSTR, aFilters),
                                           ComSafeArrayIn(IN_BSTR, aFlags),
                                           IN_BSTR aDestination,
                                           IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSources=%zu aFilters=%zu aFlags=%zu aDestination=%ls aProgress=%p\n", this, "GuestSession::copyToGuest", aSources, aFilters, aFlags, aDestination, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayBSTRInConverter TmpSources(ComSafeArrayInArg(aSources));
        ArrayBSTRInConverter TmpFilters(ComSafeArrayInArg(aFilters));
        ArrayBSTRInConverter TmpFlags(ComSafeArrayInArg(aFlags));
        BSTRInConverter TmpDestination(aDestination);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYTOGUEST_ENTER(this, (uint32_t)TmpSources.array().size(), NULL /*for now*/, (uint32_t)TmpFilters.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, TmpDestination.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = copyToGuest(TmpSources.array(),
                              TmpFilters.array(),
                              TmpFlags.array(),
                              TmpDestination.str(),
                              TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYTOGUEST_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSources.array().size(), NULL /*for now*/, (uint32_t)TmpFilters.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, TmpDestination.str().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYTOGUEST_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_COPYTOGUEST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::copyToGuest", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryCopy(IN_BSTR aSource,
                                             IN_BSTR aDestination,
                                             ComSafeArrayIn(DirectoryCopyFlag_T, aFlags),
                                             IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%ls aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::directoryCopy", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<DirectoryCopyFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPY_ENTER(this, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryCopy(TmpSource.str(),
                                TmpDestination.str(),
                                TmpFlags.array(),
                                TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPY_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::directoryCopy", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryCopyFromGuest(IN_BSTR aSource,
                                                      IN_BSTR aDestination,
                                                      ComSafeArrayIn(DirectoryCopyFlag_T, aFlags),
                                                      IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%ls aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::directoryCopyFromGuest", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<DirectoryCopyFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYFROMGUEST_ENTER(this, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryCopyFromGuest(TmpSource.str(),
                                         TmpDestination.str(),
                                         TmpFlags.array(),
                                         TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYFROMGUEST_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYFROMGUEST_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYFROMGUEST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::directoryCopyFromGuest", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryCopyToGuest(IN_BSTR aSource,
                                                    IN_BSTR aDestination,
                                                    ComSafeArrayIn(DirectoryCopyFlag_T, aFlags),
                                                    IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%ls aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::directoryCopyToGuest", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<DirectoryCopyFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYTOGUEST_ENTER(this, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryCopyToGuest(TmpSource.str(),
                                       TmpDestination.str(),
                                       TmpFlags.array(),
                                       TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYTOGUEST_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYTOGUEST_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCOPYTOGUEST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::directoryCopyToGuest", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryCreate(IN_BSTR aPath,
                                               ULONG aMode,
                                               ComSafeArrayIn(DirectoryCreateFlag_T, aFlags))
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aMode=%RU32 aFlags=%zu\n", this, "GuestSession::directoryCreate", aPath, aMode, aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPath(aPath);
        
        ArrayInConverter<DirectoryCreateFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATE_ENTER(this, TmpPath.str().c_str(), aMode, (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryCreate(TmpPath.str(),
                                  aMode,
                                  TmpFlags.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATE_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aMode, (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aMode, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aMode, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::directoryCreate", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryCreateTemp(IN_BSTR aTemplateName,
                                                   ULONG aMode,
                                                   IN_BSTR aPath,
                                                   BOOL aSecure,
                                                   BSTR *aDirectory)
{
    LogRelFlow(("{%p} %s: enter aTemplateName=%ls aMode=%RU32 aPath=%ls aSecure=%RTbool aDirectory=%p\n", this, "GuestSession::directoryCreateTemp", aTemplateName, aMode, aPath, aSecure, aDirectory));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDirectory);


        BSTRInConverter TmpTemplateName(aTemplateName);
        
        BSTRInConverter TmpPath(aPath);
        
        BSTROutConverter TmpDirectory(aDirectory);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATETEMP_ENTER(this, TmpTemplateName.str().c_str(), aMode, TmpPath.str().c_str(), aSecure != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryCreateTemp(TmpTemplateName.str(),
                                      aMode,
                                      TmpPath.str(),
                                      aSecure != FALSE,
                                      TmpDirectory.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATETEMP_RETURN(this, hrc, 0 /*normal*/, TmpTemplateName.str().c_str(), aMode, TmpPath.str().c_str(), aSecure != FALSE, TmpDirectory.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATETEMP_RETURN(this, hrc, 1 /*hrc exception*/, 0, aMode, 0, aSecure != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYCREATETEMP_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aMode, 0, aSecure != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDirectory=%ls hrc=%Rhrc\n", this, "GuestSession::directoryCreateTemp", *aDirectory, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryExists(IN_BSTR aPath,
                                               BOOL aFollowSymlinks,
                                               BOOL *aExists)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFollowSymlinks=%RTbool aExists=%p\n", this, "GuestSession::directoryExists", aPath, aFollowSymlinks, aExists));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExists);


        BSTRInConverter TmpPath(aPath);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYEXISTS_ENTER(this, TmpPath.str().c_str(), aFollowSymlinks != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryExists(TmpPath.str(),
                                  aFollowSymlinks != FALSE,
                                  aExists);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYEXISTS_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYEXISTS_RETURN(this, hrc, 1 /*hrc exception*/, 0, aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYEXISTS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExists=%RTbool hrc=%Rhrc\n", this, "GuestSession::directoryExists", *aExists, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryOpen(IN_BSTR aPath,
                                             IN_BSTR aFilter,
                                             ComSafeArrayIn(DirectoryOpenFlag_T, aFlags),
                                             IGuestDirectory **aDirectory)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFilter=%ls aFlags=%zu aDirectory=%p\n", this, "GuestSession::directoryOpen", aPath, aFilter, aFlags, aDirectory));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDirectory);


        BSTRInConverter TmpPath(aPath);
        BSTRInConverter TmpFilter(aFilter);
        ArrayInConverter<DirectoryOpenFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IGuestDirectory> TmpDirectory(aDirectory);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYOPEN_ENTER(this, TmpPath.str().c_str(), TmpFilter.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryOpen(TmpPath.str(),
                                TmpFilter.str(),
                                TmpFlags.array(),
                                TmpDirectory.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYOPEN_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), TmpFilter.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpDirectory.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYOPEN_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYOPEN_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDirectory=%p hrc=%Rhrc\n", this, "GuestSession::directoryOpen", *aDirectory, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryRemove(IN_BSTR aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls\n", this, "GuestSession::directoryRemove", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPath(aPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVE_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryRemove(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVE_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::directoryRemove", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::DirectoryRemoveRecursive(IN_BSTR aPath,
                                                        ComSafeArrayIn(DirectoryRemoveRecFlag_T, aFlags),
                                                        IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::directoryRemoveRecursive", aPath, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpPath(aPath);
        ArrayInConverter<DirectoryRemoveRecFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVERECURSIVE_ENTER(this, TmpPath.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = directoryRemoveRecursive(TmpPath.str(),
                                           TmpFlags.array(),
                                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVERECURSIVE_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVERECURSIVE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_DIRECTORYREMOVERECURSIVE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::directoryRemoveRecursive", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::EnvironmentScheduleSet(IN_BSTR aName,
                                                      IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aValue=%ls\n", this, "GuestSession::environmentScheduleSet", aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULESET_ENTER(this, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = environmentScheduleSet(TmpName.str(),
                                         TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULESET_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULESET_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULESET_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::environmentScheduleSet", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::EnvironmentScheduleUnset(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "GuestSession::environmentScheduleUnset", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULEUNSET_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = environmentScheduleUnset(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULEUNSET_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULEUNSET_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTSCHEDULEUNSET_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::environmentScheduleUnset", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::EnvironmentGetBaseVariable(IN_BSTR aName,
                                                          BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aValue=%p\n", this, "GuestSession::environmentGetBaseVariable", aName, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpName(aName);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTGETBASEVARIABLE_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = environmentGetBaseVariable(TmpName.str(),
                                             TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTGETBASEVARIABLE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTGETBASEVARIABLE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTGETBASEVARIABLE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "GuestSession::environmentGetBaseVariable", *aValue, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::EnvironmentDoesBaseVariableExist(IN_BSTR aName,
                                                                BOOL *aExists)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aExists=%p\n", this, "GuestSession::environmentDoesBaseVariableExist", aName, aExists));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExists);


        BSTRInConverter TmpName(aName);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTDOESBASEVARIABLEEXIST_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = environmentDoesBaseVariableExist(TmpName.str(),
                                                   aExists);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTDOESBASEVARIABLEEXIST_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), *aExists != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTDOESBASEVARIABLEEXIST_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aExists != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_ENVIRONMENTDOESBASEVARIABLEEXIST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aExists != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExists=%RTbool hrc=%Rhrc\n", this, "GuestSession::environmentDoesBaseVariableExist", *aExists, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileCopy(IN_BSTR aSource,
                                        IN_BSTR aDestination,
                                        ComSafeArrayIn(FileCopyFlag_T, aFlags),
                                        IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%ls aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::fileCopy", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<FileCopyFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPY_ENTER(this, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileCopy(TmpSource.str(),
                           TmpDestination.str(),
                           TmpFlags.array(),
                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPY_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::fileCopy", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileCopyFromGuest(IN_BSTR aSource,
                                                 IN_BSTR aDestination,
                                                 ComSafeArrayIn(FileCopyFlag_T, aFlags),
                                                 IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%ls aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::fileCopyFromGuest", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<FileCopyFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYFROMGUEST_ENTER(this, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileCopyFromGuest(TmpSource.str(),
                                    TmpDestination.str(),
                                    TmpFlags.array(),
                                    TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYFROMGUEST_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYFROMGUEST_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYFROMGUEST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::fileCopyFromGuest", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileCopyToGuest(IN_BSTR aSource,
                                               IN_BSTR aDestination,
                                               ComSafeArrayIn(FileCopyFlag_T, aFlags),
                                               IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%ls aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::fileCopyToGuest", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<FileCopyFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYTOGUEST_ENTER(this, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileCopyToGuest(TmpSource.str(),
                                  TmpDestination.str(),
                                  TmpFlags.array(),
                                  TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYTOGUEST_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYTOGUEST_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECOPYTOGUEST_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::fileCopyToGuest", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileCreateTemp(IN_BSTR aTemplateName,
                                              ULONG aMode,
                                              IN_BSTR aPath,
                                              BOOL aSecure,
                                              IGuestFile **aFile)
{
    LogRelFlow(("{%p} %s: enter aTemplateName=%ls aMode=%RU32 aPath=%ls aSecure=%RTbool aFile=%p\n", this, "GuestSession::fileCreateTemp", aTemplateName, aMode, aPath, aSecure, aFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFile);


        BSTRInConverter TmpTemplateName(aTemplateName);
        
        BSTRInConverter TmpPath(aPath);
        
        ComTypeOutConverter<IGuestFile> TmpFile(aFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECREATETEMP_ENTER(this, TmpTemplateName.str().c_str(), aMode, TmpPath.str().c_str(), aSecure != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileCreateTemp(TmpTemplateName.str(),
                                 aMode,
                                 TmpPath.str(),
                                 aSecure != FALSE,
                                 TmpFile.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECREATETEMP_RETURN(this, hrc, 0 /*normal*/, TmpTemplateName.str().c_str(), aMode, TmpPath.str().c_str(), aSecure != FALSE, (void *)TmpFile.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECREATETEMP_RETURN(this, hrc, 1 /*hrc exception*/, 0, aMode, 0, aSecure != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILECREATETEMP_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aMode, 0, aSecure != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFile=%p hrc=%Rhrc\n", this, "GuestSession::fileCreateTemp", *aFile, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileExists(IN_BSTR aPath,
                                          BOOL aFollowSymlinks,
                                          BOOL *aExists)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFollowSymlinks=%RTbool aExists=%p\n", this, "GuestSession::fileExists", aPath, aFollowSymlinks, aExists));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExists);


        BSTRInConverter TmpPath(aPath);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEEXISTS_ENTER(this, TmpPath.str().c_str(), aFollowSymlinks != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileExists(TmpPath.str(),
                             aFollowSymlinks != FALSE,
                             aExists);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEEXISTS_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEEXISTS_RETURN(this, hrc, 1 /*hrc exception*/, 0, aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEEXISTS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExists=%RTbool hrc=%Rhrc\n", this, "GuestSession::fileExists", *aExists, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileOpen(IN_BSTR aPath,
                                        FileAccessMode_T aAccessMode,
                                        FileOpenAction_T aOpenAction,
                                        ULONG aCreationMode,
                                        IGuestFile **aFile)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aAccessMode=%RU32 aOpenAction=%RU32 aCreationMode=%RU32 aFile=%p\n", this, "GuestSession::fileOpen", aPath, aAccessMode, aOpenAction, aCreationMode, aFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFile);


        BSTRInConverter TmpPath(aPath);
        
        
        
        ComTypeOutConverter<IGuestFile> TmpFile(aFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPEN_ENTER(this, TmpPath.str().c_str(), aAccessMode, aOpenAction, aCreationMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileOpen(TmpPath.str(),
                           aAccessMode,
                           aOpenAction,
                           aCreationMode,
                           TmpFile.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPEN_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aAccessMode, aOpenAction, aCreationMode, (void *)TmpFile.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPEN_RETURN(this, hrc, 1 /*hrc exception*/, 0, aAccessMode, aOpenAction, aCreationMode, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPEN_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aAccessMode, aOpenAction, aCreationMode, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFile=%p hrc=%Rhrc\n", this, "GuestSession::fileOpen", *aFile, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileOpenEx(IN_BSTR aPath,
                                          FileAccessMode_T aAccessMode,
                                          FileOpenAction_T aOpenAction,
                                          FileSharingMode_T aSharingMode,
                                          ULONG aCreationMode,
                                          ComSafeArrayIn(FileOpenExFlag_T, aFlags),
                                          IGuestFile **aFile)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aAccessMode=%RU32 aOpenAction=%RU32 aSharingMode=%RU32 aCreationMode=%RU32 aFlags=%zu aFile=%p\n", this, "GuestSession::fileOpenEx", aPath, aAccessMode, aOpenAction, aSharingMode, aCreationMode, aFlags, aFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFile);


        BSTRInConverter TmpPath(aPath);
        
        
        
        
        ArrayInConverter<FileOpenExFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IGuestFile> TmpFile(aFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPENEX_ENTER(this, TmpPath.str().c_str(), aAccessMode, aOpenAction, aSharingMode, aCreationMode, (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileOpenEx(TmpPath.str(),
                             aAccessMode,
                             aOpenAction,
                             aSharingMode,
                             aCreationMode,
                             TmpFlags.array(),
                             TmpFile.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPENEX_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aAccessMode, aOpenAction, aSharingMode, aCreationMode, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpFile.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPENEX_RETURN(this, hrc, 1 /*hrc exception*/, 0, aAccessMode, aOpenAction, aSharingMode, aCreationMode, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEOPENEX_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aAccessMode, aOpenAction, aSharingMode, aCreationMode, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFile=%p hrc=%Rhrc\n", this, "GuestSession::fileOpenEx", *aFile, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FileQuerySize(IN_BSTR aPath,
                                             BOOL aFollowSymlinks,
                                             LONG64 *aSize)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFollowSymlinks=%RTbool aSize=%p\n", this, "GuestSession::fileQuerySize", aPath, aFollowSymlinks, aSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSize);


        BSTRInConverter TmpPath(aPath);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEQUERYSIZE_ENTER(this, TmpPath.str().c_str(), aFollowSymlinks != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fileQuerySize(TmpPath.str(),
                                aFollowSymlinks != FALSE,
                                aSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEQUERYSIZE_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aFollowSymlinks != FALSE, *aSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEQUERYSIZE_RETURN(this, hrc, 1 /*hrc exception*/, 0, aFollowSymlinks != FALSE, *aSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FILEQUERYSIZE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aFollowSymlinks != FALSE, *aSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSize=%RI64 hrc=%Rhrc\n", this, "GuestSession::fileQuerySize", *aSize, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjExists(IN_BSTR aPath,
                                           BOOL aFollowSymlinks,
                                           BOOL *aExists)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFollowSymlinks=%RTbool aExists=%p\n", this, "GuestSession::fsObjExists", aPath, aFollowSymlinks, aExists));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExists);


        BSTRInConverter TmpPath(aPath);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJEXISTS_ENTER(this, TmpPath.str().c_str(), aFollowSymlinks != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjExists(TmpPath.str(),
                              aFollowSymlinks != FALSE,
                              aExists);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJEXISTS_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJEXISTS_RETURN(this, hrc, 1 /*hrc exception*/, 0, aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJEXISTS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aFollowSymlinks != FALSE, *aExists != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExists=%RTbool hrc=%Rhrc\n", this, "GuestSession::fsObjExists", *aExists, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjQueryInfo(IN_BSTR aPath,
                                              BOOL aFollowSymlinks,
                                              IGuestFsObjInfo **aInfo)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFollowSymlinks=%RTbool aInfo=%p\n", this, "GuestSession::fsObjQueryInfo", aPath, aFollowSymlinks, aInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInfo);


        BSTRInConverter TmpPath(aPath);
        
        ComTypeOutConverter<IGuestFsObjInfo> TmpInfo(aInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJQUERYINFO_ENTER(this, TmpPath.str().c_str(), aFollowSymlinks != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjQueryInfo(TmpPath.str(),
                                 aFollowSymlinks != FALSE,
                                 TmpInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJQUERYINFO_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aFollowSymlinks != FALSE, (void *)TmpInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJQUERYINFO_RETURN(this, hrc, 1 /*hrc exception*/, 0, aFollowSymlinks != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJQUERYINFO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aFollowSymlinks != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aInfo=%p hrc=%Rhrc\n", this, "GuestSession::fsObjQueryInfo", *aInfo, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjRemove(IN_BSTR aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls\n", this, "GuestSession::fsObjRemove", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPath(aPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVE_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjRemove(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVE_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::fsObjRemove", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjRemoveArray(ComSafeArrayIn(IN_BSTR, aPath),
                                                IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aPath=%zu aProgress=%p\n", this, "GuestSession::fsObjRemoveArray", aPath, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayBSTRInConverter TmpPath(ComSafeArrayInArg(aPath));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVEARRAY_ENTER(this, (uint32_t)TmpPath.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjRemoveArray(TmpPath.array(),
                                   TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVEARRAY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpPath.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVEARRAY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJREMOVEARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::fsObjRemoveArray", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjRename(IN_BSTR aOldPath,
                                           IN_BSTR aNewPath,
                                           ComSafeArrayIn(FsObjRenameFlag_T, aFlags))
{
    LogRelFlow(("{%p} %s: enter aOldPath=%ls aNewPath=%ls aFlags=%zu\n", this, "GuestSession::fsObjRename", aOldPath, aNewPath, aFlags));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpOldPath(aOldPath);
        BSTRInConverter TmpNewPath(aNewPath);
        ArrayInConverter<FsObjRenameFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJRENAME_ENTER(this, TmpOldPath.str().c_str(), TmpNewPath.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjRename(TmpOldPath.str(),
                              TmpNewPath.str(),
                              TmpFlags.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJRENAME_RETURN(this, hrc, 0 /*normal*/, TmpOldPath.str().c_str(), TmpNewPath.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJRENAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJRENAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::fsObjRename", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjMove(IN_BSTR aSource,
                                         IN_BSTR aDestination,
                                         ComSafeArrayIn(FsObjMoveFlag_T, aFlags),
                                         IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%ls aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::fsObjMove", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpSource(aSource);
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<FsObjMoveFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVE_ENTER(this, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjMove(TmpSource.str(),
                            TmpDestination.str(),
                            TmpFlags.array(),
                            TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVE_RETURN(this, hrc, 0 /*normal*/, TmpSource.str().c_str(), TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::fsObjMove", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjMoveArray(ComSafeArrayIn(IN_BSTR, aSource),
                                              IN_BSTR aDestination,
                                              ComSafeArrayIn(FsObjMoveFlag_T, aFlags),
                                              IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%zu aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::fsObjMoveArray", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayBSTRInConverter TmpSource(ComSafeArrayInArg(aSource));
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<FsObjMoveFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVEARRAY_ENTER(this, (uint32_t)TmpSource.array().size(), NULL /*for now*/, TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjMoveArray(TmpSource.array(),
                                 TmpDestination.str(),
                                 TmpFlags.array(),
                                 TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVEARRAY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSource.array().size(), NULL /*for now*/, TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVEARRAY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJMOVEARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::fsObjMoveArray", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjCopyArray(ComSafeArrayIn(IN_BSTR, aSource),
                                              IN_BSTR aDestination,
                                              ComSafeArrayIn(FileCopyFlag_T, aFlags),
                                              IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aSource=%zu aDestination=%ls aFlags=%zu aProgress=%p\n", this, "GuestSession::fsObjCopyArray", aSource, aDestination, aFlags, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ArrayBSTRInConverter TmpSource(ComSafeArrayInArg(aSource));
        BSTRInConverter TmpDestination(aDestination);
        ArrayInConverter<FileCopyFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJCOPYARRAY_ENTER(this, (uint32_t)TmpSource.array().size(), NULL /*for now*/, TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjCopyArray(TmpSource.array(),
                                 TmpDestination.str(),
                                 TmpFlags.array(),
                                 TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJCOPYARRAY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpSource.array().size(), NULL /*for now*/, TmpDestination.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJCOPYARRAY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJCOPYARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "GuestSession::fsObjCopyArray", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsObjSetACL(IN_BSTR aPath,
                                           BOOL aFollowSymlinks,
                                           IN_BSTR aAcl,
                                           ULONG aMode)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFollowSymlinks=%RTbool aAcl=%ls aMode=%RU32\n", this, "GuestSession::fsObjSetACL", aPath, aFollowSymlinks, aAcl, aMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPath(aPath);
        
        BSTRInConverter TmpAcl(aAcl);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJSETACL_ENTER(this, TmpPath.str().c_str(), aFollowSymlinks != FALSE, TmpAcl.str().c_str(), aMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsObjSetACL(TmpPath.str(),
                              aFollowSymlinks != FALSE,
                              TmpAcl.str(),
                              aMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJSETACL_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), aFollowSymlinks != FALSE, TmpAcl.str().c_str(), aMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJSETACL_RETURN(this, hrc, 1 /*hrc exception*/, 0, aFollowSymlinks != FALSE, 0, aMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSOBJSETACL_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aFollowSymlinks != FALSE, 0, aMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::fsObjSetACL", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsQueryFreeSpace(IN_BSTR aPath,
                                                LONG64 *aFreeSpace)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aFreeSpace=%p\n", this, "GuestSession::fsQueryFreeSpace", aPath, aFreeSpace));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFreeSpace);


        BSTRInConverter TmpPath(aPath);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYFREESPACE_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsQueryFreeSpace(TmpPath.str(),
                                   aFreeSpace);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYFREESPACE_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), *aFreeSpace);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYFREESPACE_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aFreeSpace);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYFREESPACE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aFreeSpace);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFreeSpace=%RI64 hrc=%Rhrc\n", this, "GuestSession::fsQueryFreeSpace", *aFreeSpace, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::FsQueryInfo(IN_BSTR aPath,
                                           IGuestFsInfo **aInfo)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aInfo=%p\n", this, "GuestSession::fsQueryInfo", aPath, aInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInfo);


        BSTRInConverter TmpPath(aPath);
        ComTypeOutConverter<IGuestFsInfo> TmpInfo(aInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYINFO_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = fsQueryInfo(TmpPath.str(),
                              TmpInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYINFO_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), (void *)TmpInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYINFO_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_FSQUERYINFO_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aInfo=%p hrc=%Rhrc\n", this, "GuestSession::fsQueryInfo", *aInfo, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::ProcessCreate(IN_BSTR aExecutable,
                                             ComSafeArrayIn(IN_BSTR, aArguments),
                                             IN_BSTR aCwd,
                                             ComSafeArrayIn(IN_BSTR, aEnvironmentChanges),
                                             ComSafeArrayIn(ProcessCreateFlag_T, aFlags),
                                             ULONG aTimeoutMS,
                                             IGuestProcess **aGuestProcess)
{
    LogRelFlow(("{%p} %s: enter aExecutable=%ls aArguments=%zu aCwd=%ls aEnvironmentChanges=%zu aFlags=%zu aTimeoutMS=%RU32 aGuestProcess=%p\n", this, "GuestSession::processCreate", aExecutable, aArguments, aCwd, aEnvironmentChanges, aFlags, aTimeoutMS, aGuestProcess));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestProcess);


        BSTRInConverter TmpExecutable(aExecutable);
        ArrayBSTRInConverter TmpArguments(ComSafeArrayInArg(aArguments));
        BSTRInConverter TmpCwd(aCwd);
        ArrayBSTRInConverter TmpEnvironmentChanges(ComSafeArrayInArg(aEnvironmentChanges));
        ArrayInConverter<ProcessCreateFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        
        ComTypeOutConverter<IGuestProcess> TmpGuestProcess(aGuestProcess);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATE_ENTER(this, TmpExecutable.str().c_str(), (uint32_t)TmpArguments.array().size(), NULL /*for now*/, TmpCwd.str().c_str(), (uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = processCreate(TmpExecutable.str(),
                                TmpArguments.array(),
                                TmpCwd.str(),
                                TmpEnvironmentChanges.array(),
                                TmpFlags.array(),
                                aTimeoutMS,
                                TmpGuestProcess.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATE_RETURN(this, hrc, 0 /*normal*/, TmpExecutable.str().c_str(), (uint32_t)TmpArguments.array().size(), NULL /*for now*/, TmpCwd.str().c_str(), (uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, aTimeoutMS, (void *)TmpGuestProcess.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0, aTimeoutMS, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0, aTimeoutMS, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aGuestProcess=%p hrc=%Rhrc\n", this, "GuestSession::processCreate", *aGuestProcess, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::ProcessCreateEx(IN_BSTR aExecutable,
                                               ComSafeArrayIn(IN_BSTR, aArguments),
                                               IN_BSTR aCwd,
                                               ComSafeArrayIn(IN_BSTR, aEnvironmentChanges),
                                               ComSafeArrayIn(ProcessCreateFlag_T, aFlags),
                                               ULONG aTimeoutMS,
                                               ProcessPriority_T aPriority,
                                               ComSafeArrayIn(LONG, aAffinity),
                                               IGuestProcess **aGuestProcess)
{
    LogRelFlow(("{%p} %s: enter aExecutable=%ls aArguments=%zu aCwd=%ls aEnvironmentChanges=%zu aFlags=%zu aTimeoutMS=%RU32 aPriority=%RU32 aAffinity=%zu aGuestProcess=%p\n", this, "GuestSession::processCreateEx", aExecutable, aArguments, aCwd, aEnvironmentChanges, aFlags, aTimeoutMS, aPriority, aAffinity, aGuestProcess));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestProcess);


        BSTRInConverter TmpExecutable(aExecutable);
        ArrayBSTRInConverter TmpArguments(ComSafeArrayInArg(aArguments));
        BSTRInConverter TmpCwd(aCwd);
        ArrayBSTRInConverter TmpEnvironmentChanges(ComSafeArrayInArg(aEnvironmentChanges));
        ArrayInConverter<ProcessCreateFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        
        
        ArrayInConverter<LONG> TmpAffinity(ComSafeArrayInArg(aAffinity));
        ComTypeOutConverter<IGuestProcess> TmpGuestProcess(aGuestProcess);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATEEX_ENTER(this, TmpExecutable.str().c_str(), (uint32_t)TmpArguments.array().size(), NULL /*for now*/, TmpCwd.str().c_str(), (uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, aTimeoutMS, aPriority, (uint32_t)TmpAffinity.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = processCreateEx(TmpExecutable.str(),
                                  TmpArguments.array(),
                                  TmpCwd.str(),
                                  TmpEnvironmentChanges.array(),
                                  TmpFlags.array(),
                                  aTimeoutMS,
                                  aPriority,
                                  TmpAffinity.array(),
                                  TmpGuestProcess.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATEEX_RETURN(this, hrc, 0 /*normal*/, TmpExecutable.str().c_str(), (uint32_t)TmpArguments.array().size(), NULL /*for now*/, TmpCwd.str().c_str(), (uint32_t)TmpEnvironmentChanges.array().size(), NULL /*for now*/, (uint32_t)TmpFlags.array().size(), NULL /*for now*/, aTimeoutMS, aPriority, (uint32_t)TmpAffinity.array().size(), NULL /*for now*/, (void *)TmpGuestProcess.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATEEX_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0, 0, aTimeoutMS, aPriority, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSCREATEEX_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0, 0, aTimeoutMS, aPriority, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aGuestProcess=%p hrc=%Rhrc\n", this, "GuestSession::processCreateEx", *aGuestProcess, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::ProcessGet(ULONG aPid,
                                          IGuestProcess **aGuestProcess)
{
    LogRelFlow(("{%p} %s: enter aPid=%RU32 aGuestProcess=%p\n", this, "GuestSession::processGet", aPid, aGuestProcess));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestProcess);


        
        ComTypeOutConverter<IGuestProcess> TmpGuestProcess(aGuestProcess);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSGET_ENTER(this, aPid);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = processGet(aPid,
                             TmpGuestProcess.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSGET_RETURN(this, hrc, 0 /*normal*/, aPid, (void *)TmpGuestProcess.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSGET_RETURN(this, hrc, 1 /*hrc exception*/, aPid, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_PROCESSGET_RETURN(this, hrc, 9 /*unhandled exception*/, aPid, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aGuestProcess=%p hrc=%Rhrc\n", this, "GuestSession::processGet", *aGuestProcess, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::SymlinkCreate(IN_BSTR aSymlink,
                                             IN_BSTR aTarget,
                                             SymlinkType_T aType)
{
    LogRelFlow(("{%p} %s: enter aSymlink=%ls aTarget=%ls aType=%RU32\n", this, "GuestSession::symlinkCreate", aSymlink, aTarget, aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpSymlink(aSymlink);
        BSTRInConverter TmpTarget(aTarget);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKCREATE_ENTER(this, TmpSymlink.str().c_str(), TmpTarget.str().c_str(), aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = symlinkCreate(TmpSymlink.str(),
                                TmpTarget.str(),
                                aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKCREATE_RETURN(this, hrc, 0 /*normal*/, TmpSymlink.str().c_str(), TmpTarget.str().c_str(), aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKCREATE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKCREATE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestSession::symlinkCreate", hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::SymlinkExists(IN_BSTR aSymlink,
                                             BOOL *aExists)
{
    LogRelFlow(("{%p} %s: enter aSymlink=%ls aExists=%p\n", this, "GuestSession::symlinkExists", aSymlink, aExists));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExists);


        BSTRInConverter TmpSymlink(aSymlink);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKEXISTS_ENTER(this, TmpSymlink.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = symlinkExists(TmpSymlink.str(),
                                aExists);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKEXISTS_RETURN(this, hrc, 0 /*normal*/, TmpSymlink.str().c_str(), *aExists != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKEXISTS_RETURN(this, hrc, 1 /*hrc exception*/, 0, *aExists != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKEXISTS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, *aExists != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aExists=%RTbool hrc=%Rhrc\n", this, "GuestSession::symlinkExists", *aExists, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::SymlinkRead(IN_BSTR aSymlink,
                                           ComSafeArrayIn(SymlinkReadFlag_T, aFlags),
                                           BSTR *aTarget)
{
    LogRelFlow(("{%p} %s: enter aSymlink=%ls aFlags=%zu aTarget=%p\n", this, "GuestSession::symlinkRead", aSymlink, aFlags, aTarget));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTarget);


        BSTRInConverter TmpSymlink(aSymlink);
        ArrayInConverter<SymlinkReadFlag_T> TmpFlags(ComSafeArrayInArg(aFlags));
        BSTROutConverter TmpTarget(aTarget);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKREAD_ENTER(this, TmpSymlink.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = symlinkRead(TmpSymlink.str(),
                              TmpFlags.array(),
                              TmpTarget.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKREAD_RETURN(this, hrc, 0 /*normal*/, TmpSymlink.str().c_str(), (uint32_t)TmpFlags.array().size(), NULL /*for now*/, TmpTarget.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKREAD_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_SYMLINKREAD_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aTarget=%ls hrc=%Rhrc\n", this, "GuestSession::symlinkRead", *aTarget, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::WaitFor(ULONG aWaitFor,
                                       ULONG aTimeoutMS,
                                       GuestSessionWaitResult_T *aReason)
{
    LogRelFlow(("{%p} %s: enter aWaitFor=%RU32 aTimeoutMS=%RU32 aReason=%p\n", this, "GuestSession::waitFor", aWaitFor, aTimeoutMS, aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReason);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFOR_ENTER(this, aWaitFor, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitFor(aWaitFor,
                          aTimeoutMS,
                          aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFOR_RETURN(this, hrc, 0 /*normal*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFOR_RETURN(this, hrc, 1 /*hrc exception*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFOR_RETURN(this, hrc, 9 /*unhandled exception*/, aWaitFor, aTimeoutMS, *aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReason=%RU32 hrc=%Rhrc\n", this, "GuestSession::waitFor", *aReason, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::WaitForArray(ComSafeArrayIn(GuestSessionWaitForFlag_T, aWaitFor),
                                            ULONG aTimeoutMS,
                                            GuestSessionWaitResult_T *aReason)
{
    LogRelFlow(("{%p} %s: enter aWaitFor=%zu aTimeoutMS=%RU32 aReason=%p\n", this, "GuestSession::waitForArray", aWaitFor, aTimeoutMS, aReason));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReason);


        ArrayInConverter<GuestSessionWaitForFlag_T> TmpWaitFor(ComSafeArrayInArg(aWaitFor));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFORARRAY_ENTER(this, (uint32_t)TmpWaitFor.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = waitForArray(TmpWaitFor.array(),
                               aTimeoutMS,
                               aReason);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFORARRAY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpWaitFor.array().size(), NULL /*for now*/, aTimeoutMS, *aReason);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFORARRAY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aTimeoutMS, *aReason);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSESSION_WAITFORARRAY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aTimeoutMS, *aReason);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReason=%RU32 hrc=%Rhrc\n", this, "GuestSession::waitForArray", *aReason, hrc));
    return hrc;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod1IGuestSession()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod2IGuestSession()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod3IGuestSession()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod4IGuestSession()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod5IGuestSession()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod6IGuestSession()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod7IGuestSession()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestSessionWrap::InternalAndReservedMethod8IGuestSession()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestSessionWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(GuestSessionWrap, IGuestSession)
#endif // VBOX_WITH_XPCOM
