/** @file
 * VirtualBox API class wrapper code for IConsole.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_CONSOLE

#include "ConsoleWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ConsoleWrap)

//
// IConsole properties
//

STDMETHODIMP ConsoleWrap::COMGETTER(Machine)(IMachine **aMachine)
{
    LogRelFlow(("{%p} %s: enter aMachine=%p\n", this, "Console::getMachine", aMachine));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMachine);
        ComTypeOutConverter<IMachine> TmpMachine(aMachine);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MACHINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMachine(TmpMachine.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MACHINE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMachine.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MACHINE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MACHINE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMachine=%p hrc=%Rhrc\n", this, "Console::getMachine", *aMachine, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(State)(MachineState_T *aState)
{
    LogRelFlow(("{%p} %s: enter aState=%p\n", this, "Console::getState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_STATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_STATE_RETURN(this, hrc, 0 /*normal*/,*aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_STATE_RETURN(this, hrc, 1 /*hrc exception*/,*aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_STATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aState=%RU32 hrc=%Rhrc\n", this, "Console::getState", *aState, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(Guest)(IGuest **aGuest)
{
    LogRelFlow(("{%p} %s: enter aGuest=%p\n", this, "Console::getGuest", aGuest));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuest);
        ComTypeOutConverter<IGuest> TmpGuest(aGuest);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_GUEST_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuest(TmpGuest.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_GUEST_RETURN(this, hrc, 0 /*normal*/,(void *)TmpGuest.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_GUEST_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_GUEST_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGuest=%p hrc=%Rhrc\n", this, "Console::getGuest", *aGuest, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(Keyboard)(IKeyboard **aKeyboard)
{
    LogRelFlow(("{%p} %s: enter aKeyboard=%p\n", this, "Console::getKeyboard", aKeyboard));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyboard);
        ComTypeOutConverter<IKeyboard> TmpKeyboard(aKeyboard);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_KEYBOARD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyboard(TmpKeyboard.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_KEYBOARD_RETURN(this, hrc, 0 /*normal*/,(void *)TmpKeyboard.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_KEYBOARD_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_KEYBOARD_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyboard=%p hrc=%Rhrc\n", this, "Console::getKeyboard", *aKeyboard, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(Mouse)(IMouse **aMouse)
{
    LogRelFlow(("{%p} %s: enter aMouse=%p\n", this, "Console::getMouse", aMouse));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMouse);
        ComTypeOutConverter<IMouse> TmpMouse(aMouse);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MOUSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMouse(TmpMouse.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MOUSE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpMouse.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MOUSE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_MOUSE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMouse=%p hrc=%Rhrc\n", this, "Console::getMouse", *aMouse, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(Display)(IDisplay **aDisplay)
{
    LogRelFlow(("{%p} %s: enter aDisplay=%p\n", this, "Console::getDisplay", aDisplay));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDisplay);
        ComTypeOutConverter<IDisplay> TmpDisplay(aDisplay);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DISPLAY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDisplay(TmpDisplay.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DISPLAY_RETURN(this, hrc, 0 /*normal*/,(void *)TmpDisplay.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DISPLAY_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DISPLAY_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDisplay=%p hrc=%Rhrc\n", this, "Console::getDisplay", *aDisplay, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(Debugger)(IMachineDebugger **aDebugger)
{
    LogRelFlow(("{%p} %s: enter aDebugger=%p\n", this, "Console::getDebugger", aDebugger));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDebugger);
        ComTypeOutConverter<IMachineDebugger> TmpDebugger(aDebugger);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DEBUGGER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDebugger(TmpDebugger.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DEBUGGER_RETURN(this, hrc, 0 /*normal*/,(void *)TmpDebugger.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DEBUGGER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_DEBUGGER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDebugger=%p hrc=%Rhrc\n", this, "Console::getDebugger", *aDebugger, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(USBDevices)(ComSafeArrayOut(IUSBDevice *, aUSBDevices))
{
    LogRelFlow(("{%p} %s: enter aUSBDevices=%p\n", this, "Console::getUSBDevices", aUSBDevices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUSBDevices);
        ArrayComTypeOutConverter<IUSBDevice> TmpUSBDevices(ComSafeArrayOutArg(aUSBDevices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USBDEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBDevices(TmpUSBDevices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USBDEVICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpUSBDevices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USBDEVICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USBDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUSBDevices=%zu hrc=%Rhrc\n", this, "Console::getUSBDevices", ComSafeArraySize(*aUSBDevices), hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(RemoteUSBDevices)(ComSafeArrayOut(IHostUSBDevice *, aRemoteUSBDevices))
{
    LogRelFlow(("{%p} %s: enter aRemoteUSBDevices=%p\n", this, "Console::getRemoteUSBDevices", aRemoteUSBDevices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRemoteUSBDevices);
        ArrayComTypeOutConverter<IHostUSBDevice> TmpRemoteUSBDevices(ComSafeArrayOutArg(aRemoteUSBDevices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_REMOTEUSBDEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRemoteUSBDevices(TmpRemoteUSBDevices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_REMOTEUSBDEVICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpRemoteUSBDevices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_REMOTEUSBDEVICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_REMOTEUSBDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRemoteUSBDevices=%zu hrc=%Rhrc\n", this, "Console::getRemoteUSBDevices", ComSafeArraySize(*aRemoteUSBDevices), hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(SharedFolders)(ComSafeArrayOut(ISharedFolder *, aSharedFolders))
{
    LogRelFlow(("{%p} %s: enter aSharedFolders=%p\n", this, "Console::getSharedFolders", aSharedFolders));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSharedFolders);
        ArrayComTypeOutConverter<ISharedFolder> TmpSharedFolders(ComSafeArrayOutArg(aSharedFolders));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_SHAREDFOLDERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSharedFolders(TmpSharedFolders.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_SHAREDFOLDERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSharedFolders.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_SHAREDFOLDERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_SHAREDFOLDERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSharedFolders=%zu hrc=%Rhrc\n", this, "Console::getSharedFolders", ComSafeArraySize(*aSharedFolders), hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(VRDEServerInfo)(IVRDEServerInfo **aVRDEServerInfo)
{
    LogRelFlow(("{%p} %s: enter aVRDEServerInfo=%p\n", this, "Console::getVRDEServerInfo", aVRDEServerInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEServerInfo);
        ComTypeOutConverter<IVRDEServerInfo> TmpVRDEServerInfo(aVRDEServerInfo);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_VRDESERVERINFO_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEServerInfo(TmpVRDEServerInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_VRDESERVERINFO_RETURN(this, hrc, 0 /*normal*/,(void *)TmpVRDEServerInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_VRDESERVERINFO_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_VRDESERVERINFO_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEServerInfo=%p hrc=%Rhrc\n", this, "Console::getVRDEServerInfo", *aVRDEServerInfo, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "Console::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "Console::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(AttachedPCIDevices)(ComSafeArrayOut(IPCIDeviceAttachment *, aAttachedPCIDevices))
{
    LogRelFlow(("{%p} %s: enter aAttachedPCIDevices=%p\n", this, "Console::getAttachedPCIDevices", aAttachedPCIDevices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAttachedPCIDevices);
        ArrayComTypeOutConverter<IPCIDeviceAttachment> TmpAttachedPCIDevices(ComSafeArrayOutArg(aAttachedPCIDevices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_ATTACHEDPCIDEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAttachedPCIDevices(TmpAttachedPCIDevices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_ATTACHEDPCIDEVICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpAttachedPCIDevices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_ATTACHEDPCIDEVICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_ATTACHEDPCIDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAttachedPCIDevices=%zu hrc=%Rhrc\n", this, "Console::getAttachedPCIDevices", ComSafeArraySize(*aAttachedPCIDevices), hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(UseHostClipboard)(BOOL *aUseHostClipboard)
{
    LogRelFlow(("{%p} %s: enter aUseHostClipboard=%p\n", this, "Console::getUseHostClipboard", aUseHostClipboard));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUseHostClipboard);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USEHOSTCLIPBOARD_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUseHostClipboard(aUseHostClipboard);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USEHOSTCLIPBOARD_RETURN(this, hrc, 0 /*normal*/,*aUseHostClipboard != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USEHOSTCLIPBOARD_RETURN(this, hrc, 1 /*hrc exception*/,*aUseHostClipboard != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_USEHOSTCLIPBOARD_RETURN(this, hrc, 9 /*unhandled exception*/,*aUseHostClipboard != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUseHostClipboard=%RTbool hrc=%Rhrc\n", this, "Console::getUseHostClipboard", *aUseHostClipboard, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMSETTER(UseHostClipboard)(BOOL aUseHostClipboard)
{
    LogRelFlow(("{%p} %s: enter aUseHostClipboard=%RTbool\n", this, "Console::setUseHostClipboard", aUseHostClipboard));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SET_USEHOSTCLIPBOARD_ENTER(this, aUseHostClipboard != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setUseHostClipboard(aUseHostClipboard != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SET_USEHOSTCLIPBOARD_RETURN(this, hrc, 0 /*normal*/,aUseHostClipboard != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SET_USEHOSTCLIPBOARD_RETURN(this, hrc, 1 /*hrc exception*/,aUseHostClipboard != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SET_USEHOSTCLIPBOARD_RETURN(this, hrc, 9 /*unhandled exception*/,aUseHostClipboard != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::setUseHostClipboard", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(EmulatedUSB)(IEmulatedUSB **aEmulatedUSB)
{
    LogRelFlow(("{%p} %s: enter aEmulatedUSB=%p\n", this, "Console::getEmulatedUSB", aEmulatedUSB));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEmulatedUSB);
        ComTypeOutConverter<IEmulatedUSB> TmpEmulatedUSB(aEmulatedUSB);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EMULATEDUSB_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEmulatedUSB(TmpEmulatedUSB.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EMULATEDUSB_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEmulatedUSB.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EMULATEDUSB_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GET_EMULATEDUSB_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEmulatedUSB=%p hrc=%Rhrc\n", this, "Console::getEmulatedUSB", *aEmulatedUSB, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute1IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute2IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute3IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute4IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute5IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute6IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute7IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::COMGETTER(InternalAndReservedAttribute8IConsole)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IConsole methods
//

STDMETHODIMP ConsoleWrap::PowerUp(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "Console::powerUp", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = powerUp(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUP_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUP_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUP_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Console::powerUp", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::PowerUpPaused(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "Console::powerUpPaused", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUPPAUSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = powerUpPaused(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUPPAUSED_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUPPAUSED_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERUPPAUSED_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Console::powerUpPaused", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::PowerDown(IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aProgress=%p\n", this, "Console::powerDown", aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERDOWN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = powerDown(TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERDOWN_RETURN(this, hrc, 0 /*normal*/, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERDOWN_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERDOWN_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Console::powerDown", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::Reset()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Console::reset"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = reset();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESET_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESET_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESET_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::reset", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::Pause()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Console::pause"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_PAUSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = pause();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_PAUSE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_PAUSE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_PAUSE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::pause", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::Resume()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Console::resume"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESUME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = resume();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESUME_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESUME_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_RESUME_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::resume", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::PowerButton()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Console::powerButton"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERBUTTON_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = powerButton();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERBUTTON_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERBUTTON_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_POWERBUTTON_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::powerButton", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::SleepButton()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Console::sleepButton"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SLEEPBUTTON_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = sleepButton();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SLEEPBUTTON_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SLEEPBUTTON_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_SLEEPBUTTON_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::sleepButton", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::GetPowerButtonHandled(BOOL *aHandled)
{
    LogRelFlow(("{%p} %s: enter aHandled=%p\n", this, "Console::getPowerButtonHandled", aHandled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHandled);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETPOWERBUTTONHANDLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPowerButtonHandled(aHandled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETPOWERBUTTONHANDLED_RETURN(this, hrc, 0 /*normal*/, *aHandled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETPOWERBUTTONHANDLED_RETURN(this, hrc, 1 /*hrc exception*/, *aHandled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETPOWERBUTTONHANDLED_RETURN(this, hrc, 9 /*unhandled exception*/, *aHandled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aHandled=%RTbool hrc=%Rhrc\n", this, "Console::getPowerButtonHandled", *aHandled, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::GetGuestEnteredACPIMode(BOOL *aEntered)
{
    LogRelFlow(("{%p} %s: enter aEntered=%p\n", this, "Console::getGuestEnteredACPIMode", aEntered));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEntered);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETGUESTENTEREDACPIMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestEnteredACPIMode(aEntered);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETGUESTENTEREDACPIMODE_RETURN(this, hrc, 0 /*normal*/, *aEntered != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETGUESTENTEREDACPIMODE_RETURN(this, hrc, 1 /*hrc exception*/, *aEntered != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETGUESTENTEREDACPIMODE_RETURN(this, hrc, 9 /*unhandled exception*/, *aEntered != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aEntered=%RTbool hrc=%Rhrc\n", this, "Console::getGuestEnteredACPIMode", *aEntered, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::GetDeviceActivity(ComSafeArrayIn(DeviceType_T, aType),
                                            ComSafeArrayOut(DeviceActivity_T, aActivity))
{
    LogRelFlow(("{%p} %s: enter aType=%zu aActivity=%p\n", this, "Console::getDeviceActivity", aType, aActivity));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aActivity);


        ArrayInConverter<DeviceType_T> TmpType(ComSafeArrayInArg(aType));
        ArrayOutConverter<DeviceActivity_T> TmpActivity(ComSafeArrayOutArg(aActivity));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETDEVICEACTIVITY_ENTER(this, (uint32_t)TmpType.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDeviceActivity(TmpType.array(),
                                    TmpActivity.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETDEVICEACTIVITY_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpType.array().size(), NULL /*for now*/, (uint32_t)TmpActivity.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETDEVICEACTIVITY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_GETDEVICEACTIVITY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aActivity=%zu hrc=%Rhrc\n", this, "Console::getDeviceActivity", ComSafeArraySize(*aActivity), hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::AttachUSBDevice(IN_BSTR aId,
                                          IN_BSTR aCaptureFilename)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aCaptureFilename=%ls\n", this, "Console::attachUSBDevice", aId, aCaptureFilename));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        UuidInConverter TmpId(aId);
        BSTRInConverter TmpCaptureFilename(aCaptureFilename);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ATTACHUSBDEVICE_ENTER(this, TmpId.uuid().toStringCurly().c_str(), TmpCaptureFilename.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = attachUSBDevice(TmpId.uuid(),
                                  TmpCaptureFilename.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ATTACHUSBDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), TmpCaptureFilename.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ATTACHUSBDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ATTACHUSBDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::attachUSBDevice", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::DetachUSBDevice(IN_BSTR aId,
                                          IUSBDevice **aDevice)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aDevice=%p\n", this, "Console::detachUSBDevice", aId, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IUSBDevice> TmpDevice(aDevice);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_DETACHUSBDEVICE_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = detachUSBDevice(TmpId.uuid(),
                                  TmpDevice.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_DETACHUSBDEVICE_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpDevice.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_DETACHUSBDEVICE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_DETACHUSBDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDevice=%p hrc=%Rhrc\n", this, "Console::detachUSBDevice", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::FindUSBDeviceByAddress(IN_BSTR aName,
                                                 IUSBDevice **aDevice)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aDevice=%p\n", this, "Console::findUSBDeviceByAddress", aName, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IUSBDevice> TmpDevice(aDevice);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYADDRESS_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findUSBDeviceByAddress(TmpName.str(),
                                         TmpDevice.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYADDRESS_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpDevice.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYADDRESS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDevice=%p hrc=%Rhrc\n", this, "Console::findUSBDeviceByAddress", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::FindUSBDeviceById(IN_BSTR aId,
                                            IUSBDevice **aDevice)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aDevice=%p\n", this, "Console::findUSBDeviceById", aId, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IUSBDevice> TmpDevice(aDevice);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYID_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findUSBDeviceById(TmpId.uuid(),
                                    TmpDevice.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYID_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpDevice.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_FINDUSBDEVICEBYID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDevice=%p hrc=%Rhrc\n", this, "Console::findUSBDeviceById", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::CreateSharedFolder(IN_BSTR aName,
                                             IN_BSTR aHostPath,
                                             BOOL aWritable,
                                             BOOL aAutomount,
                                             IN_BSTR aAutoMountPoint)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aHostPath=%ls aWritable=%RTbool aAutomount=%RTbool aAutoMountPoint=%ls\n", this, "Console::createSharedFolder", aName, aHostPath, aWritable, aAutomount, aAutoMountPoint));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        BSTRInConverter TmpHostPath(aHostPath);
        
        
        BSTRInConverter TmpAutoMountPoint(aAutoMountPoint);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CREATESHAREDFOLDER_ENTER(this, TmpName.str().c_str(), TmpHostPath.str().c_str(), aWritable != FALSE, aAutomount != FALSE, TmpAutoMountPoint.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createSharedFolder(TmpName.str(),
                                     TmpHostPath.str(),
                                     aWritable != FALSE,
                                     aAutomount != FALSE,
                                     TmpAutoMountPoint.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CREATESHAREDFOLDER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), TmpHostPath.str().c_str(), aWritable != FALSE, aAutomount != FALSE, TmpAutoMountPoint.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CREATESHAREDFOLDER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aWritable != FALSE, aAutomount != FALSE, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CREATESHAREDFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aWritable != FALSE, aAutomount != FALSE, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::createSharedFolder", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::RemoveSharedFolder(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "Console::removeSharedFolder", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVESHAREDFOLDER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeSharedFolder(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVESHAREDFOLDER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVESHAREDFOLDER_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVESHAREDFOLDER_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::removeSharedFolder", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::Teleport(IN_BSTR aHostname,
                                   ULONG aTcpport,
                                   IN_BSTR aPassword,
                                   ULONG aMaxDowntime,
                                   IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aHostname=%ls aTcpport=%RU32 aPassword=%ls aMaxDowntime=%RU32 aProgress=%p\n", this, "Console::teleport", aHostname, aTcpport, aPassword, aMaxDowntime, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        BSTRInConverter TmpHostname(aHostname);
        
        BSTRInConverter TmpPassword(aPassword);
        
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_TELEPORT_ENTER(this, TmpHostname.str().c_str(), aTcpport, TmpPassword.str().c_str(), aMaxDowntime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = teleport(TmpHostname.str(),
                           aTcpport,
                           TmpPassword.str(),
                           aMaxDowntime,
                           TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_TELEPORT_RETURN(this, hrc, 0 /*normal*/, TmpHostname.str().c_str(), aTcpport, TmpPassword.str().c_str(), aMaxDowntime, (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_TELEPORT_RETURN(this, hrc, 1 /*hrc exception*/, 0, aTcpport, 0, aMaxDowntime, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_TELEPORT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aTcpport, 0, aMaxDowntime, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Console::teleport", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::AddEncryptionPassword(IN_BSTR aId,
                                                IN_BSTR aPassword,
                                                BOOL aClearOnSuspend)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aPassword=%ls aClearOnSuspend=%RTbool\n", this, "Console::addEncryptionPassword", aId, aPassword, aClearOnSuspend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpId(aId);
        BSTRInConverter TmpPassword(aPassword);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORD_ENTER(this, TmpId.str().c_str(), TmpPassword.str().c_str(), aClearOnSuspend != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addEncryptionPassword(TmpId.str(),
                                        TmpPassword.str(),
                                        aClearOnSuspend != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORD_RETURN(this, hrc, 0 /*normal*/, TmpId.str().c_str(), TmpPassword.str().c_str(), aClearOnSuspend != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aClearOnSuspend != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aClearOnSuspend != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::addEncryptionPassword", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::AddEncryptionPasswords(ComSafeArrayIn(IN_BSTR, aIds),
                                                 ComSafeArrayIn(IN_BSTR, aPasswords),
                                                 BOOL aClearOnSuspend)
{
    LogRelFlow(("{%p} %s: enter aIds=%zu aPasswords=%zu aClearOnSuspend=%RTbool\n", this, "Console::addEncryptionPasswords", aIds, aPasswords, aClearOnSuspend));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        ArrayBSTRInConverter TmpIds(ComSafeArrayInArg(aIds));
        ArrayBSTRInConverter TmpPasswords(ComSafeArrayInArg(aPasswords));
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORDS_ENTER(this, (uint32_t)TmpIds.array().size(), NULL /*for now*/, (uint32_t)TmpPasswords.array().size(), NULL /*for now*/, aClearOnSuspend != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addEncryptionPasswords(TmpIds.array(),
                                         TmpPasswords.array(),
                                         aClearOnSuspend != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORDS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpIds.array().size(), NULL /*for now*/, (uint32_t)TmpPasswords.array().size(), NULL /*for now*/, aClearOnSuspend != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORDS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, aClearOnSuspend != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_ADDENCRYPTIONPASSWORDS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, aClearOnSuspend != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::addEncryptionPasswords", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::RemoveEncryptionPassword(IN_BSTR aId)
{
    LogRelFlow(("{%p} %s: enter aId=%ls\n", this, "Console::removeEncryptionPassword", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpId(aId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVEENCRYPTIONPASSWORD_ENTER(this, TmpId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeEncryptionPassword(TmpId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVEENCRYPTIONPASSWORD_RETURN(this, hrc, 0 /*normal*/, TmpId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVEENCRYPTIONPASSWORD_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_REMOVEENCRYPTIONPASSWORD_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::removeEncryptionPassword", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::ClearAllEncryptionPasswords()
{
    LogRelFlow(("{%p} %s: enter\n", this, "Console::clearAllEncryptionPasswords"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CLEARALLENCRYPTIONPASSWORDS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = clearAllEncryptionPasswords();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CLEARALLENCRYPTIONPASSWORDS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CLEARALLENCRYPTIONPASSWORDS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CONSOLE_CLEARALLENCRYPTIONPASSWORDS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Console::clearAllEncryptionPasswords", hrc));
    return hrc;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod1IConsole()
{
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod2IConsole()
{
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod3IConsole()
{
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod4IConsole()
{
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod5IConsole()
{
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod6IConsole()
{
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod7IConsole()
{
    return E_NOTIMPL;
}

STDMETHODIMP ConsoleWrap::InternalAndReservedMethod8IConsole()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ConsoleWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(ConsoleWrap, IConsole)
#endif // VBOX_WITH_XPCOM
