/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_decode_ccsds_27_fb = R"doc(A rate 1/2, k=7 convolutional decoder for the CCSDS standard.

This block performs soft-decision convolutional decoding using the Viterbi algorithm.


The input is a stream of (possibly noise corrupted) floating point values nominally spanning [-1.0, 1.0], representing the encoded channel symbols 0 (-1.0) and 1 (1.0), with erased symbols at 0.0.


The output is MSB first packed bytes of decoded values.


As a rate 1/2 code, there will be one output byte for every 16 input symbols.


This block is designed for continuous data streaming, not packetized data. The first 32 bits out will be zeroes, with the output delayed four bytes from the corresponding inputs.

Constructor Specific Documentation:

)doc";


static const char* __doc_gr_fec_decode_ccsds_27_fb_decode_ccsds_27_fb = R"doc()doc";


static const char* __doc_gr_fec_decode_ccsds_27_fb_make = R"doc(A rate 1/2, k=7 convolutional decoder for the CCSDS standard.

This block performs soft-decision convolutional decoding using the Viterbi algorithm.


The input is a stream of (possibly noise corrupted) floating point values nominally spanning [-1.0, 1.0], representing the encoded channel symbols 0 (-1.0) and 1 (1.0), with erased symbols at 0.0.


The output is MSB first packed bytes of decoded values.


As a rate 1/2 code, there will be one output byte for every 16 input symbols.


This block is designed for continuous data streaming, not packetized data. The first 32 bits out will be zeroes, with the output delayed four bytes from the corresponding inputs.

Constructor Specific Documentation:

)doc";
