// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns summaries of invoked Hooks. For more information, see [View invocation summaries for CloudFormation Hooks] in the
// CloudFormation Hooks User Guide.
//
// This operation supports the following parameter combinations:
//
//   - No parameters: Returns all Hook invocation summaries.
//
//   - TypeArn only: Returns summaries for a specific Hook.
//
//   - TypeArn and Status : Returns summaries for a specific Hook filtered by
//     status.
//
//   - TargetId and TargetType : Returns summaries for a specific Hook invocation
//     target.
//
// [View invocation summaries for CloudFormation Hooks]: https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-view-invocations.html
func (c *Client) ListHookResults(ctx context.Context, params *ListHookResultsInput, optFns ...func(*Options)) (*ListHookResultsOutput, error) {
	if params == nil {
		params = &ListHookResultsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListHookResults", params, optFns, c.addOperationListHookResultsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListHookResultsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListHookResultsInput struct {

	// The token for the next set of items to return. (You received this token from a
	// previous call.)
	NextToken *string

	// Filters results by the status of Hook invocations. Can only be used in
	// combination with TypeArn . Valid values are:
	//
	//   - HOOK_IN_PROGRESS : The Hook is currently running.
	//
	//   - HOOK_COMPLETE_SUCCEEDED : The Hook completed successfully.
	//
	//   - HOOK_COMPLETE_FAILED : The Hook completed but failed validation.
	//
	//   - HOOK_FAILED : The Hook encountered an error during execution.
	Status types.HookStatus

	// Filters results by the unique identifier of the target the Hook was invoked
	// against.
	//
	// For change sets, this is the change set ARN. When the target is a Cloud Control
	// API operation, this value must be the HookRequestToken returned by the Cloud
	// Control API request. For more information on the HookRequestToken , see [ProgressEvent].
	//
	// Required when TargetType is specified and cannot be used otherwise.
	//
	// [ProgressEvent]: https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html
	TargetId *string

	// Filters results by target type. Currently, only CHANGE_SET and CLOUD_CONTROL
	// are supported filter options.
	//
	// Required when TargetId is specified and cannot be used otherwise.
	TargetType types.ListHookResultsTargetType

	// Filters results by the ARN of the Hook. Can be used alone or in combination
	// with Status .
	TypeArn *string

	noSmithyDocumentSerde
}

type ListHookResultsOutput struct {

	// A list of HookResultSummary structures that provides the status and Hook status
	// reason for each Hook invocation for the specified target.
	HookResults []types.HookResultSummary

	// Pagination token, null or empty if no more results.
	NextToken *string

	// The unique identifier of the Hook invocation target.
	TargetId *string

	// The target type.
	TargetType types.ListHookResultsTargetType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListHookResultsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpListHookResults{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpListHookResults{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListHookResults"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListHookResults(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListHookResults(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListHookResults",
	}
}
