/* file_item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from file_item.vala, do not modify */

/*
Copyright Buddies of Budgie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DESKTOP_ITEM (desktop_item_get_type ())
#define DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_ITEM, DesktopItem))
#define DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_ITEM, DesktopItemClass))
#define IS_DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_ITEM))
#define IS_DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_ITEM))
#define DESKTOP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_ITEM, DesktopItemClass))

typedef struct _DesktopItem DesktopItem;
typedef struct _DesktopItemClass DesktopItemClass;
typedef struct _DesktopItemPrivate DesktopItemPrivate;

#define TYPE_UNIFIED_PROPS (unified_props_get_type ())
#define UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIFIED_PROPS, UnifiedProps))
#define UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIFIED_PROPS, UnifiedPropsClass))
#define IS_UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIFIED_PROPS))
#define IS_UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIFIED_PROPS))
#define UNIFIED_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIFIED_PROPS, UnifiedPropsClass))

typedef struct _UnifiedProps UnifiedProps;
typedef struct _UnifiedPropsClass UnifiedPropsClass;

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;
typedef struct _FileItemPrivate FileItemPrivate;
enum  {
	FILE_ITEM_0_PROPERTY,
	FILE_ITEM_FILE_LIST_PROPERTY,
	FILE_ITEM_FILE_TYPE_PROPERTY,
	FILE_ITEM_NUM_PROPERTIES
};
static GParamSpec* file_item_properties[FILE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnifiedPropsPrivate UnifiedPropsPrivate;

#define TYPE_FILE_MENU (file_menu_get_type ())
#define FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_MENU, FileMenu))
#define FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_MENU, FileMenuClass))
#define IS_FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_MENU))
#define IS_FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_MENU))
#define FILE_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_MENU, FileMenuClass))

typedef struct _FileMenu FileMenu;
typedef struct _FileMenuClass FileMenuClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _FileItemLoadImageForFileData FileItemLoadImageForFileData;

struct _DesktopItem {
	GtkFlowBoxChild parent_instance;
	DesktopItemPrivate * priv;
	UnifiedProps* props;
	gint _label_width;
	gboolean _copying;
	gboolean _mount;
	gchar* _name;
	gchar* _type;
	gboolean _special_dir;
	GtkImage* image;
	GtkLabel* label;
	GtkEventBox* event_box;
	GtkBox* main_layout;
	GdkPixbuf* original_image_pixbuf;
	GIcon* icon;
};

struct _DesktopItemClass {
	GtkFlowBoxChildClass parent_class;
};

struct _FileItem {
	DesktopItem parent_instance;
	FileItemPrivate * priv;
	GFile* file;
	GFileInfo* info;
	GDesktopAppInfo* app_info;
	GKeyFile* keyfile;
	gboolean exclude_item;
};

struct _FileItemClass {
	DesktopItemClass parent_class;
};

struct _FileItemPrivate {
	GList* _flist;
	gchar* _ftype;
	GIcon* _override_icon;
	gchar* _override_icon_name;
	gboolean use_override_icon;
};

struct _UnifiedProps {
	GObject parent_instance;
	UnifiedPropsPrivate * priv;
	GHashTable* files_currently_copying;
	gboolean is_launching;
	GdkCursor* blocked_cursor;
	GdkCursor* hand_cursor;
	GdkCursor* loading_cursor;
	GdkAppLaunchContext* launch_context;
	FileMenu* file_menu;
	GtkIconTheme* icon_theme;
	gint* icon_size;
	guint* s_factor;
};

struct _UnifiedPropsClass {
	GObjectClass parent_class;
};

struct _FileItemLoadImageForFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FileItem* self;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GFileInfo* _tmp2_;
	UnifiedProps* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* file_path;
	GFile* _tmp6_;
	gchar* _tmp7_;
	GdkPixbuf* file_pixbuf;
	const gchar* _tmp8_;
	UnifiedProps* _tmp9_;
	gint* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GError* e;
	const gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

static gint FileItem_private_offset;
static gpointer file_item_parent_class = NULL;

VALA_EXTERN GType desktop_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopItem, g_object_unref)
VALA_EXTERN GType unified_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnifiedProps, g_object_unref)
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN FileItem* file_item_new (UnifiedProps* p,
                         GFile* f,
                         GFileInfo* finfo,
                         GIcon* override_icon);
VALA_EXTERN FileItem* file_item_construct (GType object_type,
                               UnifiedProps* p,
                               GFile* f,
                               GFileInfo* finfo,
                               GIcon* override_icon);
VALA_EXTERN DesktopItem* desktop_item_new (void);
VALA_EXTERN DesktopItem* desktop_item_construct (GType object_type);
VALA_EXTERN void desktop_item_set_label_name (DesktopItem* self,
                                  const gchar* value);
VALA_EXTERN void file_item_update_icon (FileItem* self,
                            GError** error);
VALA_EXTERN gboolean file_item_on_button_press (FileItem* self,
                                    GdkEventButton* ev);
static gboolean _file_item_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                   GdkEventButton* event,
                                                                   gpointer self);
VALA_EXTERN gboolean file_item_on_button_release (FileItem* self,
                                      GdkEventButton* ev);
static gboolean _file_item_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self);
VALA_EXTERN gboolean file_item_emit_launch (FileItem* self);
VALA_EXTERN GType file_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileMenu, g_object_unref)
VALA_EXTERN void file_item_launch (FileItem* self,
                       gboolean in_terminal);
VALA_EXTERN GThemedIcon* file_item_get_mimetype_icon (FileItem* self);
VALA_EXTERN gboolean unified_props_get_is_single_click (UnifiedProps* self);
VALA_EXTERN void file_menu_set_item (FileMenu* self,
                         FileItem* item,
                         GList* selected);
VALA_EXTERN void file_menu_set_is_copying (FileMenu* self,
                               gboolean value);
VALA_EXTERN void file_menu_set_show_open_in_terminal (FileMenu* self,
                                          gboolean value);
VALA_EXTERN void file_menu_show_menu (FileMenu* self,
                          GdkEventButton* event);
VALA_EXTERN gboolean unified_props_is_desired_primary_click_type (UnifiedProps* self,
                                                      GdkEventButton* ev);
VALA_EXTERN GSettings* unified_props_get_desktop_settings (UnifiedProps* self);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN const gchar* file_item_get_file_type (FileItem* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN GList* file_item_get_file_list (FileItem* self);
static void file_item_load_image_for_file_data_free (gpointer _data);
static void file_item_load_image_for_file (FileItem* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void file_item_load_image_for_file_finish (FileItem* self,
                                           GAsyncResult* _res_);
static gboolean file_item_load_image_for_file_co (FileItemLoadImageForFileData* _data_);
VALA_EXTERN gint unified_props_get_max_thumbnail_size (UnifiedProps* self);
VALA_EXTERN void desktop_item_set_image_pixbuf (DesktopItem* self,
                                    GdkPixbuf* pix);
VALA_EXTERN void file_item_move_to_trash (FileItem* self);
static void __lambda6_ (FileItem* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN void desktop_item_set_icon_factors (DesktopItem* self,
                                    GError** error);
VALA_EXTERN void desktop_item_set_icon_from_name (DesktopItem* self,
                                      const gchar* icon_name,
                                      GError** error);
VALA_EXTERN void desktop_item_set_icon (DesktopItem* self,
                            GIcon* ico,
                            GError** error);
static void ___lambda4_ (FileItem* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void file_item_set_file_type (FileItem* self,
                              const gchar* value);
VALA_EXTERN gboolean desktop_item_get_is_special (DesktopItem* self);
static void file_item_finalize (GObject * obj);
static GType file_item_get_type_once (void);
static void _vala_file_item_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_file_item_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* SUPPORTED_TERMINALS[9];

static inline gpointer
file_item_get_instance_private (FileItem* self)
{
	return G_STRUCT_MEMBER_P (self, FileItem_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_file_item_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                          GdkEventButton* event,
                                                          gpointer self)
{
	gboolean result;
	result = file_item_on_button_press ((FileItem*) self, event);
	return result;
}

static gboolean
_file_item_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                              GdkEventButton* event,
                                                              gpointer self)
{
	gboolean result;
	result = file_item_on_button_release ((FileItem*) self, event);
	return result;
}

FileItem*
file_item_construct (GType object_type,
                     UnifiedProps* p,
                     GFile* f,
                     GFileInfo* finfo,
                     GIcon* override_icon)
{
	FileItem * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFileInfo* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp44_ = FALSE;
	GDesktopAppInfo* _tmp45_;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (p != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	g_return_val_if_fail (finfo != NULL, NULL);
	self = (FileItem*) desktop_item_construct (object_type);
	((DesktopItem*) self)->props = p;
	_tmp0_ = _g_object_ref0 (f);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	if (finfo == NULL) {
		{
			GFileInfo* _tmp1_ = NULL;
			GFile* _tmp2_;
			GFileInfo* _tmp3_;
			_tmp2_ = self->file;
			_tmp3_ = g_file_query_info (_tmp2_, "standard::*", 0, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			finfo = _tmp1_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("file_item.vala:43: Failed to get file info: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	(self->priv->_flist == NULL) ? NULL : (self->priv->_flist = (_g_list_free__g_object_unref0_ (self->priv->_flist), NULL));
	self->priv->_flist = NULL;
	_tmp6_ = self->file;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	self->priv->_flist = g_list_append (self->priv->_flist, _tmp7_);
	_tmp8_ = _g_object_ref0 (finfo);
	_g_object_unref0 (self->info);
	self->info = _tmp8_;
	_tmp9_ = g_file_info_get_content_type (finfo);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (self->priv->_ftype);
	self->priv->_ftype = _tmp10_;
	_tmp11_ = self->priv->_ftype;
	if (g_strcmp0 (_tmp11_, "application/x-desktop") == 0) {
		gchar* path = NULL;
		GFile* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		GDesktopAppInfo* _tmp15_;
		GDesktopAppInfo* _tmp16_;
		_tmp12_ = self->file;
		_tmp13_ = g_file_get_path (_tmp12_);
		path = _tmp13_;
		_tmp14_ = path;
		_tmp15_ = g_desktop_app_info_new_from_filename (_tmp14_);
		_g_object_unref0 (self->app_info);
		self->app_info = _tmp15_;
		_tmp16_ = self->app_info;
		if (_tmp16_ != NULL) {
			gchar* app_name = NULL;
			GDesktopAppInfo* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp23_;
			_tmp17_ = self->app_info;
			_tmp18_ = g_desktop_app_info_get_locale_string (_tmp17_, "DisplayName");
			app_name = _tmp18_;
			_tmp19_ = app_name;
			if (_tmp19_ == NULL) {
				GDesktopAppInfo* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = self->app_info;
				_tmp21_ = g_app_info_get_display_name ((GAppInfo*) _tmp20_);
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (app_name);
				app_name = _tmp22_;
			}
			_tmp23_ = app_name;
			desktop_item_set_label_name ((DesktopItem*) self, _tmp23_);
			_g_free0 (app_name);
		} else {
			GKeyFile* _tmp24_;
			_tmp24_ = g_key_file_new ();
			_g_key_file_unref0 (self->keyfile);
			self->keyfile = _tmp24_;
			{
				gchar* group = NULL;
				gchar* _tmp25_;
				GKeyFile* _tmp26_;
				const gchar* _tmp27_;
				_tmp25_ = g_strdup ("Desktop Entry");
				group = _tmp25_;
				_tmp26_ = self->keyfile;
				_tmp27_ = path;
				g_key_file_load_from_file (_tmp26_, _tmp27_, G_KEY_FILE_NONE, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (group);
					goto __catch1_g_error;
				}
				if (override_icon == NULL) {
					{
						gchar* icon_name = NULL;
						GKeyFile* _tmp28_;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						_tmp28_ = self->keyfile;
						_tmp29_ = group;
						_tmp30_ = g_key_file_get_string (_tmp28_, _tmp29_, "Icon", &_inner_error0_);
						icon_name = _tmp30_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
						_tmp31_ = icon_name;
						_tmp32_ = g_strdup (_tmp31_);
						_g_free0 (self->priv->_override_icon_name);
						self->priv->_override_icon_name = _tmp32_;
						_g_free0 (icon_name);
					}
					goto __finally2;
					__catch2_g_error:
					{
						gchar* _tmp33_;
						g_clear_error (&_inner_error0_);
						g_warning ("file_item.vala:77: Failed to load any icon for this KeyFile. Using our" \
" fallback instead.");
						_tmp33_ = g_strdup ("application-x-executable");
						_g_free0 (self->priv->_override_icon_name);
						self->priv->_override_icon_name = _tmp33_;
					}
					__finally2:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (group);
						goto __catch1_g_error;
					}
				}
				{
					gchar* keyfile_name = NULL;
					GKeyFile* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					_tmp34_ = self->keyfile;
					_tmp35_ = group;
					_tmp36_ = g_key_file_get_string (_tmp34_, _tmp35_, "Name", &_inner_error0_);
					keyfile_name = _tmp36_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch3_g_error;
					}
					_tmp37_ = keyfile_name;
					desktop_item_set_label_name ((DesktopItem*) self, _tmp37_);
					_g_free0 (keyfile_name);
				}
				goto __finally3;
				__catch3_g_error:
				{
					const gchar* _tmp38_;
					GFileInfo* _tmp39_;
					const gchar* _tmp40_;
					GFileInfo* _tmp41_;
					const gchar* _tmp42_;
					g_clear_error (&_inner_error0_);
					_tmp38_ = path;
					_tmp39_ = self->info;
					_tmp40_ = g_file_info_get_display_name (_tmp39_);
					g_warning ("file_item.vala:86: Failed to get KeyFile Name for %s. Setting as %s", _tmp38_, _tmp40_);
					_tmp41_ = self->info;
					_tmp42_ = g_file_info_get_display_name (_tmp41_);
					desktop_item_set_label_name ((DesktopItem*) self, _tmp42_);
				}
				__finally3:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (group);
					goto __catch1_g_error;
				}
				_g_free0 (group);
			}
			goto __finally1;
			__catch1_g_error:
			{
				const gchar* _tmp43_;
				g_clear_error (&_inner_error0_);
				_tmp43_ = path;
				g_warning ("file_item.vala:90: Failed to parse the %s as a KeyFile. Excluding item" \
".", _tmp43_);
				_g_key_file_unref0 (self->keyfile);
				self->keyfile = NULL;
				self->exclude_item = TRUE;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_g_free0 (path);
	}
	_tmp45_ = self->app_info;
	if (_tmp45_ == NULL) {
		GKeyFile* _tmp46_;
		_tmp46_ = self->keyfile;
		_tmp44_ = _tmp46_ == NULL;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		GFileInfo* _tmp47_;
		const gchar* _tmp48_;
		_tmp47_ = self->info;
		_tmp48_ = g_file_info_get_display_name (_tmp47_);
		desktop_item_set_label_name ((DesktopItem*) self, _tmp48_);
	}
	_tmp50_ = self->priv->_ftype;
	if (g_strcmp0 (_tmp50_, "inode/directory") == 0) {
		_tmp49_ = "dir";
	} else {
		_tmp49_ = "file";
	}
	_tmp51_ = g_strdup (_tmp49_);
	_g_free0 (((DesktopItem*) self)->_type);
	((DesktopItem*) self)->_type = _tmp51_;
	if (override_icon != NULL) {
		GIcon* _tmp52_;
		GIcon* _tmp53_;
		_tmp52_ = _g_object_ref0 (override_icon);
		_g_object_unref0 (((DesktopItem*) self)->icon);
		((DesktopItem*) self)->icon = _tmp52_;
		_tmp53_ = _g_object_ref0 (override_icon);
		_g_object_unref0 (self->priv->_override_icon);
		self->priv->_override_icon = _tmp53_;
		self->priv->use_override_icon = TRUE;
	} else {
		const gchar* _tmp54_;
		_tmp54_ = self->priv->_override_icon_name;
		if (g_strcmp0 (_tmp54_, "") != 0) {
			self->priv->use_override_icon = TRUE;
		}
	}
	{
		file_item_update_icon (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp55_;
		GError* _tmp56_;
		const gchar* _tmp57_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = ((DesktopItem*) self)->_name;
		_tmp56_ = e;
		_tmp57_ = _tmp56_->message;
		g_warning ("file_item.vala:113: Failed to set icon for FileItem %s: %s", _tmp55_, _tmp57_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _file_item_on_button_press_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _file_item_on_button_release_gtk_widget_button_release_event, self, 0);
	return self;
}

FileItem*
file_item_new (UnifiedProps* p,
               GFile* f,
               GFileInfo* finfo,
               GIcon* override_icon)
{
	return file_item_construct (TYPE_FILE_ITEM, p, f, finfo, override_icon);
}

gboolean
file_item_emit_launch (FileItem* self)
{
	UnifiedProps* _tmp0_;
	GHashTable* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((DesktopItem*) self)->props;
	_tmp1_ = _tmp0_->files_currently_copying;
	_tmp2_ = self->info;
	_tmp3_ = g_file_info_get_display_name (_tmp2_);
	if (g_hash_table_contains (_tmp1_, _tmp3_)) {
		result = GDK_EVENT_STOP;
		return result;
	}
	file_item_launch (self, FALSE);
	result = GDK_EVENT_STOP;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GThemedIcon*
file_item_get_mimetype_icon (FileItem* self)
{
	GThemedIcon* themed_icon = NULL;
	GFileInfo* _tmp0_;
	GIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	gchar* content_type_to_icon = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GThemedIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->info;
	_tmp1_ = g_file_info_get_icon (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_themed_icon_get_type (), GThemedIcon));
	themed_icon = _tmp2_;
	_tmp3_ = self->priv->_ftype;
	_tmp4_ = string_replace (_tmp3_, "/", "-");
	content_type_to_icon = _tmp4_;
	_tmp5_ = content_type_to_icon;
	_tmp6_ = string_replace (_tmp5_, "+", "-");
	_g_free0 (content_type_to_icon);
	content_type_to_icon = _tmp6_;
	_tmp7_ = content_type_to_icon;
	g_themed_icon_prepend_name (themed_icon, _tmp7_);
	result = themed_icon;
	_g_free0 (content_type_to_icon);
	return result;
}

gboolean
file_item_on_button_release (FileItem* self,
                             GdkEventButton* ev)
{
	gboolean shift_down = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	shift_down = (ev->state & GDK_SHIFT_MASK) != 0;
	if (ev->type == GDK_BUTTON_RELEASE) {
		_tmp0_ = ev->button == ((guint) 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		UnifiedProps* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		GtkContainer* parent = NULL;
		GtkContainer* _tmp5_;
		GtkContainer* _tmp6_;
		gboolean _tmp7_ = FALSE;
		GtkContainer* _tmp8_;
		_tmp2_ = ((DesktopItem*) self)->props;
		_tmp3_ = unified_props_get_is_single_click (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			_tmp1_ = !shift_down;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = file_item_emit_launch (self);
			return result;
		}
		_tmp5_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		parent = _tmp6_;
		_tmp8_ = parent;
		if (_tmp8_ != NULL) {
			GtkContainer* _tmp9_;
			_tmp9_ = parent;
			_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_flow_box_get_type ());
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GtkFlowBox* flowbox = NULL;
			GtkContainer* _tmp10_;
			GtkFlowBox* _tmp11_;
			GtkFlowBoxChild* child = NULL;
			GtkFlowBoxChild* _tmp12_;
			GtkFlowBoxChild* _tmp13_;
			_tmp10_ = parent;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_flow_box_get_type (), GtkFlowBox));
			flowbox = _tmp11_;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_flow_box_child_get_type (), GtkFlowBoxChild));
			child = _tmp12_;
			_tmp13_ = child;
			if (gtk_flow_box_child_is_selected (_tmp13_)) {
				GtkFlowBox* _tmp14_;
				GtkFlowBoxChild* _tmp15_;
				_tmp14_ = flowbox;
				_tmp15_ = child;
				gtk_flow_box_unselect_child (_tmp14_, _tmp15_);
			} else {
				GtkFlowBox* _tmp16_;
				GtkFlowBoxChild* _tmp17_;
				_tmp16_ = flowbox;
				_tmp17_ = child;
				gtk_flow_box_select_child (_tmp16_, _tmp17_);
			}
			result = GDK_EVENT_STOP;
			_g_object_unref0 (child);
			_g_object_unref0 (flowbox);
			_g_object_unref0 (parent);
			return result;
		}
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (parent);
		return result;
	}
	if (ev->button == ((guint) 3)) {
		GtkContainer* parent = NULL;
		GtkContainer* _tmp18_;
		GtkContainer* _tmp19_;
		gboolean _tmp20_ = FALSE;
		GtkContainer* _tmp21_;
		UnifiedProps* _tmp36_;
		FileMenu* _tmp37_;
		UnifiedProps* _tmp38_;
		GHashTable* _tmp39_;
		GFileInfo* _tmp40_;
		const gchar* _tmp41_;
		gboolean _tmp42_ = FALSE;
		GDesktopAppInfo* _tmp43_;
		UnifiedProps* _tmp45_;
		FileMenu* _tmp46_;
		UnifiedProps* _tmp47_;
		FileMenu* _tmp48_;
		_tmp18_ = gtk_widget_get_parent ((GtkWidget*) self);
		_tmp19_ = _g_object_ref0 (_tmp18_);
		parent = _tmp19_;
		_tmp21_ = parent;
		if (_tmp21_ != NULL) {
			GtkContainer* _tmp22_;
			_tmp22_ = parent;
			_tmp20_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_flow_box_get_type ());
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GtkFlowBox* flowbox = NULL;
			GtkContainer* _tmp23_;
			GtkFlowBox* _tmp24_;
			GList* selected = NULL;
			GtkFlowBox* _tmp25_;
			GList* _tmp26_;
			GList* selected_items = NULL;
			GList* _tmp27_;
			UnifiedProps* _tmp31_;
			FileMenu* _tmp32_;
			GList* _tmp33_;
			_tmp23_ = parent;
			_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_flow_box_get_type (), GtkFlowBox));
			flowbox = _tmp24_;
			_tmp25_ = flowbox;
			_tmp26_ = gtk_flow_box_get_selected_children (_tmp25_);
			selected = _tmp26_;
			selected_items = NULL;
			_tmp27_ = selected;
			{
				GList* child_collection = NULL;
				GList* child_it = NULL;
				child_collection = _tmp27_;
				for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
					GtkFlowBoxChild* child = NULL;
					child = (GtkFlowBoxChild*) child_it->data;
					{
						GtkFlowBoxChild* _tmp28_;
						_tmp28_ = child;
						if (IS_FILE_ITEM (_tmp28_)) {
							GtkFlowBoxChild* _tmp29_;
							FileItem* _tmp30_;
							_tmp29_ = child;
							_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_FILE_ITEM, FileItem));
							selected_items = g_list_append (selected_items, _tmp30_);
						}
					}
				}
			}
			_tmp31_ = ((DesktopItem*) self)->props;
			_tmp32_ = _tmp31_->file_menu;
			_tmp33_ = selected_items;
			file_menu_set_item (_tmp32_, self, _tmp33_);
			(selected_items == NULL) ? NULL : (selected_items = (_g_list_free__g_object_unref0_ (selected_items), NULL));
			(selected == NULL) ? NULL : (selected = (g_list_free (selected), NULL));
			_g_object_unref0 (flowbox);
		} else {
			UnifiedProps* _tmp34_;
			FileMenu* _tmp35_;
			_tmp34_ = ((DesktopItem*) self)->props;
			_tmp35_ = _tmp34_->file_menu;
			file_menu_set_item (_tmp35_, self, NULL);
		}
		_tmp36_ = ((DesktopItem*) self)->props;
		_tmp37_ = _tmp36_->file_menu;
		_tmp38_ = ((DesktopItem*) self)->props;
		_tmp39_ = _tmp38_->files_currently_copying;
		_tmp40_ = self->info;
		_tmp41_ = g_file_info_get_display_name (_tmp40_);
		file_menu_set_is_copying (_tmp37_, g_hash_table_contains (_tmp39_, _tmp41_));
		_tmp43_ = self->app_info;
		if (_tmp43_ == NULL) {
			GKeyFile* _tmp44_;
			_tmp44_ = self->keyfile;
			_tmp42_ = _tmp44_ == NULL;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp45_ = ((DesktopItem*) self)->props;
		_tmp46_ = _tmp45_->file_menu;
		file_menu_set_show_open_in_terminal (_tmp46_, _tmp42_);
		_tmp47_ = ((DesktopItem*) self)->props;
		_tmp48_ = _tmp47_->file_menu;
		file_menu_show_menu (_tmp48_, ev);
		result = GDK_EVENT_STOP;
		_g_object_unref0 (parent);
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

gboolean
file_item_on_button_press (FileItem* self,
                           GdkEventButton* ev)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	if (ev->button == ((guint) 1)) {
		gboolean _tmp1_ = FALSE;
		UnifiedProps* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = ((DesktopItem*) self)->props;
		_tmp3_ = unified_props_get_is_single_click (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			UnifiedProps* _tmp5_;
			_tmp5_ = ((DesktopItem*) self)->props;
			_tmp1_ = unified_props_is_desired_primary_click_type (_tmp5_, ev);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = file_item_emit_launch (self);
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

void
file_item_launch (FileItem* self,
                  gboolean in_terminal)
{
	UnifiedProps* _tmp0_;
	GdkAppLaunchContext* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GKeyFile* _tmp10_;
	gboolean _tmp20_ = FALSE;
	GAppInfo* appinfo = NULL;
	const gchar* _tmp111_;
	const gchar* _tmp112_;
	GAppInfo* _tmp118_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((DesktopItem*) self)->props;
	_tmp1_ = _tmp0_->launch_context;
	gdk_app_launch_context_set_timestamp (_tmp1_, (guint32) GDK_CURRENT_TIME);
	_tmp2_ = self->app_info;
	if (_tmp2_ != NULL) {
		{
			GDesktopAppInfo* _tmp3_;
			UnifiedProps* _tmp4_;
			GdkAppLaunchContext* _tmp5_;
			_tmp3_ = self->app_info;
			_tmp4_ = ((DesktopItem*) self)->props;
			_tmp5_ = _tmp4_->launch_context;
			g_app_info_launch ((GAppInfo*) _tmp3_, NULL, (GAppLaunchContext*) _tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = gtk_widget_get_name ((GtkWidget*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("file_item.vala:232: Failed to launch %s: %s", _tmp7_, _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		return;
	}
	_tmp10_ = self->keyfile;
	if (_tmp10_ != NULL) {
		{
			gchar* keyfile_url = NULL;
			GKeyFile* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			UnifiedProps* _tmp14_;
			GdkAppLaunchContext* _tmp15_;
			_tmp11_ = self->keyfile;
			_tmp12_ = g_key_file_get_string (_tmp11_, "Desktop Entry", "URL", &_inner_error0_);
			keyfile_url = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp13_ = keyfile_url;
			_tmp14_ = ((DesktopItem*) self)->props;
			_tmp15_ = _tmp14_->launch_context;
			g_app_info_launch_default_for_uri (_tmp13_, (GAppLaunchContext*) _tmp15_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (keyfile_url);
				goto __catch1_g_error;
			}
			_g_free0 (keyfile_url);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = gtk_widget_get_name ((GtkWidget*) self);
			_tmp17_ = _tmp16_;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("file_item.vala:243: Failed to launch %s: %s", _tmp17_, _tmp19_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		return;
	}
	if (in_terminal) {
		UnifiedProps* _tmp21_;
		GSettings* _tmp22_;
		GSettings* _tmp23_;
		_tmp21_ = ((DesktopItem*) self)->props;
		_tmp22_ = unified_props_get_desktop_settings (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp20_ = _tmp23_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gchar* preferred_terminal = NULL;
		UnifiedProps* _tmp24_;
		GSettings* _tmp25_;
		GSettings* _tmp26_;
		gchar* _tmp27_;
		gboolean supported_terminal = FALSE;
		const gchar* _tmp28_;
		gchar** args = NULL;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar** _tmp33_;
		gint args_length1;
		gint _args_size_;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		const gchar* _tmp40_;
		gchar* path = NULL;
		GFile* _tmp58_;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		_tmp24_ = ((DesktopItem*) self)->props;
		_tmp25_ = unified_props_get_desktop_settings (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_settings_get_string (_tmp26_, "terminal");
		preferred_terminal = _tmp27_;
		_tmp28_ = preferred_terminal;
		supported_terminal = _vala_string_array_contains (SUPPORTED_TERMINALS, G_N_ELEMENTS (SUPPORTED_TERMINALS), _tmp28_);
		if (!supported_terminal) {
			gchar* _tmp29_;
			gchar* _tmp30_;
			g_warning ("file_item.vala:254: Unknown Terminal provided. Please use a supported " \
"Terminal or file an issue at https://github.com/BuddiesOfBudgie/budgie" \
"-desktop-view");
			g_warning ("file_item.vala:255: Consult Budgie Desktop View documentation at https" \
"://github.com/BuddiesOfBudgie/budgie-desktop-view/wiki on changing the" \
" default Terminal.");
			_tmp29_ = _vala_g_strjoinv (", ", SUPPORTED_TERMINALS, (gint) G_N_ELEMENTS (SUPPORTED_TERMINALS));
			_tmp30_ = _tmp29_;
			g_warning ("file_item.vala:256: Supported Terminals: %s", _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (preferred_terminal);
			return;
		}
		_tmp31_ = preferred_terminal;
		_tmp32_ = g_strdup (_tmp31_);
		_tmp33_ = g_new0 (gchar*, 1 + 1);
		_tmp33_[0] = _tmp32_;
		args = _tmp33_;
		args_length1 = 1;
		_args_size_ = args_length1;
		_tmp40_ = preferred_terminal;
		if (g_strcmp0 (_tmp40_, "alacritty") != 0) {
			const gchar* _tmp41_;
			_tmp41_ = preferred_terminal;
			_tmp39_ = g_strcmp0 (_tmp41_, "gnome-terminal") != 0;
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			const gchar* _tmp42_;
			_tmp42_ = preferred_terminal;
			_tmp38_ = g_strcmp0 (_tmp42_, "kgx") != 0;
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			const gchar* _tmp43_;
			_tmp43_ = preferred_terminal;
			_tmp37_ = g_strcmp0 (_tmp43_, "mate-terminal") != 0;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			const gchar* _tmp44_;
			_tmp44_ = preferred_terminal;
			_tmp36_ = g_strcmp0 (_tmp44_, "tilix") != 0;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			const gchar* _tmp45_;
			_tmp45_ = preferred_terminal;
			_tmp35_ = g_strcmp0 (_tmp45_, "kitty") != 0;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			const gchar* _tmp46_;
			_tmp46_ = preferred_terminal;
			_tmp34_ = g_strcmp0 (_tmp46_, "xfce4-terminal") != 0;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("--new-tab");
			_vala_array_add1 (&args, &args_length1, &_args_size_, _tmp47_);
		} else {
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_ = FALSE;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_ = FALSE;
			const gchar* _tmp52_;
			_tmp52_ = preferred_terminal;
			if (g_strcmp0 (_tmp52_, "gnome-terminal") == 0) {
				_tmp51_ = TRUE;
			} else {
				const gchar* _tmp53_;
				_tmp53_ = preferred_terminal;
				_tmp51_ = g_strcmp0 (_tmp53_, "kgx") == 0;
			}
			if (_tmp51_) {
				_tmp50_ = TRUE;
			} else {
				const gchar* _tmp54_;
				_tmp54_ = preferred_terminal;
				_tmp50_ = g_strcmp0 (_tmp54_, "mate-terminal") == 0;
			}
			if (_tmp50_) {
				_tmp49_ = TRUE;
			} else {
				const gchar* _tmp55_;
				_tmp55_ = preferred_terminal;
				_tmp49_ = g_strcmp0 (_tmp55_, "xfce4-terminal") == 0;
			}
			if (_tmp49_) {
				const gchar* _tmp56_;
				_tmp56_ = ((DesktopItem*) self)->_type;
				_tmp48_ = g_strcmp0 (_tmp56_, "file") == 0;
			} else {
				_tmp48_ = FALSE;
			}
			if (_tmp48_) {
				gchar* _tmp57_;
				_tmp57_ = g_strdup ("--tab");
				_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp57_);
			}
		}
		_tmp58_ = self->file;
		_tmp59_ = g_file_get_path (_tmp58_);
		path = _tmp59_;
		_tmp60_ = ((DesktopItem*) self)->_type;
		if (g_strcmp0 (_tmp60_, "dir") == 0) {
			const gchar* _tmp61_;
			const gchar* _tmp62_;
			GQuark _tmp64_ = 0U;
			static GQuark _tmp63_label0 = 0;
			static GQuark _tmp63_label1 = 0;
			static GQuark _tmp63_label2 = 0;
			_tmp61_ = preferred_terminal;
			_tmp62_ = _tmp61_;
			_tmp64_ = (NULL == _tmp62_) ? 0 : g_quark_from_string (_tmp62_);
			if (_tmp64_ == ((0 != _tmp63_label0) ? _tmp63_label0 : (_tmp63_label0 = g_quark_from_static_string ("alacritty")))) {
				switch (0) {
					default:
					{
						gchar* _tmp65_;
						const gchar* _tmp66_;
						gchar* _tmp67_;
						_tmp65_ = g_strdup ("--working-directory");
						_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp65_);
						_tmp66_ = path;
						_tmp67_ = g_strdup (_tmp66_);
						_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp67_);
						break;
					}
				}
			} else if (_tmp64_ == ((0 != _tmp63_label1) ? _tmp63_label1 : (_tmp63_label1 = g_quark_from_static_string ("kitty")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp68_;
						gchar* _tmp69_;
						_tmp68_ = path;
						_tmp69_ = g_strdup_printf ("--directory=%s", _tmp68_);
						_vala_array_add5 (&args, &args_length1, &_args_size_, _tmp69_);
						break;
					}
				}
			} else if (_tmp64_ == ((0 != _tmp63_label2) ? _tmp63_label2 : (_tmp63_label2 = g_quark_from_static_string ("konsole")))) {
				switch (0) {
					default:
					{
						gchar* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_;
						_tmp70_ = g_strdup ("--workdir");
						_vala_array_add6 (&args, &args_length1, &_args_size_, _tmp70_);
						_tmp71_ = path;
						_tmp72_ = g_strdup (_tmp71_);
						_vala_array_add7 (&args, &args_length1, &_args_size_, _tmp72_);
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						const gchar* _tmp73_;
						gchar* _tmp74_;
						_tmp73_ = path;
						_tmp74_ = g_strdup_printf ("--working-directory=%s", _tmp73_);
						_vala_array_add8 (&args, &args_length1, &_args_size_, _tmp74_);
						break;
					}
				}
			}
		} else {
			gchar* editor = NULL;
			const gchar* _tmp75_;
			gchar* _tmp76_;
			const gchar* _tmp77_;
			const gchar* _tmp79_;
			_tmp75_ = g_getenv ("EDITOR");
			_tmp76_ = g_strdup (_tmp75_);
			editor = _tmp76_;
			_tmp77_ = editor;
			if (_tmp77_ == NULL) {
				gchar* _tmp78_;
				_tmp78_ = g_strdup ("nano");
				_g_free0 (editor);
				editor = _tmp78_;
			}
			_tmp79_ = preferred_terminal;
			if (g_strcmp0 (_tmp79_, "gnome-terminal") == 0) {
				gchar* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				const gchar* _tmp83_;
				gchar* _tmp84_;
				_tmp80_ = g_strdup ("--");
				_vala_array_add9 (&args, &args_length1, &_args_size_, _tmp80_);
				_tmp81_ = editor;
				_tmp82_ = g_strdup (_tmp81_);
				_vala_array_add10 (&args, &args_length1, &_args_size_, _tmp82_);
				_tmp83_ = path;
				_tmp84_ = g_strdup (_tmp83_);
				_vala_array_add11 (&args, &args_length1, &_args_size_, _tmp84_);
			} else {
				const gchar* _tmp85_;
				_tmp85_ = preferred_terminal;
				if (g_strcmp0 (_tmp85_, "mate-terminal") == 0) {
					gchar* _tmp86_;
					const gchar* _tmp87_;
					gchar* _tmp88_;
					const gchar* _tmp89_;
					gchar* _tmp90_;
					_tmp86_ = g_strdup ("-x");
					_vala_array_add12 (&args, &args_length1, &_args_size_, _tmp86_);
					_tmp87_ = editor;
					_tmp88_ = g_strdup (_tmp87_);
					_vala_array_add13 (&args, &args_length1, &_args_size_, _tmp88_);
					_tmp89_ = path;
					_tmp90_ = g_strdup (_tmp89_);
					_vala_array_add14 (&args, &args_length1, &_args_size_, _tmp90_);
				} else {
					const gchar* _tmp91_;
					_tmp91_ = preferred_terminal;
					if (g_strcmp0 (_tmp91_, "xfce4-terminal") == 0) {
						gchar** cmd = NULL;
						const gchar* _tmp92_;
						gchar* _tmp93_;
						const gchar* _tmp94_;
						gchar* _tmp95_;
						gchar** _tmp96_;
						gint cmd_length1;
						gint _cmd_size_;
						gchar* _tmp97_;
						gchar** _tmp98_;
						gint _tmp98__length1;
						gchar* _tmp99_;
						_tmp92_ = editor;
						_tmp93_ = g_strdup (_tmp92_);
						_tmp94_ = path;
						_tmp95_ = g_strdup (_tmp94_);
						_tmp96_ = g_new0 (gchar*, 2 + 1);
						_tmp96_[0] = _tmp93_;
						_tmp96_[1] = _tmp95_;
						cmd = _tmp96_;
						cmd_length1 = 2;
						_cmd_size_ = cmd_length1;
						_tmp97_ = g_strdup ("-e");
						_vala_array_add15 (&args, &args_length1, &_args_size_, _tmp97_);
						_tmp98_ = cmd;
						_tmp98__length1 = cmd_length1;
						_tmp99_ = _vala_g_strjoinv (" ", _tmp98_, (gint) _tmp98__length1);
						_vala_array_add16 (&args, &args_length1, &_args_size_, _tmp99_);
						cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
					} else {
						gchar* _tmp100_;
						const gchar* _tmp101_;
						gchar* _tmp102_;
						const gchar* _tmp103_;
						gchar* _tmp104_;
						_tmp100_ = g_strdup ("-e");
						_vala_array_add17 (&args, &args_length1, &_args_size_, _tmp100_);
						_tmp101_ = editor;
						_tmp102_ = g_strdup (_tmp101_);
						_vala_array_add18 (&args, &args_length1, &_args_size_, _tmp102_);
						_tmp103_ = path;
						_tmp104_ = g_strdup (_tmp103_);
						_vala_array_add19 (&args, &args_length1, &_args_size_, _tmp104_);
					}
				}
			}
			_g_free0 (editor);
		}
		{
			gchar** _tmp105_;
			gint _tmp105__length1;
			gchar** _tmp106_;
			gchar** _tmp107_;
			gchar** _tmp108_;
			gint _tmp108__length1;
			_tmp105_ = args;
			_tmp105__length1 = args_length1;
			_tmp107_ = _tmp106_ = g_get_environ ();
			_tmp108_ = _tmp107_;
			_tmp108__length1 = _vala_array_length (_tmp106_);
			g_spawn_async (NULL, _tmp105_, _tmp108_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
			_tmp108_ = (_vala_array_free (_tmp108_, _tmp108__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp109_;
			const gchar* _tmp110_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp109_ = e;
			_tmp110_ = _tmp109_->message;
			g_warning ("file_item.vala:337: Failed to launch this process: %s", _tmp110_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (preferred_terminal);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (path);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (preferred_terminal);
		return;
	}
	appinfo = NULL;
	_tmp111_ = file_item_get_file_type (self);
	_tmp112_ = _tmp111_;
	if (g_strcmp0 (_tmp112_, "trash") == 0) {
		GAppInfo* _tmp113_;
		_tmp113_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
		_g_object_unref0 (appinfo);
		appinfo = (GAppInfo*) G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo);
	} else {
		{
			GAppInfo* _tmp114_ = NULL;
			GFile* _tmp115_;
			GAppInfo* _tmp116_;
			GAppInfo* _tmp117_;
			_tmp115_ = self->file;
			_tmp116_ = g_file_query_default_handler (_tmp115_, NULL, &_inner_error0_);
			_tmp114_ = _tmp116_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp117_ = _tmp114_;
			_tmp114_ = NULL;
			_g_object_unref0 (appinfo);
			appinfo = _tmp117_;
			_g_object_unref0 (_tmp114_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp118_ = appinfo;
	if (_tmp118_ == NULL) {
		{
			GFile* _tmp119_;
			gchar* _tmp120_;
			gchar** _tmp121_;
			gchar** _tmp122_;
			gint _tmp122__length1;
			gchar** _tmp123_;
			gchar** _tmp124_;
			gchar** _tmp125_;
			gint _tmp125__length1;
			_tmp119_ = self->file;
			_tmp120_ = g_file_get_path (_tmp119_);
			_tmp121_ = g_new0 (gchar*, 1 + 1);
			_tmp121_[0] = _tmp120_;
			_tmp122_ = _tmp121_;
			_tmp122__length1 = 1;
			_tmp124_ = _tmp123_ = g_get_environ ();
			_tmp125_ = _tmp124_;
			_tmp125__length1 = _vala_array_length (_tmp123_);
			g_spawn_async (NULL, _tmp122_, _tmp125_, G_SPAWN_STDERR_TO_DEV_NULL | G_SPAWN_STDOUT_TO_DEV_NULL, NULL, NULL, NULL, &_inner_error0_);
			_tmp125_ = (_vala_array_free (_tmp125_, _tmp125__length1, (GDestroyNotify) g_free), NULL);
			_tmp122_ = (_vala_array_free (_tmp122_, _tmp122__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp126_;
			const gchar* _tmp127_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp126_ = e;
			_tmp127_ = _tmp126_->message;
			g_warning ("file_item.vala:357: Failed to launch this process: %s", _tmp127_);
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (appinfo);
		return;
	}
	{
		const gchar* _tmp128_;
		const gchar* _tmp129_;
		_tmp128_ = file_item_get_file_type (self);
		_tmp129_ = _tmp128_;
		if (g_strcmp0 (_tmp129_, "trash") == 0) {
			GList* trash_uris = NULL;
			gchar* _tmp130_;
			GAppInfo* _tmp131_;
			GList* _tmp132_;
			UnifiedProps* _tmp133_;
			GdkAppLaunchContext* _tmp134_;
			trash_uris = NULL;
			_tmp130_ = g_strdup ("trash:///");
			trash_uris = g_list_append (trash_uris, _tmp130_);
			_tmp131_ = appinfo;
			_tmp132_ = trash_uris;
			_tmp133_ = ((DesktopItem*) self)->props;
			_tmp134_ = _tmp133_->launch_context;
			g_app_info_launch_uris (_tmp131_, _tmp132_, (GAppLaunchContext*) _tmp134_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				(trash_uris == NULL) ? NULL : (trash_uris = (_g_list_free__g_free0_ (trash_uris), NULL));
				goto __catch5_g_error;
			}
			(trash_uris == NULL) ? NULL : (trash_uris = (_g_list_free__g_free0_ (trash_uris), NULL));
		} else {
			GAppInfo* _tmp135_;
			GList* _tmp136_;
			GList* _tmp137_;
			UnifiedProps* _tmp138_;
			GdkAppLaunchContext* _tmp139_;
			_tmp135_ = appinfo;
			_tmp136_ = file_item_get_file_list (self);
			_tmp137_ = _tmp136_;
			_tmp138_ = ((DesktopItem*) self)->props;
			_tmp139_ = _tmp138_->launch_context;
			g_app_info_launch (_tmp135_, _tmp137_, (GAppLaunchContext*) _tmp139_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch5_g_error;
			}
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp140_;
		const gchar* _tmp141_;
		GError* _tmp142_;
		const gchar* _tmp143_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp140_ = gtk_widget_get_name ((GtkWidget*) self);
		_tmp141_ = _tmp140_;
		_tmp142_ = e;
		_tmp143_ = _tmp142_->message;
		g_warning ("file_item.vala:372: Failed to launch %s: %s", _tmp141_, _tmp143_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (appinfo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (appinfo);
}

static void
file_item_load_image_for_file_data_free (gpointer _data)
{
	FileItemLoadImageForFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FileItemLoadImageForFileData, _data_);
}

static void
file_item_load_image_for_file (FileItem* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	FileItemLoadImageForFileData* _data_;
	FileItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FileItemLoadImageForFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, file_item_load_image_for_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	file_item_load_image_for_file_co (_data_);
}

static void
file_item_load_image_for_file_finish (FileItem* self,
                                      GAsyncResult* _res_)
{
	FileItemLoadImageForFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
file_item_load_image_for_file_co (FileItemLoadImageForFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_ftype;
	if (!g_str_has_prefix (_data_->_tmp1_, "image/")) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->info;
		_data_->_tmp3_ = ((DesktopItem*) _data_->self)->props;
		_data_->_tmp4_ = unified_props_get_max_thumbnail_size (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp0_ = g_file_info_get_size (_data_->_tmp2_) > ((gint64) (_data_->_tmp5_ * 1000000));
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->file;
	_data_->_tmp7_ = g_file_get_path (_data_->_tmp6_);
	_data_->file_path = _data_->_tmp7_;
	{
		_data_->_tmp8_ = _data_->file_path;
		_data_->_tmp9_ = ((DesktopItem*) _data_->self)->props;
		_data_->_tmp10_ = _data_->_tmp9_->icon_size;
		_data_->_tmp11_ = gdk_pixbuf_new_from_file_at_scale (_data_->_tmp8_, *_data_->_tmp10_, -1, TRUE, &_data_->_inner_error0_);
		_data_->file_pixbuf = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp12_ = _data_->file_pixbuf;
		desktop_item_set_image_pixbuf ((DesktopItem*) _data_->self, _data_->_tmp12_);
		_g_object_unref0 (_data_->file_pixbuf);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->file_path;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_warning ("file_item.vala:391: Failed to create a PixBuf for the %s: %s\n", _data_->_tmp13_, _data_->_tmp15_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->file_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->file_path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda6_ (FileItem* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = self->file;
		g_file_trash_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->file;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("file_item.vala:409: Failed to move %s to trash: %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ ((FileItem*) self, source_object, res);
	g_object_unref (self);
}

void
file_item_move_to_trash (FileItem* self)
{
	GCancellable* c = NULL;
	UnifiedProps* _tmp0_;
	GHashTable* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GFile* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((DesktopItem*) self)->props;
	_tmp1_ = _tmp0_->files_currently_copying;
	_tmp2_ = self->info;
	_tmp3_ = g_file_info_get_display_name (_tmp2_);
	_tmp4_ = g_hash_table_lookup (_tmp1_, _tmp3_);
	_tmp5_ = _g_object_ref0 ((GCancellable*) _tmp4_);
	c = _tmp5_;
	_tmp6_ = c;
	if (_tmp6_ != NULL) {
		GCancellable* _tmp7_;
		_tmp7_ = c;
		g_cancellable_cancel (_tmp7_);
	}
	_tmp8_ = self->file;
	g_file_trash_async (_tmp8_, G_PRIORITY_DEFAULT, NULL, ___lambda6__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (c);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
___lambda4_ (FileItem* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	file_item_load_image_for_file_finish (self, res);
}

static void
____lambda4__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda4_ ((FileItem*) self, source_object, res);
	g_object_unref (self);
}

void
file_item_update_icon (FileItem* self,
                       GError** error)
{
	GIcon* desired_icon = NULL;
	const gchar* _tmp0_;
	GIcon* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	desktop_item_set_icon_factors ((DesktopItem*) self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	desired_icon = NULL;
	_tmp0_ = self->priv->_override_icon_name;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		{
			const gchar* _tmp1_;
			_tmp1_ = self->priv->_override_icon_name;
			desktop_item_set_icon_from_name ((DesktopItem*) self, _tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			GError* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _g_error_copy0 (_tmp2_);
			_inner_error0_ = _tmp3_;
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (desired_icon);
			return;
		}
		_g_object_unref0 (desired_icon);
		return;
	}
	if (self->priv->use_override_icon) {
		GIcon* _tmp4_;
		GIcon* _tmp5_;
		_tmp4_ = self->priv->_override_icon;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (desired_icon);
		desired_icon = _tmp5_;
	} else {
		GDesktopAppInfo* _tmp6_;
		_tmp6_ = self->app_info;
		if (_tmp6_ != NULL) {
			GDesktopAppInfo* _tmp7_;
			GIcon* _tmp8_;
			GIcon* _tmp9_;
			_tmp7_ = self->app_info;
			_tmp8_ = g_app_info_get_icon ((GAppInfo*) _tmp7_);
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (desired_icon);
			desired_icon = _tmp9_;
		} else {
			GThemedIcon* _tmp10_;
			_tmp10_ = file_item_get_mimetype_icon (self);
			_g_object_unref0 (desired_icon);
			desired_icon = (GIcon*) _tmp10_;
		}
	}
	_tmp11_ = desired_icon;
	if (_tmp11_ != NULL) {
		GIcon* _tmp12_;
		GIcon* _tmp13_;
		_tmp12_ = desired_icon;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (((DesktopItem*) self)->icon);
		((DesktopItem*) self)->icon = _tmp13_;
		{
			GIcon* _tmp14_;
			_tmp14_ = desired_icon;
			desktop_item_set_icon ((DesktopItem*) self, _tmp14_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp15_;
			GError* _tmp16_;
			const gchar* _tmp17_;
			GError* _tmp18_;
			GError* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = ((DesktopItem*) self)->_name;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_warning ("file_item.vala:446: Failed to set icon for FileItem %s: %s", _tmp15_, _tmp17_);
			_tmp18_ = e;
			_tmp19_ = _g_error_copy0 (_tmp18_);
			_inner_error0_ = _tmp19_;
			_g_error_free0 (e);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (desired_icon);
			return;
		}
	}
	if (!self->priv->use_override_icon) {
		file_item_load_image_for_file (self, ____lambda4__gasync_ready_callback, g_object_ref (self));
	}
	_g_object_unref0 (desired_icon);
}

GList*
file_item_get_file_list (FileItem* self)
{
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_flist;
	result = _tmp0_;
	return result;
}

const gchar*
file_item_get_file_type (FileItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ftype;
	result = _tmp0_;
	return result;
}

void
file_item_set_file_type (FileItem* self,
                         const gchar* value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = desktop_item_get_is_special ((DesktopItem*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = g_strdup (value);
	_g_free0 (self->priv->_ftype);
	self->priv->_ftype = _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, file_item_properties[FILE_ITEM_FILE_TYPE_PROPERTY]);
}

static void
file_item_class_init (FileItemClass * klass,
                      gpointer klass_data)
{
	file_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_file_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_file_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = file_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_ITEM_FILE_LIST_PROPERTY, file_item_properties[FILE_ITEM_FILE_LIST_PROPERTY] = g_param_spec_pointer ("file-list", "file-list", "file-list", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_ITEM_FILE_TYPE_PROPERTY, file_item_properties[FILE_ITEM_FILE_TYPE_PROPERTY] = g_param_spec_string ("file-type", "file-type", "file-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
file_item_instance_init (FileItem * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = file_item_get_instance_private (self);
	self->app_info = NULL;
	self->keyfile = NULL;
	self->exclude_item = FALSE;
	self->priv->_override_icon = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_override_icon_name = _tmp0_;
	self->priv->use_override_icon = FALSE;
}

static void
file_item_finalize (GObject * obj)
{
	FileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_ITEM, FileItem);
	_g_object_unref0 (self->file);
	_g_object_unref0 (self->info);
	_g_object_unref0 (self->app_info);
	_g_key_file_unref0 (self->keyfile);
	(self->priv->_flist == NULL) ? NULL : (self->priv->_flist = (_g_list_free__g_object_unref0_ (self->priv->_flist), NULL));
	_g_free0 (self->priv->_ftype);
	_g_object_unref0 (self->priv->_override_icon);
	_g_free0 (self->priv->_override_icon_name);
	G_OBJECT_CLASS (file_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
file_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileItem), 0, (GInstanceInitFunc) file_item_instance_init, NULL };
	GType file_item_type_id;
	file_item_type_id = g_type_register_static (TYPE_DESKTOP_ITEM, "FileItem", &g_define_type_info, 0);
	FileItem_private_offset = g_type_add_instance_private (file_item_type_id, sizeof (FileItemPrivate));
	return file_item_type_id;
}

GType
file_item_get_type (void)
{
	static volatile gsize file_item_type_id__once = 0;
	if (g_once_init_enter (&file_item_type_id__once)) {
		GType file_item_type_id;
		file_item_type_id = file_item_get_type_once ();
		g_once_init_leave (&file_item_type_id__once, file_item_type_id);
	}
	return file_item_type_id__once;
}

static void
_vala_file_item_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	FileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_ITEM, FileItem);
	switch (property_id) {
		case FILE_ITEM_FILE_LIST_PROPERTY:
		g_value_set_pointer (value, file_item_get_file_list (self));
		break;
		case FILE_ITEM_FILE_TYPE_PROPERTY:
		g_value_set_string (value, file_item_get_file_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_file_item_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	FileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_ITEM, FileItem);
	switch (property_id) {
		case FILE_ITEM_FILE_TYPE_PROPERTY:
		file_item_set_file_type (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

