/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __PROFILE_BPF_SKEL_H__
#define __PROFILE_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct profile_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *pids;
		struct bpf_map *tids;
		struct bpf_map *stackmap;
		struct bpf_map *counts;
		struct bpf_map *rodata;
	} maps;
	struct {
		struct bpf_program *do_perf_event;
	} progs;
	struct {
		struct bpf_link *do_perf_event;
	} links;
	struct profile_bpf__rodata {
		bool kernel_stacks_only;
		bool user_stacks_only;
		bool include_idle;
		bool filter_by_pid;
		bool filter_by_tid;
		bool use_pidns;
		__u64 pidns_dev;
		__u64 pidns_ino;
	} *rodata;

#ifdef __cplusplus
	static inline struct profile_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct profile_bpf *open_and_load();
	static inline int load(struct profile_bpf *skel);
	static inline int attach(struct profile_bpf *skel);
	static inline void detach(struct profile_bpf *skel);
	static inline void destroy(struct profile_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
profile_bpf__destroy(struct profile_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
profile_bpf__create_skeleton(struct profile_bpf *obj);

static inline struct profile_bpf *
profile_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct profile_bpf *obj;
	int err;

	obj = (struct profile_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = profile_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	profile_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct profile_bpf *
profile_bpf__open(void)
{
	return profile_bpf__open_opts(NULL);
}

static inline int
profile_bpf__load(struct profile_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct profile_bpf *
profile_bpf__open_and_load(void)
{
	struct profile_bpf *obj;
	int err;

	obj = profile_bpf__open();
	if (!obj)
		return NULL;
	err = profile_bpf__load(obj);
	if (err) {
		profile_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
profile_bpf__attach(struct profile_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
profile_bpf__detach(struct profile_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *profile_bpf__elf_bytes(size_t *sz);

static inline int
profile_bpf__create_skeleton(struct profile_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "profile_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 5;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "pids";
	map->map = &obj->maps.pids;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "tids";
	map->map = &obj->maps.tids;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 2 * s->map_skel_sz);
	map->name = "stackmap";
	map->map = &obj->maps.stackmap;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 3 * s->map_skel_sz);
	map->name = "counts";
	map->map = &obj->maps.counts;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 4 * s->map_skel_sz);
	map->name = "profile_.rodata";
	map->map = &obj->maps.rodata;
	map->mmaped = (void **)&obj->rodata;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "do_perf_event";
	s->progs[0].prog = &obj->progs.do_perf_event;
	s->progs[0].link = &obj->links.do_perf_event;

	s->data = profile_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *profile_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x80\x1d\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0e\0\
\x01\0\xbf\x16\0\0\0\0\0\0\xb4\x01\0\0\0\0\0\0\x63\x1a\xf8\xff\0\0\0\0\xb7\x01\
\0\0\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\
\0\0\0\x7b\x1a\xd0\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\
\0\0\0\0\x56\x01\x11\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x79\x11\0\
\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x79\x22\0\0\0\0\0\0\xbf\xa3\0\0\
\0\0\0\0\x07\x03\0\0\xd0\xff\xff\xff\xb4\x04\0\0\x08\0\0\0\x85\0\0\0\x78\0\0\0\
\x55\0\x06\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xd0\xff\xff\xff\x61\x12\
\x04\0\0\0\0\0\x63\x2a\xdc\xff\0\0\0\0\x61\x10\0\0\0\0\0\0\x05\0\x04\0\0\0\0\0\
\x85\0\0\0\x0e\0\0\0\xbf\x01\0\0\0\0\0\0\x77\x01\0\0\x20\0\0\0\x63\x1a\xdc\xff\
\0\0\0\0\x63\x0a\xd8\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\
\0\0\0\0\0\x56\x01\x01\0\0\0\0\0\x16\0\x4d\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x06\0\x01\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xdc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\
\0\x15\0\x43\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\
\x56\x01\x06\0\x01\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xd8\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x39\0\0\0\0\0\x61\
\xa1\xdc\xff\0\0\0\0\x63\x1a\xe0\xff\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\
\xec\xff\xff\xff\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\xb4\x07\0\0\xff\xff\
\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\xb4\0\0\0\xff\
\xff\xff\xff\x56\x01\x07\0\0\0\0\0\xb7\x02\0\0\0\0\0\0\xbf\x61\0\0\0\0\0\0\x0f\
\x21\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x03\0\0\0\0\0\0\x85\0\
\0\0\x1b\0\0\0\x63\x0a\xe8\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\
\x11\0\0\0\0\0\0\x56\x01\x08\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x0f\x16\0\0\0\0\0\0\
\xbf\x61\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x03\0\0\0\x01\0\0\
\x85\0\0\0\x1b\0\0\0\xbf\x07\0\0\0\0\0\0\x63\x7a\xe4\xff\0\0\0\0\xbf\xa2\0\0\0\
\0\0\0\x07\x02\0\0\xe0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\
\0\x01\0\0\0\x55\0\x10\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe0\xff\xff\
\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\x18\0\0\0\0\0\0\0\0\0\0\0\
\xb7\x04\0\0\x01\0\0\0\x85\0\0\0\x02\0\0\0\x16\0\x01\0\0\0\0\0\x56\0\x08\0\xef\
\xff\xff\xff\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe0\xff\xff\xff\x18\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x02\0\0\0\0\0\xb7\x01\0\0\x01\0\0\
\0\xdb\x10\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x47\x50\x4c\0\x9f\xeb\x01\0\x18\0\0\0\0\0\
\0\0\x90\x07\0\0\x90\x07\0\0\x81\x06\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\
\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\
\x01\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\
\x19\0\0\0\0\0\0\x08\x07\0\0\0\x1d\0\0\0\0\0\0\x08\x08\0\0\0\x23\0\0\0\0\0\0\
\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x0a\0\0\0\x30\0\0\0\0\0\0\x08\x0b\0\
\0\0\x33\0\0\0\0\0\0\x08\x0c\0\0\0\x38\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\0\0\0\
\0\0\0\0\0\x02\x0e\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x1e\0\0\
\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x46\0\0\0\x01\0\0\0\0\0\0\0\x4b\0\0\0\x05\0\0\
\0\x40\0\0\0\x4f\0\0\0\x09\0\0\0\x80\0\0\0\x55\0\0\0\x0d\0\0\0\xc0\0\0\0\x61\0\
\0\0\0\0\0\x0e\x0f\0\0\0\x01\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x46\0\0\0\x01\
\0\0\0\0\0\0\0\x4b\0\0\0\x05\0\0\0\x40\0\0\0\x4f\0\0\0\x09\0\0\0\x80\0\0\0\x55\
\0\0\0\x0d\0\0\0\xc0\0\0\0\x66\0\0\0\0\0\0\x0e\x11\0\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\x02\x14\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x07\0\0\0\0\0\0\
\0\x02\0\0\x04\x10\0\0\0\x46\0\0\0\x13\0\0\0\0\0\0\0\x4b\0\0\0\x05\0\0\0\x40\0\
\0\0\x6b\0\0\0\0\0\0\x0e\x15\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x18\0\0\0\x74\0\
\0\0\x04\0\0\x04\x1c\0\0\0\x7a\0\0\0\x07\0\0\0\0\0\0\0\x7e\0\0\0\x02\0\0\0\x20\
\0\0\0\x8c\0\0\0\x02\0\0\0\x40\0\0\0\x9a\0\0\0\x1a\0\0\0\x60\0\0\0\x9f\0\0\0\0\
\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x19\0\0\0\x04\0\0\0\
\x10\0\0\0\0\0\0\0\0\0\0\x02\x1c\0\0\0\xa4\0\0\0\0\0\0\x08\x1d\0\0\0\xa8\0\0\0\
\0\0\0\x08\x1e\0\0\0\xae\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\x02\
\x20\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\0\x28\0\0\0\0\0\0\x04\
\0\0\x04\x20\0\0\0\x46\0\0\0\x01\0\0\0\0\0\0\0\x4b\0\0\0\x17\0\0\0\x40\0\0\0\
\x4f\0\0\0\x1b\0\0\0\x80\0\0\0\x55\0\0\0\x1f\0\0\0\xc0\0\0\0\xc1\0\0\0\0\0\0\
\x0e\x21\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x24\0\0\0\xc8\0\0\0\x03\0\0\x04\xb8\
\0\0\0\xdc\0\0\0\x25\0\0\0\0\0\0\0\xe1\0\0\0\x1d\0\0\0\x40\x05\0\0\xef\0\0\0\
\x1d\0\0\0\x80\x05\0\0\xf4\0\0\0\0\0\0\x08\x26\0\0\0\x07\x01\0\0\x15\0\0\x04\
\xa8\0\0\0\x0f\x01\0\0\x27\0\0\0\0\0\0\0\x13\x01\0\0\x27\0\0\0\x40\0\0\0\x17\
\x01\0\0\x27\0\0\0\x80\0\0\0\x1b\x01\0\0\x27\0\0\0\xc0\0\0\0\x1f\x01\0\0\x27\0\
\0\0\0\x01\0\0\x22\x01\0\0\x27\0\0\0\x40\x01\0\0\x25\x01\0\0\x27\0\0\0\x80\x01\
\0\0\x29\x01\0\0\x27\0\0\0\xc0\x01\0\0\x2d\x01\0\0\x27\0\0\0\0\x02\0\0\x30\x01\
\0\0\x27\0\0\0\x40\x02\0\0\x33\x01\0\0\x27\0\0\0\x80\x02\0\0\x36\x01\0\0\x27\0\
\0\0\xc0\x02\0\0\x39\x01\0\0\x27\0\0\0\0\x03\0\0\x3c\x01\0\0\x27\0\0\0\x40\x03\
\0\0\x3f\x01\0\0\x27\0\0\0\x80\x03\0\0\x42\x01\0\0\x27\0\0\0\xc0\x03\0\0\x4a\
\x01\0\0\x27\0\0\0\0\x04\0\0\0\0\0\0\x28\0\0\0\x40\x04\0\0\x4d\x01\0\0\x27\0\0\
\0\x80\x04\0\0\x53\x01\0\0\x27\0\0\0\xc0\x04\0\0\0\0\0\0\x2d\0\0\0\0\x05\0\0\
\x56\x01\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\x05\x08\0\0\0\x64\
\x01\0\0\x29\0\0\0\0\0\0\0\x67\x01\0\0\x1c\0\0\0\0\0\0\0\x6b\x01\0\0\x2c\0\0\0\
\0\0\0\0\x73\x01\0\0\0\0\0\x08\x2a\0\0\0\x77\x01\0\0\0\0\0\x08\x2b\0\0\0\x7d\
\x01\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\0\x6b\x01\0\0\x03\0\0\x84\x08\0\0\0\x64\
\x01\0\0\x1c\0\0\0\0\0\0\x10\x8c\x01\0\0\x1c\0\0\0\x10\0\0\x02\x8f\x01\0\0\x1c\
\0\0\0\x12\0\0\x01\0\0\0\0\x03\0\0\x05\x08\0\0\0\x93\x01\0\0\x29\0\0\0\0\0\0\0\
\x96\x01\0\0\x1c\0\0\0\0\0\0\0\x9a\x01\0\0\x2e\0\0\0\0\0\0\0\x9a\x01\0\0\x0a\0\
\0\x84\x08\0\0\0\x93\x01\0\0\x1c\0\0\0\0\0\0\x10\xa2\x01\0\0\x1c\0\0\0\x10\0\0\
\x01\xa6\x01\0\0\x1c\0\0\0\x11\0\0\x01\xae\x01\0\0\x1c\0\0\0\x12\0\0\x01\xb2\
\x01\0\0\x1c\0\0\0\x20\0\0\x08\x46\0\0\0\x1c\0\0\0\x30\0\0\x04\xb9\x01\0\0\x1c\
\0\0\0\x38\0\0\x01\xc1\x01\0\0\x1c\0\0\0\x39\0\0\x01\xc4\x01\0\0\x1c\0\0\0\x3a\
\0\0\x01\xcb\x01\0\0\x1c\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\0\x0d\x02\0\0\0\xd3\
\x01\0\0\x23\0\0\0\xd7\x01\0\0\x01\0\0\x0c\x2f\0\0\0\xd3\x02\0\0\x02\0\0\x04\
\x08\0\0\0\x7a\0\0\0\x07\0\0\0\0\0\0\0\xe2\x02\0\0\x07\0\0\0\x20\0\0\0\0\0\0\0\
\0\0\0\x0a\x33\0\0\0\0\0\0\0\0\0\0\x09\x34\0\0\0\xda\x05\0\0\0\0\0\x08\x35\0\0\
\0\xdf\x05\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x04\xe5\x05\0\0\0\0\0\x0e\x32\0\0\0\
\x01\0\0\0\xf8\x05\0\0\0\0\0\x0e\x32\0\0\0\x01\0\0\0\x09\x06\0\0\0\0\0\x0e\x32\
\0\0\0\x01\0\0\0\x16\x06\0\0\0\0\0\x0e\x32\0\0\0\x01\0\0\0\x24\x06\0\0\0\0\0\
\x0e\x32\0\0\0\x01\0\0\0\x32\x06\0\0\0\0\0\x0e\x32\0\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\x0a\x3d\0\0\0\0\0\0\0\0\0\0\x09\x1d\0\0\0\x3c\x06\0\0\0\0\0\x0e\x3c\0\0\0\
\x01\0\0\0\x46\x06\0\0\0\0\0\x0e\x3c\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x1c\0\0\
\0\x50\x06\0\0\0\0\0\x0e\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x19\0\0\0\
\x04\0\0\0\x04\0\0\0\x63\x06\0\0\0\0\0\x0e\x42\0\0\0\x01\0\0\0\x6b\x06\0\0\x04\
\0\0\x0f\0\0\0\0\x10\0\0\0\0\0\0\0\x20\0\0\0\x12\0\0\0\0\0\0\0\x20\0\0\0\x16\0\
\0\0\0\0\0\0\x10\0\0\0\x22\0\0\0\0\0\0\0\x20\0\0\0\x71\x06\0\0\x09\0\0\x0f\0\0\
\0\0\x36\0\0\0\0\0\0\0\x01\0\0\0\x37\0\0\0\0\0\0\0\x01\0\0\0\x38\0\0\0\0\0\0\0\
\x01\0\0\0\x39\0\0\0\0\0\0\0\x01\0\0\0\x3a\0\0\0\0\0\0\0\x01\0\0\0\x3b\0\0\0\0\
\0\0\0\x01\0\0\0\x3e\0\0\0\0\0\0\0\x08\0\0\0\x3f\0\0\0\0\0\0\0\x08\0\0\0\x41\0\
\0\0\x18\0\0\0\x08\0\0\0\x79\x06\0\0\x01\0\0\x0f\0\0\0\0\x43\0\0\0\0\0\0\0\x04\
\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\
\x59\x50\x45\x5f\x5f\0\x75\x33\x32\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\x69\x67\
\x6e\x65\x64\x20\x69\x6e\x74\0\x75\x38\0\x5f\x5f\x75\x38\0\x75\x6e\x73\x69\x67\
\x6e\x65\x64\x20\x63\x68\x61\x72\0\x74\x79\x70\x65\0\x6b\x65\x79\0\x76\x61\x6c\
\x75\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x70\x69\x64\x73\0\x74\
\x69\x64\x73\0\x73\x74\x61\x63\x6b\x6d\x61\x70\0\x6b\x65\x79\x5f\x74\0\x70\x69\
\x64\0\x75\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\x5f\x69\x64\0\x6b\x65\x72\x6e\
\x5f\x73\x74\x61\x63\x6b\x5f\x69\x64\0\x6e\x61\x6d\x65\0\x63\x68\x61\x72\0\x75\
\x36\x34\0\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\
\x6e\x67\x20\x6c\x6f\x6e\x67\0\x63\x6f\x75\x6e\x74\x73\0\x62\x70\x66\x5f\x70\
\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x5f\x64\x61\x74\x61\0\x72\x65\x67\x73\0\
\x73\x61\x6d\x70\x6c\x65\x5f\x70\x65\x72\x69\x6f\x64\0\x61\x64\x64\x72\0\x62\
\x70\x66\x5f\x75\x73\x65\x72\x5f\x70\x74\x5f\x72\x65\x67\x73\x5f\x74\0\x70\x74\
\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\x34\0\x72\x31\x33\0\x72\x31\x32\0\
\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\x30\0\x72\x39\0\x72\x38\0\x61\x78\0\
\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\x6f\x72\x69\x67\x5f\x61\x78\0\x69\x70\
\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\
\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\x72\x65\x64\x5f\x63\x73\0\x75\x31\x36\0\
\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\x74\
\0\x73\x6c\0\x77\x66\x65\0\x73\x73\0\x73\x73\x78\0\x66\x72\x65\x64\x5f\x73\x73\
\0\x73\x74\x69\0\x73\x77\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\0\x76\x65\x63\x74\
\x6f\x72\0\x65\x6e\x63\x6c\x61\x76\x65\0\x6c\x6d\0\x6e\x65\x73\x74\x65\x64\0\
\x69\x6e\x73\x6e\x6c\x65\x6e\0\x63\x74\x78\0\x64\x6f\x5f\x70\x65\x72\x66\x5f\
\x65\x76\x65\x6e\x74\0\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\0\x2f\x62\x75\
\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\
\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x70\x72\x6f\x66\x69\x6c\x65\x2e\x62\
\x70\x66\x2e\x63\0\x69\x6e\x74\x20\x64\x6f\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\
\x6e\x74\x28\x73\x74\x72\x75\x63\x74\x20\x62\x70\x66\x5f\x70\x65\x72\x66\x5f\
\x65\x76\x65\x6e\x74\x5f\x64\x61\x74\x61\x20\x2a\x63\x74\x78\x29\0\x09\x73\x74\
\x72\x75\x63\x74\x20\x6b\x65\x79\x5f\x74\x20\x6b\x65\x79\x20\x3d\x20\x7b\x7d\
\x3b\0\x09\x73\x74\x72\x75\x63\x74\x20\x62\x70\x66\x5f\x70\x69\x64\x6e\x73\x5f\
\x69\x6e\x66\x6f\x20\x6e\x73\x20\x3d\x20\x7b\x7d\x3b\0\x09\x69\x66\x20\x28\x75\
\x73\x65\x5f\x70\x69\x64\x6e\x73\x20\x26\x26\x20\x21\x62\x70\x66\x5f\x67\x65\
\x74\x5f\x6e\x73\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\x5f\x74\x67\
\x69\x64\x28\x70\x69\x64\x6e\x73\x5f\x64\x65\x76\x2c\x20\x70\x69\x64\x6e\x73\
\x5f\x69\x6e\x6f\x2c\x20\x26\x6e\x73\x2c\0\x62\x70\x66\x5f\x70\x69\x64\x6e\x73\
\x5f\x69\x6e\x66\x6f\0\x74\x67\x69\x64\0\x30\x3a\x31\0\x09\x09\x70\x69\x64\x20\
\x3d\x20\x6e\x73\x2e\x74\x67\x69\x64\x3b\0\x30\x3a\x30\0\x09\x09\x74\x69\x64\
\x20\x3d\x20\x6e\x73\x2e\x70\x69\x64\x3b\0\x09\x7d\x20\x65\x6c\x73\x65\x20\x7b\
\0\x09\x09\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\
\x65\x6e\x74\x5f\x70\x69\x64\x5f\x74\x67\x69\x64\x28\x29\x3b\0\x09\x09\x70\x69\
\x64\x20\x3d\x20\x69\x64\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x69\x66\x20\x28\x21\
\x69\x6e\x63\x6c\x75\x64\x65\x5f\x69\x64\x6c\x65\x20\x26\x26\x20\x74\x69\x64\
\x20\x3d\x3d\x20\x30\x29\0\x09\x69\x66\x20\x28\x66\x69\x6c\x74\x65\x72\x5f\x62\
\x79\x5f\x70\x69\x64\x20\x26\x26\x20\x21\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\
\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x70\x69\x64\x73\x2c\x20\x26\
\x70\x69\x64\x29\x29\0\x09\x69\x66\x20\x28\x66\x69\x6c\x74\x65\x72\x5f\x62\x79\
\x5f\x74\x69\x64\x20\x26\x26\x20\x21\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\
\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x74\x69\x64\x73\x2c\x20\x26\x74\
\x69\x64\x29\x29\0\x09\x6b\x65\x79\x2e\x70\x69\x64\x20\x3d\x20\x70\x69\x64\x3b\
\0\x09\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x63\x6f\
\x6d\x6d\x28\x26\x6b\x65\x79\x2e\x6e\x61\x6d\x65\x2c\x20\x73\x69\x7a\x65\x6f\
\x66\x28\x6b\x65\x79\x2e\x6e\x61\x6d\x65\x29\x29\x3b\0\x09\x69\x66\x20\x28\x75\
\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\x73\x5f\x6f\x6e\x6c\x79\x29\0\x09\x09\x6b\
\x65\x79\x2e\x6b\x65\x72\x6e\x5f\x73\x74\x61\x63\x6b\x5f\x69\x64\x20\x3d\x20\
\x62\x70\x66\x5f\x67\x65\x74\x5f\x73\x74\x61\x63\x6b\x69\x64\x28\x26\x63\x74\
\x78\x2d\x3e\x72\x65\x67\x73\x2c\x20\x26\x73\x74\x61\x63\x6b\x6d\x61\x70\x2c\
\x20\x30\x29\x3b\0\x09\x69\x66\x20\x28\x6b\x65\x72\x6e\x65\x6c\x5f\x73\x74\x61\
\x63\x6b\x73\x5f\x6f\x6e\x6c\x79\x29\0\x09\x09\x6b\x65\x79\x2e\x75\x73\x65\x72\
\x5f\x73\x74\x61\x63\x6b\x5f\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\
\x5f\x73\x74\x61\x63\x6b\x69\x64\x28\x26\x63\x74\x78\x2d\x3e\x72\x65\x67\x73\
\x2c\x20\x26\x73\x74\x61\x63\x6b\x6d\x61\x70\x2c\0\x2f\x62\x75\x69\x6c\x64\x2f\
\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\
\x74\x6f\x6f\x6c\x73\x2f\x2e\x2f\x6d\x61\x70\x73\x2e\x62\x70\x66\x2e\x68\0\x09\
\x76\x61\x6c\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\
\x70\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\x69\
\x66\x20\x28\x76\x61\x6c\x29\0\x09\x65\x72\x72\x20\x3d\x20\x62\x70\x66\x5f\x6d\
\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\
\x20\x6b\x65\x79\x2c\x20\x69\x6e\x69\x74\x2c\x20\x42\x50\x46\x5f\x4e\x4f\x45\
\x58\x49\x53\x54\x29\x3b\0\x09\x69\x66\x20\x28\x65\x72\x72\x20\x26\x26\x20\x65\
\x72\x72\x20\x21\x3d\x20\x2d\x45\x45\x58\x49\x53\x54\x29\0\x09\x72\x65\x74\x75\
\x72\x6e\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\
\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\x69\x66\x20\x28\
\x76\x61\x6c\x70\x29\0\x09\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\
\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x76\x61\x6c\x70\x2c\x20\x31\x29\x3b\0\x7d\
\0\x62\x6f\x6f\x6c\0\x5f\x42\x6f\x6f\x6c\0\x6b\x65\x72\x6e\x65\x6c\x5f\x73\x74\
\x61\x63\x6b\x73\x5f\x6f\x6e\x6c\x79\0\x75\x73\x65\x72\x5f\x73\x74\x61\x63\x6b\
\x73\x5f\x6f\x6e\x6c\x79\0\x69\x6e\x63\x6c\x75\x64\x65\x5f\x69\x64\x6c\x65\0\
\x66\x69\x6c\x74\x65\x72\x5f\x62\x79\x5f\x70\x69\x64\0\x66\x69\x6c\x74\x65\x72\
\x5f\x62\x79\x5f\x74\x69\x64\0\x75\x73\x65\x5f\x70\x69\x64\x6e\x73\0\x70\x69\
\x64\x6e\x73\x5f\x64\x65\x76\0\x70\x69\x64\x6e\x73\x5f\x69\x6e\x6f\0\x64\x6f\
\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x2e\x7a\x65\x72\x6f\0\x4c\x49\x43\
\x45\x4e\x53\x45\0\x2e\x6d\x61\x70\x73\0\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\x69\
\x63\x65\x6e\x73\x65\0\0\0\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x14\0\0\0\x14\0\0\
\0\xac\x02\0\0\xc0\x02\0\0\x4c\0\0\0\x08\0\0\0\xe5\x01\0\0\x01\0\0\0\0\0\0\0\
\x30\0\0\0\x10\0\0\0\xe5\x01\0\0\x2a\0\0\0\0\0\0\0\xf0\x01\0\0\x1e\x02\0\0\0\
\xcc\0\0\x10\0\0\0\xf0\x01\0\0\x51\x02\0\0\x0f\xdc\0\0\x38\0\0\0\xf0\x01\0\0\
\x69\x02\0\0\x18\xec\0\0\x40\0\0\0\xf0\x01\0\0\x89\x02\0\0\x06\xf4\0\0\x58\0\0\
\0\xf0\x01\0\0\x89\x02\0\0\x10\xf4\0\0\x60\0\0\0\xf0\x01\0\0\x89\x02\0\0\x30\
\xf4\0\0\x78\0\0\0\xf0\x01\0\0\x89\x02\0\0\x3b\xf4\0\0\xa0\0\0\0\xf0\x01\0\0\
\x89\x02\0\0\x14\xf4\0\0\xb0\0\0\0\xf0\x01\0\0\x89\x02\0\0\x10\xf4\0\0\xc8\0\0\
\0\xf0\x01\0\0\xeb\x02\0\0\x0c\xfc\0\0\xd0\0\0\0\xf0\x01\0\0\xeb\x02\0\0\x07\
\xfc\0\0\xd8\0\0\0\xf0\x01\0\0\0\x03\0\0\x0c\0\x01\0\xe0\0\0\0\xf0\x01\0\0\x10\
\x03\0\0\x02\x04\x01\0\xe8\0\0\0\xf0\x01\0\0\x1a\x03\0\0\x08\x08\x01\0\xf0\0\0\
\0\xf0\x01\0\0\x3d\x03\0\0\x0c\x0c\x01\0\0\x01\0\0\xf0\x01\0\0\x3d\x03\0\0\x07\
\x0c\x01\0\x10\x01\0\0\xf0\x01\0\0\x4f\x03\0\0\x07\x1c\x01\0\x28\x01\0\0\xf0\
\x01\0\0\x4f\x03\0\0\x14\x1c\x01\0\x38\x01\0\0\xf0\x01\0\0\x6f\x03\0\0\x06\x28\
\x01\0\x50\x01\0\0\xf0\x01\0\0\x6f\x03\0\0\x14\x28\x01\0\x68\x01\0\0\xf0\x01\0\
\0\x6f\x03\0\0\x18\x28\x01\0\x80\x01\0\0\xf0\x01\0\0\x6f\x03\0\0\x14\x28\x01\0\
\x88\x01\0\0\xf0\x01\0\0\xa8\x03\0\0\x06\x34\x01\0\xa0\x01\0\0\xf0\x01\0\0\xa8\
\x03\0\0\x14\x34\x01\0\xb8\x01\0\0\xf0\x01\0\0\xa8\x03\0\0\x18\x34\x01\0\xd0\
\x01\0\0\xf0\x01\0\0\xa8\x03\0\0\x14\x34\x01\0\xd8\x01\0\0\xf0\x01\0\0\xe1\x03\
\0\0\x0c\x40\x01\0\xe0\x01\0\0\xf0\x01\0\0\xe1\x03\0\0\x0a\x40\x01\0\xe8\x01\0\
\0\xf0\x01\0\0\xf1\x03\0\0\x1c\x44\x01\0\xf8\x01\0\0\xf0\x01\0\0\xf1\x03\0\0\
\x02\x44\x01\0\x10\x02\0\0\xf0\x01\0\0\x25\x04\0\0\x06\x4c\x01\0\x50\x02\0\0\
\xf0\x01\0\0\x3c\x04\0\0\x17\x58\x01\0\x78\x02\0\0\xf0\x01\0\0\x7d\x04\0\0\x06\
\x60\x01\0\xa8\x02\0\0\xf0\x01\0\0\x96\x04\0\0\x17\x6c\x01\0\xf0\x02\0\0\xd3\
\x04\0\0\0\x05\0\0\x08\x7c\0\0\x08\x03\0\0\xd3\x04\0\0\x26\x05\0\0\x06\x80\0\0\
\x20\x03\0\0\xd3\x04\0\0\x30\x05\0\0\x08\x8c\0\0\x50\x03\0\0\xd3\x04\0\0\x69\
\x05\0\0\x0a\x90\0\0\x70\x03\0\0\xd3\x04\0\0\x85\x05\0\0\x09\x9c\0\0\x88\x03\0\
\0\xf0\x01\0\0\xac\x05\0\0\x06\x7c\x01\0\x98\x03\0\0\xf0\x01\0\0\xb7\x05\0\0\
\x03\x80\x01\0\xa0\x03\0\0\xf0\x01\0\0\xd8\x05\0\0\x01\x8c\x01\0\x10\0\0\0\xe5\
\x01\0\0\x04\0\0\0\xc8\0\0\0\x31\0\0\0\xe7\x02\0\0\0\0\0\0\xd8\0\0\0\x31\0\0\0\
\xfc\x02\0\0\0\0\0\0\x38\x02\0\0\x24\0\0\0\xfc\x02\0\0\0\0\0\0\x98\x02\0\0\x24\
\0\0\0\xfc\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x89\0\0\0\x01\0\x05\0\
\x18\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x51\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\xb0\x03\0\0\0\0\0\0\x6c\0\0\0\
\x11\0\x05\0\x05\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x25\0\0\0\x11\0\x05\0\x08\0\0\
\0\0\0\0\0\x08\0\0\0\0\0\0\0\x9c\0\0\0\x11\0\x05\0\x10\0\0\0\0\0\0\0\x08\0\0\0\
\0\0\0\0\xbc\0\0\0\x11\0\x05\0\x02\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\xd7\0\0\0\
\x11\0\x05\0\x03\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x7b\0\0\0\x11\0\x06\0\0\0\0\0\
\0\0\0\0\x20\0\0\0\0\0\0\0\xc9\0\0\0\x11\0\x05\0\x04\0\0\0\0\0\0\0\x01\0\0\0\0\
\0\0\0\x76\0\0\0\x11\0\x06\0\x20\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x01\0\0\0\x11\
\0\x05\0\x01\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x80\0\0\0\x11\0\x06\0\x40\0\0\0\0\
\0\0\0\x10\0\0\0\0\0\0\0\x12\0\0\0\x11\0\x05\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\
\0\x5f\0\0\0\x11\0\x06\0\x50\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x06\x01\0\0\x11\0\
\x07\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\
\x60\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x78\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\
\x10\x01\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x38\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\
\0\x68\x01\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x88\x01\0\0\0\0\0\0\x01\0\0\0\x0b\0\
\0\0\xb8\x01\0\0\0\0\0\0\x01\0\0\0\x0c\0\0\0\x10\x02\0\0\0\0\0\0\x01\0\0\0\x0d\
\0\0\0\x50\x02\0\0\0\0\0\0\x01\0\0\0\x0e\0\0\0\x78\x02\0\0\0\0\0\0\x01\0\0\0\
\x0f\0\0\0\xb0\x02\0\0\0\0\0\0\x01\0\0\0\x0e\0\0\0\xf0\x02\0\0\0\0\0\0\x01\0\0\
\0\x10\0\0\0\x20\x03\0\0\0\0\0\0\x01\0\0\0\x10\0\0\0\x30\x03\0\0\0\0\0\0\x01\0\
\0\0\x03\0\0\0\x70\x03\0\0\0\0\0\0\x01\0\0\0\x10\0\0\0\xec\x06\0\0\0\0\0\0\x04\
\0\0\0\x0a\0\0\0\xf8\x06\0\0\0\0\0\0\x04\0\0\0\x0c\0\0\0\x04\x07\0\0\0\0\0\0\
\x04\0\0\0\x0e\0\0\0\x10\x07\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\x28\x07\0\0\0\0\0\
\0\x03\0\0\0\x0f\0\0\0\x34\x07\0\0\0\0\0\0\x03\0\0\0\x0d\0\0\0\x40\x07\0\0\0\0\
\0\0\x03\0\0\0\x08\0\0\0\x4c\x07\0\0\0\0\0\0\x03\0\0\0\x09\0\0\0\x58\x07\0\0\0\
\0\0\0\x03\0\0\0\x0b\0\0\0\x64\x07\0\0\0\0\0\0\x03\0\0\0\x05\0\0\0\x70\x07\0\0\
\0\0\0\0\x03\0\0\0\x06\0\0\0\x7c\x07\0\0\0\0\0\0\x03\0\0\0\x07\0\0\0\x88\x07\0\
\0\0\0\0\0\x03\0\0\0\x03\0\0\0\xa0\x07\0\0\0\0\0\0\x04\0\0\0\x11\0\0\0\x2c\0\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\0\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\0\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\0\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\0\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x01\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x60\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\x01\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x80\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\x01\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\x01\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\x01\
\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\
\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\
\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x20\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x30\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x40\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x50\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\x70\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\x02\0\0\0\0\0\0\x04\0\0\0\x01\
\0\0\0\x90\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\x02\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xb0\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\x02\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\xd0\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xec\x02\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\xfc\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x0c\x03\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\x1c\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x0d\x18\x16\x11\x12\
\x14\x0e\x0f\x10\x03\x13\x15\x17\x19\x1a\0\x75\x73\x65\x72\x5f\x73\x74\x61\x63\
\x6b\x73\x5f\x6f\x6e\x6c\x79\0\x6b\x65\x72\x6e\x65\x6c\x5f\x73\x74\x61\x63\x6b\
\x73\x5f\x6f\x6e\x6c\x79\0\x70\x69\x64\x6e\x73\x5f\x64\x65\x76\0\x2e\x74\x65\
\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x2e\x72\x65\x6c\
\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\0\x64\x6f\x5f\x70\x65\x72\x66\x5f\x65\
\x76\x65\x6e\x74\0\x63\x6f\x75\x6e\x74\x73\0\x2e\x6d\x61\x70\x73\0\x75\x73\x65\
\x5f\x70\x69\x64\x6e\x73\0\x74\x69\x64\x73\0\x70\x69\x64\x73\0\x73\x74\x61\x63\
\x6b\x6d\x61\x70\0\x64\x6f\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\x74\x2e\x7a\
\x65\x72\x6f\0\x70\x69\x64\x6e\x73\x5f\x69\x6e\x6f\0\x2e\x6c\x6c\x76\x6d\x5f\
\x61\x64\x64\x72\x73\x69\x67\0\x6c\x69\x63\x65\x6e\x73\x65\0\x69\x6e\x63\x6c\
\x75\x64\x65\x5f\x69\x64\x6c\x65\0\x66\x69\x6c\x74\x65\x72\x5f\x62\x79\x5f\x74\
\x69\x64\0\x66\x69\x6c\x74\x65\x72\x5f\x62\x79\x5f\x70\x69\x64\0\x2e\x73\x74\
\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x6f\x64\x61\x74\x61\0\
\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe5\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x6f\x1c\0\0\0\0\0\0\x0e\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2f\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x54\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\
\0\0\xb0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x42\
\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90\x17\0\0\0\0\0\0\0\x01\0\
\0\0\0\0\0\x0d\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xf5\0\0\0\
\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x03\0\0\0\0\0\0\x20\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x66\0\0\0\x01\0\0\0\x03\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x10\x04\0\0\0\0\0\0\x70\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x80\x04\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\x01\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x84\x04\0\0\0\0\0\0\x29\x0e\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xfd\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x90\x18\0\
\0\0\0\0\0\xe0\0\0\0\0\0\0\0\x0d\0\0\0\x08\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\
\0\0\0\x39\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\x12\0\0\0\0\0\0\
\x2c\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x35\0\0\
\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\x19\0\0\0\0\0\0\xf0\x02\0\0\
\0\0\0\0\x0d\0\0\0\x0a\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xa6\0\0\0\x03\
\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\x60\x1c\0\0\0\0\0\0\x0f\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xed\0\0\0\x02\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\x15\0\0\0\0\0\0\xb0\x01\0\0\0\0\0\0\x01\0\0\
\0\x04\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct profile_bpf *profile_bpf::open(const struct bpf_object_open_opts *opts) { return profile_bpf__open_opts(opts); }
struct profile_bpf *profile_bpf::open_and_load() { return profile_bpf__open_and_load(); }
int profile_bpf::load(struct profile_bpf *skel) { return profile_bpf__load(skel); }
int profile_bpf::attach(struct profile_bpf *skel) { return profile_bpf__attach(skel); }
void profile_bpf::detach(struct profile_bpf *skel) { profile_bpf__detach(skel); }
void profile_bpf::destroy(struct profile_bpf *skel) { profile_bpf__destroy(skel); }
const void *profile_bpf::elf_bytes(size_t *sz) { return profile_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
profile_bpf__assert(struct profile_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->kernel_stacks_only) == 1, "unexpected size of 'kernel_stacks_only'");
	_Static_assert(sizeof(s->rodata->user_stacks_only) == 1, "unexpected size of 'user_stacks_only'");
	_Static_assert(sizeof(s->rodata->include_idle) == 1, "unexpected size of 'include_idle'");
	_Static_assert(sizeof(s->rodata->filter_by_pid) == 1, "unexpected size of 'filter_by_pid'");
	_Static_assert(sizeof(s->rodata->filter_by_tid) == 1, "unexpected size of 'filter_by_tid'");
	_Static_assert(sizeof(s->rodata->use_pidns) == 1, "unexpected size of 'use_pidns'");
	_Static_assert(sizeof(s->rodata->pidns_dev) == 8, "unexpected size of 'pidns_dev'");
	_Static_assert(sizeof(s->rodata->pidns_ino) == 8, "unexpected size of 'pidns_ino'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __PROFILE_BPF_SKEL_H__ */
