// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "OffsetProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::OffsetPropertyPrivate
{
public:
    std::optional<qreal> horizontal;
    std::optional<qreal> vertical;
};

OffsetProperty::OffsetProperty()
    : d(std::make_unique<OffsetPropertyPrivate>())
{
}

OffsetProperty::OffsetProperty(const OffsetProperty &other)
    : d(std::make_unique<OffsetPropertyPrivate>())
{
    d->horizontal = other.d->horizontal;
    d->vertical = other.d->vertical;
}

OffsetProperty::OffsetProperty(OffsetProperty &&other)
    : d(std::move(other.d))
{
}

OffsetProperty::~OffsetProperty() = default;

OffsetProperty &OffsetProperty::operator=(const OffsetProperty &other)
{
    if (this != &other) {
        d->horizontal = other.d->horizontal;
        d->vertical = other.d->vertical;
    }
    return *this;
}

OffsetProperty &OffsetProperty::operator=(OffsetProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<qreal> OffsetProperty::horizontal() const
{
    return d->horizontal;
}

void OffsetProperty::setHorizontal(const std::optional<qreal> &newValue)
{
    if (newValue == d->horizontal) {
        return;
    }

    d->horizontal = newValue;
}

std::optional<qreal> OffsetProperty::vertical() const
{
    return d->vertical;
}

void OffsetProperty::setVertical(const std::optional<qreal> &newValue)
{
    if (newValue == d->vertical) {
        return;
    }

    d->vertical = newValue;
}

bool OffsetProperty::hasAnyValue() const
{
    if (d->horizontal.has_value()) {
        return true;
    }
    if (d->vertical.has_value()) {
        return true;
    }
    return false;
}

bool OffsetProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->horizontal.has_value() && d->horizontal.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->vertical.has_value() && d->vertical.value() != emptyValue<qreal>()) {
        return false;
    }

    return true;
}

QString OffsetProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "OffsetProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "horizontal: ";
    if (d->horizontal) {
        out << d->horizontal.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "vertical: ";
    if (d->vertical) {
        out << d->vertical.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void OffsetProperty::resolveProperties(const OffsetProperty *source, OffsetProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (!destination->d->horizontal.has_value()) {
        destination->d->horizontal = source->d->horizontal;
    }
    if (!destination->d->vertical.has_value()) {
        destination->d->vertical = source->d->vertical;
    }
}

std::unique_ptr<OffsetProperty> OffsetProperty::empty()
{
    auto result = std::make_unique<OffsetProperty>();
    result->d->horizontal = emptyValue<qreal>();
    result->d->vertical = emptyValue<qreal>();
    return result;
}

QVector2D OffsetProperty::toVector2D() const
{
    return QVector2D{float(d->horizontal.value_or(0.0)), float(d->vertical.value_or(0.0))};
}

bool Union::Properties::operator==(const OffsetProperty &left, const OffsetProperty &right)
{
    if (left.horizontal() != right.horizontal()) {
        return false;
    }
    if (left.vertical() != right.vertical()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::OffsetProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}