// ui/base/ime/mojom/text_input_state.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_DATA_VIEW_H_
#define UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/base/ime/mojom/text_input_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"


namespace ui::mojom {
class ImeTextSpanInfoDataView;

class TextInputStateDataView;



}  // ui::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::ImeTextSpanInfoDataView> {
  using Data = ::ui::mojom::internal::ImeTextSpanInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::TextInputStateDataView> {
  using Data = ::ui::mojom::internal::TextInputState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


class ImeTextSpanInfoDataView {
 public:
  ImeTextSpanInfoDataView() = default;

  ImeTextSpanInfoDataView(
      internal::ImeTextSpanInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSpanDataView(
      ::ui::mojom::ImeTextSpanDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpan(UserType* output) {
    
    auto* pointer = data_->span.Get();
    return mojo::internal::Deserialize<::ui::mojom::ImeTextSpanDataView>(
        pointer, output, message_);
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
 private:
  internal::ImeTextSpanInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextInputStateDataView {
 public:
  TextInputStateDataView() = default;

  TextInputStateDataView(
      internal::TextInputState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t node_id() const {
    return data_->node_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::ui::mojom::TextInputType>(
        data_value, output);
  }
  ::ui::mojom::TextInputType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::TextInputType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::ui::mojom::TextInputMode>(
        data_value, output);
  }
  ::ui::mojom::TextInputMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::TextInputMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::ui::mojom::TextInputAction>(
        data_value, output);
  }
  ::ui::mojom::TextInputAction action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::TextInputAction>(data_->action));
  }
  uint32_t flags() const {
    return data_->flags;
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::BigString16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigString16DataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigString16DataView>(
        pointer, output, message_);
  }
  inline void GetSelectionDataView(
      ::gfx::mojom::RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelection(UserType* output) {
    
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetCompositionDataView(
      ::gfx::mojom::RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComposition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RangeDataView, UserType>(),
    "Attempting to read the optional `composition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadComposition` instead "
    "of `ReadComposition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->composition.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RangeDataView>(
        pointer, output, message_);
  }
  bool can_compose_inline() const {
    return data_->can_compose_inline;
  }
  bool show_ime_if_needed() const {
    return data_->show_ime_if_needed;
  }
  bool always_hide_ime() const {
    return data_->always_hide_ime;
  }
  bool reply_to_request() const {
    return data_->reply_to_request;
  }
  inline void GetEditContextControlBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEditContextControlBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `edit_context_control_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEditContextControlBounds` instead "
    "of `ReadEditContextControlBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->edit_context_control_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetEditContextSelectionBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEditContextSelectionBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `edit_context_selection_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEditContextSelectionBounds` instead "
    "of `ReadEditContextSelectionBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->edit_context_selection_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVkPolicy(UserType* output) const {
    auto data_value = data_->vk_policy;
    return mojo::internal::Deserialize<::ui::mojom::VirtualKeyboardPolicy>(
        data_value, output);
  }
  ::ui::mojom::VirtualKeyboardPolicy vk_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::VirtualKeyboardPolicy>(data_->vk_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLastVkVisibilityRequest(UserType* output) const {
    auto data_value = data_->last_vk_visibility_request;
    return mojo::internal::Deserialize<::ui::mojom::VirtualKeyboardVisibilityRequest>(
        data_value, output);
  }
  ::ui::mojom::VirtualKeyboardVisibilityRequest last_vk_visibility_request() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::VirtualKeyboardVisibilityRequest>(data_->last_vk_visibility_request));
  }
  inline void GetImeTextSpansInfoDataView(
      mojo::ArrayDataView<ImeTextSpanInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImeTextSpansInfo(UserType* output) {
    
    auto* pointer = data_->ime_text_spans_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TextInputState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ui::mojom

#endif  // UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_DATA_VIEW_H_