// ui/accessibility/mojom/ax_tree_id.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_tree_id.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"




#include "ui/accessibility/mojom/ax_tree_id.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeIDDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::ax::mojom::AXTreeIDDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::ax::mojom::internal::AXTreeID_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::ax::mojom::AXTreeIDDataView::Tag::kUnknown: {
    decltype(Traits::unknown(input))
    in_unknown = Traits::unknown(input);
    fragment->data.f_unknown = in_unknown;
    break;
  }
  case ::ax::mojom::AXTreeIDDataView::Tag::kToken: {
    decltype(Traits::token(input))
    in_token = Traits::token(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_token)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
  in_token,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null token in AXTreeID union");
    fragment->data.f_token.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::ax::mojom::internal::AXTreeID_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXTreeIDDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {

inline void AXTreeIDDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) const {
  CHECK(is_token());
  *output = ::mojo_base::mojom::UnguessableTokenDataView(data_->data.f_token.Get(), message_);
}


}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_H_